import json
import re

raw = '''1	俄罗斯	欧洲	2020	1710万 (17,098,250)	12.6963%
2	加拿大	美洲	2020	988万 (9,879,750)	7.3362%
3	中国	亚洲	2020	960万 (9,600,012)	%
4	美国	美洲	2020	937万 (9,370,000)	%
5	巴西	美洲	2020	852万 (8,515,770)	6.3234%
6	澳大利亚	大洋洲	2020	774万 (7,741,220)	5.7483%
7	印度	亚洲	2020	329万 (3,287,260)	2.4410%
8	阿根廷	美洲	2020	278万 (2,780,400)	2.0646%
9	哈萨克斯坦	亚洲	2020	272万 (2,724,900)	2.0234%
10	阿尔及利亚	非洲	2020	238万 (2,381,741)	1.7686%
11	刚果（金）	非洲	2020	234万 (2,344,860)	1.7412%
12	沙特阿拉伯	亚洲	2020	215万 (2,149,690)	1.5963%
13	墨西哥	美洲	2020	196万 (1,964,375)	1.4586%
14	印尼	亚洲	2020	192万 (1,916,906)	1.4234%
15	苏丹	非洲	2020	188万 (1,878,000)	1.3945%
16	利比亚	非洲	2020	176万 (1,759,540)	1.3065%
17	伊朗	亚洲	2020	175万 (1,745,150)	1.2959%
18	蒙古	亚洲	2020	156万 (1,564,115)	1.1614%
19	秘鲁	美洲	2020	129万 (1,285,220)	0.9543%
20	乍得	非洲	2020	128万 (1,284,000)	0.9534%
21	尼日尔	非洲	2020	127万 (1,267,000)	0.9408%
22	安哥拉	非洲	2020	125万 (1,246,700)	0.9257%
23	马里	非洲	2020	124万 (1,240,190)	0.9209%
24	南非	非洲	2020	122万 (1,219,090)	0.9052%
25	哥伦比亚	美洲	2020	114万 (1,140,619)	0.8470%
26	埃塞俄比亚	非洲	2020	114万 (1,136,239)	0.8437%
27	玻利维亚	美洲	2020	110万 (1,098,580)	0.8158%
28	毛里塔尼亚	非洲	2020	103万 (1,030,700)	0.7653%
29	埃及	非洲	2020	100万 (1,001,450)	0.7436%
30	坦桑尼亚	非洲	2020	94.73万 (947,300)	0.7034%
31	尼日利亚	非洲	2020	92.38万 (923,770)	0.6859%
32	委内瑞拉	美洲	2020	91.2万 (912,050)	0.6772%
33	纳米比亚	非洲	2020	82.43万 (824,290)	0.6121%
34	莫桑比克	非洲	2020	79.94万 (799,380)	0.5936%
35	巴基斯坦	亚洲	2020	79.61万 (796,100)	0.5911%
36	土耳其	欧洲	2020	78.53万 (785,350)	0.5832%
37	智利	美洲	2020	75.67万 (756,700)	0.5619%
38	赞比亚	非洲	2020	75.26万 (752,610)	0.5589%
39	缅甸	亚洲	2020	67.66万 (676,590)	0.5024%
40	阿富汗	亚洲	2020	65.29万 (652,860)	0.4848%
41	南苏丹	非洲	2020	64.69万 (646,883)	0.4803%
42	索马里	非洲	2020	63.77万 (637,660)	0.4735%
43	挪威	欧洲	2020	62.45万 (624,499)	0.4637%
44	中非	非洲	2020	62.3万 (622,980)	0.4626%
45	乌克兰	欧洲	2020	60.35万 (603,550)	0.4482%
46	马达加斯加	非洲	2020	58.73万 (587,295)	0.4361%
47	博茨瓦纳	非洲	2020	58.17万 (581,730)	0.4320%
48	肯尼亚	非洲	2020	58.04万 (580,370)	0.4310%
49	法国	欧洲	2020	54.91万 (549,086)	0.4077%
50	瑞典	欧洲	2020	52.89万 (528,860)	0.3927%
51	也门	亚洲	2020	52.8万 (527,970)	0.3920%
52	泰国	亚洲	2020	51.31万 (513,120)	0.3810%
53	西班牙	欧洲	2020	50.6万 (505,969)	0.3757%
54	土库曼斯坦	亚洲	2020	48.81万 (488,100)	0.3624%
55	喀麦隆	非洲	2020	47.54万 (475,440)	0.3530%
56	巴布亚新几内亚	大洋洲	2020	46.28万 (462,840)	0.3437%
57	乌兹别克斯坦	亚洲	2020	44.89万 (448,924)	0.3333%
58	摩洛哥	非洲	2020	44.66万 (446,550)	0.3316%
59	伊拉克	亚洲	2020	43.51万 (435,052)	0.3230%
60	格陵兰	美洲	2020	41.05万 (410,450)	0.3048%
61	巴拉圭	美洲	2020	40.68万 (406,752)	0.3020%
62	津巴布韦	非洲	2020	39.08万 (390,760)	0.2902%
63	日本	亚洲	2020	37.8万 (377,974)	0.2807%
64	德国	欧洲	2020	35.76万 (357,590)	0.2655%
65	刚果（布）	非洲	2020	34.2万 (342,000)	0.2540%
66	芬兰	欧洲	2020	33.85万 (338,460)	0.2513%
67	越南	亚洲	2020	33.13万 (331,340)	0.2460%
68	马来西亚	亚洲	2020	33.02万 (330,241)	0.2452%
69	科特迪瓦	非洲	2020	32.25万 (322,460)	0.2394%
70	波兰	欧洲	2020	31.27万 (312,710)	0.2322%
71	阿曼	亚洲	2020	30.95万 (309,500)	0.2298%
72	意大利	欧洲	2020	30.21万 (302,068)	0.2243%
73	菲律宾	亚洲	2020	30.0万 (300,000)	0.2228%
74	布基纳法索	非洲	2020	27.42万 (274,220)	0.2036%
75	新西兰	大洋洲	2020	26.77万 (267,710)	0.1988%
76	加蓬	非洲	2020	26.77万 (267,670)	0.1988%
77	厄瓜多尔	美洲	2020	25.64万 (256,370)	0.1904%
78	几内亚	非洲	2020	24.59万 (245,860)	0.1826%
79	英国	欧洲	2020	24.36万 (243,610)	0.1809%
80	乌干达	非洲	2020	24.16万 (241,550)	0.1794%
81	加纳	非洲	2020	23.85万 (238,530)	0.1771%
82	罗马尼亚	欧洲	2020	23.84万 (238,400)	0.1770%
83	老挝	亚洲	2020	23.68万 (236,800)	0.1758%
84	圭亚那	美洲	2020	21.5万 (214,970)	0.1596%
85	白俄罗斯	欧洲	2020	20.76万 (207,610)	0.1542%
86	吉尔吉斯斯坦	亚洲	2020	20.0万 (199,950)	0.1485%
87	塞内加尔	非洲	2020	19.67万 (196,710)	0.1461%
88	叙利亚	亚洲	2020	18.52万 (185,180)	0.1375%
89	柬埔寨	亚洲	2020	18.1万 (181,040)	0.1344%
90	乌拉圭	美洲	2020	17.62万 (176,220)	0.1309%
91	苏里南	美洲	2020	16.38万 (163,820)	0.1216%
92	突尼斯	非洲	2020	16.36万 (163,610)	0.1215%
93	孟加拉	亚洲	2020	14.76万 (147,570)	0.1096%
94	尼泊尔	亚洲	2020	14.72万 (147,180)	0.1093%
95	塔吉克斯坦	亚洲	2020	14.14万 (141,380)	0.1050%
96	希腊	欧洲	2020	13.2万 (131,960)	0.0980%
97	尼加拉瓜	美洲	2020	13.04万 (130,370)	0.0968%
98	厄立特里亚	非洲	2020	12.16万 (121,630)	0.0903%
99	朝鲜	亚洲	2020	12.05万 (120,540)	0.0895%
100	马拉维	非洲	2020	11.85万 (118,480)	0.0880%
101	贝宁	非洲	2020	11.48万 (114,760)	0.0852%
102	洪都拉斯	美洲	2020	11.25万 (112,490)	0.0835%
103	利比里亚	非洲	2020	11.14万 (111,370)	0.0827%
104	保加利亚	欧洲	2020	11.1万 (111,000)	0.0824%
105	古巴	美洲	2020	10.99万 (109,880)	0.0816%
106	危地马拉	美洲	2020	10.89万 (108,890)	0.0809%
107	冰岛	欧洲	2020	10.3万 (103,000)	0.0765%
108	韩国	亚洲	2020	10.04万 (100,410)	0.0746%
109	阿联酋	亚洲	2020	9.86万 (98,647)	0.0733%
110	匈牙利	欧洲	2020	9.3万 (93,030)	0.0691%
111	葡萄牙	欧洲	2020	9.22万 (92,230)	0.0685%
112	约旦	亚洲	2020	8.93万 (89,318)	0.0663%
113	克罗地亚	欧洲	2020	8.81万 (88,070)	0.0654%
114	阿塞拜疆	亚洲	2020	8.66万 (86,600)	0.0643%
115	塞尔维亚	欧洲	2020	8.5万 (84,990)	0.0631%
116	奥地利	欧洲	2020	8.39万 (83,879)	0.0623%
117	捷克	欧洲	2020	7.89万 (78,871)	0.0586%
118	巴拿马	美洲	2020	7.53万 (75,320)	0.0559%
119	塞拉利昂	非洲	2020	7.23万 (72,300)	0.0537%
120	爱尔兰	欧洲	2020	7.03万 (70,280)	0.0522%
121	格鲁吉亚	亚洲	2020	6.97万 (69,700)	0.0518%
122	斯里兰卡	亚洲	2020	6.56万 (65,610)	0.0487%
123	立陶宛	欧洲	2020	6.53万 (65,290)	0.0485%
124	拉脱维亚	欧洲	2020	6.46万 (64,590)	0.0480%
125	多哥	非洲	2020	5.68万 (56,790)	0.0422%
126	波黑	欧洲	2020	5.12万 (51,210)	0.0380%
127	哥斯达黎加	美洲	2020	5.11万 (51,100)	0.0379%
128	斯洛伐克	欧洲	2020	4.9万 (49,030)	0.0364%
129	多米尼加	美洲	2020	4.87万 (48,670)	0.0361%
130	爱沙尼亚	欧洲	2020	4.53万 (45,340)	0.0337%
131	丹麦	欧洲	2020	4.29万 (42,920)	0.0319%
132	荷兰	欧洲	2020	4.15万 (41,540)	0.0308%
133	瑞士	欧洲	2020	4.13万 (41,290)	0.0307%
134	不丹	亚洲	2020	3.84万 (38,390)	0.0285%
135	几内亚比绍	非洲	2020	3.61万 (36,130)	0.0268%
136	摩尔多瓦	欧洲	2020	3.38万 (33,850)	0.0251%
137	比利时	欧洲	2020	3.05万 (30,530)	0.0227%
138	莱索托	非洲	2020	3.04万 (30,360)	0.0225%
139	亚美尼亚	亚洲	2020	2.97万 (29,740)	0.0221%
140	所罗门群岛	大洋洲	2020	2.89万 (28,900)	0.0215%
141	阿尔巴尼亚	欧洲	2020	2.88万 (28,750)	0.0213%
142	赤道几内亚	非洲	2020	2.81万 (28,050)	0.0208%
143	布隆迪	非洲	2020	2.78万 (27,830)	0.0207%
144	海地	美洲	2020	2.77万 (27,750)	0.0206%
145	卢旺达	非洲	2020	2.63万 (26,340)	0.0196%
146	马其顿	欧洲	2020	2.57万 (25,710)	0.0191%
147	吉布提	非洲	2020	2.32万 (23,200)	0.0172%
148	伯利兹	美洲	2020	2.3万 (22,970)	0.0171%
149	以色列	亚洲	2020	2.21万 (22,070)	0.0164%
150	萨尔瓦多	美洲	2020	2.1万 (21,040)	0.0156%
151	斯洛文尼亚	欧洲	2020	2.05万 (20,480)	0.0152%
152	新喀里多尼亚	大洋洲	2020	1.86万 (18,580)	0.0138%
153	斐济群岛	大洋洲	2020	1.83万 (18,270)	0.0136%
154	科威特	亚洲	2020	1.78万 (17,820)	0.0132%
155	斯威士兰	非洲	2020	1.74万 (17,360)	0.0129%
156	东帝汶	亚洲	2020	1.49万 (14,870)	0.0110%
157	巴哈马	美洲	2020	1.39万 (13,880)	0.0103%
158	黑山	欧洲	2020	1.38万 (13,810)	0.0103%
159	法罗群岛	欧洲	2020	1.3万 (12,959)	0.0096%
160	瓦努阿图	大洋洲	2020	1.22万 (12,190)	0.0091%
161	卡塔尔	亚洲	2020	1.15万 (11,490)	0.0085%
162	冈比亚	非洲	2020	1.13万 (11,300)	0.0084%
163	牙买加	美洲	2020	1.1万 (10,990)	0.0082%
164	黎巴嫩	亚洲	2020	1.04万 (10,450)	0.0078%
165	塞浦路斯	欧洲	2020	9250	0.0069%
166	波多黎各	美洲	2020	8870	0.0066%
167	巴勒斯坦	亚洲	2020	6020	0.0045%
168	文莱	亚洲	2020	5770	0.0043%
169	特立尼达和多巴哥	美洲	2020	5130	0.0038%
170	百慕大	美洲	2020	4290	0.0032%
171	佛得角	非洲	2020	4030	0.0030%
172	法属波利尼西亚	大洋洲	2020	3471	0.0026%
173	萨摩亚	大洋洲	2020	2840	0.0021%
174	卢森堡	欧洲	2020	2590	0.0019%
175	毛里求斯	非洲	2020	2040	0.0015%
176	科摩罗	非洲	2020	1861	0.0014%
177	香港	亚洲	2020	1110	0.0008%
178	圣多美和普林西比	非洲	2020	960	0.0007%
179	特克斯和凯科斯群岛	美洲	2020	950	0.0007%
180	基里巴斯	大洋洲	2020	810	0.0006%
181	巴林	亚洲	2020	785	0.0006%
182	多米尼克	美洲	2020	750	0.0006%
183	汤加	大洋洲	2020	750	0.0006%
184	新加坡	亚洲	2020	728	0.0005%
185	密克罗尼西亚联邦	大洋洲	2020	700	0.0005%
186	圣卢西亚	美洲	2020	620	0.0005%
187	马恩岛	欧洲	2020	570	0.0004%
188	关岛	大洋洲	2020	540	0.0004%
189	安道尔	欧洲	2020	470	0.0003%
190	塞舌尔	非洲	2020	460	0.0003%
191	北马里亚纳群岛	大洋洲	2020	460	0.0003%
192	帕劳	大洋洲	2020	460	0.0003%
193	库拉索	美洲	2020	444	0.0003%
194	安提瓜和巴布达	美洲	2020	440	0.0003%
195	巴巴多斯	美洲	2020	430	0.0003%
196	圣文森特和格林纳丁斯	美洲	2020	390	0.0003%
197	格林纳达	美洲	2020	340	0.0003%
198	马耳他	欧洲	2020	320	0.0002%
199	马尔代夫	亚洲	2020	300	0.0002%
200	开曼群岛	美洲	2020	264	0.0002%
201	圣基茨和尼维斯	美洲	2020	260	0.0002%
202	美属萨摩亚	大洋洲	2020	200	0.0001%
203	马绍尔群岛	大洋洲	2020	180	0.0001%
204	阿鲁巴	美洲	2020	180	0.0001%
205	列支敦士登	欧洲	2020	160	0.0001%
206	英属维尔京群岛	美洲	2020	150	0.0001%
207	摩纳哥	欧洲	2020	74	0.0001%
208	圣马力诺	欧洲	2020	60	0.0000%
209	法属圣马丁	美洲	2020	50	0.0000%
210	荷属圣马丁	美洲	2020	34	0.0000%
211	澳门	亚洲	2020	32	0.0000%
212	图瓦卢	大洋洲	2020	30	0.0000%
213	瑙鲁	大洋洲	2020	20	0.0000%
214	直布罗陀	欧洲	2020	10	0.0000%'''

def collect_countries_area():
    detail_number = re.compile(r"\(.*?\)")

    rows = []
    json_data = {

    }

    for row in raw.split("\n"):
        rows.append(row.replace("\t", "|"))

    cnt = 0
    for row in rows:
        datas = row.split("|")
        name = datas[1]
        area = datas[4]
        if "(" in area:
            # 超过万平方千米
            area = detail_number.findall(area)[0]
            area = area.lstrip("(").rstrip(")")
        area = area.replace(",", "")
        area = int(area)
        json_data[name] = area
        cnt += 1
        print("国土数据载入已完成: " + str(round(cnt / 214 * 100, 2)) + "%\r", end = "")

    json.dump(json_data, open("countries_area_data.json", "w", encoding = "utf-8"), ensure_ascii = False, indent = 4)

    print()
