from ...Internal.Core import Core
from ...Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Reboot:
	"""Reboot commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("reboot", core, parent)

	def set(self) -> None:
		"""SCPI: SYSTem:REBoot \n
		Snippet: driver.system.reboot.set() \n
		Reboots the instrument including the operating system. \n
		"""
		self._core.io.write(f'SYSTem:REBoot')

	def set_with_opc(self) -> None:
		"""SCPI: SYSTem:REBoot \n
		Snippet: driver.system.reboot.set_with_opc() \n
		Reboots the instrument including the operating system. \n
		Same as set, but waits for the operation to complete before continuing further. Use the RsSmcv.utilities.opc_timeout_set() to set the timeout value. \n
		"""
		self._core.io.write_with_opc(f'SYSTem:REBoot')
