from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Special:
	"""Special commands group definition. 4 total commands, 3 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("special", core, parent)

	@property
	def pilot(self):
		"""pilot commands group. 0 Sub-classes, 2 commands."""
		if not hasattr(self, '_pilot'):
			from .Special_.Pilot import Pilot
			self._pilot = Pilot(self._core, self._base)
		return self._pilot

	@property
	def rds(self):
		"""rds commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_rds'):
			from .Special_.Rds import Rds
			self._rds = Rds(self._core, self._base)
		return self._rds

	@property
	def settings(self):
		"""settings commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_settings'):
			from .Special_.Settings import Settings
			self._settings = Settings(self._core, self._base)
		return self._settings

	def clone(self) -> 'Special':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Special(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
