from ....Internal.Core import Core
from ....Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Radio:
	"""Radio commands group definition. 183 total commands, 2 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("radio", core, parent)

	@property
	def am(self):
		"""am commands group. 5 Sub-classes, 5 commands."""
		if not hasattr(self, '_am'):
			from .Radio_.Am import Am
			self._am = Am(self._core, self._base)
		return self._am

	@property
	def fm(self):
		"""fm commands group. 8 Sub-classes, 4 commands."""
		if not hasattr(self, '_fm'):
			from .Radio_.Fm import Fm
			self._fm = Fm(self._core, self._base)
		return self._fm

	def clone(self) -> 'Radio':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Radio(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
