from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Max:
	"""Max commands group definition. 2 total commands, 0 Sub-groups, 2 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("max", core, parent)

	def get_low(self) -> int:
		"""SCPI: [SOURce<HW>]:BB:DVBT:USEFul:[RATE]:MAX:LOW \n
		Snippet: value: int = driver.source.bb.dvbt.useful.rate.max.get_low() \n
		Displays the maximum data rate, that is derived from the current modulation parameter settings. The value is the optimal
		value at the TS input interface, that is necessary for the modulator. If 'Stuffing > On', the value indicates the maximum
		useful data rate, that is allowed in the transport stream. If 'Stuffing > Off', the value indicates the transport stream
		input data rate that is required for the transport stream. \n
			:return: max_use_drlp: integer Range: 0 to 9999999999
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:DVBT:USEFul:RATE:MAX:LOW?')
		return Conversions.str_to_int(response)

	def get_high(self) -> int:
		"""SCPI: [SOURce<HW>]:BB:DVBT:USEFul:[RATE]:MAX:[HIGH] \n
		Snippet: value: int = driver.source.bb.dvbt.useful.rate.max.get_high() \n
		Displays the maximum data rate, that is derived from the current modulation parameter settings. The value is the optimal
		value at the TS input interface, that is necessary for the modulator. If 'Stuffing > On', the value indicates the maximum
		useful data rate, that is allowed in the transport stream. If 'Stuffing > Off', the value indicates the transport stream
		input data rate that is required for the transport stream. \n
			:return: max_use_drhp: integer Range: 0 to 9999999999
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:DVBT:USEFul:RATE:MAX:HIGH?')
		return Conversions.str_to_int(response)
