from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions
from ....... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class State:
	"""State commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("state", core, parent)

	def set(self, state: bool, carrier=repcap.Carrier.Default) -> None:
		"""SCPI: [SOURce<HW>]:BB:ARBitrary:MCARrier:CARRier<CH>:STATe \n
		Snippet: driver.source.bb.arbitrary.mcarrier.carrier.state.set(state = False, carrier = repcap.Carrier.Default) \n
		Enables/diasbled the selected carrier. \n
			:param state: 0| 1| OFF| ON
			:param carrier: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Mcarrier')"""
		param = Conversions.bool_to_str(state)
		carrier_cmd_val = self._base.get_repcap_cmd_value(carrier, repcap.Carrier)
		self._core.io.write(f'SOURce<HwInstance>:BB:ARBitrary:MCARrier:CARRier{carrier_cmd_val}:STATe {param}')

	def get(self, carrier=repcap.Carrier.Default) -> bool:
		"""SCPI: [SOURce<HW>]:BB:ARBitrary:MCARrier:CARRier<CH>:STATe \n
		Snippet: value: bool = driver.source.bb.arbitrary.mcarrier.carrier.state.get(carrier = repcap.Carrier.Default) \n
		Enables/diasbled the selected carrier. \n
			:param carrier: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Mcarrier')
			:return: state: 0| 1| OFF| ON"""
		carrier_cmd_val = self._base.get_repcap_cmd_value(carrier, repcap.Carrier)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:ARBitrary:MCARrier:CARRier{carrier_cmd_val}:STATe?')
		return Conversions.str_to_bool(response)
