from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal.Utilities import trim_str_response
from ....... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class NidPlp:
	"""NidPlp commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("nidPlp", core, parent)

	def get(self, subframe=repcap.Subframe.Default) -> str:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:SUBFrame<CH>:PLP:NIDPlp \n
		Snippet: value: str = driver.source.bb.a3Tsc.subframe.plp.nidPlp.get(subframe = repcap.Subframe.Default) \n
		Queries all IDs of the PLPs mapped to the subframe. \n
			:param subframe: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Subframe')
			:return: pl_pids_sub_frame: string"""
		subframe_cmd_val = self._base.get_repcap_cmd_value(subframe, repcap.Subframe)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:A3TSc:SUBFrame{subframe_cmd_val}:PLP:NIDPlp?')
		return trim_str_response(response)
