from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup
from ......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Alp:
	"""Alp commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("alp", core, parent)

	def get_lmt(self) -> bool:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:SPECial:ALP:LMT \n
		Snippet: value: bool = driver.source.bb.a3Tsc.special.alp.get_lmt() \n
		Sets how the signaling is supported. \n
			:return: lmt_comp_mode: 0| 1| OFF| ON
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:A3TSc:SPECial:ALP:LMT?')
		return Conversions.str_to_bool(response)

	def set_lmt(self, lmt_comp_mode: bool) -> None:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:SPECial:ALP:LMT \n
		Snippet: driver.source.bb.a3Tsc.special.alp.set_lmt(lmt_comp_mode = False) \n
		Sets how the signaling is supported. \n
			:param lmt_comp_mode: 0| 1| OFF| ON
		"""
		param = Conversions.bool_to_str(lmt_comp_mode)
		self._core.io.write(f'SOURce<HwInstance>:BB:A3TSc:SPECial:ALP:LMT {param}')
