from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions
from ..... import enums


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Channel:
	"""Channel commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("channel", core, parent)

	# noinspection PyTypeChecker
	def get_bandwidth(self) -> enums.CodingChannelBandwidth:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:CHANnel:[BANDwidth] \n
		Snippet: value: enums.CodingChannelBandwidth = driver.source.bb.a3Tsc.channel.get_bandwidth() \n
		Selects the channel bandwidth. \n
			:return: channel_bw: BW_6| BW_7| BW_8
		"""
		response = self._core.io.query_str('SOURce<HwInstance>:BB:A3TSc:CHANnel:BANDwidth?')
		return Conversions.str_to_scalar_enum(response, enums.CodingChannelBandwidth)

	def set_bandwidth(self, channel_bw: enums.CodingChannelBandwidth) -> None:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:CHANnel:[BANDwidth] \n
		Snippet: driver.source.bb.a3Tsc.channel.set_bandwidth(channel_bw = enums.CodingChannelBandwidth.BW_6) \n
		Selects the channel bandwidth. \n
			:param channel_bw: BW_6| BW_7| BW_8
		"""
		param = Conversions.enum_scalar_to_str(channel_bw, enums.CodingChannelBandwidth)
		self._core.io.write(f'SOURce<HwInstance>:BB:A3TSc:CHANnel:BANDwidth {param}')
