#!/usr/bin/env python3

# +------------------------+			   
# | Created with Sailboat  |			   
# |			                   |			   
# | Do not edit this file  |			   
# | directly. Instead  	   |			   
# | you should edit the	   |			   
# | `sailboat.toml` file.  |			   
# +------------------------+	

import setuptools

try:
  with open("README.md", "r") as fh:
	  long_description = fh.read()
except:
	long_description = "# XYZ\nA static site builder written in Python\n### Contributors\n- Cole Wilson\n### Contact\n<cole@colewilson.xyz> "

options = {
	"name":"staticXYZ",
	"version":"0.0.2",
	"scripts":['bin/xyz'],
	"entry_points":{'console_scripts': []},
	"author":"Cole Wilson",
	"author_email":"cole@colewilson.xyz",
	"description":"A static site builder written in Python",
	"long_description":long_description,
	"long_description_content_type":"text/markdown",
	"url":"https://github.com/cole-wilson/xyz",
	"packages":setuptools.find_packages(),
	"install_requires":['toml', 'jinja2', 'markdown'],
	"classifiers":["Programming Language :: Python :: 3"],
	"python_requires":'>=3.6',
	"package_data":{"": [],},
	"license":"none",
	"keywords":'static site jekyll xyz',
}

custom_options = {}

if __name__=="__main__":
	setuptools.setup(**custom_options,**options)