"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * (experimental) Github Actions as OpenID Connect Identity Provider for AWS IAM. There can be only one (per AWS Account).
 *
 * Use `fromAccount` to retrieve a reference to existing Github OIDC provider.
 *
 * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services
 * @experimental
 */
class GithubActionsIdentityProvider extends iam.OpenIdConnectProvider {
    /**
     * (experimental) Define a new Github OpenID Connect Identity PRovider for AWS IAM.
     *
     * There can be only one (per AWS Account).
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @experimental
     * @example
     *
     * new GithubActionsIdentityProvider(scope, "GithubProvider");
     */
    constructor(scope, id) {
        super(scope, id, {
            url: `https://${GithubActionsIdentityProvider.issuer}`,
            thumbprints: [GithubActionsIdentityProvider.thumbprint],
            clientIds: ['sts.amazonaws.com'],
        });
    }
    /**
     * (experimental) Retrieve a reference to existing Github OIDC provider in your AWS account.
     *
     * An AWS account can only have single Github OIDC provider configured into it,
     * so internally the reference is made by constructing the ARN from AWS
     * Account ID & Github issuer URL.
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @returns a CDK Construct representing the Github OIDC provider
     * @experimental
     * @example
     *
     * GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider");
     */
    static fromAccount(scope, id) {
        const accountId = cdk.Stack.of(scope).account;
        const providerArn = `arn:aws:iam::${accountId}:oidc-provider/${GithubActionsIdentityProvider.issuer}`;
        return iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(scope, id, providerArn);
    }
}
exports.GithubActionsIdentityProvider = GithubActionsIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
GithubActionsIdentityProvider[_a] = { fqn: "aws-cdk-github-oidc.GithubActionsIdentityProvider", version: "0.0.16" };
/**
 * @experimental
 */
GithubActionsIdentityProvider.issuer = 'token.actions.githubusercontent.com';
/**
 * @experimental
 */
GithubActionsIdentityProvider.thumbprint = 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e';
//# sourceMappingURL=data:application/json;base64,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