#!/usr/bin/env python
# encoding: utf-8
"""
Predictor.py

Created by Wim Vranken on 1st May 2020, as wrapper around original Disomine code
Note that the original DisoMine code was upgraded to Python3.7 and simplified by taking out redundant code for production version
The DisoMine code was also modified to better work in conjunction with the data structures used here.
Copyright (c) 2020- Wim Vranken. All rights reserved.
"""

from b2bTools.general.Io import B2bIo
from b2bTools.singleSeq.DisoMine.standalone import standalone

class DisoMine(B2bIo):

  version = '2.0'
  # scriptName = "b2bTools.singleSeq.DisoMine.Predictor"
  scriptName = "python.b2bTools.singleSeq.DisoMine.Predictor"
  name = "DisoMine"
  def __init__(self):
    self.allPredictions = {}

    # Additional info for writing files
    self.references = ['doi: 10.1101/2020.05.25.115253 (2020)']
    self.infoTexts = ['Generated by DisoMine', 'See http://bio2byte.be']

    self.informationPerPredictor = {
      self.name: {
        'references': self.references,
        'info':       ";".join(self.infoTexts),
        'version':    self.version,
        'origin':     self.scriptName
      }
    }

  # Warning: THIS IS NOW NOT WORKING FROM A DICT BUT FROM A LIST OF TUPLES!
  def predictSeqs(self, seqs):

    """
    :param seqs: List/tuple of (seqId,sequenceString) tuples
    :return: True if all sequences predicted, False if problems

    See self.allPredictions for the predictions themselves.
    """

    assert hasattr(self,'allPredictions') and self.allPredictions and self.allPredictions != {}, "Have to run DynaMine and EFoldMine prior to DisoMine"

    disoMineResults = standalone(seqs, self.allPredictions)

    if not disoMineResults:
      print("DisoMine failed....")
