# Generated by Django 4.0 on 2022-09-15 13:55

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import settings_app.upload_utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('custom', '0001_initial'),
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, null=True)),
                ('last_name', models.CharField(blank=True, max_length=30, null=True)),
                ('pob', models.CharField(blank=True, max_length=100, null=True, verbose_name='Place of birth')),
                ('dob', models.DateField(blank=True, null=True)),
                ('sex', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female')], max_length=6, null=True)),
                ('marital', models.CharField(choices=[('Single', 'Single'), ('Married', 'Married'), ('Divorce', 'Divorce'), ('Widow', 'Widow')], max_length=15, null=True, verbose_name='Marital Status')),
                ('blood', models.CharField(choices=[('A', 'A'), ('B', 'B'), ('AB', 'AB'), ('O', 'O')], max_length=15, null=True)),
                ('father', models.CharField(max_length=100, null=True)),
                ('mother', models.CharField(max_length=100, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.country')),
            ],
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='WorkExperience',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('institute', models.CharField(blank=True, max_length=100, null=True)),
                ('department', models.CharField(blank=True, max_length=200, null=True)),
                ('position', models.CharField(blank=True, max_length=50, null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='workexperience', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(default='default.jpg', null=True, upload_to=settings_app.upload_utils.upload_photo)),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='photo', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='NonFormalEducation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=500, null=True)),
                ('tutelary_entity', models.CharField(blank=True, max_length=100, null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('hours', models.IntegerField(blank=True, null=True)),
                ('area', models.CharField(blank=True, max_length=200, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_nonformal, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach certicate')),
                ('is_active', models.BooleanField(default=True)),
                ('traning_id', models.IntegerField(blank=True, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nonformaleducation', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='LocationTL',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('aldeia', models.CharField(blank=True, max_length=50, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='locationtl', to='employee.employee')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
        ),
        migrations.CreateModel(
            name='LocationInter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=50, null=True)),
                ('city', models.CharField(blank=True, max_length=50, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.country')),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='locationinter', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='LIDNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('electoral', models.CharField(max_length=30, null=True, verbose_name='Electoral Number')),
                ('bi', models.CharField(blank=True, max_length=30, null=True)),
                ('bi_expiry_date', models.DateField(blank=True, null=True)),
                ('passport', models.CharField(blank=True, max_length=15, null=True)),
                ('passport_expiry_date', models.DateField(blank=True, null=True)),
                ('cert_rdtl', models.CharField(blank=True, max_length=30, null=True, verbose_name='Certidaun RDTL')),
                ('file_el', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Electoral')),
                ('file_bi', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach BI')),
                ('file_pas', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Passport')),
                ('file_cert', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Certidaun RDTL')),
                ('file_civil', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_civilstatus, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Civil Status')),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='lidnumber', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='IIDNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('passport', models.CharField(blank=True, max_length=15, null=True)),
                ('passport_expiry_date', models.DateField(blank=True, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='iidnumber', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='FormalEducation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('faculty', models.CharField(blank=True, max_length=100, null=True)),
                ('department', models.CharField(blank=True, max_length=100, null=True)),
                ('area', models.CharField(blank=True, max_length=200, null=True)),
                ('graduation_year', models.DateField(blank=True, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_formal, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach certificate')),
                ('is_active', models.BooleanField(default=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('education_level', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='formaleducation', to='custom.educationlevel')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='formaleducation', to='employee.employee')),
                ('university', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='formaleducation', to='custom.university')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='FIDNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('niss', models.CharField(blank=True, max_length=30, null=True)),
                ('payrol_number', models.CharField(blank=True, max_length=30, null=True)),
                ('bank_account', models.CharField(blank=True, max_length=30, null=True)),
                ('bank', models.CharField(blank=True, max_length=30, null=True)),
                ('iban', models.CharField(blank=True, max_length=30, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach bank account')),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='fidnumber', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='EmployeeUser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='employeeuser', to='employee.employee')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.AddField(
            model_name='employee',
            name='status',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='employee.status'),
        ),
        migrations.AddField(
            model_name='employee',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user'),
        ),
        migrations.CreateModel(
            name='EmpLanguage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('speak', models.CharField(blank=True, choices=[('Native', 'Native'), ('Good', 'Good'), ('Sufficient', 'Sufficient'), ('Basic', 'Basic')], max_length=15, null=True)),
                ('read', models.CharField(blank=True, choices=[('Native', 'Native'), ('Good', 'Good'), ('Sufficient', 'Sufficient'), ('Basic', 'Basic')], max_length=15, null=True)),
                ('write', models.CharField(blank=True, choices=[('Native', 'Native'), ('Good', 'Good'), ('Sufficient', 'Sufficient'), ('Basic', 'Basic')], max_length=15, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='emplanguage', to='employee.employee')),
                ('language', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='emplanguage', to='custom.language')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='EmpDependency',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, null=True)),
                ('pob', models.CharField(blank=True, max_length=100, null=True, verbose_name='Place of birth')),
                ('dob', models.DateField(blank=True, null=True)),
                ('sex', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female')], max_length=6, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_depend, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attachment')),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='empdependency', to='employee.employee')),
                ('family_relation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='empdependency', to='custom.familyrelation')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='DriverLicence',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number', models.CharField(blank=True, max_length=30, null=True)),
                ('type', models.CharField(blank=True, max_length=30, null=True)),
                ('expiry_date', models.DateField(blank=True, max_length=15, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_id_card, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attachment')),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='driverlicence', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='ContactInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.CharField(blank=True, max_length=50, null=True)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('emergency_call', models.CharField(blank=True, max_length=20, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='contactinfo', to='employee.employee')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='AddressTL',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=50, null=True)),
                ('aldeia', models.CharField(blank=True, max_length=50, null=True)),
                ('latitude', models.CharField(blank=True, max_length=20, null=True)),
                ('longitude', models.CharField(blank=True, max_length=20, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('employee', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='addresstl', to='employee.employee')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
        ),
    ]
