/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.tdb.store.bulkloader.BulkLoader;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import tdb2.xloader.AbstractCmdxLoad;
import tdb2.xloader.CmdxBuildIndex;
import tdb2.xloader.CmdxBuildNodeTable;
import tdb2.xloader.CmdxIngestData;

public class CmdxLoader
extends AbstractCmdxLoad {
    public static void main(String ... args) {
        new CmdxLoader("AIO", args).mainRun();
    }

    protected CmdxLoader(String stageName, String[] argv) {
        super(stageName, argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
    }

    @Override
    protected String getCommandName() {
        return "cmd-xloader";
    }

    @Override
    protected void exec() {
        String TMPDIR = this.tmpdir;
        String DIR = this.location;
        String datafile = this.filenames.get(0);
        FileOps.ensureDir(TMPDIR);
        FileOps.clearAll(TMPDIR);
        if (!TMPDIR.equals(DIR)) {
            FileOps.ensureDir(DIR);
            FileOps.clearAll(DIR);
        }
        BulkLoader.DataTickPoint = BulkLoaderX.DataTick = 100000;
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.printf("RAM = %,d\n", maxMemory);
        System.out.println("STEP 1 - load node table");
        CmdxBuildNodeTable.main("--loc=" + DIR, datafile);
        System.out.println("STEP 2 - ingest triples and quads");
        CmdxIngestData.main("--loc=" + DIR, datafile);
        System.out.println("STEP 3 - build indexes");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=SPO");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=POS");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=OSP");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=GSPO");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=GPOS");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=GOSP");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=SPOG");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=POSG");
        CmdxBuildIndex.main("--loc=" + DIR, "--index=OSPG");
    }
}

