/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Boolean2ScorerSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.ReqExclBulkScorer;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreAndDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<WeightedBooleanClause> weightedClauses;
    final ScoreMode scoreMode;

    BooleanWeight(BooleanQuery query2, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query2);
        this.query = query2;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        this.weightedClauses = new ArrayList();
        for (BooleanClause c : query2) {
            Weight w = searcher.createWeight(c.getQuery(), c.isScoring() ? scoreMode : ScoreMode.COMPLETE_NO_SCORES, boost);
            this.weightedClauses.add(new WeightedBooleanClause(c, w));
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        for (WeightedBooleanClause wc : this.weightedClauses) {
            if (!wc.clause.isScoring() && (this.scoreMode.needsScores() || wc.clause.isProhibited())) continue;
            wc.weight.extractTerms(terms);
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            Explanation e2 = w.explain(context2, doc);
            if (e2.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e2);
                } else if (c.isRequired()) {
                    subs.add(Explanation.match((Number)Float.valueOf(0.0f), "match on required clause, product of:", Explanation.match((Number)Float.valueOf(0.0f), (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e2));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.getQuery().toString() + ")", e2));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e2));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Scorer scorer = this.scorer(context2);
        int advanced = scorer.iterator().advance(doc);
        assert (advanced == doc);
        return Explanation.match((Number)Float.valueOf(scorer.score()), "sum of:", subs);
    }

    @Override
    public Matches matches(LeafReaderContext context2, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Matches> matches = new ArrayList<Matches>();
        int shouldMatchCount = 0;
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause bc = wc.clause;
            Matches m = w.matches(context2, doc);
            if (bc.isProhibited() && m != null) {
                return null;
            }
            if (bc.isRequired()) {
                if (m == null) {
                    return null;
                }
                matches.add(m);
            }
            if (bc.getOccur() != BooleanClause.Occur.SHOULD || m == null) continue;
            matches.add(m);
            ++shouldMatchCount;
        }
        if (shouldMatchCount < minShouldMatch) {
            return null;
        }
        return MatchesUtils.fromSubMatches(matches);
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    ScoreAndDoc fake = new ScoreAndDoc();

                    @Override
                    public void setScorer(Scorable scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min2, max2);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context2) throws IOException {
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        for (WeightedBooleanClause wc : this.weightedClauses) {
            BulkScorer subScorer;
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            if (c.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w.bulkScorer(context2)) == null) continue;
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional.size()) {
            return null;
        }
        if (optional.size() == 1) {
            return (BulkScorer)optional.get(0);
        }
        return new BooleanScorer(this, optional, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.scoreMode.needsScores());
    }

    private BulkScorer requiredBulkScorer(LeafReaderContext context2) throws IOException {
        BulkScorer scorer = null;
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            if (!c.isRequired()) continue;
            if (scorer != null) {
                return null;
            }
            scorer = w.bulkScorer(context2);
            if (scorer == null) {
                return null;
            }
            if (c.isScoring() || !this.scoreMode.needsScores()) continue;
            scorer = BooleanWeight.disableScoring(scorer);
        }
        return scorer;
    }

    BulkScorer booleanScorer(LeafReaderContext context2) throws IOException {
        Scorer prohibitedScorer;
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context2);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context2.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses == 1 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context2);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Scorer scorer;
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            if (!c.isProhibited() || (scorer = w.scorer(context2)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer scorer = prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(this, prohibited, ScoreMode.COMPLETE_NO_SCORES);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context2) throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            return super.bulkScorer(context2);
        }
        BulkScorer bulkScorer = this.booleanScorer(context2);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context2);
    }

    @Override
    public Scorer scorer(LeafReaderContext context2) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        if (this.query.clauses().size() > 16) {
            return false;
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            ScorerSupplier subScorer = w.scorerSupplier(context2);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.getOccur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        return new Boolean2ScorerSupplier(this, scorers, this.scoreMode, minShouldMatch);
    }

    private static class WeightedBooleanClause {
        final BooleanClause clause;
        final Weight weight;

        WeightedBooleanClause(BooleanClause clause, Weight weight) {
            this.clause = clause;
            this.weight = weight;
        }
    }
}

