/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.CachingMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatches;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.intervals.MinimizingConjunctionMatchesIterator;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

abstract class ConjunctionIntervalsSource
extends IntervalsSource {
    protected final List<IntervalsSource> subSources;
    protected final boolean isMinimizing;

    protected ConjunctionIntervalsSource(List<IntervalsSource> subSources, boolean isMinimizing) {
        assert (subSources.size() > 1);
        this.subSources = subSources;
        this.isMinimizing = isMinimizing;
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, parent);
        for (IntervalsSource source : this.subSources) {
            source.visit(field, v);
        }
    }

    @Override
    public final IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> subIntervals = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) {
                return null;
            }
            subIntervals.add(it);
        }
        return this.combine(subIntervals);
    }

    protected abstract IntervalIterator combine(List<IntervalIterator> var1);

    @Override
    public final IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            if (this.isMinimizing) {
                mi = new CachingMatchesIterator(mi);
            }
            subs.add(mi);
        }
        IntervalIterator it = this.combine(subs.stream().map(m -> IntervalMatches.wrapMatches(m, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return this.isMinimizing ? new MinimizingConjunctionMatchesIterator(it, subs) : new ConjunctionMatchesIterator(it, subs);
    }

    static class SingletonMatchesIterator
    extends FilterMatchesIterator {
        boolean exhausted = false;

        SingletonMatchesIterator(MatchesIterator in) {
            super(in);
        }

        @Override
        public boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }
    }

    private static class ConjunctionMatchesIterator
    implements IntervalMatchesIterator {
        final IntervalIterator iterator;
        final List<IntervalMatchesIterator> subs;
        boolean cached = true;

        private ConjunctionMatchesIterator(IntervalIterator iterator, List<IntervalMatchesIterator> subs) {
            this.iterator = iterator;
            this.subs = subs;
        }

        @Override
        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        @Override
        public int startPosition() {
            return this.iterator.start();
        }

        @Override
        public int endPosition() {
            return this.iterator.end();
        }

        @Override
        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            for (MatchesIterator matchesIterator : this.subs) {
                start = Math.min(start, matchesIterator.startOffset());
            }
            return start;
        }

        @Override
        public int endOffset() throws IOException {
            int end = -1;
            for (MatchesIterator matchesIterator : this.subs) {
                end = Math.max(end, matchesIterator.endOffset());
            }
            return end;
        }

        @Override
        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
            for (MatchesIterator matchesIterator : this.subs) {
                MatchesIterator sub = matchesIterator.getSubMatches();
                if (sub == null) {
                    sub = new SingletonMatchesIterator(matchesIterator);
                }
                subMatches.add(sub);
            }
            return MatchesUtils.disjunction(subMatches);
        }

        @Override
        public Query getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int gaps() {
            return this.iterator.gaps();
        }

        @Override
        public int width() {
            return this.iterator.width();
        }
    }
}

