/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterTSV
implements ResultSetWriter {
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_TSV)) {
            throw new ResultSetException("ResultSetWriter for TSV asked for a " + lang);
        }
        return new ResultSetWriterTSV();
    };
    private static final String NL = "\n";
    private static final String SEP = "\t";
    private static final String headerBytes = "?_askResult\n";
    private static final String yesBytes = "true";
    private static final String noBytes = "false";

    private ResultSetWriterTSV() {
    }

    @Override
    public void write(OutputStream out, ResultSet resultSet, Context context2) {
        ResultSetWriterTSV.output(IO.wrapUTF8(out), resultSet);
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        ResultSetWriterTSV.output(IO.wrap(out), resultSet);
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
    }

    private static void output(AWriter out, boolean booleanResult) {
        out.write(headerBytes);
        if (booleanResult) {
            out.write(yesBytes);
        } else {
            out.write(noBytes);
        }
        out.write(NL);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(AWriter out, ResultSet resultSet) {
        try {
            NodeFormatter formatter = ResultSetWriterTSV.createNodeFormatter();
            String sep = null;
            List<String> varNames = resultSet.getResultVars();
            ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
            for (String v : varNames) {
                if (sep != null) {
                    out.write(sep);
                } else {
                    sep = SEP;
                }
                Var var = Var.alloc(v);
                out.write(var.toString());
                vars.add(var);
            }
            out.write(NL);
            while (resultSet.hasNext()) {
                sep = null;
                Binding b = resultSet.nextBinding();
                for (Var v : vars) {
                    if (sep != null) {
                        out.write(sep);
                    }
                    sep = SEP;
                    Node n = b.get(v);
                    if (n == null) continue;
                    formatter.format(out, n);
                }
                out.write(NL);
            }
        }
        finally {
            out.flush();
        }
    }

    protected static NodeFormatter createNodeFormatter() {
        return new NodeFormatterTTL(null, null);
    }
}

