/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleDerivation;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngine;
import org.apache.jena.reasoner.rulesys.impl.RETEEngine;
import org.apache.jena.reasoner.rulesys.impl.RETERuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETEConflictSet {
    protected static Logger logger = LoggerFactory.getLogger(FRuleEngine.class);
    protected RETERuleContext gcontext;
    protected boolean isMonotonic;
    protected ArrayList<CSEntry> conflictSet = new ArrayList();
    protected int nPos = 0;
    protected int nNeg = 0;

    public RETEConflictSet(RETERuleContext context2, boolean isMonotonic) {
        this.gcontext = context2;
        this.isMonotonic = isMonotonic;
    }

    public void add(Rule rule, BindingEnvironment env, boolean isAdd) {
        if (this.isMonotonic) {
            RETERuleContext context2 = new RETERuleContext((ForwardRuleInfGraphI)this.gcontext.getGraph(), this.gcontext.getEngine());
            context2.setEnv(env);
            context2.setRule(rule);
            RETEConflictSet.execute(context2, isAdd);
        } else {
            boolean done = false;
            if (isAdd && this.nNeg > 0 || !isAdd && this.nPos > 0) {
                Iterator<CSEntry> i = this.conflictSet.iterator();
                while (i.hasNext()) {
                    CSEntry cse = i.next();
                    if (cse.rule != rule || !cse.env.equals(env) || isAdd == cse.isAdd) continue;
                    i.remove();
                    if (cse.isAdd) {
                        --this.nPos;
                    } else {
                        --this.nNeg;
                    }
                    done = true;
                }
            }
            if (!done) {
                this.conflictSet.add(new CSEntry(rule, env, isAdd));
                if (isAdd) {
                    ++this.nPos;
                } else {
                    ++this.nNeg;
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.conflictSet.isEmpty();
    }

    public boolean fireOne() {
        if (this.isEmpty()) {
            return false;
        }
        int index = this.conflictSet.size() - 1;
        CSEntry cse = this.conflictSet.remove(index);
        if (cse.isAdd) {
            --this.nPos;
        } else {
            --this.nNeg;
        }
        RETERuleContext context2 = new RETERuleContext((ForwardRuleInfGraphI)this.gcontext.getGraph(), this.gcontext.getEngine());
        context2.setEnv(cse.env);
        context2.setRule(cse.rule);
        if (context2.shouldStillFire()) {
            RETEConflictSet.execute(context2, cse.isAdd);
        }
        return true;
    }

    public static void execute(RETERuleContext context2, boolean isAdd) {
        int i;
        Rule rule = context2.getRule();
        BindingEnvironment env = context2.getEnv();
        ForwardRuleInfGraphI infGraph = (ForwardRuleInfGraphI)context2.getGraph();
        if (infGraph.shouldTrace()) {
            logger.info("Fired rule: " + rule.toShortString());
        }
        RETEEngine engine = context2.getEngine();
        engine.incRuleCount();
        ArrayList<Triple> matchList = null;
        if (infGraph.shouldLogDerivations() && isAdd) {
            matchList = new ArrayList<Triple>(rule.bodyLength());
            for (i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clause = rule.getBodyElement(i);
                if (!(clause instanceof TriplePattern)) continue;
                matchList.add(env.instantiate((TriplePattern)clause));
            }
        }
        for (i = 0; i < rule.headLength(); ++i) {
            ClauseEntry hClause = rule.getHeadElement(i);
            if (hClause instanceof TriplePattern) {
                Triple t = env.instantiate((TriplePattern)hClause);
                if (isAdd) {
                    if (context2.contains(t)) continue;
                    engine.addTriple(t, true);
                    if (!infGraph.shouldLogDerivations()) continue;
                    infGraph.logDerivation(t, new RuleDerivation(rule, t, matchList, infGraph));
                    continue;
                }
                if (!context2.contains(t)) continue;
                engine.deleteTriple(t, true);
                continue;
            }
            if (hClause instanceof Functor && isAdd) {
                Functor f = (Functor)hClause;
                Builtin imp = f.getImplementor();
                if (imp != null) {
                    imp.headAction(f.getBoundArgs(env), f.getArgLength(), context2);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + rule.toShortString());
            }
            if (!(hClause instanceof Rule)) continue;
            Rule r = (Rule)hClause;
            if (r.isBackward()) {
                if (isAdd) {
                    infGraph.addBRule(r.instantiate(env));
                    continue;
                }
                infGraph.deleteBRule(r.instantiate(env));
                continue;
            }
            throw new ReasonerException("Found non-backward subrule : " + r);
        }
    }

    private static class CSEntry {
        protected Rule rule;
        protected BindingEnvironment env;
        protected boolean isAdd;

        CSEntry(Rule rule, BindingEnvironment env, boolean isAdd) {
            this.rule = rule;
            this.env = env;
            this.isAdd = isAdd;
        }
    }
}

