/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.List;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;

public class FusekiRequestsMetrics
implements MeterBinder {
    private DataAccessPoint dataAccessPoint;

    public FusekiRequestsMetrics(DataAccessPoint dataAccessPoint) {
        this.dataAccessPoint = dataAccessPoint;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        DataService dataService = this.dataAccessPoint.getDataService();
        for (Operation operation : dataService.getOperations()) {
            List<Endpoint> endpoints = dataService.getEndpoints(operation);
            for (Endpoint endpoint : endpoints) {
                CounterSet counters = endpoint.getCounters();
                for (CounterName counterName : counters.counters()) {
                    Counter counter = counters.get(counterName);
                    Gauge.builder("fuseki_" + counterName.getFullName(), counter, Counter::value).tags("dataset", this.dataAccessPoint.getName(), "endpoint", endpoint.getName(), "operation", operation.getName(), "description", operation.getDescription()).register(registry);
                }
            }
        }
    }
}

