/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.Arrays;
import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;

public class ComponentId {
    public static final int SIZE = 4;
    private final UUID coordinatorId;
    private final byte[] bytes;
    private final String displayName;
    static int counter = 0;

    private ComponentId(String label, UUID coordinatorId, byte[] bytes) {
        this.coordinatorId = coordinatorId;
        if (label == null) {
            label = "";
        }
        if (bytes.length > 4) {
            throw new IllegalArgumentException("Bytes for ComponentId too long " + bytes.length + " > 4");
        }
        if (bytes.length < 4) {
            bytes = Arrays.copyOf(bytes, 4);
        }
        this.bytes = bytes;
        this.displayName = label;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public UUID getBaseId() {
        return this.coordinatorId;
    }

    public String label() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName + "[" + Bytes.asHex(this.bytes) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentId other = (ComponentId)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public static ComponentId create(UUID coordinatorBase, byte[] bytes) {
        bytes = Arrays.copyOf(bytes, bytes.length);
        return new ComponentId(null, coordinatorBase, bytes);
    }

    public static ComponentId alloc(String label, UUID coordinatorBase, int index) {
        byte[] bytes = Bytes.intToBytes(index);
        return new ComponentId(label, coordinatorBase, bytes);
    }

    public static ComponentId allocLocal() {
        UUID uuid2 = UUID.randomUUID();
        return ComponentId.alloc("Local-" + ++counter, uuid2, counter);
    }
}

