"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyBase = exports.MyBaseProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cddc_generated_1 = require("./cddc.generated");
Object.defineProperty(exports, "MyBaseProperty", { enumerable: true, get: function () { return cddc_generated_1.RosMyBase; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::CDDC::MyBase`, which is used to create hosts in a dedicated cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosMyBase`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-cddc-mybase
 */
class MyBase extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosMyBase = new cddc_generated_1.RosMyBase(this, id, {
            ecsInstanceName: props.ecsInstanceName,
            periodType: props.periodType,
            resourceGroupId: props.resourceGroupId,
            userData: props.userData,
            dedicatedHostGroupDescription: props.dedicatedHostGroupDescription,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew,
            ecsUniqueSuffix: props.ecsUniqueSuffix,
            imageId: props.imageId,
            userDataInBase64: props.userDataInBase64,
            ecsHostName: props.ecsHostName,
            engine: props.engine,
            passwordInherit: props.passwordInherit,
            keyPairName: props.keyPairName,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            ecsClassList: props.ecsClassList,
            period: props.period,
            payType: props.payType,
            internetChargeType: props.internetChargeType,
            ecsDeploymentSetId: props.ecsDeploymentSetId,
            internetMaxBandwidthOut: props.internetMaxBandwidthOut,
            vpcId: props.vpcId,
            osPassword: props.osPassword,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMyBase;
        this.attrInstanceIds = rosMyBase.attrInstanceIds;
        this.attrOrderIds = rosMyBase.attrOrderIds;
    }
}
exports.MyBase = MyBase;
//# sourceMappingURL=data:application/json;base64,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