"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DedicatedHostGroup = exports.DedicatedHostGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cddc_generated_1 = require("./cddc.generated");
Object.defineProperty(exports, "DedicatedHostGroupProperty", { enumerable: true, get: function () { return cddc_generated_1.RosDedicatedHostGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::CDDC::DedicatedHostGroup`, which is used to create a dedicated cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDedicatedHostGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-cddc-dedicatedhostgroup
 */
class DedicatedHostGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDedicatedHostGroup = new cddc_generated_1.RosDedicatedHostGroup(this, id, {
            diskAllocationRatio: props.diskAllocationRatio,
            allocationPolicy: props.allocationPolicy,
            vpcId: props.vpcId,
            memAllocationRatio: props.memAllocationRatio,
            hostReplacePolicy: props.hostReplacePolicy,
            cpuAllocationRatio: props.cpuAllocationRatio,
            engine: props.engine,
            dedicatedHostGroupDesc: props.dedicatedHostGroupDesc,
            openPermission: props.openPermission,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDedicatedHostGroup;
        this.attrAllocationPolicy = rosDedicatedHostGroup.attrAllocationPolicy;
        this.attrBastionInstanceId = rosDedicatedHostGroup.attrBastionInstanceId;
        this.attrCpuAllocateRation = rosDedicatedHostGroup.attrCpuAllocateRation;
        this.attrCpuAllocatedAmount = rosDedicatedHostGroup.attrCpuAllocatedAmount;
        this.attrCpuAllocationRatio = rosDedicatedHostGroup.attrCpuAllocationRatio;
        this.attrDedicatedHostGroupDesc = rosDedicatedHostGroup.attrDedicatedHostGroupDesc;
        this.attrDedicatedHostGroupId = rosDedicatedHostGroup.attrDedicatedHostGroupId;
        this.attrDeployType = rosDedicatedHostGroup.attrDeployType;
        this.attrDiskAllocateRation = rosDedicatedHostGroup.attrDiskAllocateRation;
        this.attrDiskAllocatedAmount = rosDedicatedHostGroup.attrDiskAllocatedAmount;
        this.attrDiskAllocationRatio = rosDedicatedHostGroup.attrDiskAllocationRatio;
        this.attrDiskUsedAmount = rosDedicatedHostGroup.attrDiskUsedAmount;
        this.attrDiskUtility = rosDedicatedHostGroup.attrDiskUtility;
        this.attrEngine = rosDedicatedHostGroup.attrEngine;
        this.attrHostNumber = rosDedicatedHostGroup.attrHostNumber;
        this.attrHostReplacePolicy = rosDedicatedHostGroup.attrHostReplacePolicy;
        this.attrInstanceNumber = rosDedicatedHostGroup.attrInstanceNumber;
        this.attrMemAllocateRation = rosDedicatedHostGroup.attrMemAllocateRation;
        this.attrMemAllocatedAmount = rosDedicatedHostGroup.attrMemAllocatedAmount;
        this.attrMemAllocationRatio = rosDedicatedHostGroup.attrMemAllocationRatio;
        this.attrMemUsedAmount = rosDedicatedHostGroup.attrMemUsedAmount;
        this.attrMemUtility = rosDedicatedHostGroup.attrMemUtility;
        this.attrOpenPermission = rosDedicatedHostGroup.attrOpenPermission;
        this.attrText = rosDedicatedHostGroup.attrText;
        this.attrVpcId = rosDedicatedHostGroup.attrVpcId;
    }
}
exports.DedicatedHostGroup = DedicatedHostGroup;
//# sourceMappingURL=data:application/json;base64,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