# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LibraryPanelArgs', 'LibraryPanel']

@pulumi.input_type
class LibraryPanelArgs:
    def __init__(__self__, *,
                 model_json: pulumi.Input[str],
                 folder_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LibraryPanel resource.
        :param pulumi.Input[str] model_json: The JSON model for the library panel.
        :param pulumi.Input[int] folder_id: ID of the folder where the library panel is stored.
        :param pulumi.Input[str] name: Name of the library panel.
        :param pulumi.Input[str] uid: The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        """
        pulumi.set(__self__, "model_json", model_json)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> pulumi.Input[str]:
        """
        The JSON model for the library panel.
        """
        return pulumi.get(self, "model_json")

    @model_json.setter
    def model_json(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_json", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the folder where the library panel is stored.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the library panel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class _LibraryPanelState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[str]] = None,
                 dashboard_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[int]] = None,
                 folder_name: Optional[pulumi.Input[str]] = None,
                 folder_uid: Optional[pulumi.Input[str]] = None,
                 model_json: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[int]] = None,
                 panel_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering LibraryPanel resources.
        :param pulumi.Input[str] created: Timestamp when the library panel was created.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] dashboard_ids: Numerical IDs of Grafana dashboards containing the library panel.
        :param pulumi.Input[str] description: Description of the library panel.
        :param pulumi.Input[int] folder_id: ID of the folder where the library panel is stored.
        :param pulumi.Input[str] folder_name: Name of the folder containing the library panel.
        :param pulumi.Input[str] folder_uid: Unique ID (UID) of the folder containing the library panel.
        :param pulumi.Input[str] model_json: The JSON model for the library panel.
        :param pulumi.Input[str] name: Name of the library panel.
        :param pulumi.Input[int] org_id: The numeric ID of the library panel computed by Grafana.
        :param pulumi.Input[int] panel_id: The numeric ID of the library panel computed by Grafana.
        :param pulumi.Input[str] type: Type of the library panel (eg. text).
        :param pulumi.Input[str] uid: The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        :param pulumi.Input[str] updated: Timestamp when the library panel was last modified.
        :param pulumi.Input[int] version: Version of the library panel.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if dashboard_ids is not None:
            pulumi.set(__self__, "dashboard_ids", dashboard_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if folder_name is not None:
            pulumi.set(__self__, "folder_name", folder_name)
        if folder_uid is not None:
            pulumi.set(__self__, "folder_uid", folder_uid)
        if model_json is not None:
            pulumi.set(__self__, "model_json", model_json)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if panel_id is not None:
            pulumi.set(__self__, "panel_id", panel_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the library panel was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="dashboardIds")
    def dashboard_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Numerical IDs of Grafana dashboards containing the library panel.
        """
        return pulumi.get(self, "dashboard_ids")

    @dashboard_ids.setter
    def dashboard_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "dashboard_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the library panel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the folder where the library panel is stored.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="folderName")
    def folder_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_name")

    @folder_name.setter
    def folder_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_name", value)

    @property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID (UID) of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_uid")

    @folder_uid.setter
    def folder_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_uid", value)

    @property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON model for the library panel.
        """
        return pulumi.get(self, "model_json")

    @model_json.setter
    def model_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_json", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the library panel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="panelId")
    def panel_id(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "panel_id")

    @panel_id.setter
    def panel_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "panel_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the library panel (eg. text).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the library panel was last modified.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Version of the library panel.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class LibraryPanel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_id: Optional[pulumi.Input[int]] = None,
                 model_json: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages Grafana library panels.

        * [Official documentation](https://grafana.com/docs/grafana/latest/panels/panel-library/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/library_element/)

        ## Example Usage

        ```python
        import pulumi
        import json
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.LibraryPanel("test", model_json=json.dumps({
            "title": "updated name",
            "id": 12,
            "version": 35,
        }))
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/libraryPanel:LibraryPanel panel_name {{library_panel_slug}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] folder_id: ID of the folder where the library panel is stored.
        :param pulumi.Input[str] model_json: The JSON model for the library panel.
        :param pulumi.Input[str] name: Name of the library panel.
        :param pulumi.Input[str] uid: The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LibraryPanelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Grafana library panels.

        * [Official documentation](https://grafana.com/docs/grafana/latest/panels/panel-library/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/library_element/)

        ## Example Usage

        ```python
        import pulumi
        import json
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.LibraryPanel("test", model_json=json.dumps({
            "title": "updated name",
            "id": 12,
            "version": 35,
        }))
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/libraryPanel:LibraryPanel panel_name {{library_panel_slug}}
        ```

        :param str resource_name: The name of the resource.
        :param LibraryPanelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LibraryPanelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_id: Optional[pulumi.Input[int]] = None,
                 model_json: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LibraryPanelArgs.__new__(LibraryPanelArgs)

            __props__.__dict__["folder_id"] = folder_id
            if model_json is None and not opts.urn:
                raise TypeError("Missing required property 'model_json'")
            __props__.__dict__["model_json"] = model_json
            __props__.__dict__["name"] = name
            __props__.__dict__["uid"] = uid
            __props__.__dict__["created"] = None
            __props__.__dict__["dashboard_ids"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["folder_name"] = None
            __props__.__dict__["folder_uid"] = None
            __props__.__dict__["org_id"] = None
            __props__.__dict__["panel_id"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        super(LibraryPanel, __self__).__init__(
            'grafana:index/libraryPanel:LibraryPanel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[str]] = None,
            dashboard_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[int]] = None,
            folder_name: Optional[pulumi.Input[str]] = None,
            folder_uid: Optional[pulumi.Input[str]] = None,
            model_json: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[int]] = None,
            panel_id: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'LibraryPanel':
        """
        Get an existing LibraryPanel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created: Timestamp when the library panel was created.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] dashboard_ids: Numerical IDs of Grafana dashboards containing the library panel.
        :param pulumi.Input[str] description: Description of the library panel.
        :param pulumi.Input[int] folder_id: ID of the folder where the library panel is stored.
        :param pulumi.Input[str] folder_name: Name of the folder containing the library panel.
        :param pulumi.Input[str] folder_uid: Unique ID (UID) of the folder containing the library panel.
        :param pulumi.Input[str] model_json: The JSON model for the library panel.
        :param pulumi.Input[str] name: Name of the library panel.
        :param pulumi.Input[int] org_id: The numeric ID of the library panel computed by Grafana.
        :param pulumi.Input[int] panel_id: The numeric ID of the library panel computed by Grafana.
        :param pulumi.Input[str] type: Type of the library panel (eg. text).
        :param pulumi.Input[str] uid: The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        :param pulumi.Input[str] updated: Timestamp when the library panel was last modified.
        :param pulumi.Input[int] version: Version of the library panel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LibraryPanelState.__new__(_LibraryPanelState)

        __props__.__dict__["created"] = created
        __props__.__dict__["dashboard_ids"] = dashboard_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["folder_name"] = folder_name
        __props__.__dict__["folder_uid"] = folder_uid
        __props__.__dict__["model_json"] = model_json
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["panel_id"] = panel_id
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["updated"] = updated
        __props__.__dict__["version"] = version
        return LibraryPanel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Timestamp when the library panel was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="dashboardIds")
    def dashboard_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        Numerical IDs of Grafana dashboards containing the library panel.
        """
        return pulumi.get(self, "dashboard_ids")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the library panel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[int]]:
        """
        ID of the folder where the library panel is stored.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="folderName")
    def folder_name(self) -> pulumi.Output[str]:
        """
        Name of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_name")

    @property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> pulumi.Output[str]:
        """
        Unique ID (UID) of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_uid")

    @property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> pulumi.Output[str]:
        """
        The JSON model for the library panel.
        """
        return pulumi.get(self, "model_json")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the library panel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[int]:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="panelId")
    def panel_id(self) -> pulumi.Output[int]:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "panel_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the library panel (eg. text).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The unique identifier (UID) of a library panel uniquely identifies library panels between multiple Grafana installs. It’s automatically generated unless you specify it during library panel creation.The UID provides consistent URLs for accessing library panels and when syncing library panels between multiple Grafana installs.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        Timestamp when the library panel was last modified.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        Version of the library panel.
        """
        return pulumi.get(self, "version")

