# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CloudPluginInstallationArgs', 'CloudPluginInstallation']

@pulumi.input_type
class CloudPluginInstallationArgs:
    def __init__(__self__, *,
                 slug: pulumi.Input[str],
                 stack_slug: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        The set of arguments for constructing a CloudPluginInstallation resource.
        :param pulumi.Input[str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[str] stack_slug: The stack id to which the plugin should be installed.
        :param pulumi.Input[str] version: Version of the plugin to be installed.
        """
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "stack_slug", stack_slug)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Input[str]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: pulumi.Input[str]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> pulumi.Input[str]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @stack_slug.setter
    def stack_slug(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_slug", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Version of the plugin to be installed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _CloudPluginInstallationState:
    def __init__(__self__, *,
                 slug: Optional[pulumi.Input[str]] = None,
                 stack_slug: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudPluginInstallation resources.
        :param pulumi.Input[str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[str] stack_slug: The stack id to which the plugin should be installed.
        :param pulumi.Input[str] version: Version of the plugin to be installed.
        """
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if stack_slug is not None:
            pulumi.set(__self__, "stack_slug", stack_slug)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> Optional[pulumi.Input[str]]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @stack_slug.setter
    def stack_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_slug", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the plugin to be installed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class CloudPluginInstallation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 stack_slug: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages Grafana Cloud Plugin Installations.

        * [Plugin Catalog](https://grafana.com/grafana/plugins/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.CloudPluginInstallation("test",
            slug="some-plugin",
            stack_slug="stackname",
            version="1.2.3")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/cloudPluginInstallation:CloudPluginInstallation plugin_name {{stack_slug}}_{{plugin_slug}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[str] stack_slug: The stack id to which the plugin should be installed.
        :param pulumi.Input[str] version: Version of the plugin to be installed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudPluginInstallationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Grafana Cloud Plugin Installations.

        * [Plugin Catalog](https://grafana.com/grafana/plugins/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test = grafana.CloudPluginInstallation("test",
            slug="some-plugin",
            stack_slug="stackname",
            version="1.2.3")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/cloudPluginInstallation:CloudPluginInstallation plugin_name {{stack_slug}}_{{plugin_slug}}
        ```

        :param str resource_name: The name of the resource.
        :param CloudPluginInstallationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudPluginInstallationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 stack_slug: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudPluginInstallationArgs.__new__(CloudPluginInstallationArgs)

            if slug is None and not opts.urn:
                raise TypeError("Missing required property 'slug'")
            __props__.__dict__["slug"] = slug
            if stack_slug is None and not opts.urn:
                raise TypeError("Missing required property 'stack_slug'")
            __props__.__dict__["stack_slug"] = stack_slug
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(CloudPluginInstallation, __self__).__init__(
            'grafana:index/cloudPluginInstallation:CloudPluginInstallation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            slug: Optional[pulumi.Input[str]] = None,
            stack_slug: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'CloudPluginInstallation':
        """
        Get an existing CloudPluginInstallation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[str] stack_slug: The stack id to which the plugin should be installed.
        :param pulumi.Input[str] version: Version of the plugin to be installed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudPluginInstallationState.__new__(_CloudPluginInstallationState)

        __props__.__dict__["slug"] = slug
        __props__.__dict__["stack_slug"] = stack_slug
        __props__.__dict__["version"] = version
        return CloudPluginInstallation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> pulumi.Output[str]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Version of the plugin to be installed.
        """
        return pulumi.get(self, "version")

