import { Construct } from '@aws-cdk/core';
import { DatadogCredentials } from '../common/properties';
/**
 * @stability stable
 */
export interface DatadogDashboardProps {
    /**
     * Credentials for the Datadog API.
     *
     * @stability stable
     */
    readonly datadogCredentials: DatadogCredentials;
    /**
     * JSON string of the dashboard definition.
     *
     * @stability stable
     */
    readonly dashboardDefinition: string;
}
/**
 * Datadog Dashboard 1.0.0.
 *
 * @stability stable
 */
export declare class DatadogDashboard {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogDashboardProps);
}
