"""
This subpackage provides a class ConceptLattice to work with Concept Lattice object from FCA theory.

Classes
-------
concept_lattice.ConceptLattice:
    A class to work with Concept Lattices object from FCA theory
formal_concept.FormalConcept:
    A class to describe a Formal Concept object from FCA theory
pattern_concept.PatternConcept:
    A class to describe a Pattern Concept object from FCA theory

Modules
-------
concept_lattice:
    This module provides the ConceptLattice class
concept_measures:
    This module provides a set of functions to compute interestingness measures of concepts
formal_concept:
    This module provides the FormalConcept class
pattern_concept:
    This module provides the PatternConcept class

"""
from .concept_lattice import ConceptLattice
