#  Copyright (c) 2019 Markus Ressel
#  .
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#  .
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#  .
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
from py_range_parse import Range, parse_range

from container_app_conf import ConfigEntry


class RangeConfigEntry(ConfigEntry):
    _example = "[-5..5]"

    def _value_to_type(self, value: any) -> Range or None:
        """
        Tries to convert the given value to a range.
        :param value: the value to parse
        :return: the parsed range value
        """
        if isinstance(value, Range):
            return value
        elif isinstance(value, str):
            parsed = parse_range(value)
            if parsed is None:
                raise ValueError("Cannot parse the range format: {}".format(value))
            return parsed
        else:
            raise ValueError("Unsupported type: {}".format(type(value)))
