[![Build Status](https://travis-ci.org/Bobsans/image-optimizer.svg?branch=master)](https://travis-ci.org/Bobsans/image-optimizer)
[![Coverage Status](https://coveralls.io/repos/github/Bobsans/image-optimizer/badge.svg?branch=master)](https://coveralls.io/github/Bobsans/image-optimizer?branch=master)
[![PyPI version](https://badge.fury.io/py/image_optimizer.svg)](https://badge.fury.io/py/image_optimizer)

image_optimizer
======================================

Оптимизатор изображений на базе PIL.


Установка
--------------------------------------
```bash
pip install image_optimizer
```


Параметры коммандной строки
--------------------------------------
```
> image_optimizer source -r -t THREADS
    source                # Файл или директория для оптимизации
    -r                    # Рекурсивный поиск изображений в поддиректориях
    -t THREADS            # Установка количества потоков
    -l                    # Отключение вывода статистики
    -s RESIZE_PATTERN     # Ресайзинг изображений по шаблону 
```


Использование
--------------------------------------
```bash
# Оптимизация файла image.jpg
> image_optimizer C:\image.jpg

# Оптимизация изображений в директории images
> image_optimizer C:\images

# Оптимизация изображений в директории images и вложенных директориях
> image_optimizer C:\images -r

# Оптимизация изображений в директории images и вложенных директориях в 4 потока
> image_optimizer C:\images -r -t 4

# Оптимизация изображений в директории images и вложенных директориях c ресайзингом вниз до 500px
> image_optimizer C:\images -r -s max500x500 

```

Шаблон ресайзинга
--------------------------------------
Шаблон задается в формате: `[min|max](width)x(height)[f]`

```
[min|max] - (опционально) режим ресайзинга:
   - min - будут изменены размеры (прапорционально) только тех изображений, ширина или высота которых больше заданной до достижения одной из размерностей минимального значения
   - max - будут изменены размеры (прапорционально) только тех изображений, ширина или высота которых меньше заданной до достижения одной из размерностей максимального значения
(width) - необходимая ширина
(height) - необходимая высота
[f] - (опционально) производить ресайзинг по правилам min|max, но без учета размера (будет применено ко всем)
```
Примеры:
```
... -s min1000x1000
>>> image1.jpg (1280x1024) > (1280x1024)
>>> image2.jpg (640x480)   > (1333x1000)

... -s min1000x1000f
>>> image1.jpg (1280x1024) > (1250x1000)
>>> image2.jpg (640x480)   > (1333x1000)

... -s max1000x1000
>>> image1.jpg (1280x1024) > (1000x800)
>>> image2.jpg (640x480)   > (640x480)

... -s max1000x1000f
>>> image1.jpg (1280x1024) > (1000x800)
>>> image2.jpg (640x480)   > (1000x750)

... -s 1000x1000
>>> image1.jpg (1280x1024) > (1000x1000)
>>> image2.jpg (640x480)   > (1000x1000)


```


Поддерживаемые типы файлов
--------------------------------------
BMP, EPS, GIF, J2C, J2K, JP2, JPC, JPE, JPEG, JPF, JPG, JPX, MPO, PBM, PCX, PGM, PNG, PPM, TGA


Список изменений
--------------------------------------
* **v0.3.5** \[_13.10.2018_\]

    - Добавлена возможность ресайзинга изображений.

* **v0.3.4** \[_27.03.2018_\]

    - Переработано форматирование размеров файлов.

* **v0.3.3** \[_02.02.2018_\]

    - Обновлены зависимости.

* **v0.3.2** \[_08.11.2016_\]

    - Добавлен аргумент `-l`, отелючающий вывод статистики.
    - Оптимизация кода.

* **v0.3.1** \[_27.10.2016_\]

    - Убраны аргументы `-f` и `-d`. Теперь можно просто указать путь до файла или папки.
    - Аргумент `--sub` заменен на `-r`.
    - Исправлены некоторые баги.

* **v0.3.0** \[_23.09.2016_\]

    - Добавлена поддержка мультипоточности.
    - Улучшен вывод статистики.

* **v0.2.0** \[_19.09.2016_\]

    - Добавлены аргументы коммандной строки.
    - Добавлена поддержка нестандартных типов изображений.

* **v0.1.0** \[_17.09.2016_\]

    - Начало работы над проектом.


Ссылки
--------------------------------------
- [PyPi](https://pypi.python.org/pypi/image_optimizer)
- [GitHub](https://github.com/Bobsans/image-optimizer)
