"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketReplication = exports.ReplicationRuleStatus = exports.ReplicationDestinationStorageClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
var ReplicationDestinationStorageClass;
(function (ReplicationDestinationStorageClass) {
    ReplicationDestinationStorageClass["DEEP_ARCHIVE"] = "DEEP_ARCHIVE";
    ReplicationDestinationStorageClass["GLACIER"] = "GLACIER";
    ReplicationDestinationStorageClass["INTELLIGENT_TIERING"] = "INTELLIGENT_TIERING";
    ReplicationDestinationStorageClass["ONEZONE_IA"] = "ONEZONE_IA";
    ReplicationDestinationStorageClass["OUTPOSTS"] = "OUTPOSTS";
    ReplicationDestinationStorageClass["REDUCED_REDUNDANCY"] = "REDUCED_REDUNDANCY";
    ReplicationDestinationStorageClass["STANDARD"] = "STANDARD";
    ReplicationDestinationStorageClass["STANDARD_IA"] = "STANDARD_IA";
})(ReplicationDestinationStorageClass = exports.ReplicationDestinationStorageClass || (exports.ReplicationDestinationStorageClass = {}));
var ReplicationRuleStatus;
(function (ReplicationRuleStatus) {
    ReplicationRuleStatus["DISABLED"] = "Disabled";
    ReplicationRuleStatus["ENABLED"] = "Enabled";
})(ReplicationRuleStatus = exports.ReplicationRuleStatus || (exports.ReplicationRuleStatus = {}));
class BucketReplication extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const sourceAccount = cdk.Stack.of(props.sourceBucket).account;
        const destinationAccount = cdk.Stack.of(props.destinationBucket).account;
        const cfnSourceBucket = props.sourceBucket.node
            .defaultChild;
        const replicationRole = new iam.Role(this, 'ReplicationRole', {
            assumedBy: new iam.ServicePrincipal('s3.amazonaws.com'),
        });
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [`${props.destinationBucket.bucketArn}/*`],
            actions: [
                's3:ReplicateObject',
                's3:ReplicateDelete',
                's3:ReplicateTags',
            ],
        }));
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [props.sourceBucket.bucketArn],
            actions: ['s3:GetReplicationConfiguration', 's3:ListBucket'],
        }));
        replicationRole.addToPolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [`${props.sourceBucket.bucketArn}/*`],
            actions: [
                's3:GetObjectVersion',
                's3:GetObjectVersionAcl',
                's3:GetObjectVersionTagging',
            ],
        }));
        if (sourceAccount !== destinationAccount) {
            props.destinationBucket.addToResourcePolicy(new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                principals: [
                    new iam.ArnPrincipal(`arn:aws:iam::${sourceAccount}:root`),
                ],
                resources: [`${props.destinationBucket.bucketArn}/*`],
                actions: [
                    's3:ReplicateObject',
                    's3:ReplicateDelete',
                    's3:ReplicateTags',
                ],
            }));
            props.destinationBucket.addToResourcePolicy(new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                principals: [
                    new iam.ArnPrincipal(`arn:aws:iam::${sourceAccount}:root`),
                ],
                resources: [`${props.destinationBucket.bucketArn}`],
                actions: [
                    's3:List*',
                    's3:GetBucketVersioning',
                    's3:PutBucketVersioning',
                ],
            }));
        }
        cfnSourceBucket.replicationConfiguration = {
            role: replicationRole.roleArn,
            rules: [
                {
                    destination: {
                        storageClass: ReplicationDestinationStorageClass.STANDARD,
                        ...props.replicationDestinationProperties,
                        bucket: props.destinationBucket.bucketArn,
                    },
                    status: ReplicationRuleStatus.ENABLED,
                    ...props.replicationRuleProperties,
                },
            ],
        };
    }
}
exports.BucketReplication = BucketReplication;
_a = JSII_RTTI_SYMBOL_1;
BucketReplication[_a] = { fqn: "cdk-s3-bucketreplication.BucketReplication", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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