"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic
 */
class Topic extends topic_base_1.TopicBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.topicName,
        });
        this.autoCreatePolicy = true;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_TopicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Topic);
            }
            throw error;
        }
        if (props.fifo && !props.topicName) {
            // NOTE: Workaround for CloudFormation problem reported in CDK issue 12386
            // see https://github.com/aws/aws-cdk/issues/12386
            throw new Error('FIFO SNS topics must be given a topic name.');
        }
        if (props.contentBasedDeduplication && !props.fifo) {
            throw new Error('Content based deduplication can only be enabled for FIFO SNS topics.');
        }
        let cfnTopicName;
        if (props.fifo && props.topicName && !props.topicName.endsWith('.fifo')) {
            cfnTopicName = this.physicalName + '.fifo';
        }
        else {
            cfnTopicName = this.physicalName;
        }
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: cfnTopicName,
            kmsMasterKeyId: props.masterKey && props.masterKey.keyArn,
            contentBasedDeduplication: props.contentBasedDeduplication,
            fifoTopic: props.fifo,
        });
        this.topicArn = this.getResourceArnAttribute(resource.ref, {
            service: 'sns',
            resource: this.physicalName,
        });
        this.topicName = this.getResourceNameAttribute(resource.attrTopicName);
        this.fifo = props.fifo || false;
    }
    /**
     * Import an existing SNS topic provided an ARN
     *
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic)
     */
    static fromTopicArn(scope, id, topicArn) {
        class Import extends topic_base_1.TopicBase {
            constructor() {
                super(...arguments);
                this.topicArn = topicArn;
                this.topicName = core_1.Stack.of(scope).splitArn(topicArn, core_1.ArnFormat.NO_RESOURCE_NAME).resource;
                this.fifo = this.topicName.endsWith('.fifo');
                this.autoCreatePolicy = false;
            }
        }
        return new Import(scope, id);
    }
}
exports.Topic = Topic;
_a = JSII_RTTI_SYMBOL_1;
Topic[_a] = { fqn: "@aws-cdk/aws-sns.Topic", version: "1.173.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0b3BpYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx3Q0FBaUQ7QUFFakQsbURBQTJDO0FBQzNDLDZDQUFpRDtBQThDakQ7O0dBRUc7QUFDSCxNQUFhLEtBQU0sU0FBUSxzQkFBUztJQTBCbEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFvQixFQUFFO1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxTQUFTO1NBQzlCLENBQUMsQ0FBQztRQUxjLHFCQUFnQixHQUFZLElBQUksQ0FBQzs7Ozs7OytDQXhCekMsS0FBSzs7OztRQStCZCxJQUFJLEtBQUssQ0FBQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFO1lBQ2xDLDBFQUEwRTtZQUMxRSxrREFBa0Q7WUFDbEQsTUFBTSxJQUFJLEtBQUssQ0FBQyw2Q0FBNkMsQ0FBQyxDQUFDO1NBQ2hFO1FBRUQsSUFBSSxLQUFLLENBQUMseUJBQXlCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFO1lBQ2xELE1BQU0sSUFBSSxLQUFLLENBQUMsc0VBQXNFLENBQUMsQ0FBQztTQUN6RjtRQUVELElBQUksWUFBb0IsQ0FBQztRQUN6QixJQUFJLEtBQUssQ0FBQyxJQUFJLElBQUksS0FBSyxDQUFDLFNBQVMsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ3ZFLFlBQVksR0FBRyxJQUFJLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQztTQUM1QzthQUFNO1lBQ0wsWUFBWSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDbEM7UUFFRCxNQUFNLFFBQVEsR0FBRyxJQUFJLHdCQUFRLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM5QyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsU0FBUyxFQUFFLFlBQVk7WUFDdkIsY0FBYyxFQUFFLEtBQUssQ0FBQyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxNQUFNO1lBQ3pELHlCQUF5QixFQUFFLEtBQUssQ0FBQyx5QkFBeUI7WUFDMUQsU0FBUyxFQUFFLEtBQUssQ0FBQyxJQUFJO1NBQ3RCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUU7WUFDekQsT0FBTyxFQUFFLEtBQUs7WUFDZCxRQUFRLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3ZFLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksSUFBSSxLQUFLLENBQUM7S0FDakM7SUE1REQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLFlBQVksQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFnQjtRQUN2RSxNQUFNLE1BQU8sU0FBUSxzQkFBUztZQUE5Qjs7Z0JBQ2tCLGFBQVEsR0FBRyxRQUFRLENBQUM7Z0JBQ3BCLGNBQVMsR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsZ0JBQVMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLFFBQVEsQ0FBQztnQkFDcEYsU0FBSSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUM5QyxxQkFBZ0IsR0FBWSxLQUFLLENBQUM7WUFDOUMsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7O0FBbEJILHNCQStEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElLZXkgfSBmcm9tICdAYXdzLWNkay9hd3Mta21zJztcbmltcG9ydCB7IEFybkZvcm1hdCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuVG9waWMgfSBmcm9tICcuL3Nucy5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSVRvcGljLCBUb3BpY0Jhc2UgfSBmcm9tICcuL3RvcGljLWJhc2UnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgbmV3IFNOUyB0b3BpY1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFRvcGljUHJvcHMge1xuICAvKipcbiAgICogQSBkZXZlbG9wZXItZGVmaW5lZCBzdHJpbmcgdGhhdCBjYW4gYmUgdXNlZCB0byBpZGVudGlmeSB0aGlzIFNOUyB0b3BpYy5cbiAgICpcbiAgICogQGRlZmF1bHQgTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZGlzcGxheU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgbmFtZSBmb3IgdGhlIHRvcGljLlxuICAgKlxuICAgKiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSBhIG5hbWUsIEFXUyBDbG91ZEZvcm1hdGlvbiBnZW5lcmF0ZXMgYSB1bmlxdWVcbiAgICogcGh5c2ljYWwgSUQgYW5kIHVzZXMgdGhhdCBJRCBmb3IgdGhlIHRvcGljIG5hbWUuIEZvciBtb3JlIGluZm9ybWF0aW9uLFxuICAgKiBzZWUgTmFtZSBUeXBlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBHZW5lcmF0ZWQgbmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgdG9waWNOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIEtNUyBLZXksIGVpdGhlciBtYW5hZ2VkIGJ5IHRoaXMgQ0RLIGFwcCwgb3IgaW1wb3J0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG1hc3RlcktleT86IElLZXk7XG5cbiAgLyoqXG4gICAqIEVuYWJsZXMgY29udGVudC1iYXNlZCBkZWR1cGxpY2F0aW9uIGZvciBGSUZPIHRvcGljcy5cbiAgICpcbiAgICogQGRlZmF1bHQgTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgY29udGVudEJhc2VkRGVkdXBsaWNhdGlvbj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFNldCB0byB0cnVlIHRvIGNyZWF0ZSBhIEZJRk8gdG9waWMuXG4gICAqXG4gICAqIEBkZWZhdWx0IE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGZpZm8/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEEgbmV3IFNOUyB0b3BpY1xuICovXG5leHBvcnQgY2xhc3MgVG9waWMgZXh0ZW5kcyBUb3BpY0Jhc2Uge1xuXG4gIC8qKlxuICAgKiBJbXBvcnQgYW4gZXhpc3RpbmcgU05TIHRvcGljIHByb3ZpZGVkIGFuIEFSTlxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGUgVGhlIHBhcmVudCBjcmVhdGluZyBjb25zdHJ1Y3RcbiAgICogQHBhcmFtIGlkIFRoZSBjb25zdHJ1Y3QncyBuYW1lXG4gICAqIEBwYXJhbSB0b3BpY0FybiB0b3BpYyBBUk4gKGkuZS4gYXJuOmF3czpzbnM6dXMtZWFzdC0yOjQ0NDQ1NTU1NjY2NjpNeVRvcGljKVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tVG9waWNBcm4oc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgdG9waWNBcm46IHN0cmluZyk6IElUb3BpYyB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgVG9waWNCYXNlIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSB0b3BpY0FybiA9IHRvcGljQXJuO1xuICAgICAgcHVibGljIHJlYWRvbmx5IHRvcGljTmFtZSA9IFN0YWNrLm9mKHNjb3BlKS5zcGxpdEFybih0b3BpY0FybiwgQXJuRm9ybWF0Lk5PX1JFU09VUkNFX05BTUUpLnJlc291cmNlO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGZpZm8gPSB0aGlzLnRvcGljTmFtZS5lbmRzV2l0aCgnLmZpZm8nKTtcbiAgICAgIHByb3RlY3RlZCBhdXRvQ3JlYXRlUG9saWN5OiBib29sZWFuID0gZmFsc2U7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSB0b3BpY0Fybjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgdG9waWNOYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBmaWZvOiBib29sZWFuO1xuXG4gIHByb3RlY3RlZCByZWFkb25seSBhdXRvQ3JlYXRlUG9saWN5OiBib29sZWFuID0gdHJ1ZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVG9waWNQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLnRvcGljTmFtZSxcbiAgICB9KTtcblxuICAgIGlmIChwcm9wcy5maWZvICYmICFwcm9wcy50b3BpY05hbWUpIHtcbiAgICAgIC8vIE5PVEU6IFdvcmthcm91bmQgZm9yIENsb3VkRm9ybWF0aW9uIHByb2JsZW0gcmVwb3J0ZWQgaW4gQ0RLIGlzc3VlIDEyMzg2XG4gICAgICAvLyBzZWUgaHR0cHM6Ly9naXRodWIuY29tL2F3cy9hd3MtY2RrL2lzc3Vlcy8xMjM4NlxuICAgICAgdGhyb3cgbmV3IEVycm9yKCdGSUZPIFNOUyB0b3BpY3MgbXVzdCBiZSBnaXZlbiBhIHRvcGljIG5hbWUuJyk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLmNvbnRlbnRCYXNlZERlZHVwbGljYXRpb24gJiYgIXByb3BzLmZpZm8pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ29udGVudCBiYXNlZCBkZWR1cGxpY2F0aW9uIGNhbiBvbmx5IGJlIGVuYWJsZWQgZm9yIEZJRk8gU05TIHRvcGljcy4nKTtcbiAgICB9XG5cbiAgICBsZXQgY2ZuVG9waWNOYW1lOiBzdHJpbmc7XG4gICAgaWYgKHByb3BzLmZpZm8gJiYgcHJvcHMudG9waWNOYW1lICYmICFwcm9wcy50b3BpY05hbWUuZW5kc1dpdGgoJy5maWZvJykpIHtcbiAgICAgIGNmblRvcGljTmFtZSA9IHRoaXMucGh5c2ljYWxOYW1lICsgJy5maWZvJztcbiAgICB9IGVsc2Uge1xuICAgICAgY2ZuVG9waWNOYW1lID0gdGhpcy5waHlzaWNhbE5hbWU7XG4gICAgfVxuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuVG9waWModGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgZGlzcGxheU5hbWU6IHByb3BzLmRpc3BsYXlOYW1lLFxuICAgICAgdG9waWNOYW1lOiBjZm5Ub3BpY05hbWUsXG4gICAgICBrbXNNYXN0ZXJLZXlJZDogcHJvcHMubWFzdGVyS2V5ICYmIHByb3BzLm1hc3RlcktleS5rZXlBcm4sXG4gICAgICBjb250ZW50QmFzZWREZWR1cGxpY2F0aW9uOiBwcm9wcy5jb250ZW50QmFzZWREZWR1cGxpY2F0aW9uLFxuICAgICAgZmlmb1RvcGljOiBwcm9wcy5maWZvLFxuICAgIH0pO1xuXG4gICAgdGhpcy50b3BpY0FybiA9IHRoaXMuZ2V0UmVzb3VyY2VBcm5BdHRyaWJ1dGUocmVzb3VyY2UucmVmLCB7XG4gICAgICBzZXJ2aWNlOiAnc25zJyxcbiAgICAgIHJlc291cmNlOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICB9KTtcbiAgICB0aGlzLnRvcGljTmFtZSA9IHRoaXMuZ2V0UmVzb3VyY2VOYW1lQXR0cmlidXRlKHJlc291cmNlLmF0dHJUb3BpY05hbWUpO1xuICAgIHRoaXMuZmlmbyA9IHByb3BzLmZpZm8gfHwgZmFsc2U7XG4gIH1cbn1cbiJdfQ==