# Generated by Django 2.0.9 on 2018-10-30 04:49

from django.db import migrations, models
import django.db.models.deletion
import moonstuff.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('eveonline', '0010_alliance_ticker'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExtractEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField()),
                ('arrival_time', models.DateTimeField()),
                ('decay_time', models.DateTimeField()),
                ('corp', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveonline.EveCorporationInfo')),
            ],
        ),
        migrations.CreateModel(
            name='Moon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80)),
                ('system_id', models.IntegerField()),
                ('moon_id', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Refinery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150)),
                ('structure_id', models.CharField(max_length=15)),
                ('size', models.BooleanField()),
                ('location', models.ForeignKey(on_delete=models.SET(moonstuff.models.get_fallback_moon), to='moonstuff.Moon')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveonline.EveCorporationInfo')),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ore', models.CharField(max_length=75)),
                ('ore_id', models.IntegerField()),
                ('amount', models.DecimalField(decimal_places=10, max_digits=11)),
            ],
        ),
        migrations.AddField(
            model_name='moon',
            name='resources',
            field=models.ManyToManyField(to='moonstuff.Resource'),
        ),
        migrations.AddField(
            model_name='extractevent',
            name='moon',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='moonstuff.Moon'),
        ),
        migrations.AddField(
            model_name='extractevent',
            name='structure',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='moonstuff.Refinery'),
        ),
        migrations.AlterUniqueTogether(
            name='extractevent',
            unique_together={('arrival_time', 'moon')},
        ),
    ]
