"""See pyproject.toml for project metadata."""

from setuptools import setup

setup()


# [metadata]
# name = FracAbility
# version = attr: my_package.VERSION
# author = Gabriele Benedetti
# author_email = gabri.benedetti@gmail.com
# description = Python toolbox used to analyse fracture networks for digitalized rock outcrops.
# long_description = file: README.md
# long_description_content_type = text/markdown
# keywords = topology earth-science survival-analysis fracture-networks
# url = https://github.com/gbene/FracAbility
#
# classifiers =
#     Programming Language :: Python :: 3.8
#     Programming Language :: Python :: 3.9
#     Programming Language :: Python :: 3.10
#     License :: OSI Approved :: GNU Affero General Public License v3
#     Intended Audience :: Science/Research
#     Topic :: Scientific/Engineering :: Information Analysis
#
# project_urls =
#     changelog = https://github.com/gbene/FracAbility/releases
#     tracker = https://github.com/gbene/FracAbility/issues
#     documentation = https://fracability.readthedocs.io/en/latest/index.html
#
#
# [options]
# package_dir =
#     = fracability
# packages = find:
# python_requires = >=3.8
# install_requires =
#     pyvista
#     networkx
#     geopandas
#     scipy
#     seaborn
#     python-ternary
#     pyperclip
#     pyqt5
#
#
# [options.packages.find]
# where = fracability
