"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @stability stable
 */
class FargateCluster extends cluster_1.Cluster {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            coreDnsComputeType: (_b = props.coreDnsComputeType) !== null && _b !== void 0 ? _b : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.defaultProfile = this.addFargateProfile((_d = (_c = props.defaultProfile) === null || _c === void 0 ? void 0 : _c.fargateProfileName) !== null && _d !== void 0 ? _d : (props.defaultProfile ? 'custom' : 'default'), (_e = props.defaultProfile) !== null && _e !== void 0 ? _e : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
_a = JSII_RTTI_SYMBOL_1;
FargateCluster[_a] = { fqn: "@aws-cdk/aws-eks.FargateCluster", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,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