# Changelog

## v1.8.7 (27/02/2023)
- [Auto Merge](https://github.com/PyLav/PyLav/commit/7e4a64d32360bad65709aeee92ec8e79d82781b3) - @Drapersniper
- [New Crowdin translations by GitHub Action](https://github.com/PyLav/PyLav/commit/c8f362ac0134d74c927db2df6105abf42d979350) - @crowdin-bot
- [Stop using `.changed` property and use `__bool__` dunder](https://github.com/PyLav/PyLav/commit/db9442d27f1bea9efd0366882ac92c468baea87e) - @Drapersniper
- [Merge API ops for volume, and make player.paused into a property](https://github.com/PyLav/PyLav/commit/ceccc6937f4ac50b14546c9d71a15b83c1befdfb) - @Drapersniper
- [Fix a bug where the player was being moved to the same channel it was already in](https://github.com/PyLav/PyLav/commit/1598f5f290440daf1f14200326aeccf6c21bbc75) - @Drapersniper
- [Stop making duplicate del calls to the node api on player destruction](https://github.com/PyLav/PyLav/commit/76e3d6291dda5df1bb49978f681d3a7c52390884) - @Drapersniper
- [Dependency update](https://github.com/PyLav/PyLav/commit/1a849394858ca477bc6a906b8948432990a185a8) - @Drapersniper
- [Update pre-commit sourcery hook](https://github.com/PyLav/PyLav/commit/faa459c4d37e68af13afe21fdc337e6258858798) - @Drapersniper

---

## v1.8.6 (27/02/2023)
- [Fix discord invite breaking](https://github.com/PyLav/PyLav/commit/47eef410323050b6fc4f9d4e7a2ae2e7a183a530) - @Drapersniper
- [Fix Lavalink action reference](https://github.com/PyLav/PyLav/commit/cd0fac6a55a607865b2a540cdaa5a9d2bb6110f0) - @Drapersniper
- [Additional documentation around PostgresSQL setup](https://github.com/PyLav/PyLav/commit/19ee64eb72adb1545e2f68338efe5bc6ac73bcf9) - @Drapersniper

---

## v1.8.5 (26/02/2023)
- [Bump dependencies](https://github.com/PyLav/PyLav/commit/9a6b3bf59b1a2e6d304821dc2de1ee30c92c8f62) - @Drapersniper
- [Auto Merge](https://github.com/PyLav/PyLav/commit/0397a30e9be69ea0686cb5a9f2a1970d9e40751e) - @Drapersniper

---

## v1.8.4 (26/02/2023)
- [Enable the `pg_trgm` module of postgres](https://github.com/PyLav/PyLav/commit/3da844118ec4375fec077d4e41209e613131e866) - @Drapersniper
- [Fix the markdown formatting for 2 variables so that they are rendered](https://github.com/PyLav/PyLav/commit/9e8a2eabfe7a068ac22be096e065c40d5f3bc008) - @Drapersniper
- [Add the player to its track for better requester identification](https://github.com/PyLav/PyLav/commit/7d59dd55a74ed97c0a9093a0c131ab906f95b9a0) - @Drapersniper
- [Bump markdown-it-py from 2.1.0 to 2.2.0 (#221)](https://github.com/PyLav/PyLav/commit/e241b7c64d6cf86a465dc68c87ff8b1ea2d432f3) - @dependabot[bot]
- [update gren settings](https://github.com/PyLav/PyLav/commit/fdbe9c85d47c2939be68db0b1ac6156ddc4c7485) - @Drapersniper

---

## v1.8.3 (21/02/2023)
- [Make release](https://github.com/PyLav/PyLav/commit/bdd04c13e962c7dc6f754bcd96eba2ce02910f9d) - @Drapersniper

---

## v1.8.2 (21/02/2023)


---

## v1.8.1 (21/02/2023)
- [Auto Merge](https://github.com/PyLav/PyLav/commit/8236702ab47e574d8ff34fcbfdcd4c18a5994676) - @Drapersniper
- [New Crowdin translations by GitHub Action](https://github.com/PyLav/PyLav/commit/d7770e9973cbbccdffc19dd867ae27e066ac7cef) - @crowdin-bot
- [Dependency updates](https://github.com/PyLav/PyLav/commit/1482e5e7cea85c6794325cec1df06665f4f663ae) - @Drapersniper
- [Enforce forced vc even in the case of a manual move](https://github.com/PyLav/PyLav/commit/831969923963f41d1ccecff9e19b625026cad6ed) - @Drapersniper
- [pre-commit hook updates](https://github.com/PyLav/PyLav/commit/cafce4edffa5bf4c2c689a416e143d06ce7270c4) - @Drapersniper
- [Clean up player on forced dc](https://github.com/PyLav/PyLav/commit/c6f0587c41e63d5c4343ca731b50ad444bac0284) - @Drapersniper
- [Stop restoring inactive players](https://github.com/PyLav/PyLav/commit/ab3e0c87e85a9b41a6455e998ef66a6920312c40) - @Drapersniper
- [Bump pascalgn/automerge-action from 0.15.5 to 0.15.6 (#219)](https://github.com/PyLav/PyLav/commit/621282d5ec09ae8763150130ade4c2b63b3c1e1e) - @dependabot[bot]

---

## v1.8.0 (16/02/2023)
- [Bump crowdin/github-action from 1.6.0 to 1.7.0 (#216)](https://github.com/PyLav/PyLav/commit/15b3a797b67436e4e2a277985ecd611198893ced) - @dependabot[bot]
- [remove sourcery](https://github.com/PyLav/PyLav/commit/18a79d6e8b55d7d34e626c430b47415b611d8cda) - @Drapersniper
- [Auto Merge](https://github.com/PyLav/PyLav/commit/59710b49084b04fe237ff6e4cc88ad764f78bd9d) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/PyLav/PyLav/commit/f9e04fe8e13e0e9f726b598ca5bc4648d01a2af5) - @crowdin-bot
- [Auto Merge](https://github.com/PyLav/PyLav/commit/c8aaae58eb6efd5bc81cf2de3374b701121fd288) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/PyLav/PyLav/commit/d19fdd6f60b781344a08acdaec4c7a8380a63ced) - @crowdin-bot
- [tweaks and handling for none Query on Trakc object creation](https://github.com/PyLav/PyLav/commit/1db8d832d7aab70722e6c3af130f15aa2b007ac5) - @Drapersniper
- [Rename `is_playing` to `is_active` add `is_playing` which is `is_active and not self.pause`](https://github.com/PyLav/PyLav/commit/edd403f65a920f5fc8d172da3a5c99955dc9cf9e) - @Drapersniper
- [Add initial support for nose resuming](https://github.com/PyLav/PyLav/commit/98544e8f18398a7d49902d6ca00359752ed725f8) - @Drapersniper
- [Fix an issue where queues and history were not restored - Part 2](https://github.com/PyLav/PyLav/commit/84bc6a9d430db035733a424610ca3d487f6e4522) - @Drapersniper
- [Fix an issue where queues and history were not restored](https://github.com/PyLav/PyLav/commit/83d2658d3f3d6603ea226e5f8fbd3992a661d56b) - @Drapersniper
- [fix `KeyError: 'decoded'` on autoplay](https://github.com/PyLav/PyLav/commit/a21d4d5df995dbe476c9fbfe06c7704dd4dacabc) - @Drapersniper
- [Fix `AttributeError: 'NoneType' object has no attribute 'stream'` in queue and now playing generation.](https://github.com/PyLav/PyLav/commit/48e5a38006b4fb3d056e7e2608ded98977db3569) - @Drapersniper
- [automerge](https://github.com/PyLav/PyLav/commit/7ddbaeacc661357682491c90f084d6f25efdd977) - @Drapersniper
- [Auto Merge](https://github.com/PyLav/PyLav/commit/df5a8cdb6fb0944addf088271fa97ca952cb094e) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/PyLav/PyLav/commit/3a58d805e142550265c86ea355f73569584a028e) - @crowdin-bot
- [Update secrets](https://github.com/PyLav/PyLav/commit/955f9c1bfab6bdc25aadce5df6a11ecd22f2e392) - @Drapersniper
- [Update secrets](https://github.com/PyLav/PyLav/commit/5a892ff7ad7d4abb218aa57da66f3c9931a66418) - @Drapersniper

---

## v1.7.2 (13/02/2023)
- [Update references](https://github.com/PyLav/PyLav/commit/c17e6aa9698a4611f8bab2aeb44b4b54d8c4208e) - @Drapersniper

---

## v1.7.1 (13/02/2023)
- [fix workflow](https://github.com/PyLav/PyLav/commit/b387651f92a497b08ec7c609160309337dc71d18) - @Drapersniper

---

## v1.7.0 (13/02/2023)
## What's Changed
* Bump stefanzweifel/git-auto-commit-action from 4.15.4 to 4.16.0 by @dependabot in https://github.com/PyLav/PyLav/pull/212
* New Crowdin translations by Github Action by @Drapersniper in https://github.com/PyLav/PyLav/pull/213
* New Crowdin translations by Github Action by @Drapersniper in https://github.com/PyLav/PyLav/pull/214


**Full Changelog**: https://github.com/PyLav/PyLav/compare/v1.6.1...v1.7.0
---

## v1.6.1 (11/02/2023)
- [fix `asyncpg.exceptions.UndefinedTableError: relation "version" does not exist` in the low level migrations](https://github.com/Drapersniper/PyLav/commit/78919d88592811a85aaac59c177fb3490f5f3e64) - @Drapersniper
- [Change undertow settings](https://github.com/Drapersniper/PyLav/commit/aa62006f814b12cc0268ae934e479288f4dae0ec) - @Drapersniper

---

## v1.6.0 (08/02/2023)
- [Auto Merge](https://github.com/Drapersniper/PyLav/commit/b3ac5aa51ba4a10792b2644b2c8714c473bb0f0d) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/Drapersniper/PyLav/commit/225f07e642033778f4ac198752a9bee9044f680f) - @crowdin-bot
- [Auto Merge](https://github.com/Drapersniper/PyLav/commit/0795fbd0e5f3c08b3a91157a3bdf0e43469cd294) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/Drapersniper/PyLav/commit/09f5e1bde69564a57cf4ebb5fb55103cbd6d34d3) - @crowdin-bot
- [In theory closes #284](https://github.com/Drapersniper/PyLav/commit/3c059405e93bdb70160386b9d14d699d73f69ba4) - @Drapersniper
- [Closes #285](https://github.com/Drapersniper/PyLav/commit/05ce5b67e1f21e5d056b35e1f9478cfd4f8b1018) - @Drapersniper
- [Add __bool__ to Node Response classes](https://github.com/Drapersniper/PyLav/commit/d8f60a8433f25c9873310e59ab71ba333cbc5d41) - @Drapersniper
- [Move the localtrack cache to PyLav](https://github.com/Drapersniper/PyLav/commit/c577dffd1f33f21fbae89d7dcbc97361e421958a) - @Drapersniper
- [Get rid of Partial track logic (maybe to be readded in the future? probs not)](https://github.com/Drapersniper/PyLav/commit/02b54696b01ace5fefd2a08e2b8749e16283b0a7) - @Drapersniper
- [Reset the playlist update timer if the next timer is greater than the current time + the envar number of days until the next (i.e if the envvar value changes)](https://github.com/Drapersniper/PyLav/commit/3691131f9f09672861034ee4169bc9dcd687a740) - @Drapersniper

---

## v1.5.1 (07/02/2023)
- [Auto Merge](https://github.com/Drapersniper/PyLav/commit/aed460efe649837151f262cf3159eb0c609b3daa) - @Drapersniper
- [New Crowdin translations by Github Action](https://github.com/Drapersniper/PyLav/commit/0e6c6fc7fe36ccf1b7b11beb7b873114b89f05b2) - @crowdin-bot
- [Update commit messages for crowdin and automerge](https://github.com/Drapersniper/PyLav/commit/5db98a75007257e929d1fa3f42d88e6a11d249e7) - @Drapersniper
- [don't expose exception in these 2 cases](https://github.com/Drapersniper/PyLav/commit/16e6e94d994039113db5204eb7a7c0c1dd8734a5) - @Drapersniper

---

## v1.5.0 (06/02/2023)
- [Make Release](https://github.com/Drapersniper/PyLav/commit/851dad9e5e9aa06c3d26e01b73186c3b9e34f97b) - @Drapersniper
- [Fix `threading.Lock` and `asyncio.Lock` usages (earlier usage didn't work as a decorator for coroutine decorators).](https://github.com/Drapersniper/PyLav/commit/42ddaa33ac25f2c2ce3966724bf4122b5c4030cd) - @Drapersniper
- [Fix: IndexError list index out of range (#201)](https://github.com/Drapersniper/PyLav/commit/facf83bcad9ae13de85bbee7fc049a76624ca884) - @Drapersniper

---

## v1.4.4 (04/02/2023)
- [Some fixes and dynamic trace for better node logging](https://github.com/Drapersniper/PyLav/commit/0106ccb0f8117a16a3b6cc67136d1c60e1d85f20) - @Drapersniper

---

## v1.4.3 (04/02/2023)
- [Fix and improved bundled playlist update logging](https://github.com/Drapersniper/PyLav/commit/e84e47261c5a9daa4ea62757b812d6bc5a070802) - @Drapersniper

---

## v1.4.2 (04/02/2023)
- [Fix an issue when failures were raising when they should not](https://github.com/Drapersniper/PyLav/commit/d44a15fc07455d0e35eb79aac097d94af0ea8357) - @Drapersniper
- [pre-commit run on all files](https://github.com/Drapersniper/PyLav/commit/06779e908bbea5f3982d6bcb568f23cd5cfeee83) - @Drapersniper
- [ffs](https://github.com/Drapersniper/PyLav/commit/1309217a05f3a293a98176365b5f6f49b4dac5a9) - @Drapersniper
- [ffs](https://github.com/Drapersniper/PyLav/commit/a4c79e4347aeb569618b24d093d99d5782c793ec) - @Drapersniper
- [cleanup automerge](https://github.com/Drapersniper/PyLav/commit/cf76a17424b1e119a0ff6bfbfbf7aae4c8bb52ff) - @Drapersniper

---

## v1.4.1 (04/02/2023)
- [Make Release](https://github.com/Drapersniper/PyLav/commit/c568bd8cadceb3a37ede91d84c307361b353e46d) - @Drapersniper
- [Cleanup the now playing embed text](https://github.com/Drapersniper/PyLav/commit/b80a50de90281f3044f09b3ac37073823552f42b) - @Drapersniper
- [Disable logging for deepdiff and watchfiles modules](https://github.com/Drapersniper/PyLav/commit/9093a9f4468a0fc1a1720f83b1fdf2f93f697b9c) - @Drapersniper
- [Show help on the embed foot to assist users using the controller](https://github.com/Drapersniper/PyLav/commit/cbe06754838e63f17d904c31f082f5661815f760) - @Drapersniper
- [Disable the watchfile logger and deepdiff logger](https://github.com/Drapersniper/PyLav/commit/33adbf6986d103a30bbbf802932371f8ae88e990) - @Drapersniper
- [Add watchfiles dependency to more efficiently process PyLav Local files](https://github.com/Drapersniper/PyLav/commit/4b6bcd354ac3ccea3fc599a78e8f6ccfa4704e6b) - @Drapersniper
- [Add a way to hide the progress bar in the now playing embed](https://github.com/Drapersniper/PyLav/commit/dd1e1b455b386e0a202824762dce9604c0e74083) - @Drapersniper

---

## v1.4.0 (03/02/2023)
- [Release](https://github.com/Drapersniper/PyLav/commit/3752e113e931b0e2da1c7ce619d13ca17455419f) - @Drapersniper
- [fix TypeError: 'async_generator' object cannot be interpreted as an integer](https://github.com/Drapersniper/PyLav/commit/c902ede507aca495cadf4c731828029c4720f5f7) - @Drapersniper
- [fix TypeError: 'async for' requires an object with __aiter__ method, got list_iterator](https://github.com/Drapersniper/PyLav/commit/266979bd0e4e0847e64e31f5008070bdb5f98fdc) - @Drapersniper
- [fix circular import error](https://github.com/Drapersniper/PyLav/commit/2b16919b56fad47709df645c13f5e1cb68bbf7a6) - @Drapersniper
- [Translation friendly strings + a few fixes](https://github.com/Drapersniper/PyLav/commit/1e372611b47c814aa0fbf4c0cc17337b0c288c3c) - @Drapersniper
- [update .pre-commit-config.yaml](https://github.com/Drapersniper/PyLav/commit/a74878f32c86d40902349189e154492e40136b00) - @Drapersniper
- [fix RuntimeWarning: coroutine 'sort_key_nodes' was never awaited](https://github.com/Drapersniper/PyLav/commit/ef9401708aa9d3a3212446f84eadbd8afd8278aa) - @Drapersniper
- [Circular import fix](https://github.com/Drapersniper/PyLav/commit/e2ef9829d93b0baf3c09b14d3364a83f0e8d5975) - @Drapersniper
- [Translation friendly string, reduce usage of asyncstdlib and AsyncIter to improve response times](https://github.com/Drapersniper/PyLav/commit/2868e7bd6b2cf2f1c0f1fe098619036519f2e0eb) - @Drapersniper

---

## v1.3.9 (02/02/2023)
- [fix automerge.yml](https://github.com/Drapersniper/PyLav/commit/06b0c81e1e295b2b2587d9907cddd0938bc8f969) - @Drapersniper
- [automerge.yml update](https://github.com/Drapersniper/PyLav/commit/36b3a0549b692972537e9a408a5058a7b7793e6f) - @Drapersniper
- [Dependency update](https://github.com/Drapersniper/PyLav/commit/9c6cdd1600e3c354defa7568487bccfdf9d50c25) - @Drapersniper
- [update crowdin workflow to run whenever a python file changes](https://github.com/Drapersniper/PyLav/commit/73f0c40ae4595e395d3d98caf368c3858eca85dd) - @Drapersniper
- [fix automerge workflow](https://github.com/Drapersniper/PyLav/commit/e903a5c5df7e8d1d709f96d23669d40e660bff7a) - @Drapersniper
- [update crowdin action to stop pushing translations](https://github.com/Drapersniper/PyLav/commit/d73af846904dba44ba2bde65729463391cf880d8) - @Drapersniper
- [update crowdin action to stop pushing translations](https://github.com/Drapersniper/PyLav/commit/cf063c7a8fea6e0a130250c105c24b55a4352577) - @Drapersniper
- [Update application.example.yml](https://github.com/Drapersniper/PyLav/commit/18800d3b4e1dc1b65661fdbeb21b80fb9c3abc1e) - @Drapersniper
- [Translation-friendly strings; Just partial because I got lazy](https://github.com/Drapersniper/PyLav/commit/2e4eb99d45a91f6dcaa56ee33ecf75241bb1ab9a) - @Drapersniper
- [Delete bad translations](https://github.com/Drapersniper/PyLav/commit/0981e64b107d407ec3835e00eb52177de5e3276d) - @Drapersniper
- [Translation friendly strings](https://github.com/Drapersniper/PyLav/commit/fb9fd96b7c30098adaec79ef0e97e617fa2a34e8) - @Drapersniper
- [Update to the newest version of LavaSrc](https://github.com/Drapersniper/PyLav/commit/ad023b3d996a0a0650a0c927bf8676c3b4db5627) - @Drapersniper
- [Admin: labeller updates](https://github.com/Drapersniper/PyLav/commit/1d4e1b56acc6dd63fcc55303f900dec892f21800) - @Drapersniper
- [vale](https://github.com/Drapersniper/PyLav/commit/3d9b44d74642459b2d724d3347aeacc1bdaadcc8) - @Drapersniper
- [update .pre-commit-config.yaml](https://github.com/Drapersniper/PyLav/commit/a4f3a355da60b19e44bb3a8abbf5be9e6a8a39f5) - @Drapersniper
- [update docker-compose.yml with the new version of Lavasrc](https://github.com/Drapersniper/PyLav/commit/092f3b526c4b85a49c950adaf1a2c69a5c6a5ec2) - @Drapersniper
- [Update Playlist artwork attribute to artworkUrl](https://github.com/Drapersniper/PyLav/commit/91a50fcd6cf1faf02e40455de23695cfb74e9add) - @Drapersniper
- [Labeler and automerge updates](https://github.com/Drapersniper/PyLav/commit/6ac6ffbb70382072f38cc811153abf9bb249f34f) - @Drapersniper
- [chore(workflows): Update automerge workflow to run when a PR is created and on pull review](https://github.com/Drapersniper/PyLav/commit/0f44c78ff7077be111d7e97b7c9a712bb7c81159) - @Drapersniper
- [Clean up Auto merge action](https://github.com/Drapersniper/PyLav/commit/e3510c5e2d4d944abdd64ff2d790e1ccd1078b08) - @Drapersniper
- [Nuke Translations](https://github.com/Drapersniper/PyLav/commit/30c497906f600b3c48a08e2ccdae4a7b55ce0481) - @Drapersniper
- [Nuke Translations](https://github.com/Drapersniper/PyLav/commit/22c7f07b9ec1dcb72802c0a871d41a58b47aed69) - @Drapersniper
- [Fixes](https://github.com/Drapersniper/PyLav/commit/73c5f54b045da08ff8844c39a348bd6279a53fd4) - @Drapersniper
- [update pre-commit](https://github.com/Drapersniper/PyLav/commit/68a0957fb8ea3ac4b2cd288c79e9ca27d2961b1b) - @Drapersniper
- [Simplify Crowdin Action, Update user references to direct users to the PyLav merged project](https://github.com/Drapersniper/PyLav/commit/ed86c5f3136cd002236a0cf32475833e1c335c94) - @Drapersniper
- [Fix the crowdin action](https://github.com/Drapersniper/PyLav/commit/d564475110a402983e030d4ae23f94a2277f8fb6) - @Drapersniper
- [Fix the crowdin action](https://github.com/Drapersniper/PyLav/commit/a439f46d6e9281d5e2395c5cbe877ab8776c57e4) - @Drapersniper
- [Crowdin project merge](https://github.com/Drapersniper/PyLav/commit/0760ac815539f0276de750f6798a6296442b0f70) - @Drapersniper

---

## v1.3.8 (31/01/2023)
- [Formatting and logging added to 1.3.8 LL migration](https://github.com/Drapersniper/PyLav/commit/f52ef79382ebf6d9a0a86a01911649e7cfe621f9) - @Drapersniper
- [Fix ImportError: cannot import name 'ConfigController' from partially initialized module 'pylav.storage.controllers.config' (most likely due to a circular import) introduced with 3107feaa1c54220c79715320425466e8a24a2921](https://github.com/Drapersniper/PyLav/commit/dc3eaba76c69da09813a10c89c45ee2634978d09) - @Drapersniper
- [Update 1.3.8 migration to name the new column artworkUrl instead of artwork to mirror Lavalink's response](https://github.com/Drapersniper/PyLav/commit/f96c39ba72fcf38052b86f71616f28d4368521c6) - @Drapersniper
- [enable local queries to be searchable in the cache](https://github.com/Drapersniper/PyLav/commit/2203bbbb2f1a02758b808e3cc536e4b592ca3643) - @Drapersniper
- [Fix an invalid import due to 3107feaa1c54220c79715320425466e8a24a2921](https://github.com/Drapersniper/PyLav/commit/00620289b508bc320196f4e84f9b39f2aed6ec77) - @Drapersniper
- [Add 1.3.8 migrations](https://github.com/Drapersniper/PyLav/commit/e2debe4b8fef9bb5bccf9fc4e3b6a98a9ffe65e4) - @Drapersniper
- [Cleanup 1.0.0 low level migrations and split it up in prep for 1.3.7 migrations](https://github.com/Drapersniper/PyLav/commit/3107feaa1c54220c79715320425466e8a24a2921) - @Drapersniper
- [Fix an error if a Null player was passed to `Client.get_all_tracks_for_queries`](https://github.com/Drapersniper/PyLav/commit/ed96e0722bc8c1ca86f6c3d275905bef9e2df005) - @Drapersniper
- [Allow caching for the local source](https://github.com/Drapersniper/PyLav/commit/bf28fbc3727c0dbf3fca7ca3c78827e92c9a4f82) - @Drapersniper
- [Update pre-commit hooks](https://github.com/Drapersniper/PyLav/commit/5ff29441dcdcc8fb0a9d970c93ccf779c6082395) - @Drapersniper
- [Make Locks Object specific for locks affecting Players and Queues (Used to be a shared lock)](https://github.com/Drapersniper/PyLav/commit/6f30c712c54c21cd0f5d33878d7c1cda94716074) - @Drapersniper

---

## v1.3.7 (30/01/2023)
- [Cache RadioBrowser responses for http://all.api.radio-browser.info/json/servers as it is extremely rate-limited](https://github.com/Drapersniper/PyLav/commit/141838c5c48e66c542594d3eae606841d28db441) - @Drapersniper
- [Fix the start up failures caused by aiohttp.client_exceptions.ContentTypeError: 0, message='Attempt to decode JSON with unexpected mimetype: text/html; charset=iso-8859-1', url=URL('http://all.api.radio-browser.info/json/servers')](https://github.com/Drapersniper/PyLav/commit/7a69d0be2f8c38344620bd68d5ea2823465e7ecd) - @Drapersniper

---

## v1.3.6 (30/01/2023)
- [Speed up Queue rebuild + fix a crash that could happen due to partial tracks](https://github.com/Drapersniper/PyLav/commit/08fcdb4077d68e81ad524c701c3362b898b66533) - @Drapersniper
- [Localtrack tweaks](https://github.com/Drapersniper/PyLav/commit/a4dba731b9527077f8ea517f1e1985d550256af3) - @Drapersniper
- [Many Localtrack optmizations as well as other smaller tweaks](https://github.com/Drapersniper/PyLav/commit/3f547b36d354662a1d376e18074729410b1acb80) - @Drapersniper

---

## v1.3.5 (30/01/2023)
- [hotfix for d.py circular imports](https://github.com/Drapersniper/PyLav/commit/e7f89ec4739a88ce939bb476546e8cc18d15bec1) - @Drapersniper

---

## v1.3.4 (30/01/2023)
- [remove unnecessary async methods](https://github.com/Drapersniper/PyLav/commit/5a674424ac83783b5df9f2abaf8c61bf9f11b5f3) - @Drapersniper
- [KeyError fix for when new stations are added to RadioBrowser and cache is not up to date.](https://github.com/Drapersniper/PyLav/commit/f4e26a99eea375347d6d11abe1804b33846edcd5) - @Drapersniper

---

## v1.3.3 (29/01/2023)
- [Add caching to the Radio transformers, improve transformers performance](https://github.com/Drapersniper/PyLav/commit/15383ca5189ebdeeddcb85377f28eef956198abd) - @Drapersniper

---

## v1.3.2 (28/01/2023)
- [Fix incorrect boolean in Client.managed_node_is_enabled](https://github.com/Drapersniper/PyLav/commit/cda5e6cff92acbb1a531a651160a7a2547767ebd) - @Drapersniper
- [Disable Managed node if running inside a container](https://github.com/Drapersniper/PyLav/commit/e374c937a51591a5bfb552993041564cb71db668) - @Drapersniper

---

## v1.3.1 (28/01/2023)
- [Add a version bump as part of the release logic](https://github.com/Drapersniper/PyLav/commit/fde01a1fefc393e0263c0423a5f768485f037885) - @Drapersniper
- [Dependency update](https://github.com/Drapersniper/PyLav/commit/a51a5897baff810d29f9ccc1714e4c816d6d7420) - @Drapersniper
- [pre-commit updates](https://github.com/Drapersniper/PyLav/commit/57eaa6eac2a07e873b016c58eec8f1b8636f77ae) - @Drapersniper
- [Bump crowdin/github-action from 1.5.3 to 1.6.0 (#169)](https://github.com/Drapersniper/PyLav/commit/17265241a4fe7dea5b68ab1e9ef1f31a36a46c84) - @dependabot[bot]
- [formatting](https://github.com/Drapersniper/PyLav/commit/b61f421c212f42bf451be8623f55a9aacc36c0d4) - @Drapersniper
- [Update documentation](https://github.com/Drapersniper/PyLav/commit/e923f6944225f8fda72b9e636af66a57761395ed) - @Drapersniper

---

## v1.3.0 (23/01/2023)
- [enhancements to reduce duplicate work on track conversions](https://github.com/Drapersniper/PyLav/commit/03ea4608d6e582c0fdf68d61aa2a01ef36d78cd0) - @Drapersniper
- [Stricter type definitions aligned with Lavalink V4](https://github.com/Drapersniper/PyLav/commit/dc26c0d237480871894aa1651e0856bd98a2309f) - @Drapersniper
- [Fix a startup issue that could happen on an OS change](https://github.com/Drapersniper/PyLav/commit/7a9a1878ced6b3df44a297b09d19f82e0b6643ab) - @Drapersniper
- [pre-commit update](https://github.com/Drapersniper/PyLav/commit/96a8160d2c49bda82ce908d7460b2a9cec8f79ee) - @Drapersniper
- [fix docker-compose.yml envvar](https://github.com/Drapersniper/PyLav/commit/e2cab308f0b55b01349482827e101aff6a1084e3) - @Drapersniper
- [update docker-compose.yml with new red image](https://github.com/Drapersniper/PyLav/commit/a80e543a11e4df1b89d2a6c9cfe9b9778ad7337e) - @Drapersniper
- [Update Docker image to my fork of Phase](https://github.com/Drapersniper/PyLav/commit/f395f55d0020224f498b2e808bc6e6f114ad1e14) - @Drapersniper

---

## v1.2.7 (22/01/2023)
- [Fix incorrect assignement due to walrus](https://github.com/Drapersniper/PyLav/commit/44b55d8456743e3be0b6f6dbd050c20c67fb178d) - @Drapersniper

---

## v1.2.6 (22/01/2023)
- [fix incorrect assignment](https://github.com/Drapersniper/PyLav/commit/3529b64ddc7b0a5a6de70c25ac453215e9766107) - @Drapersniper
- [undo accidental deletion](https://github.com/Drapersniper/PyLav/commit/0c5e325a5f34aefbab08c8aa58aa3cb61c63b27c) - @Drapersniper
- [Introduce end-of-line normalization](https://github.com/Drapersniper/PyLav/commit/a8a08a6ea6c5522cbdc67db79303c894c81d63ab) - @Drapersniper
- [if PYLAV__DATA_FOLDER is defined, and PYLAV__YAML_CONFIG is not specified, create the pylav.yaml file inside PYLAV__DATA_FOLDER](https://github.com/Drapersniper/PyLav/commit/3b58dd42ce1a80a667f31f38e4120b319f83b982) - @Drapersniper
- [update docker compose to use githubs image repo](https://github.com/Drapersniper/PyLav/commit/dccecf9de9b7f72c2372d09657780fe576224b2b) - @Drapersniper
- [Override localtracks folder as part of migrations if the envvar is explicitly set](https://github.com/Drapersniper/PyLav/commit/896048c7a0989764b0aadcbb0269a7f4e4207c6b) - @Drapersniper

---

## v1.2.5 (22/01/2023)
- [fix incorrect URL import](https://github.com/Drapersniper/PyLav/commit/69893a4269e1d84c7af4b580416c3b20ff489e02) - @Drapersniper
- [Use `yarl` which is a dep of aiohttp](https://github.com/Drapersniper/PyLav/commit/bd5ce779c77fcdb2a7c14f0b21320561ff90ec2d) - @Drapersniper
- [Fix RadioBrowser resolution and simplify logic](https://github.com/Drapersniper/PyLav/commit/f382e7356af321cc7ab1bfe3d9b1051447f94709) - @Drapersniper
- [fix NameError: name '__load_origin' is not defined](https://github.com/Drapersniper/PyLav/commit/449aadc52b924822b3631262687ee6bc066b28cd) - @Drapersniper

---

## v1.2.4 (21/01/2023)
- [fix AttributeError: 'Red' object has no attribute 'dispatch_event'](https://github.com/Drapersniper/PyLav/commit/acb26eeda14573ede7649044ca6e08c83f221abf) - @Drapersniper
- [add home helper code to identify origins](https://github.com/Drapersniper/PyLav/commit/f73b2d724d1db0cd125e21667e0c8f8e0cddf661) - @Drapersniper
- [Bump dependencies](https://github.com/Drapersniper/PyLav/commit/18c6c7bd4568f20d5059a8b2178c9af0e29f674b) - @Drapersniper
- [fix incorrect doc strings](https://github.com/Drapersniper/PyLav/commit/95245e1e6191ea8ce5e7fe71b1fe6f14668f35f8) - @Drapersniper
- [Implement a compatibility module for the json module which uses fastest json module available for any given op](https://github.com/Drapersniper/PyLav/commit/9bf08eac497bc3c2a152c1e37ac5e49512400529) - @Drapersniper

---

## v1.2.3 (21/01/2023)
- [add `PlayerAutoDisconnectedEmptyQueueEvent`  `PlayerAutoDisconnectedAloneEvent` `PlayerAutoPausedEvent` and `PlayerAutoResumedEvent` events to the player](https://github.com/Drapersniper/PyLav/commit/26e48b07448cabf25584a55810d8b75b304d2afc) - @Drapersniper
- [add `PYLAV__YAML_CONFIG` and `PYLAV__LOCAL_TRACKS_FOLDER` env vars](https://github.com/Drapersniper/PyLav/commit/2458cc2461150835b197d73625ad894771a5789c) - @Drapersniper
- [explicitly set the hostname and container_name](https://github.com/Drapersniper/PyLav/commit/ecbbfb6db28e7b8e88a9a969b958904b6f1ece36) - @Drapersniper

---

## v1.2.2 (18/01/2023)
- [properly use PYLAV__EXTERNAL_UNMANAGED_NAME](https://github.com/Drapersniper/PyLav/commit/273b5046238d5ef1e178975967f5b433fe3a2cdf) - @Drapersniper

---

## v1.2.1 (18/01/2023)
- [Remove caching from radio browser api init](https://github.com/Drapersniper/PyLav/commit/a4e870d8236204ef8387ff5bc44f6390346d84ca) - @Drapersniper

---

## v1.2.0 (18/01/2023)
- [Enforce Env Var on config stored values (Run a migration on every start up)](https://github.com/Drapersniper/PyLav/commit/0295ddeacc89f8449e7d84cd0b208bedb85c51da) - @Drapersniper
- [Add PYLAV__EXTERNAL_UNMANAGED_NAME to allow setting a name to the EnvVar node and set ENV Vars to take precedence over the file values](https://github.com/Drapersniper/PyLav/commit/66643bb714fc67f6a0e4bc7cad4ecb34e02d624a) - @Drapersniper
- [update docker-compose.yml](https://github.com/Drapersniper/PyLav/commit/650e7308758858c8139eb8ef0ffbb96a41e881d8) - @Drapersniper

---

## v1.1.19 (18/01/2023)
- [Make Release](https://github.com/Drapersniper/PyLav/commit/9b2a1a1286636201ec5a3716d51768459afb3f4f) - @Drapersniper

---

## v1.1.18 (18/01/2023)
- [hotfix migration](https://github.com/Drapersniper/PyLav/commit/f80281b26fd21eefb9faccae984c49e137e46f4d) - @Drapersniper

---

## v1.1.17 (18/01/2023)
- [pre-commit update](https://github.com/Drapersniper/PyLav/commit/e8b5120f3fbedb51aab021ef7037e59b6478bb16) - @Drapersniper
- [Tweak LavaScr Providers to align with Topi's suggestion](https://github.com/Drapersniper/PyLav/commit/23247baad9b55badb12c5b68fe8d63d913f8d74e) - @Drapersniper

---

## v1.1.7 (15/01/2023)
- [Tweaks to special handling logic for node penalty](https://github.com/Drapersniper/PyLav/commit/1c27a95e7899a6102edfd3b0b64dc6e0176f1d25) - @Drapersniper
- [fix incorrect reference to pylav.docker.yaml](https://github.com/Drapersniper/PyLav/commit/fdbe1ec61e4005360ae2152738ec96bf238f422e) - @Drapersniper

---

## v1.1.6 (14/01/2023)
- [Add a special penalty handling for nodes to change the weighting](https://github.com/Drapersniper/PyLav/commit/44153b74658aca19d5c3d829977e00482dae8b52) - @Drapersniper
- [Update docker-compose.yml with the new lavasrc commit](https://github.com/Drapersniper/PyLav/commit/f6fda52bb1817a890e23266f160b2c2f74a253d3) - @Drapersniper
- [Disable the london node - as that has been sunset-ed for the time being](https://github.com/Drapersniper/PyLav/commit/867fc28cb15e0f3e8ce813663344bc86723c4d0b) - @Drapersniper
- [Add new Lavasrc configuration values for playlist and album limits (Applemusic built-in limit = 9K songs and Spotify = 11K songs)](https://github.com/Drapersniper/PyLav/commit/0de5c235336b61002b4af14bd455d32304ea9d2c) - @Drapersniper

---

## v1.1.5 (12/01/2023)
- [More optimizations](https://github.com/Drapersniper/PyLav/commit/240686c7c45c4fcd6d384ca8e334689f0504bd28) - @Drapersniper
- [optmization fixes](https://github.com/Drapersniper/PyLav/commit/df6aaf99105817218b3898c53efe621678f1aa75) - @Drapersniper
- [bulk process track where possible](https://github.com/Drapersniper/PyLav/commit/31e8df416507f29e8b1995191570566da4c62eb3) - @Drapersniper
- [Increase the node session timeouts](https://github.com/Drapersniper/PyLav/commit/cf0b3c9f0e762aadc2374060625f4f49e4bf9f8c) - @Drapersniper
- [pre-commit hook version update](https://github.com/Drapersniper/PyLav/commit/445817f0ff0a1e6db035dd29a2a3e5bad70d89d1) - @Drapersniper
- [increase session timeout for node](https://github.com/Drapersniper/PyLav/commit/3c9cbfe39278ec71ba4b655b2a86ea713810dbf2) - @Drapersniper

---

## v1.1.4 (09/01/2023)
- [Further start up enhancements](https://github.com/Drapersniper/PyLav/commit/1b89d276b8e3bceb9430cb0c36ad2f842391226f) - @Drapersniper

---

## v1.1.3 (09/01/2023)
- [Better track caching and references (Better performance)](https://github.com/Drapersniper/PyLav/commit/9eedaa9d17431e275431ea414a92a04c9ce58323) - @Drapersniper
- [Fix the base64 decoder](https://github.com/Drapersniper/PyLav/commit/b550a3d20b3f5cd01956da62e31c6143b0c5b5b4) - @Drapersniper
- [Used cached session for decode endpoints](https://github.com/Drapersniper/PyLav/commit/4197ad78cfa0210c6fc20f352b32ff91d642609a) - @Drapersniper
- [Fix incorrect cog name reference](https://github.com/Drapersniper/PyLav/commit/6b364195f70e664d4976813901aa5e462068b0d8) - @Drapersniper
- [fix AttributeError: 'NoneType' object has no attribute 'source'](https://github.com/Drapersniper/PyLav/commit/9fec736961094fcfd54afde511b6dcfe7a747df3) - @Drapersniper
- [precommit update](https://github.com/Drapersniper/PyLav/commit/839b097a2d8bd4817006e86ba0a3c94cb38038e4) - @Drapersniper
- [Update setup.md](https://github.com/Drapersniper/PyLav/commit/a6a576f57b598817c00d8ed4b5774db13e011bee) - @Drapersniper

---

## v1.1.2 (08/01/2023)
- [Update docker-compose.yml](https://github.com/Drapersniper/PyLav/commit/90d0b1e3919b0e1916d91b173607ec38e7d5fdb3) - @Drapersniper
- [Update .pre-commit-config.yaml](https://github.com/Drapersniper/PyLav/commit/313f111b139cc05166dc8e06fd5f42d8fcaf7729) - @Drapersniper
- [Fix possible AttributeError in QueueSource (#149)](https://github.com/Drapersniper/PyLav/commit/dd9d5518236eeba2715aaad59b92464a017f42eb) - @Kuro-Rui

---

## v1.1.1 (07/01/2023)
- [Bump actions/checkout from 3.1.0 to 3.3.0 (#145)](https://github.com/Drapersniper/PyLav/commit/5e1df240ffcff4f90cfc211dc297092936e14c68) - @dependabot[bot]
- [Add a missing positional argument in player.stop() (#148)](https://github.com/Drapersniper/PyLav/commit/21ac9dc7c22fa30efd3e3fe4a421ce9539e1af1d) - @Kuro-Rui

---

## v1.1.0 (06/01/2023)
- [Cleanup docker-compose.yml](https://github.com/Drapersniper/PyLav/commit/6a74b5b850ea5fd880da50a6578f254b0acde969) - @Drapersniper
- [Add every possible configuration option as an env var](https://github.com/Drapersniper/PyLav/commit/ca0b71a12e1c6f8b9e24460fd103b4ac80bb143d) - @Drapersniper
- [ignore unknown events rather than restarting the websocket connection](https://github.com/Drapersniper/PyLav/commit/59546915bc9ff1de2ffa2da1ff1c0423a6427ea3) - @Drapersniper
- [Fixes incorrect references to SegmentLoaded/SegmentSkipped events from the sponsorblock plugin](https://github.com/Drapersniper/PyLav/commit/d67c2eb47eb09c150db5e8166422f99823c80892) - @Drapersniper
- [Cleanup Sponsorblock changes](https://github.com/Drapersniper/PyLav/commit/c5fc1e0fba962401ae0ff286e99d6df76116440a) - @Drapersniper
- [Update Sponsorblock plugin to pre-release version with RESTAPI support](https://github.com/Drapersniper/PyLav/commit/4d32b74f4437f00cf7c0b5397da32561da36b9be) - @Drapersniper

---

## v1.0.15 (05/01/2023)
- [correct reset track position for historic tracks and enhanced query meta persistence](https://github.com/Drapersniper/PyLav/commit/c4c8f6ecc3e8a93e817569f6d95a8ed452ec3adf) - @Drapersniper
- [don't discard query metadata on rebuild (i.e Properly allow users to use link timestamp for youtube, spotify and soundcloud)](https://github.com/Drapersniper/PyLav/commit/fc28eac4825117ddae715b12ef1896830b560205) - @Drapersniper
- [Reference source regex](https://github.com/Drapersniper/PyLav/commit/f8337cd1d09842dabc6da28f3da90d95358e2a32) - @Drapersniper
- [Handle TrackNotFoundException closes #143](https://github.com/Drapersniper/PyLav/commit/f98470bc77b66ce4c8283f19c83bfdc4843d6e47) - @Drapersniper

---

## v1.0.14 (04/01/2023)
- [Make Release](https://github.com/Drapersniper/PyLav/commit/c2c8562fa79698bf76c200d69ffd9daecbe7891e) - @Drapersniper

---

## v1.0.13 (04/01/2023)
- [v1.0.13 (#140)](https://github.com/Drapersniper/PyLav/commit/770238c7cf1de68c9218a3327364bbc52dbbc100) - @Drapersniper
- [Update SETUP.md](https://github.com/Drapersniper/PyLav/commit/121cfdd1bc4aa8455a0018403c6dbafb61e7e93c) - @Drapersniper
- [Remove even more old locale folders](https://github.com/Drapersniper/PyLav/commit/ab156ad3848c454918795bb1d049363299abbbf1) - @Drapersniper
- [remove invalid locales folder](https://github.com/Drapersniper/PyLav/commit/51a6bb88bbb33d61ac3d90b6d208fcb6f96fe1e6) - @Drapersniper

---

## v1.0.12 (02/01/2023)
- [`[p]plsyncslash` should be owner only v2](https://github.com/Drapersniper/PyLav/commit/2f5c1c5d417edc4292ace9bf01e471618c0bf6f7) - @Drapersniper

---

## v1.0.11 (02/01/2023)
- [`[p]plsyncslash` should be owner only](https://github.com/Drapersniper/PyLav/commit/5690710cdabf5b6b245043c01a50f0f0cdaafbe3) - @Drapersniper
- [Remove old invalid locale folders](https://github.com/Drapersniper/PyLav/commit/9f2b28f4c7eaa589a3df20cb83274c9b67b3af7a) - @Drapersniper
- [[CI] Add automerge label to workflow prs](https://github.com/Drapersniper/PyLav/commit/7ab00839d50b6c686362fa1b37303436792eb560) - @Drapersniper

---

## v1.0.10 (02/01/2023)
- [Make sure name attribute can exist before accessing it](https://github.com/Drapersniper/PyLav/commit/037e0c4f0a93acbc7c4642e22f899bd99e7c70c0) - @Drapersniper

---

## v1.0.9 (02/01/2023)
- [default the PyLav external node to off](https://github.com/Drapersniper/PyLav/commit/7217d3bf68a385ca5c8d5f591395c29531f9eed1) - @Drapersniper

---

## v1.0.8 (02/01/2023)
- [fix to avoid the local database being constantly wiped](https://github.com/Drapersniper/PyLav/commit/dba0dcadf21c91fe1b8fa7fd2a72e60cdee5d598) - @Drapersniper
- [Remove `lava.link` bundled node permanently](https://github.com/Drapersniper/PyLav/commit/d7f201297e56f91faff0842541c8e92265bba56a) - @Drapersniper
- [make the redbot container depend on the postgres and ll-node containers](https://github.com/Drapersniper/PyLav/commit/d6ac80a1c309e0619431b01b54f43d8268bc478f) - @Drapersniper
- [Dependency update and cleanup](https://github.com/Drapersniper/PyLav/commit/7a51c40100e734aa151ea72e5751a39317fb47b6) - @Drapersniper

---

## v1.0.7 (02/01/2023)


---

## v1.0.6 (02/01/2023)
## What's Changed
* New Crowdin translations by Github Action by @Drapersniper in https://github.com/Drapersniper/PyLav/pull/132


**Full Changelog**: https://github.com/Drapersniper/PyLav/compare/v1.0.4...v1.0.6
---

## v1.0.5 (02/01/2023)
- [delete empty queries in cache](https://github.com/Drapersniper/PyLav/commit/9e70abea40b967950b7fb2129502d423697ed8cd) - @Drapersniper
- [Only return cached entry if there are tracks to be returned](https://github.com/Drapersniper/PyLav/commit/e10369fa5549217c2e8e54f0a616de1b7e93a5b4) - @Drapersniper
- [Add a note to the the setup.md](https://github.com/Drapersniper/PyLav/commit/e38ba1089c3960ac846b982b125a804fa0ea31ad) - @Drapersniper

---

## v1.0.4 (01/01/2023)
- [Add the youtube email config option](https://github.com/Drapersniper/PyLav/commit/7f98770f7ad81e73a476c82b749755e172a613cd) - @Drapersniper
- [Expose the dispatch manager attribute of pylav](https://github.com/Drapersniper/PyLav/commit/d2aecaafeb483a83f3218175d84f7264f8a73726) - @Drapersniper
- [Better documentation](https://github.com/Drapersniper/PyLav/commit/b5ee42b0552b7f362e52777e8c0fa30934738331) - @Drapersniper
- [Ignore DB connection errors on tasks](https://github.com/Drapersniper/PyLav/commit/bcc35de6beea4558e3d631a7c731b288b2c1c682) - @Drapersniper

---

## v1.0.3 (01/01/2023)
- [Add a workflow dispatch to PyLav-Cogs](https://github.com/Drapersniper/PyLav/commit/ad3b246c5d7c50eb821036ae20fbbc3bdfea6c25) - @Drapersniper
- [fix versioning](https://github.com/Drapersniper/PyLav/commit/9683e6d8702b20e24a42dc517623d8c04c10cdcf) - @Drapersniper
- [Sourcery](https://github.com/Drapersniper/PyLav/commit/9dc5bb339e1963f12a0c0860d89a98d3a4bc6f6a) - @Drapersniper

---

## v1.0.2 (01/01/2023)
- [Cleanup](https://github.com/Drapersniper/PyLav/commit/5b734b8408c159c38a09060aec991192a5f4b849) - @Drapersniper
- [Cleanup](https://github.com/Drapersniper/PyLav/commit/bfa1d4f4e2d75b28444076a0030632bccf4785e8) - @Drapersniper
- [Clarification in the SETUP.md](https://github.com/Drapersniper/PyLav/commit/950d642586a8188c07f0752e0ef9bb6d287460da) - @Drapersniper

---

## v1.0.1 (01/01/2023)
- [Properly parse applemusic and mixcloud queries](https://github.com/Drapersniper/PyLav/commit/e5beceed727b733bb497afef58fbb14ff65df5fe) - @Drapersniper
- [Fix regex for Spotify, apple music, bandcamp and soundcloud](https://github.com/Drapersniper/PyLav/commit/ee915ea302c324ca899150e197b35a5b5d918e82) - @Drapersniper
- [Some clarification of docker usage](https://github.com/Drapersniper/PyLav/commit/9810baa4807b50da70c86caee2f4ff439607e8fe) - @Drapersniper
- [Add a mention to discord to use docker container](https://github.com/Drapersniper/PyLav/commit/20de69c33fce4ada25aadf0dff408870c3981564) - @Drapersniper
- [add workflow_dispatch: to certain workflows](https://github.com/Drapersniper/PyLav/commit/ea99e761e98570fc719aa8c05202938b54e78f23) - @Drapersniper
- [Fix crowdin workflows](https://github.com/Drapersniper/PyLav/commit/706c842847a6a9e4e363c67f6698f168e454bb1e) - @Drapersniper

---

## v1.0.0 (30/12/2022)
- [fix release.yml](https://github.com/Drapersniper/PyLav/commit/08d440d79eef207a6a92b6987f394069c01befff) - @Drapersniper
- [reexport gren token](https://github.com/Drapersniper/PyLav/commit/81b453673c0171dec1c78043cf5733549fbf1311) - @Drapersniper
- [force token](https://github.com/Drapersniper/PyLav/commit/79447bd5213fa365b5bbf0bfe5a8f892cb644577) - @Drapersniper
- [reuse poetry cache on changelogs](https://github.com/Drapersniper/PyLav/commit/7d0509ad2c9e9d5611913f1b74c49d01b6dddcee) - @Drapersniper
- [don't try to publish if already existing](https://github.com/Drapersniper/PyLav/commit/cefc3e668d2c5a422f0090934f9a3c22daa4bac9) - @Drapersniper
- [Only run release on Ubuntu-latest for now](https://github.com/Drapersniper/PyLav/commit/b2ede0799801e78ad5289d43abe74c0362a72404) - @Drapersniper
- [Fixes release workflow](https://github.com/Drapersniper/PyLav/commit/7f4e87597d5fb910fb7f283c37ff21abedbaa7d7) - @Drapersniper
- [Fixes release workflow](https://github.com/Drapersniper/PyLav/commit/fa323e0d5b7c60634e337876759cf1c344720dd9) - @Drapersniper
- [1 0 0](https://github.com/Drapersniper/PyLav/commit/2b2fac3f4f3da7b790af0728292554410eda00f3) - @Drapersniper

---

## v0.11.20.0 (30/12/2022)
- [[patch] make patch release](https://github.com/Drapersniper/PyLav/commit/a04b7ca0a694e5ce43abc01400e97af981acefbb) - @Drapersniper
- [[patch] ignore unsupported lavalink releases (3.7+)](https://github.com/Drapersniper/PyLav/commit/2a236366ca4d439c60fd402c3a6b06f6d69a40c0) - @Drapersniper
- [add labeler.yml](https://github.com/Drapersniper/PyLav/commit/b73b4636b5ea5377d4ebec031c2e90cbbe1ec3e1) - @Drapersniper
- [Bump actions/dependency-review-action from 2 to 3](https://github.com/Drapersniper/PyLav/commit/e7ddb46c1ea723157b4ef38f4b4fc00b90948c8f) - @dependabot[bot]
- [Bump crowdin/github-action from 1.5.0 to 1.5.1](https://github.com/Drapersniper/PyLav/commit/012e60dd64c02d05050067e4ef96bb9c46070b66) - @dependabot[bot]
- [workflows](https://github.com/Drapersniper/PyLav/commit/b125e84e0f235fa8b0661834d91fa3ffac3455eb) - @Drapersniper

---

## v0.11.19.1 (26/11/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/b6a70d2af59d3593532a89e2a3af705180151f24) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/170d8c09d834c952c5018e517ec877a96675929c) - @crowdin-bot

---

## v0.11.19.0 (26/11/2022)
- [[patch] Properly fix  NameError: name 'tables' is not defined](https://github.com/Drapersniper/PyLav/commit/ee9521e95e40a97245dab038634101e0359b866f) - @Drapersniper

---

## v0.11.18.0 (25/11/2022)
- [[patch] Fix an incorrect import usage](https://github.com/Drapersniper/PyLav/commit/af17f87cec7e776ae36b73bd81d5cc73ad0bf417) - @Drapersniper

---

## v0.11.17.3 (24/11/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/7848668966b1a511d5648548dfac5d420969fde3) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/b6c434083bb4e50b1859870fba5bf6729a6ec06f) - @crowdin-bot

---

## v0.11.17.2 (24/11/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/a6b80d71b39fc1527ea9a02ceeb30a823d10c74c) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/79efb5dbc975602675b8b5db4724bef94cb7b98f) - @crowdin-bot

---

## v0.11.17.1 (23/11/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/72e281057e99ba376c3f42bf93e6ad18fac932ea) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/cf3f37148889129747a6216c1ef03bd63b041469) - @crowdin-bot

---

## v0.11.17.0 (27/10/2022)
- [[patch] Fix incorrect logic on local track folder names if a dot is used in the name](https://github.com/Drapersniper/PyLav/commit/fd889a5fa0b3e3adbc2f128804ae599e509915cd) - @Drapersniper

---

## v0.11.16.1 (26/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/e587e80bda9a5a5fffa10b8b7b1a946346d012d4) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/ea26dd61811392afdb9cce16915db76a3b4fc6b5) - @crowdin-bot

---

## v0.11.16.0 (26/10/2022)
- [[patch] Consume Managed node pipe to avoid deadlocks](https://github.com/Drapersniper/PyLav/commit/64abbed223db2d052d33de09957ef2b12fd942da) - @Drapersniper

---

## v0.11.15.1 (25/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/197760bc34dc44c28b6f6d993cfdd63c4c599ada) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/1af8f24bc806006706e43b98cfb471ca6d3cc343) - @crowdin-bot

---

## v0.11.15.0 (25/10/2022)
- [[patch] Add a logic to avoid race condition on a player reconnect](https://github.com/Drapersniper/PyLav/commit/07faa0b4d1528b8a17e19aee45877d3f70fe72a7) - @Drapersniper
- [Add a `/decodetrack` call to node healthyness check as sometimes the node can get in a bad state where the ws is pingable but the endpoints timeout](https://github.com/Drapersniper/PyLav/commit/ddf899a1f77521a90d3b2df54b2306dc70cb9f97) - @Drapersniper

---

## v0.11.14.1 (24/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/24ae78c02e818abfd72b396d2c32676dc21dc62d) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/459958059156e959d67f6e47a0f32429a9baf18e) - @crowdin-bot

---

## v0.11.14.0 (24/10/2022)


---

## v0.11.13.1 (24/10/2022)
- [[patch] Allow partial tracks to query the cache](https://github.com/Drapersniper/PyLav/commit/bd939f19b104890c929e7a5d214c51f36903c06b) - @Drapersniper
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/ba02457b9bc793c6615f12557454895797a9b41c) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/39eccb08e7baad74ae133f91c8af596931bd5c22) - @crowdin-bot

---

## v0.11.13.0 (24/10/2022)
- [[patch] Make all single tracks partial by default](https://github.com/Drapersniper/PyLav/commit/f62747a4ec0fd44ed89ec74ae9001ff83aed6525) - @Drapersniper
- [Fix localtracks not being sorted by default](https://github.com/Drapersniper/PyLav/commit/6c1ee2e0a19aa5fb5ffec184c58f3191d9cba695) - @Drapersniper

---

## v0.11.12.0 (24/10/2022)
- [[patch] fix an instance of where `Player.play()` was being called instead of `Player.add()` causing all songs in the enqueue op to be fast skipped](https://github.com/Drapersniper/PyLav/commit/1f4a09db7777a660b8a3ee1bad69c8d539552f62) - @Drapersniper
- [fix  RuntimeWarning: coroutine 'AsyncPath.is_file' was never awaited](https://github.com/Drapersniper/PyLav/commit/efd82c1366b8d5ff8fa19c09c1d099ea4f37ed33) - @Drapersniper

---

## v0.11.11.0 (24/10/2022)
- [[patch] fix skipSegments being sent to non YouTube tracks causing playback failures](https://github.com/Drapersniper/PyLav/commit/ad0a93e285f0e45301bceaa68f4d22548c457f09) - @Drapersniper

---

## v0.11.10.0 (23/10/2022)
- [[patch] cleanup plugins on init sequence](https://github.com/Drapersniper/PyLav/commit/56427d4f763b59e713da234e524d2e54c3cf8b03) - @Drapersniper

---

## v0.11.9.0 (23/10/2022)
- [[patch] Don't specify track endTime if 0](https://github.com/Drapersniper/PyLav/commit/76726906d242d1a92a70428f27843026905e7066) - @Drapersniper

---

## v0.11.8.0 (23/10/2022)
- [[patch] disable yandee source which is enabled by default](https://github.com/Drapersniper/PyLav/commit/1e9f8767de00ef614878621901fcb85d4c263858) - @Drapersniper

---

## v0.11.7.0 (21/10/2022)
- [[patch] KeyError: 'track'](https://github.com/Drapersniper/PyLav/commit/4f1a0edf2f07439a9813b66bc089b2d3b829799e) - @Drapersniper

---

## v0.11.6.1 (21/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/1f865ff795211895ddf861cf55d31503312d9c71) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/3823b4f6642502372f4ea1ee197117ed97fa848e) - @crowdin-bot

---

## v0.11.6.0 (21/10/2022)
- [[patch] certified typo moment (#82)](https://github.com/Drapersniper/PyLav/commit/857affacf4521be1e58d2b08f93be7790d0ea30b) - @Pogogo007

---

## v0.11.5.0 (21/10/2022)
- [[patch] TypeError: 'JSONB' object is not subscriptable (#80)](https://github.com/Drapersniper/PyLav/commit/d0235c946079d48f82ea4aec8048efc8fff5ca62) - @Drapersniper

---

## v0.11.4.1 (17/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/168d051f040cb45ac4af7ee47f2b224946000e84) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/77a31c25d3f450937b939adf41fc9f235de48ce0) - @crowdin-bot

---

## v0.11.4.0 (17/10/2022)
- [[patch]Refactor migration code, fix plugin migration, auto update plugin](https://github.com/Drapersniper/PyLav/commit/5a252bc7afed388b030c1da073bf27f69dd58216) - @Drapersniper

---

## v0.11.2.1 (16/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/804e2266b5c88a56584c7d3f82715a01e179f5c7) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/befa8e004487297371ef0dcb114b02d42f28faa9) - @crowdin-bot

---

## v0.11.2.0 (16/10/2022)
- [[patch] several fixes:](https://github.com/Drapersniper/PyLav/commit/85e906e7c33cefcec7a6021cbd47894eff2dad81) - @Drapersniper

---

## v0.11.1.1 (16/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/fa5f06494722fa5e64e1407cf8a8eb4b40a98b4a) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/04d86c0b39bd81516a5e76553492b9b2815e7554) - @crowdin-bot

---

## v0.11.1.0 (16/10/2022)
- [[patch] several fixes to the resuming logic](https://github.com/Drapersniper/PyLav/commit/6a09ca8852e46d3158765d8f89bdc19bf7863ea2) - @Drapersniper

---

## v0.11.0.1 (16/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/104082eb10828e4c12348d38dcd10b985da06c59) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/759a235a30937a0707c01036b0789901ab30860b) - @crowdin-bot

---

## v0.11.0.0 (16/10/2022)
- [[minor] Add todos for LL v3.7](https://github.com/Drapersniper/PyLav/commit/9c411262f6b74117413576dc7e8d6732e5944766) - @Drapersniper
- [Fix deezer matching](https://github.com/Drapersniper/PyLav/commit/c9428c86fd7348227f16f5a0592d8346dd196e6f) - @Drapersniper
- [trigger reconnect on shard reconnects](https://github.com/Drapersniper/PyLav/commit/983949fda6dfa9fd1ec576b70ee9de84a094f357) - @Drapersniper
- [fix DJ being forced on](https://github.com/Drapersniper/PyLav/commit/bcfd895a532d2722e25decc291a4210566cdd1c4) - @Drapersniper

---

## v0.10.5.1 (16/10/2022)
- [[post] Add new translations](https://github.com/Drapersniper/PyLav/commit/7f082d7980f9c1e41cc26c17e38dd56dc4cf7d3a) - @Drapersniper
- [[post] Update translations](https://github.com/Drapersniper/PyLav/commit/88be3dd3010fa352b94d1cc231deda79e5943331) - @crowdin-bot
- [Change raw requies to ORM where it makes sense to (#66)](https://github.com/Drapersniper/PyLav/commit/c2d92accd6f531fbf418603b41970440fa474450) - @Drapersniper
- [Update release.yml](https://github.com/Drapersniper/PyLav/commit/85eeb3b28fbd57a6d13ce51703c4372078d4569b) - @Drapersniper
- [Update release.yml](https://github.com/Drapersniper/PyLav/commit/13f502e2ed196a40e1d248cf5d698feea29eced7) - @Drapersniper
