/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class EntityImageClass
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock body;
    private final Margins shield;
    private final EntityImageClassHeader header;
    private final Url url;
    private final double roundCorner;
    private final LeafType leafType;
    private final LineConfigurable lineConfig;

    public EntityImageClass(GraphvizVersion version, ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, entity.getColors(skinParam).mute(skinParam));
        this.leafType = entity.getLeafType();
        this.lineConfig = entity;
        this.roundCorner = UseStyle.useBetaStyle() ? this.getStyle().value(PName.RoundCorner).asDouble() : this.getSkinParam().getRoundCorner(CornerParam.DEFAULT, null);
        this.shield = version != null && version.useShield() && entity.hasNearDecoration() ? Margins.uniform(16.0) : Margins.NONE;
        boolean showMethods = portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.body = entity.getBodier().getBody(FontParam.CLASS_ATTRIBUTE, this.getSkinParam(), showMethods, showFields, entity.getStereotype(), this.getStyle(), null);
        this.header = new EntityImageClassHeader(entity, this.getSkinParam(), portionShower);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        Dimension2D dimBody = this.body == null ? new Dimension2DDouble(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double width = Math.max(dimBody.getWidth(), dimHeader.getWidth());
        if (width < this.getSkinParam().minClassWidth()) {
            width = this.getSkinParam().minClassWidth();
        }
        double height = dimBody.getHeight() + dimHeader.getHeight();
        return new Dimension2DDouble(width, height);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        Rectangle2D result = this.body.getInnerPosition(member, stringBounder, strategy);
        if (result == null) {
            return result;
        }
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        UTranslate translate = UTranslate.dy(dimHeader.getHeight());
        return translate.apply(result);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("class " + this.getEntity().getCodeGetName()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug.startGroup(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        this.drawInternal(ug);
        ug.closeGroup();
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private Style getStyle() {
        return StyleSignature.of(SName.root, SName.element, SName.classDiagram, SName.class_).with(this.getEntity().getStereotype()).with(this.getEntity().getStereostyles()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private void drawInternal(UGraphic ug) {
        URectangle rect2;
        HColor backcolor;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(this.roundCorner).withCommentAndCodeLine(this.getEntity().getCodeGetName(), this.getEntity().getCodeLine());
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            rect.setDeltaShadow(4.0);
        }
        HColor classBorder = this.lineConfig.getColors(this.getSkinParam()).getColor(ColorType.LINE);
        HColor headerBackcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.HEADER);
        if (classBorder == null) {
            classBorder = UseStyle.useBetaStyle() ? this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder);
        }
        if ((backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK)) == null) {
            backcolor = UseStyle.useBetaStyle() ? this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : (this.leafType == LeafType.ENUM ? SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.enumBackground, ColorParam.classBackground) : SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground));
        }
        ug = ug.apply(classBorder);
        ug = ug.apply(backcolor.bg());
        UStroke stroke = this.getStroke();
        if (headerBackcolor == null) {
            headerBackcolor = UseStyle.useBetaStyle() ? this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : this.getSkinParam().getHtmlColor(ColorParam.classHeaderBackground, this.getStereo(), false);
        }
        UGraphic ugHeader = ug;
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = new URectangle(widthTotal, dimHeader.getHeight());
            rect2.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        } else if (this.roundCorner != 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = new URectangle(widthTotal, dimHeader.getHeight()).rounded(this.roundCorner);
            URectangle rect3 = new URectangle(widthTotal, this.roundCorner / 2.0);
            rect2.setDeltaShadow(0.0);
            rect3.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg()).apply(headerBackcolor);
            ugHeader.apply(stroke).draw(rect2);
            ugHeader.apply(stroke).apply(UTranslate.dy(dimHeader.getHeight() - rect3.getHeight())).draw(rect3);
            rect.setDeltaShadow(0.0);
            ug.apply(stroke).apply(new HColorNone().bg()).draw(rect);
        } else {
            ug.apply(stroke).draw(rect);
        }
        this.header.drawU(ugHeader, dimTotal.getWidth(), dimHeader.getHeight());
        if (this.body != null) {
            UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
            UTranslate translate = UTranslate.dy(dimHeader.getHeight());
            this.body.drawU(ug2.apply(translate));
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Dimension2D dimHeader = this.header.calculateDimension(stringBounder);
        if (this.body instanceof WithPorts) {
            return ((WithPorts)((Object)this.body)).getPorts(stringBounder).translateY(dimHeader.getHeight());
        }
        return new Ports();
    }

    private UStroke getStroke() {
        UStroke stroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (stroke == null) {
            stroke = this.getSkinParam().getThickness(LineParam.classBorder, this.getStereo());
        }
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    @Override
    public ShapeType getShapeType() {
        if (((ILeaf)this.getEntity()).getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.shield;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

