# coding: utf-8

"""
    User Information Service

    FABRIC User Information Service  # noqa: E501

    OpenAPI spec version: 1.1.0
    Contact: ibaldin@renci.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class PreferencesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def preferences_preftype_uuid_get(self, preftype, uuid, **kwargs):  # noqa: E501
        """get user preferences of specific type (settings, permissions or interests; open only to self)  # noqa: E501

        User preferences (returns sane defaults if user valid, but preferences not available)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_preftype_uuid_get(preftype, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PreferenceType preftype: (required)
        :param str uuid: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.preferences_preftype_uuid_get_with_http_info(preftype, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.preferences_preftype_uuid_get_with_http_info(preftype, uuid, **kwargs)  # noqa: E501
            return data

    def preferences_preftype_uuid_get_with_http_info(self, preftype, uuid, **kwargs):  # noqa: E501
        """get user preferences of specific type (settings, permissions or interests; open only to self)  # noqa: E501

        User preferences (returns sane defaults if user valid, but preferences not available)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_preftype_uuid_get_with_http_info(preftype, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PreferenceType preftype: (required)
        :param str uuid: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['preftype', 'uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preferences_preftype_uuid_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'preftype' is set
        if ('preftype' not in params or
                params['preftype'] is None):
            raise ValueError("Missing the required parameter `preftype` when calling `preferences_preftype_uuid_get`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `preferences_preftype_uuid_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'preftype' in params:
            path_params['preftype'] = params['preftype']  # noqa: E501
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/preferences/{preftype}/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def preferences_preftype_uuid_put(self, uuid, preftype, **kwargs):  # noqa: E501
        """update user preferences by type (open only to self)  # noqa: E501

        Update specific type of user preferences  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_preftype_uuid_put(uuid, preftype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param PreferenceType preftype: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.preferences_preftype_uuid_put_with_http_info(uuid, preftype, **kwargs)  # noqa: E501
        else:
            (data) = self.preferences_preftype_uuid_put_with_http_info(uuid, preftype, **kwargs)  # noqa: E501
            return data

    def preferences_preftype_uuid_put_with_http_info(self, uuid, preftype, **kwargs):  # noqa: E501
        """update user preferences by type (open only to self)  # noqa: E501

        Update specific type of user preferences  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_preftype_uuid_put_with_http_info(uuid, preftype, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :param PreferenceType preftype: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'preftype']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preferences_preftype_uuid_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `preferences_preftype_uuid_put`")  # noqa: E501
        # verify the required parameter 'preftype' is set
        if ('preftype' not in params or
                params['preftype'] is None):
            raise ValueError("Missing the required parameter `preftype` when calling `preferences_preftype_uuid_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'preftype' in params:
            path_params['preftype'] = params['preftype']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/preferences/{preftype}/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def preferences_uuid_get(self, uuid, **kwargs):  # noqa: E501
        """get all user preferences as an object (open only to self)  # noqa: E501

        Get all preferences for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_uuid_get(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: Preferences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.preferences_uuid_get_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.preferences_uuid_get_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def preferences_uuid_get_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """get all user preferences as an object (open only to self)  # noqa: E501

        Get all preferences for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preferences_uuid_get_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: (required)
        :return: Preferences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preferences_uuid_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `preferences_uuid_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/preferences/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Preferences',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
