# swagger-client
FABRIC Core API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = swagger_client.AnnouncementsApi(swagger_client.ApiClient(configuration))
announcement_type = 'announcement_type_example' # str | announcement type (optional)
is_active = true # bool | is active (optional)
search = 'search_example' # str | search term applied (optional)
offset = 0 # int | number of items to skip before starting to collect the result set (optional) (default to 0)
limit = 5 # int | maximum number of results to return per page (1 or more) (optional) (default to 5)

try:
    # Search for FABRIC Announcements
    api_response = api_instance.announcements_get(announcement_type=announcement_type, is_active=is_active, search=search, offset=offset, limit=limit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnnouncementsApi->announcements_get: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.AnnouncementsApi(swagger_client.ApiClient(configuration))
body = swagger_client.AnnouncementsPost() # AnnouncementsPost | Create an announcement (optional)

try:
    # Create a new FABRIC Announcement
    api_response = api_instance.announcements_post(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnnouncementsApi->announcements_post: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.AnnouncementsApi(swagger_client.ApiClient(configuration))
uuid = 'uuid_example' # str | universally unique identifier

try:
    # Delete Announcement as Portal Admin
    api_response = api_instance.announcements_uuid_delete(uuid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnnouncementsApi->announcements_uuid_delete: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.AnnouncementsApi(swagger_client.ApiClient(configuration))
uuid = 'uuid_example' # str | universally unique identifier

try:
    # Announcement details by UUID
    api_response = api_instance.announcements_uuid_get(uuid)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnnouncementsApi->announcements_uuid_get: %s\n" % e)

# create an instance of the API class
api_instance = swagger_client.AnnouncementsApi(swagger_client.ApiClient(configuration))
uuid = 'uuid_example' # str | universally unique identifier
body = swagger_client.AnnouncementsPatch() # AnnouncementsPatch | Update an existing announcement (optional)

try:
    # Update Announcement details as Portal Admin
    api_response = api_instance.announcements_uuid_patch(uuid, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AnnouncementsApi->announcements_uuid_patch: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://127.0.0.1:8443*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnnouncementsApi* | [**announcements_get**](docs/AnnouncementsApi.md#announcements_get) | **GET** /announcements | Search for FABRIC Announcements
*AnnouncementsApi* | [**announcements_post**](docs/AnnouncementsApi.md#announcements_post) | **POST** /announcements | Create a new FABRIC Announcement
*AnnouncementsApi* | [**announcements_uuid_delete**](docs/AnnouncementsApi.md#announcements_uuid_delete) | **DELETE** /announcements/{uuid} | Delete Announcement as Portal Admin
*AnnouncementsApi* | [**announcements_uuid_get**](docs/AnnouncementsApi.md#announcements_uuid_get) | **GET** /announcements/{uuid} | Announcement details by UUID
*AnnouncementsApi* | [**announcements_uuid_patch**](docs/AnnouncementsApi.md#announcements_uuid_patch) | **PATCH** /announcements/{uuid} | Update Announcement details as Portal Admin
*PeopleApi* | [**people_get**](docs/PeopleApi.md#people_get) | **GET** /people | Search for FABRIC People
*PeopleApi* | [**people_preferences_get**](docs/PeopleApi.md#people_preferences_get) | **GET** /people/preferences | List of People Preference options
*PeopleApi* | [**people_profile_otheridentity_types_get**](docs/PeopleApi.md#people_profile_otheridentity_types_get) | **GET** /people/profile/otheridentity-types | List of People Profile Other Identity Type options
*PeopleApi* | [**people_profile_personalpage_types_get**](docs/PeopleApi.md#people_profile_personalpage_types_get) | **GET** /people/profile/personalpage-types | List of People Profile Personal Page Type options
*PeopleApi* | [**people_profile_preferences_get**](docs/PeopleApi.md#people_profile_preferences_get) | **GET** /people/profile/preferences | List of People Profile Preference options
*PeopleApi* | [**people_uuid_get**](docs/PeopleApi.md#people_uuid_get) | **GET** /people/{uuid} | Person details by UUID
*PeopleApi* | [**people_uuid_patch**](docs/PeopleApi.md#people_uuid_patch) | **PATCH** /people/{uuid} | Update Person details as Self
*PeopleApi* | [**people_uuid_profile_patch**](docs/PeopleApi.md#people_uuid_profile_patch) | **PATCH** /people/{uuid}/profile | Update Person Profile details as Self
*ProjectsApi* | [**projects_get**](docs/ProjectsApi.md#projects_get) | **GET** /projects | Search for FABRIC Projects
*ProjectsApi* | [**projects_post**](docs/ProjectsApi.md#projects_post) | **POST** /projects | Create new Project
*ProjectsApi* | [**projects_preferences_get**](docs/ProjectsApi.md#projects_preferences_get) | **GET** /projects/preferences | List of Projects Preference options
*ProjectsApi* | [**projects_profile_preferences_get**](docs/ProjectsApi.md#projects_profile_preferences_get) | **GET** /projects/profile/preferences | List of Projects Profile Preference options
*ProjectsApi* | [**projects_tags_get**](docs/ProjectsApi.md#projects_tags_get) | **GET** /projects/tags | List of Projects Tags options
*ProjectsApi* | [**projects_uuid_delete**](docs/ProjectsApi.md#projects_uuid_delete) | **DELETE** /projects/{uuid} | Delete Project as owner
*ProjectsApi* | [**projects_uuid_get**](docs/ProjectsApi.md#projects_uuid_get) | **GET** /projects/{uuid} | Project details by UUID
*ProjectsApi* | [**projects_uuid_patch**](docs/ProjectsApi.md#projects_uuid_patch) | **PATCH** /projects/{uuid} | Update Project details as owner
*ProjectsApi* | [**projects_uuid_personnel_patch**](docs/ProjectsApi.md#projects_uuid_personnel_patch) | **PATCH** /projects/{uuid}/personnel | Update Project personnel as owner
*ProjectsApi* | [**projects_uuid_profile_patch**](docs/ProjectsApi.md#projects_uuid_profile_patch) | **PATCH** /projects/{uuid}/profile | Update Project Profile details as owner
*ProjectsApi* | [**projects_uuid_tags_patch**](docs/ProjectsApi.md#projects_uuid_tags_patch) | **PATCH** /projects/{uuid}/tags | Update Projects Tags as Facility Operator
*PublicationsApi* | [**publications_classification_terms_get**](docs/PublicationsApi.md#publications_classification_terms_get) | **GET** /publications/classification-terms | List of Classification Terms
*PublicationsApi* | [**publications_get**](docs/PublicationsApi.md#publications_get) | **GET** /publications | Publications (placeholder)
*PublicationsApi* | [**publications_post**](docs/PublicationsApi.md#publications_post) | **POST** /publications | Publications (placeholder)
*PublicationsApi* | [**publications_uuid_delete**](docs/PublicationsApi.md#publications_uuid_delete) | **DELETE** /publications/{uuid} | Publications (placeholder)
*PublicationsApi* | [**publications_uuid_get**](docs/PublicationsApi.md#publications_uuid_get) | **GET** /publications/{uuid} | Publications (placeholder)
*PublicationsApi* | [**publications_uuid_patch**](docs/PublicationsApi.md#publications_uuid_patch) | **PATCH** /publications/{uuid} | Publications (placeholder)
*SshkeysApi* | [**bastionkeys_get**](docs/SshkeysApi.md#bastionkeys_get) | **GET** /bastionkeys | Get active SSH Keys
*SshkeysApi* | [**sshkeys_get**](docs/SshkeysApi.md#sshkeys_get) | **GET** /sshkeys | Get active SSH Keys
*SshkeysApi* | [**sshkeys_post**](docs/SshkeysApi.md#sshkeys_post) | **POST** /sshkeys | Create a public/private SSH Key Pair
*SshkeysApi* | [**sshkeys_put**](docs/SshkeysApi.md#sshkeys_put) | **PUT** /sshkeys | Add a public SSH Key
*SshkeysApi* | [**sshkeys_uuid_delete**](docs/SshkeysApi.md#sshkeys_uuid_delete) | **DELETE** /sshkeys/{uuid} | Delete SSH Key by UUID
*SshkeysApi* | [**sshkeys_uuid_get**](docs/SshkeysApi.md#sshkeys_uuid_get) | **GET** /sshkeys/{uuid} | SSH Key details by UUID
*VersionApi* | [**version_get**](docs/VersionApi.md#version_get) | **GET** /version | Version
*WhoamiApi* | [**whoami_get**](docs/WhoamiApi.md#whoami_get) | **GET** /whoami | Who am I?

## Documentation For Models

 - [AnnouncementOne](docs/AnnouncementOne.md)
 - [Announcements](docs/Announcements.md)
 - [AnnouncementsDetails](docs/AnnouncementsDetails.md)
 - [AnnouncementsPatch](docs/AnnouncementsPatch.md)
 - [AnnouncementsPost](docs/AnnouncementsPost.md)
 - [ApiOptions](docs/ApiOptions.md)
 - [ApiOptionsDetails](docs/ApiOptionsDetails.md)
 - [ApiOptionsOne](docs/ApiOptionsOne.md)
 - [ApiOptionsOneApiEndpoints](docs/ApiOptionsOneApiEndpoints.md)
 - [Bastionkeys](docs/Bastionkeys.md)
 - [BastionkeysOne](docs/BastionkeysOne.md)
 - [People](docs/People.md)
 - [PeopleDetails](docs/PeopleDetails.md)
 - [PeopleOne](docs/PeopleOne.md)
 - [PeopleOneRoles](docs/PeopleOneRoles.md)
 - [PeoplePatch](docs/PeoplePatch.md)
 - [Person](docs/Person.md)
 - [Preferences](docs/Preferences.md)
 - [ProfilePeople](docs/ProfilePeople.md)
 - [ProfilePeopleOtherIdentities](docs/ProfilePeopleOtherIdentities.md)
 - [ProfilePeoplePersonalPages](docs/ProfilePeoplePersonalPages.md)
 - [ProfileProjects](docs/ProfileProjects.md)
 - [ProfileProjectsReferences](docs/ProfileProjectsReferences.md)
 - [Project](docs/Project.md)
 - [ProjectMembership](docs/ProjectMembership.md)
 - [Projects](docs/Projects.md)
 - [ProjectsDetails](docs/ProjectsDetails.md)
 - [ProjectsOne](docs/ProjectsOne.md)
 - [ProjectsPatch](docs/ProjectsPatch.md)
 - [ProjectsPersonnelPatch](docs/ProjectsPersonnelPatch.md)
 - [ProjectsPost](docs/ProjectsPost.md)
 - [ProjectsTagsPatch](docs/ProjectsTagsPatch.md)
 - [SshkeyPair](docs/SshkeyPair.md)
 - [SshkeyPairResults](docs/SshkeyPairResults.md)
 - [Sshkeys](docs/Sshkeys.md)
 - [SshkeysOne](docs/SshkeysOne.md)
 - [SshkeysPost](docs/SshkeysPost.md)
 - [SshkeysPut](docs/SshkeysPut.md)
 - [Status200OkNoContent](docs/Status200OkNoContent.md)
 - [Status200OkNoContentResults](docs/Status200OkNoContentResults.md)
 - [Status200OkPaginated](docs/Status200OkPaginated.md)
 - [Status200OkPaginatedLinks](docs/Status200OkPaginatedLinks.md)
 - [Status200OkSingle](docs/Status200OkSingle.md)
 - [Status400BadRequest](docs/Status400BadRequest.md)
 - [Status400BadRequestErrors](docs/Status400BadRequestErrors.md)
 - [Status401Unauthorized](docs/Status401Unauthorized.md)
 - [Status401UnauthorizedErrors](docs/Status401UnauthorizedErrors.md)
 - [Status403Forbidden](docs/Status403Forbidden.md)
 - [Status403ForbiddenErrors](docs/Status403ForbiddenErrors.md)
 - [Status404NotFound](docs/Status404NotFound.md)
 - [Status404NotFoundErrors](docs/Status404NotFoundErrors.md)
 - [Status500InternalServerError](docs/Status500InternalServerError.md)
 - [Status500InternalServerErrorErrors](docs/Status500InternalServerErrorErrors.md)
 - [Version](docs/Version.md)
 - [VersionResults](docs/VersionResults.md)
 - [Whoami](docs/Whoami.md)
 - [WhoamiResults](docs/WhoamiResults.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

stealey@unc.edu
