# auto generated by update_py.py


from tlclient.linker.frame import Frame, MemBuffer, FrameHeaderStatus
import tlclient.linker.frame_pb2 as frame_pb2


class Event:
    def __init__(self, s: bytes):
        pass

    def get_obj(self, MSG_TYPE):
        raise NotImplementedError

    def get_msg_type(self):
        raise NotImplementedError

    def get_nano(self):
        raise NotImplementedError

    def get_string(self) -> str:
        raise NotImplementedError

    def get_req_id(self):
        raise NotImplementedError

    def frames(self):
        raise NotImplementedError

    @staticmethod
    def new_event(msg: bytes):
        if msg[0] == FrameHeaderStatus.PB:
            with memoryview(msg) as m:
                return PBEvent(m[1:])
        elif msg[0] == FrameHeaderStatus.IS_BUFFER:
            return BatchFrameEvent(msg)
        elif msg[0] == FrameHeaderStatus.NORMAL:
            with memoryview(msg) as m:
                return FrameEvent(m)

    @staticmethod
    def new_pb_frame():
        return PBEvent()


class PBEvent(Event):
    def __init__(self, msg = None):
        self._index = 0
        if msg is None:
            self._mem_buffer: frame_pb2.MemBuffer = None
            self._frame = frame_pb2.Frame()
        else:
            self._mem_buffer: frame_pb2.MemBuffer = frame_pb2.MemBuffer()
            self._mem_buffer.ParseFromString(msg)
            self._frame = self._mem_buffer.frames[self._index]
            self._index += 1

    def get_obj(self, MSG_TYPE):
        msg = MSG_TYPE()
        msg.ParseFromString(self._frame.data)
        return msg

    def get_msg_type(self):
        return self._frame.header.msg_type

    def get_nano(self):
        return self._frame.header.nano

    def get_string(self):
        return self._frame.data

    def get_req_id(self):
        return self._frame.header.req_id

    def frames(self):
        yield self
        while self._index < len(self._mem_buffer.frames):
            self._frame = self._mem_buffer.frames[self._index]
            self._index += 1
            yield self

    def set_msg_type(self, msg_type: frame_pb2.MsgType):
        self._frame.header.msg_type = msg_type

    def set_nano(self, nano: int):
        self._frame.header.nano = nano

    def set_source(self, source: int):
        self._frame.header.source = source

    def set_data(self, msg):
        self._frame.data = msg.SerializeToString()

    def set_string(self, msg: str):
        self._frame.data = msg

    @property
    def buf(self):
        if self._mem_buffer is None:
            mem_buffer = frame_pb2.MemBuffer()
            mem_buffer.frames.append(self._frame)
            self._mem_buffer = (FrameHeaderStatus.PB).to_bytes(
                1, byteorder='little') + mem_buffer.SerializeToString()
        return self._mem_buffer


class FrameEvent(Event):
    def __init__(self, msg: memoryview):
        self._frame = Frame(msg)

    def get_obj(self, MSG_TYPE):
        return self._frame.get_obj(MSG_TYPE)

    def get_msg_type(self):
        return self._frame.get_msg_type()

    def get_nano(self):
        return self._frame.get_nano()

    def get_string(self):
        return self._frame.get_string()

    def get_req_id(self):
        return self._frame.get_req_id()

    def frames(self):
        yield self


class BatchFrameEvent(Event):
    def __init__(self, msg: bytes):
        self._buffer = msg
        self._pos = MemBuffer.HEADER_LENGTH
        self._frame = Frame(self._buffer[self._pos:])

    def get_obj(self, MSG_TYPE):
        return self._frame.get_obj(MSG_TYPE)

    def get_msg_type(self):
        return self._frame.get_msg_type()

    def get_nano(self):
        return self._frame.get_nano()

    def get_string(self):
        return self._frame.get_string()

    def get_req_id(self):
        return self._frame.get_req_id()

    def frames(self):
        yield self
        while self._buffer[self._pos] == FrameHeaderStatus.HAS_NEXT:
            self._pos += self._frame.get_length()
            self._frame = Frame(self._buffer[self._pos:])
            yield self
