from __future__ import print_function
# This test is disabled in the automatic suite, as numpy.loadtxt leaks memory

from asap3 import *
from numpy import *
from asap3.testtools import ReportTest
from ase.utils import StringIO

positions = """\
  9.552112 6.772504 0.04440463
  9.193831 8.060677 29.54671
  9.54922 6.897227 16.18429
  9.028903 8.217722 15.94014
  9.488959 7.06198 2.48602
  9.021394 8.4443 2.205692
  9.468297 7.329089 18.48887
  8.949436 8.535064 18.29582
  9.387507 7.490088 4.910348
  8.805554 8.781557 4.693369
  9.426317 7.542659 21.01691
  8.66678 8.79169 20.78942
  9.378752 7.852491 7.306445
  8.490592 8.986742 7.006955
  9.208672 7.918699 23.47826
  8.255458 8.936134 23.24651
  9.208178 8.122735 9.751494
  8.176816 9.172716 9.513896
  9.105536 8.266085 25.83138
  8.068444 9.203763 25.6282
  8.997301 8.465863 12.17011
  7.799175 9.248945 12.03395
  8.812471 8.566708 28.20779
  7.697277 9.379543 28.00551
  8.742186 8.673076 14.5852
  7.477072 9.449532 14.41288
  8.576921 8.890324 0.9357763
  7.345615 9.480216 0.7153345
  8.38964 8.874511 16.99002
  7.222464 9.459304 16.91449
  8.373938 9.013707 3.334187
  7.041521 9.5329 3.149261
  8.26936 9.136212 19.52061
  6.826723 9.529792 19.34221
  8.037588 9.165853 5.687113
  6.601874 9.540794 5.554015
  7.884424 9.271339 21.8833
  6.471299 9.565324 21.7331
  7.778998 9.385492 8.196773
  6.299348 9.507078 8.101222
  7.489674 9.38878 24.31798
  6.033415 9.484206 24.10906
  7.334209 9.502251 10.5957
  5.884142 9.411429 10.48835
  7.255269 9.507177 26.77982
  5.683911 9.400932 26.53983
  7.045017 9.579325 13.11514
  5.618474 9.273922 12.94325
  6.890621 9.548047 29.1238
  5.360588 9.277243 29.00728
  6.638262 9.496559 15.44299
  5.371569 9.163131 15.27398
  6.551691 9.53756 1.795641
  5.154037 9.07485 1.651956
  6.287471 9.571896 17.89542
  5.013474 8.992499 17.78279
  6.048877 9.564883 4.31015
  4.920051 8.843493 4.000889
  5.937487 9.422503 20.3046
  4.708265 8.632479 20.11733
  5.783699 9.361547 6.628308
  4.578052 8.490623 6.448962
  5.539166 9.315304 22.80417
  4.457719 8.36326 22.57423
  5.371928 9.216775 9.080684
  4.41434 8.180257 8.966432
  5.3663 9.125122 25.22272
  4.280695 7.954063 24.97563
  5.182438 9.118698 11.58883
  4.201622 7.912494 11.37341
  5.014035 8.920031 27.67794
  4.084406 7.754056 27.59926
  4.836545 8.817206 14.04804
  4.02318 7.617959 13.79096
  4.759015 8.677918 0.2204041
  4.047664 7.498435 0.07007638
  4.640363 8.597788 16.394
  3.954613 7.372223 16.24626
  4.515774 8.477346 2.775844
  3.864208 7.06245 2.57364
  4.373011 8.302483 18.89267
  3.982089 6.97704 18.61729
  4.314896 8.067239 5.198339
  3.992174 6.852516 4.966284
  4.262055 7.978121 21.26974
  3.974581 6.588468 21.12472
  4.168407 7.776899 7.621052
  3.904008 6.465183 7.421191
  4.11727 7.589117 23.7112
  3.93283 6.244106 23.57929
  4.027621 7.476828 9.978798
  4.042723 5.989714 9.784795
  4.010357 7.316221 26.15983
  4.036124 5.831897 25.94521
  3.977646 7.092644 12.45702
  4.13319 5.660889 12.24235
  3.940933 6.871856 28.59718
  4.219456 5.547314 28.45371
  3.770015 6.808072 14.93573
  4.310638 5.361112 14.75077
  3.879822 6.519245 1.164611
  4.319536 5.175288 0.9732215
  3.888445 6.427315 17.41015
  4.544345 4.956926 17.16883
  4.043174 6.243232 3.678883
  4.531314 4.806436 3.507314
  4.055266 6.109954 19.86397
  4.685002 4.744983 19.50354
  4.132525 5.802965 6.101609
  4.861226 4.71526 5.834461
  3.994036 5.682307 22.19773
  4.929976 4.495875 22.07406
  4.127328 5.634156 8.482123
  5.12841 4.437116 8.28757
  4.241358 5.379878 24.64727
  5.277936 4.348107 24.36295
  4.384408 5.300692 10.86002
  5.446202 4.314897 10.85888
  4.47484 5.053519 27.16194
  5.680686 4.197091 26.90187
  4.590448 4.863846 13.299
  5.707157 4.086283 13.1511
  4.757003 4.889578 29.50562
  6.006138 4.113356 29.38861
  4.790774 4.718097 15.89047
  6.096897 3.915454 15.59677
  4.928451 4.577105 2.09666
  6.296282 3.905912 1.887301
  5.177749 4.507162 18.25134
  6.400408 3.913373 18.0199
  5.321692 4.322044 4.50006
  6.724627 3.996704 4.390005
  5.488957 4.285737 20.67678
  6.870326 3.89392 20.50041
  5.602542 4.147051 7.107386
  7.001853 4.049309 6.795846
  5.8742 4.096098 23.13143
  7.212772 3.974284 22.92324
  5.94207 4.081348 9.41425
  7.379606 3.822847 9.25606
  6.054946 4.006293 25.64522
  7.572527 3.995318 25.27975
  6.30761 3.972861 11.85115
  7.601967 4.155815 11.65006
  6.50227 3.904086 28.03503
  7.867497 4.149482 27.8517
  6.642697 3.918697 14.26982
  8.006434 4.291133 14.13937
  6.845933 4.074443 0.6272669
  8.178181 4.302065 0.3748606
  7.035936 3.875763 16.73082
  8.42754 4.433949 16.55449
  7.192235 3.952319 3.089185
  8.389159 4.53387 2.838325
  7.319127 4.00438 19.13343
  8.578221 4.621301 18.90624
  7.512102 4.031391 5.40521
  8.813431 4.872679 5.306202
  7.812522 4.102491 21.67389
  8.891264 4.906431 21.31246
  7.910676 4.200673 7.844123
  8.913746 5.096296 7.690144
  8.038054 4.353301 24.12316
  9.0693 5.194398 23.97633
  8.158075 4.385151 10.36398
  9.288777 5.377515 10.12819
  8.337492 4.47681 26.55425
  9.290056 5.531462 26.23686
  8.451646 4.629075 12.79387
  9.392991 5.64277 12.5306
  8.625222 4.535173 28.86946
  9.333773 5.814491 28.69184
  8.745232 4.822074 15.28779
  9.422217 6.042707 15.0789
  8.819402 4.965075 1.522353
  9.533509 6.218598 1.269828
  8.95189 5.096248 17.6752
  9.472511 6.391477 17.4528
  9.123817 5.194289 4.035131
  9.476347 6.55237 3.7926
  9.168036 5.35086 20.136
  9.546617 6.733684 19.86708
  9.300788 5.502433 6.468782
  9.560386 6.929121 6.117968
  9.254429 5.710272 22.55272
  9.532686 7.121555 22.27596
  9.360536 5.935046 8.800444
  9.535275 7.316995 8.530223
  9.361238 6.032059 25.01853
  9.413713 7.365803 24.67645
  9.459749 6.239762 11.21147
  9.422029 7.668405 11.13305
  9.49951 6.308688 27.35072
  9.263737 7.878438 27.20133
  9.560844 6.630849 13.63856
  9.306799 7.939041 13.64013\
"""

unitcell = """\
  13.48021 0 0
  0 13.48021 0
  0 0 29.82
"""

forces = """\
   -2.87825106e-01  -3.40833931e+00  -7.11563842e+00
   -3.18933130e+00   6.54286007e+00   1.86711570e+00
   -8.15222659e-01   2.15237494e+00  -3.14862097e+00
    1.20958272e-01   8.18387333e-01  -1.84382489e+00
    6.73437508e-01   1.88461126e+00  -4.08799838e+00
   -2.19204004e-01  -1.68650350e+00   2.27535311e+00
    2.78706539e+00  -6.90345841e+00   4.51739067e+00
   -5.05255146e+00   6.63012938e+00   1.47403366e+00
    1.29863033e+00  -4.48004536e-01  -5.67944770e+00
    2.60078587e+00  -4.54348331e+00  -6.42718300e+00
   -1.09625372e+00   5.27744370e+00  -5.06755075e+00
    1.29656372e+00  -1.63943599e+00   2.84822643e+00
   -4.36999190e-01   5.07552216e-01  -7.42339378e+00
    9.31241963e-01  -1.55972661e+00   3.37533967e+00
    2.98606586e-01   7.16191628e-01  -7.41833331e+00
    1.24336622e+00   7.75696550e-01  -2.20003825e+00
   -3.75422781e-01   1.79323813e+00  -1.13110360e+00
    3.20127719e+00  -1.77408564e+00   1.34072370e+00
    3.77260531e-01  -9.32526043e-01  -8.64023679e-01
   -1.97590939e+00   1.09653648e+00  -4.46723449e-01
   -2.80698864e-01  -1.33609296e-02   5.90292656e+00
    3.48512345e+00   8.88382093e-01  -5.85720831e+00
   -2.24776935e-01   1.94226537e+00   8.28943935e+00
    2.45790276e+00  -6.38007947e-01   6.33470468e+00
   -2.95830395e+00   2.64012905e+00   7.36991335e+00
    7.51564954e+00  -1.45139976e+00  -2.32037236e+00
    4.45817461e+00  -3.58951701e+00  -3.74565591e+00
    1.58442193e+00   5.73008248e-01  -5.25463079e+00
    7.65389444e+00  -2.84267918e+00   4.37949034e+00
   -6.07495277e+00   2.78035013e+00  -8.71240115e+00
   -3.71405571e-01   1.92798089e+00   1.62581516e+00
   -5.36493657e-01   7.09982246e-01   8.71038922e-01
   -1.89718343e+00   5.63984296e-01  -5.14893498e+00
    5.44865210e+00   8.12475201e-01  -8.96603700e+00
   -6.24998563e+00   4.91742654e+00   5.70355168e+00
    4.87468440e+00   1.08546779e-01   4.79858029e-01
   -8.65565207e-01  -2.98457629e-01   2.33671217e+00
   -1.40725246e+00  -8.52610563e-01  -3.73245976e+00
   -3.72596335e+00   1.10200300e+00  -9.57763875e-01
    1.25888163e+00   8.89051670e-03  -7.63618882e+00
   -1.05789956e+00   5.97886807e-01   5.62061292e-01
    5.12874213e+00   7.52948712e-01  -9.69052343e-01
   -1.04266396e+00  -9.07681963e-01   4.31288962e+00
    3.15182426e+00   2.33722116e+00  -6.83636711e+00
   -5.93266601e+00   1.17799934e+00  -7.75942983e+00
    5.87996001e+00  -2.13290987e-02   1.65070993e+00
   -5.36101796e+00  -7.92268639e-01   4.83310335e-01
    5.56787664e-01   1.62665502e+00  -1.54059561e+00
   -4.41210493e+00   6.18161479e-01   4.32850192e+00
    7.02536785e+00   2.22419992e+00  -4.79487468e+00
    3.34764452e+00   2.29933662e+00   8.65717971e+00
   -7.47504573e+00  -2.79447978e+00   2.75339300e+00
   -5.63040663e+00   7.71120929e-02   4.24552160e+00
    8.36955615e-01  -4.72052061e-01  -3.67920292e+00
    9.07156967e-01  -1.38320440e-01   7.72621254e+00
   -2.07116444e+00  -8.33094556e-01  -2.98907902e+00
    4.10595671e+00   6.02305894e-02  -6.41093549e+00
   -3.59469639e+00  -1.37640298e+00   7.92932462e+00
   -4.26752997e+00  -8.60265029e-01   8.49464225e+00
    3.56499967e+00   4.03177663e+00   6.64494551e+00
   -2.65561508e+00  -1.12090873e+00   5.94289077e+00
    3.04056599e+00   3.47633236e+00   4.98262256e+00
    1.08140912e-01  -1.83828493e-01  -8.78127502e-01
    2.18028414e+00   2.65292539e+00   2.32766786e+00
    8.51070068e-01  -1.56107646e-01   6.41454170e+00
    1.97907161e+00   6.26509081e+00  -9.01416974e+00
   -8.05015306e+00  -3.73860504e+00   3.01455812e-01
    5.00811963e+00   9.75660128e+00   4.94020968e+00
   -5.33306906e+00  -5.10859032e+00   3.45955514e+00
    1.79807970e+00   4.07651498e+00  -2.65957897e+00
   -3.97740622e+00  -1.08196065e+00   1.65671609e+00
    2.56662402e+00   3.74191269e+00  -9.45865090e+00
    3.00705931e-01  -8.83176862e-01  -3.63951759e+00
    3.83735485e-01   1.88394892e+00   3.98343971e-01
   -1.52339841e+00   3.80497352e-01   7.72779973e+00
   -1.37291791e+00  -5.02844619e+00   1.00943941e+00
    9.41265709e-01   1.43757639e+00   2.54059696e+00
   -1.11095747e+00  -2.65512162e+00   4.52606087e-01
   -2.47054582e+00  -3.49453000e+00  -5.14362516e+00
    2.27973819e+00   3.46165751e+00  -3.34913461e+00
   -2.72016758e-01  -5.20717233e-01  -8.20121783e+00
   -6.30181966e-01   2.81999196e-01   8.81728084e+00
    2.91199212e+00   9.89788829e+00  -4.82449292e+00
   -1.94899346e+00  -1.39711129e+01   4.63783397e-02
   -1.56303747e+00  -2.67069789e+00  -6.22363389e-02
   -7.27231903e-01   1.66376024e+00   1.08470094e+00
    9.86850115e-03   3.20093174e+00  -5.43743400e-01
    4.35580654e-02  -5.07659940e+00  -3.80999298e+00
   -1.35736901e+00  -1.77086142e-01  -3.31686808e+00
   -9.84156298e-01  -3.70041334e+00  -4.96355903e+00
   -1.98324516e+00  -6.94237865e+00   8.68861523e+00
   -2.64521886e+00   7.98954313e+00  -4.35497861e-01
   -2.06632861e+00  -5.38066877e+00   2.83610505e+00
    3.06784608e-01   9.90763765e-01   5.16176995e+00
   -6.65108500e-01  -2.24626568e+00   2.46059156e+00
   -1.27508851e+00   2.90797383e+00  -1.88934745e+00
   -9.95685960e-01   2.60825213e+00   4.43886700e+00
   -4.06612178e-01  -1.05510076e+00  -3.14758234e+00
    2.34919851e+00  -3.34640857e+00  -6.96203911e-01
   -2.77101036e+00   2.37773604e+00  -3.04566480e+00
   -4.70020299e-01   3.00743806e+00   2.49918113e+00
    1.07072179e-01   1.97094814e+00   1.15101794e+00
    1.50111243e+00  -3.33114860e+00  -6.92786249e+00
   -6.30987345e+00   9.14231600e+00   1.64644712e+00
   -1.07680764e+00  -3.58097329e+00   1.37051803e+00
   -1.03537832e+00   4.92140754e+00  -6.01291972e+00
    3.96063894e-01  -3.57529683e+00  -8.33341593e+00
    4.28271856e-01   3.35005684e+00   6.52272323e+00
   -4.19454413e+00   9.47950884e+00  -6.76572378e-01
    4.12485166e+00  -6.21608470e+00   2.67409697e+00
    2.33005883e+00  -1.36316312e+00   3.63669006e+00
    1.97485329e+00   7.79913785e-01  -3.83286232e+00
    3.37286106e+00  -7.31080136e+00  -4.48727871e-02
   -3.92631947e+00   3.58642709e+00   7.21141783e+00
    1.44069110e+00  -2.21172899e+00  -1.95989921e+00
   -2.65051266e-01   5.51377517e-01   7.01888000e+00
    2.21078739e+00  -5.18186924e+00   7.95824922e+00
   -1.21814223e+00   4.02813334e-01  -9.91943757e+00
    1.35293134e+00  -3.65418494e-01  -3.71484676e+00
   -4.31036285e+00   1.10945272e+00   6.16949988e+00
   -2.31809939e+00   2.47778064e+00   5.20609733e+00
    5.27641174e+00  -2.35582002e+00   3.29533957e-01
    2.82858411e+00  -4.45926298e+00   2.22693471e+00
   -4.31119181e+00   1.09762735e+00  -5.05489198e+00
    5.43058618e+00  -5.08421041e+00  -5.98394258e+00
   -9.23488915e-01   1.70531279e+00   1.40234893e+00
    1.74473619e+00  -3.51535714e+00   1.73471557e+00
   -2.22573318e+00   2.39176959e+00   4.38690384e+00
    5.90768580e-01  -3.52380768e+00   3.43622132e-01
    4.13718874e+00  -1.49869934e-02   1.73909078e+00
    1.44497691e+00  -7.62297983e-01   5.89253131e+00
   -8.25619361e+00  -1.23003509e+00  -7.26014379e+00
   -2.00579244e+00  -1.07849480e+00   1.29537924e+00
    2.11464235e-02   9.63415615e-01   5.58896742e-01
    1.65572482e+00   4.26509142e-01  -1.24915500e+01
   -3.50818283e-01  -2.29323205e+00  -1.93643404e+00
   -6.33701548e+00   1.11391002e+00  -1.80022900e+00
    4.54629140e+00   1.31001613e+00   3.42281012e+00
   -6.93145810e-01  -1.00596864e+00   3.04927325e+00
    7.73888348e-01   4.03111163e+00  -2.50399620e+00
    3.82498803e+00  -8.37661460e-01  -9.88475462e+00
   -4.54928149e+00  -2.64856834e-01   1.31813403e+01
   -5.76142375e+00  -5.23284790e-01   4.33520944e+00
    8.15857887e+00   2.00468602e+00   1.62500822e+00
   -1.03344823e+00   9.21788455e-01   8.61634051e-01
   -1.21908941e+00  -1.92760830e+00  -5.38243525e+00
   -2.01596170e+00   1.01732347e-02   4.51548438e-01
    1.19975438e+00   8.72030616e-01  -9.59227058e-01
    3.37305093e-01  -2.70005453e+00   6.24368074e-01
    2.53132642e+00   1.76375361e+00   2.53589556e+00
   -1.88555231e-01   2.22118192e-01  -9.96324438e-01
   -4.35795204e+00  -1.96601044e+00   1.93482300e+00
   -3.34218086e+00  -1.21333857e+00  -3.68716830e+00
    6.47545539e+00   3.27106410e+00   1.55603444e+00
    3.95653089e-01  -1.35704105e+00   4.86094832e-01
    9.78496197e-01   1.73805253e+00   5.30468658e+00
    7.51348885e+00   3.57080453e+00   1.10020943e+01
   -3.99325909e+00  -6.22871445e+00   2.38944400e+00
   -3.89866830e+00  -2.37786111e+00  -5.54218098e+00
   -2.49304002e-01  -3.19458113e-01   1.32437503e+01
   -2.86626753e+00  -3.25060683e+00   4.56770685e+00
    2.96318363e+00   2.31407386e+00   4.44982650e+00
   -1.76833981e+00  -3.68905270e+00  -8.89266825e+00
    1.79828479e+00   2.51438717e+00  -6.91288616e+00
    1.74711637e+00  -1.12173026e+00  -1.59753794e+00
   -4.17597510e+00  -1.15070365e+00  -1.30494438e+00
   -2.80977456e-01  -1.91671379e+00  -5.12807845e+00
   -2.54535372e+00  -3.45338108e+00   6.13155305e+00
   -1.78066455e+00  -2.51243401e+00  -6.36039740e-01
   -8.99538288e-02   4.00773917e+00   1.27618400e+00
    3.44391200e+00   4.28850496e+00   5.44588745e+00
    1.23945133e+00  -2.84447015e-01   1.38990381e+00
    4.55515018e-02  -2.57480524e-01  -4.59390316e+00
    1.44255095e+00  -5.52015782e-01  -3.82903463e+00
    9.78866018e-01  -1.24447025e+00  -1.70574533e+00
   -1.66722999e+00  -1.94995795e+00   7.29442786e+00
    1.13388167e+00   2.58269232e-01  -1.91057523e+00
    4.37392018e-01  -7.63856424e-01   1.48459979e+00
   -5.88634945e-01   9.89250636e-01  -6.48292211e+00
    2.81445154e-01   1.55225188e+00   6.21997944e-01
    1.08066644e+00   1.80823868e+00  -1.23053076e+01
   -2.42801439e-01  -7.57162093e-01  -1.00940591e+00
    7.21943708e-01   3.96490521e+00  -6.27002015e+00
    1.40629456e-01  -3.91121732e-01   9.01030269e+00
    2.18336244e+00  -9.09103198e-01  -1.11639254e+00
   -9.27958586e-01  -2.80888302e+00   7.64990533e+00
    4.09123337e-01  -2.74106371e+00  -1.12669594e+00
   -5.77832023e-01  -2.98033941e-01   7.49726757e+00
    2.13707845e+00   9.83588064e-01  -4.66165360e+00
   -4.48945927e-03   2.62004801e+00   8.04314272e+00
    1.99924404e+00  -2.01873629e-02   3.10081010e+00
    4.80899817e-02  -1.74305292e+00  -5.38570916e+00
    6.99974441e-01   6.28237901e+00   3.03976227e+00
    4.37411277e+00  -8.74958818e+00  -8.03806995e+00
    8.79552450e-01  -8.40225626e+00   5.18645257e+00
   -3.95668646e-01   4.65626609e+00  -1.25797624e+01
"""

pos = loadtxt(StringIO(positions))
print(pos.shape)
cell = loadtxt(StringIO(unitcell))
print(cell)
z = 6 * ones(len(pos))
forces = loadtxt(StringIO(forces))

atoms = Atoms(symbols=z, positions=pos, cell=cell, pbc=True)
#view(atoms)
print("Number of atoms:", len(atoms))

atoms.set_calculator(BrennerPotential())
f = atoms.get_forces()
print("Max. error:", abs(ravel(f - forces)).max())
#print f

dyn = VelocityVerlet(atoms, 3*units.fs)
dyn.attach(MDLogger(dyn, atoms, '-', peratom=True), interval=5)
dyn.attach(Trajectory("nanotube.traj", "w", atoms), interval=10)
dyn.run(200)
