"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.escapeTokenRegex = void 0;
function escapeTokenRegex(s) {
    // A CDK Token looks like: ${Token[TOKEN.12]}
    // This contains the regex special characters: ., $, {, }, [, and ]
    // Escape those for use in a regex.
    return s.replace(/[.${}[\]]/g, '\\$&');
}
exports.escapeTokenRegex = escapeTokenRegex;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9rZW4tcmVnZXgtaGVscGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRva2VuLXJlZ2V4LWhlbHBlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUgsU0FBZ0IsZ0JBQWdCLENBQUMsQ0FBUztJQUN4Qyw2Q0FBNkM7SUFDN0MsbUVBQW1FO0lBQ25FLG1DQUFtQztJQUNuQyxPQUFPLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pDLENBQUM7QUFMRCw0Q0FLQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmV4cG9ydCBmdW5jdGlvbiBlc2NhcGVUb2tlblJlZ2V4KHM6IHN0cmluZyk6IHN0cmluZyB7XG4gIC8vIEEgQ0RLIFRva2VuIGxvb2tzIGxpa2U6ICR7VG9rZW5bVE9LRU4uMTJdfVxuICAvLyBUaGlzIGNvbnRhaW5zIHRoZSByZWdleCBzcGVjaWFsIGNoYXJhY3RlcnM6IC4sICQsIHssIH0sIFssIGFuZCBdXG4gIC8vIEVzY2FwZSB0aG9zZSBmb3IgdXNlIGluIGEgcmVnZXguXG4gIHJldHVybiBzLnJlcGxhY2UoL1suJHt9W1xcXV0vZywgJ1xcXFwkJicpO1xufSJdfQ==