"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('Verify config with default values', () => {
    // WHEN
    const configBuilder = new lib_1.CloudWatchConfigBuilder();
    const config = JSON.parse(configBuilder.generateCloudWatchConfiguration());
    // THEN
    expect(config).toMatchObject({
        logs: {
            log_stream_name: 'DefaultLogStream-{instance_id}',
            force_flush_interval: 60,
        },
    });
});
test('Verify config with custom values', () => {
    // WHEN
    const configBuilder = new lib_1.CloudWatchConfigBuilder(core_1.Duration.minutes(2));
    const config = JSON.parse(configBuilder.generateCloudWatchConfiguration());
    // THEN
    expect(config).toMatchObject({
        logs: {
            force_flush_interval: 120,
        },
    });
});
test('Verify log config', () => {
    // WHEN
    const configBuilder = new lib_1.CloudWatchConfigBuilder(core_1.Duration.minutes(2));
    configBuilder.addLogsCollectList('logGroupName', 'testStream', '/var/log/test.log');
    configBuilder.addLogsCollectList('logGroupName2', 'testStream2', '/var/log/test2.log', lib_1.TimeZone.UTC);
    const config = JSON.parse(configBuilder.generateCloudWatchConfiguration());
    // THEN
    expect(config).toMatchObject({
        logs: {
            logs_collected: {
                files: {
                    collect_list: [{
                            file_path: '/var/log/test.log',
                            log_group_name: 'logGroupName',
                            log_stream_name: 'testStream-{instance_id}',
                            timezone: 'Local',
                        }, {
                            file_path: '/var/log/test2.log',
                            log_group_name: 'logGroupName2',
                            log_stream_name: 'testStream2-{instance_id}',
                            timezone: 'UTC',
                        }],
                },
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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