"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MountPermissions = void 0;
/**
 * Permission mode under which the filesystem is mounted.
 */
var MountPermissions;
(function (MountPermissions) {
    /**
     * Mount the filesystem as read-only.
     */
    MountPermissions["READONLY"] = "readonly";
    /**
     * Mount the filesystem as read-write.
     */
    MountPermissions["READWRITE"] = "readwrite";
})(MountPermissions = exports.MountPermissions || (exports.MountPermissions = {}));
//# sourceMappingURL=data:application/json;base64,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