"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArn = void 0;
/**
 * Check whether the given string matches the SecretsManager ARN format.
 * arn:aws:secretsmanager:<Region>:<AccountId>:secret:OptionalPath/SecretName-6RandomCharacters
 * Reference:
 *   https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources
 * @param value
 */
function isArn(value) {
    var _a;
    return ((_a = value.match(/arn:aws(?:-us-gov|-cn)?:secretsmanager:[-a-z0-9]*:[0-9]*:secret:.+/)) === null || _a === void 0 ? void 0 : _a.length) === 1;
}
exports.isArn = isArn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUg7Ozs7OztHQU1HO0FBQ0gsU0FBZ0IsS0FBSyxDQUFDLEtBQWE7O0lBQ2pDLE9BQU8sT0FBQSxLQUFLLENBQUMsS0FBSyxDQUFDLG9FQUFvRSxDQUFDLDBDQUFFLE1BQU0sTUFBSyxDQUFDLENBQUM7QUFDekcsQ0FBQztBQUZELHNCQUVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuLyoqXG4gKiBDaGVjayB3aGV0aGVyIHRoZSBnaXZlbiBzdHJpbmcgbWF0Y2hlcyB0aGUgU2VjcmV0c01hbmFnZXIgQVJOIGZvcm1hdC5cbiAqIGFybjphd3M6c2VjcmV0c21hbmFnZXI6PFJlZ2lvbj46PEFjY291bnRJZD46c2VjcmV0Ok9wdGlvbmFsUGF0aC9TZWNyZXROYW1lLTZSYW5kb21DaGFyYWN0ZXJzXG4gKiBSZWZlcmVuY2U6XG4gKiAgIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZWNyZXRzbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL3JlZmVyZW5jZV9pYW0tcGVybWlzc2lvbnMuaHRtbCNpYW0tcmVzb3VyY2VzXG4gKiBAcGFyYW0gdmFsdWVcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGlzQXJuKHZhbHVlOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgcmV0dXJuIHZhbHVlLm1hdGNoKC9hcm46YXdzKD86LXVzLWdvdnwtY24pPzpzZWNyZXRzbWFuYWdlcjpbLWEtejAtOV0qOlswLTldKjpzZWNyZXQ6LisvKT8ubGVuZ3RoID09PSAxO1xufSJdfQ==