"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArn = void 0;
/**
 * Check whether the given string matches the KMS ARN format.
 * arn:aws:kms:<Region>?:<AccountId>?:key/<UUID>
 * Reference:
 *   https://docs.aws.amazon.com/kms/latest/developerguide/find-cmk-id-arn.html#find-cmk-arn-api
 */
function isArn(value) {
    var _a;
    return ((_a = value.match(/arn:aws(?:-us-gov|-cn)?:kms:[-a-z0-9]*:[0-9]*:key\/[-a-f0-9]+/)) === null || _a === void 0 ? void 0 : _a.length) === 1;
}
exports.isArn = isArn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUg7Ozs7O0dBS0c7QUFDSCxTQUFnQixLQUFLLENBQUMsS0FBYTs7SUFDakMsT0FBTyxPQUFBLEtBQUssQ0FBQyxLQUFLLENBQUMsK0RBQStELENBQUMsMENBQUUsTUFBTSxNQUFLLENBQUMsQ0FBQztBQUNwRyxDQUFDO0FBRkQsc0JBRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vKipcbiAqIENoZWNrIHdoZXRoZXIgdGhlIGdpdmVuIHN0cmluZyBtYXRjaGVzIHRoZSBLTVMgQVJOIGZvcm1hdC5cbiAqIGFybjphd3M6a21zOjxSZWdpb24+Pzo8QWNjb3VudElkPj86a2V5LzxVVUlEPlxuICogUmVmZXJlbmNlOlxuICogICBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20va21zL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9maW5kLWNtay1pZC1hcm4uaHRtbCNmaW5kLWNtay1hcm4tYXBpXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpc0Fybih2YWx1ZTogc3RyaW5nKTogYm9vbGVhbiB7XG4gIHJldHVybiB2YWx1ZS5tYXRjaCgvYXJuOmF3cyg/Oi11cy1nb3Z8LWNuKT86a21zOlstYS16MC05XSo6WzAtOV0qOmtleVxcL1stYS1mMC05XSsvKT8ubGVuZ3RoID09PSAxO1xufSJdfQ==