"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const validation_1 = require("../validation");
// ARN format:
//  arn:aws:kms:<Region>?:<AccountId>?:key/<UUID>
test.each([
    // Start with a full valid arn, and then remove/change each part from left to right
    ['arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', true],
    [':aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['a:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn::kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws-cn:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', true],
    ['arn:aws-us-gov:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', true],
    ['arn:a:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws::us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws:k:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws:kms::111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab', true],
    ['arn:aws:kms:us-west-2::key/1234abcd-12ab-34cd-56ef-1234567890ab', true],
    ['arn:aws:kms:us-west-2:111122223333:/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws:kms:us-west-2:111122223333:k/1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws:kms:us-west-2:111122223333:key1234abcd-12ab-34cd-56ef-1234567890ab', false],
    ['arn:aws:kms:us-west-2:111122223333:key/', false],
    ['arn:aws:kms:us-west-2:111122223333:key/invalid-characters-ghijklmnopqr', false],
])('test isArn(%s) -> %p', (value, expected) => {
    expect(validation_1.isArn(value)).toBe(expected);
});
//# sourceMappingURL=data:application/json;base64,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