"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const hash_1 = require("../hash");
test('invariant', () => {
    // GIVEN
    const value1 = 'foo';
    const value2 = 'foo';
    // WHEN
    const hash1 = hash_1.calculateSha256Hash(value1);
    const hash2 = hash_1.calculateSha256Hash(value2);
    // THEN
    expect(hash1).toStrictEqual(hash2);
});
test('recurses object', () => {
    // GIVEN
    const value1 = {
        key1: 'value',
        nestedObj: {
            key1: 12,
            key2: 'some value',
        },
    };
    const value2 = {
        key1: 'value',
        nestedObj: {},
    };
    // WHEN
    const hash1 = hash_1.calculateSha256Hash(value1);
    const hash2 = hash_1.calculateSha256Hash(value2);
    // THEN
    expect(hash1).not.toStrictEqual(hash2);
});
test('iterates array', () => {
    // GIVEN
    const value1 = [];
    const value2 = ['foo'];
    // WHEN
    const hash1 = hash_1.calculateSha256Hash(value1);
    const hash2 = hash_1.calculateSha256Hash(value2);
    // THEN
    expect(hash1).not.toStrictEqual(hash2);
});
test('key order invariant', () => {
    // GIVEN
    const value1 = {
        key1: 'foo',
        key2: 'bar',
    };
    const value2 = {
        key2: 'bar',
        key1: 'foo',
    };
    // WHEN
    const hash1 = hash_1.calculateSha256Hash(value1);
    const hash2 = hash_1.calculateSha256Hash(value2);
    // THEN
    expect(hash1).toStrictEqual(hash2);
});
test('bad type', () => {
    // GIVEN
    const value = true;
    // THEN
    expect(() => hash_1.calculateSha256Hash(value)).toThrowError(`Unexpected value type: ${typeof (value)}`);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzaC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaGFzaC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0dBR0c7O0FBRUgsa0NBQThDO0FBRTlDLElBQUksQ0FBQyxXQUFXLEVBQUUsR0FBRyxFQUFFO0lBQ3JCLFFBQVE7SUFDUixNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDckIsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBRXJCLE9BQU87SUFDUCxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMxQyxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUUxQyxPQUFPO0lBQ1AsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUNyQyxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLEVBQUU7SUFDM0IsUUFBUTtJQUNSLE1BQU0sTUFBTSxHQUFXO1FBQ3JCLElBQUksRUFBRSxPQUFPO1FBQ2IsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFLEVBQUU7WUFDUixJQUFJLEVBQUUsWUFBWTtTQUNuQjtLQUNGLENBQUM7SUFDRixNQUFNLE1BQU0sR0FBVztRQUNyQixJQUFJLEVBQUUsT0FBTztRQUNiLFNBQVMsRUFBRSxFQUFFO0tBQ2QsQ0FBQztJQUVGLE9BQU87SUFDUCxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMxQyxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUUxQyxPQUFPO0lBQ1AsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDekMsQ0FBQyxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxFQUFFO0lBQzFCLFFBQVE7SUFDUixNQUFNLE1BQU0sR0FBYSxFQUFFLENBQUM7SUFDNUIsTUFBTSxNQUFNLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUV2QixPQUFPO0lBQ1AsTUFBTSxLQUFLLEdBQUcsMEJBQW1CLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUMsTUFBTSxLQUFLLEdBQUcsMEJBQW1CLENBQUMsTUFBTSxDQUFDLENBQUM7SUFFMUMsT0FBTztJQUNQLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3pDLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLHFCQUFxQixFQUFFLEdBQUcsRUFBRTtJQUMvQixRQUFRO0lBQ1IsTUFBTSxNQUFNLEdBQVc7UUFDckIsSUFBSSxFQUFFLEtBQUs7UUFDWCxJQUFJLEVBQUUsS0FBSztLQUNaLENBQUM7SUFDRixNQUFNLE1BQU0sR0FBVztRQUNyQixJQUFJLEVBQUUsS0FBSztRQUNYLElBQUksRUFBRSxLQUFLO0tBQ1osQ0FBQztJQUVGLE9BQU87SUFDUCxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMxQyxNQUFNLEtBQUssR0FBRywwQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUUxQyxPQUFPO0lBQ1AsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUNyQyxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyxVQUFVLEVBQUUsR0FBRyxFQUFFO0lBQ3BCLFFBQVE7SUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLENBQUM7SUFFbkIsT0FBTztJQUNQLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQywwQkFBbUIsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQywwQkFBMEIsT0FBTSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUNuRyxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IGNhbGN1bGF0ZVNoYTI1Nkhhc2ggfSBmcm9tICcuLi9oYXNoJztcblxudGVzdCgnaW52YXJpYW50JywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCB2YWx1ZTEgPSAnZm9vJztcbiAgY29uc3QgdmFsdWUyID0gJ2Zvbyc7XG5cbiAgLy8gV0hFTlxuICBjb25zdCBoYXNoMSA9IGNhbGN1bGF0ZVNoYTI1Nkhhc2godmFsdWUxKTtcbiAgY29uc3QgaGFzaDIgPSBjYWxjdWxhdGVTaGEyNTZIYXNoKHZhbHVlMik7XG5cbiAgLy8gVEhFTlxuICBleHBlY3QoaGFzaDEpLnRvU3RyaWN0RXF1YWwoaGFzaDIpO1xufSk7XG5cbnRlc3QoJ3JlY3Vyc2VzIG9iamVjdCcsICgpID0+IHtcbiAgLy8gR0lWRU5cbiAgY29uc3QgdmFsdWUxOiBvYmplY3QgPSB7XG4gICAga2V5MTogJ3ZhbHVlJyxcbiAgICBuZXN0ZWRPYmo6IHtcbiAgICAgIGtleTE6IDEyLFxuICAgICAga2V5MjogJ3NvbWUgdmFsdWUnLFxuICAgIH0sXG4gIH07XG4gIGNvbnN0IHZhbHVlMjogb2JqZWN0ID0ge1xuICAgIGtleTE6ICd2YWx1ZScsXG4gICAgbmVzdGVkT2JqOiB7fSxcbiAgfTtcblxuICAvLyBXSEVOXG4gIGNvbnN0IGhhc2gxID0gY2FsY3VsYXRlU2hhMjU2SGFzaCh2YWx1ZTEpO1xuICBjb25zdCBoYXNoMiA9IGNhbGN1bGF0ZVNoYTI1Nkhhc2godmFsdWUyKTtcblxuICAvLyBUSEVOXG4gIGV4cGVjdChoYXNoMSkubm90LnRvU3RyaWN0RXF1YWwoaGFzaDIpO1xufSk7XG5cbnRlc3QoJ2l0ZXJhdGVzIGFycmF5JywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCB2YWx1ZTE6IHN0cmluZ1tdID0gW107XG4gIGNvbnN0IHZhbHVlMiA9IFsnZm9vJ107XG5cbiAgLy8gV0hFTlxuICBjb25zdCBoYXNoMSA9IGNhbGN1bGF0ZVNoYTI1Nkhhc2godmFsdWUxKTtcbiAgY29uc3QgaGFzaDIgPSBjYWxjdWxhdGVTaGEyNTZIYXNoKHZhbHVlMik7XG5cbiAgLy8gVEhFTlxuICBleHBlY3QoaGFzaDEpLm5vdC50b1N0cmljdEVxdWFsKGhhc2gyKTtcbn0pO1xuXG50ZXN0KCdrZXkgb3JkZXIgaW52YXJpYW50JywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCB2YWx1ZTE6IG9iamVjdCA9IHtcbiAgICBrZXkxOiAnZm9vJyxcbiAgICBrZXkyOiAnYmFyJyxcbiAgfTtcbiAgY29uc3QgdmFsdWUyOiBvYmplY3QgPSB7XG4gICAga2V5MjogJ2JhcicsXG4gICAga2V5MTogJ2ZvbycsXG4gIH07XG5cbiAgLy8gV0hFTlxuICBjb25zdCBoYXNoMSA9IGNhbGN1bGF0ZVNoYTI1Nkhhc2godmFsdWUxKTtcbiAgY29uc3QgaGFzaDIgPSBjYWxjdWxhdGVTaGEyNTZIYXNoKHZhbHVlMik7XG5cbiAgLy8gVEhFTlxuICBleHBlY3QoaGFzaDEpLnRvU3RyaWN0RXF1YWwoaGFzaDIpO1xufSk7XG5cbnRlc3QoJ2JhZCB0eXBlJywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCB2YWx1ZSA9IHRydWU7XG5cbiAgLy8gVEhFTlxuICBleHBlY3QoKCkgPT4gY2FsY3VsYXRlU2hhMjU2SGFzaCh2YWx1ZSkpLnRvVGhyb3dFcnJvcihgVW5leHBlY3RlZCB2YWx1ZSB0eXBlOiAke3R5cGVvZih2YWx1ZSl9YCk7XG59KTsiXX0=