[![CI Backend Tests](https://github.com/Bruce-liushaopeng/Evase/actions/workflows/ci_tests.yml/badge.svg?branch=main)](https://github.com/Bruce-liushaopeng/Evase/actions/workflows/ci_tests.yml)

# Evase Analysis Library
This library intends to help users detect SQL Injection vulnerabilities from their source code. 
It has several structures that take-in Python source code and use abstract-syntax trees (ASTs) to analyze for such vulnerabilities.
The code was initially part of a much bigger project, but as to provide separation of concerns, the functionality
for detecting the SQL injection-related vulnerabilities was separated out into this package.

## What's New

In the latest version of the library:
- The functions are able to fail more gracefully when encountering unexpected AST nodes.
- The Breadth-First search functions keep track of paths traversed.
  - The main traversal function (`traversal_from_exec`) now outputs a mapping of ending nodes to their possible paths.
- The dependency graph generated by `ProjectAnalysisStruct` has been tested for many use cases and seems to work very well.
- Some bugs in the module imports generated by `ModuleImportResolver` have been fixed.
  - The resolver now better handles variant imports like:
    - `from <one or more (.)> import <function|module|*>`
    - If we can backtrack to a module (through the count of '.' characters) we assume the object being imported is a module, otherwise it is a function.
- The graph node grouping mechanism in `AnalysisPerformer` has had some bugs resolved.
- Nodes in the graph now appear with the form `<package style name>:<function name>` for functions found WITHIN the analysis of the code (not external libraries).

## Issues

There are still a variety of issues with the handling of the various errors that our traversal mechanisms encounter.
- Those `Flask` endpoints that do not accept function parameters, (POST-type requests) aren't considered vulnerable due to inadequacies with the `collect_vulnerable_vars` function.
- There are many ways of writing imports, and it is likely that the `ModuleImportResolver` doesn't consider all of these.

## Usage
This package was developed initially with the intention that it be used in the Backend for the Evase web-application,
so it is structured as such. To use it in a program, the user first needs to specify information pertaining to the project.


The user is able to analyze the project with an instance of the `AnalysisPerformer` class. 

```python
from evase.structures.analysisperformer import AnalysisPerformer

code_analyzer = AnalysisPerformer(
    project_name="myProject",
    project_root="<filepath to root>"
)

code_analyzer.perform_analysis()

print(code_analyzer.get_results())

# optionally, output to JSON
code_analyzer.results_to_JSON("<output directory>")
```

Behind the scenes, this instance is performing multiple traversals of the abstract syntax trees (ASTs) generated from
the source code in the project.

## Installation
The package will be installable via PyPI. For now clone the repository, and run the following command:

`pip install .`

