import argparse
from pprint import pprint

from corpus_builder.builder_importer import from_text_file
from corpus_builder.corpus_exporter import export_to_csv, export_to_json, export_to_pickle

parser = argparse.ArgumentParser()
parser.add_argument('--input', dest='input_file', help='txt file with corpus builder definition', required=True)
parser.add_argument('--output', dest='dest_file', help='destination file to export the generated corpus', required=False)
parser.add_argument('-n', type=int, dest='num', help='reference corpus size generated by the grammar')
parser.add_argument('--aug', type=int, default=0, dest='num_aug', help='number of augmented sentences for each one of the reference corpus')
args = parser.parse_args()

builder = from_text_file(args.input_file)
corpus = builder.create_corpus(args.num, args.num_aug)

if not args.dest_file:
    pprint(corpus)
else:
    if args.dest_file.endswith('.json'):
        export_to_json(corpus, args.dest_file)
    elif args.dest_file.endswith('.csv'):
        export_to_csv(corpus, args.dest_file)
    elif args.dest_file.endswith('.pkl'):
        export_to_pickle(corpus, args.dest_file)
    else:
        print('Unsuported file type from file ' + args.dest_file + ', could not export resulting corpus')