import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 */
export interface CfnTableProps {
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     * @external
     */
    readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     * @external
     */
    readonly attributeDefinitions?: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     * @external
     */
    readonly billingMode?: string;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     * @external
     */
    readonly globalSecondaryIndexes?: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     * @external
     */
    readonly localSecondaryIndexes?: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     * @external
     */
    readonly pointInTimeRecoverySpecification?: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     * @external
     */
    readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     * @external
     */
    readonly sseSpecification?: CfnTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     * @external
     */
    readonly streamSpecification?: CfnTable.StreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     * @external
     */
    readonly tableName?: string;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     * @external
     */
    readonly timeToLiveSpecification?: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::Table";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute StreamArn
     */
    readonly attrStreamArn: string;
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     * @external
     */
    keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     * @external
     */
    attributeDefinitions: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     * @external
     */
    billingMode: string | undefined;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     * @external
     */
    globalSecondaryIndexes: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     * @external
     */
    localSecondaryIndexes: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     * @external
     */
    pointInTimeRecoverySpecification: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     * @external
     */
    provisionedThroughput: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     * @external
     */
    sseSpecification: CfnTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     * @external
     */
    streamSpecification: CfnTable.StreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     * @external
     */
    tableName: string | undefined;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     * @external
     */
    timeToLiveSpecification: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::DynamoDB::Table`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     * @external
     */
    interface AttributeDefinitionProperty {
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         * @external
         */
        readonly attributeName: string;
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         * @external
         */
        readonly attributeType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     * @external
     */
    interface GlobalSecondaryIndexProperty {
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.IndexName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         * @external
         */
        readonly indexName: string;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         * @external
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.Projection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         * @external
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         * @external
         */
        readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     * @external
     */
    interface KeySchemaProperty {
        /**
         * `CfnTable.KeySchemaProperty.AttributeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         * @external
         */
        readonly attributeName: string;
        /**
         * `CfnTable.KeySchemaProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         * @external
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     * @external
     */
    interface LocalSecondaryIndexProperty {
        /**
         * `CfnTable.LocalSecondaryIndexProperty.IndexName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         * @external
         */
        readonly indexName: string;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.KeySchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         * @external
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.Projection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         * @external
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     * @external
     */
    interface PointInTimeRecoverySpecificationProperty {
        /**
         * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         * @external
         */
        readonly pointInTimeRecoveryEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     * @external
     */
    interface ProjectionProperty {
        /**
         * `CfnTable.ProjectionProperty.NonKeyAttributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         * @external
         */
        readonly nonKeyAttributes?: string[];
        /**
         * `CfnTable.ProjectionProperty.ProjectionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         * @external
         */
        readonly projectionType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     * @external
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         * @external
         */
        readonly readCapacityUnits: number;
        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         * @external
         */
        readonly writeCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     * @external
     */
    interface SSESpecificationProperty {
        /**
         * `CfnTable.SSESpecificationProperty.KMSMasterKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid
         * @external
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         * @external
         */
        readonly sseEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnTable.SSESpecificationProperty.SSEType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype
         * @external
         */
        readonly sseType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     * @external
     */
    interface StreamSpecificationProperty {
        /**
         * `CfnTable.StreamSpecificationProperty.StreamViewType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         * @external
         */
        readonly streamViewType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     * @external
     */
    interface TimeToLiveSpecificationProperty {
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         * @external
         */
        readonly attributeName: string;
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
