# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


"""
Core C++ bindings
-----------------
This module encompasses the complete public C++ API of AMICI, which was
exposed via swig. All functions listed here are directly accessible in the
main amici package, i.e., `amici.amici.ExpData` is available as `amici
.ExpData`. Usage of functions and classes from the base `amici` package is
generally recommended as they often include convenience wrappers that avoid
common pitfalls when accessing C++ types from python and implement some
nonstandard type conversions.
"""

from typing import Iterable



from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _amici
else:
    import _amici

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _amici.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _amici.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _amici.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _amici.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _amici.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _amici.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _amici.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _amici.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _amici.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _amici.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _amici.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _amici.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _amici.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _amici.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _amici.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _amici.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _amici:
_amici.SwigPyIterator_swigregister(SwigPyIterator)

class DoubleVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.DoubleVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.DoubleVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.DoubleVector___bool__(self)

    def __len__(self) -> "std::vector< double >::size_type":
        return _amici.DoubleVector___len__(self)

    def __getslice__(self, i: "std::vector< double >::difference_type", j: "std::vector< double >::difference_type") -> "std::vector< double,std::allocator< double > > *":
        return _amici.DoubleVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.DoubleVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< double >::difference_type", j: "std::vector< double >::difference_type") -> "void":
        return _amici.DoubleVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.DoubleVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< double >::value_type const &":
        return _amici.DoubleVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.DoubleVector___setitem__(self, *args)

    def pop(self) -> "std::vector< double >::value_type":
        return _amici.DoubleVector_pop(self)

    def append(self, x: "std::vector< double >::value_type const &") -> "void":
        return _amici.DoubleVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.DoubleVector_empty(self)

    def size(self) -> "std::vector< double >::size_type":
        return _amici.DoubleVector_size(self)

    def swap(self, v: "DoubleVector") -> "void":
        return _amici.DoubleVector_swap(self, v)

    def begin(self) -> "std::vector< double >::iterator":
        return _amici.DoubleVector_begin(self)

    def end(self) -> "std::vector< double >::iterator":
        return _amici.DoubleVector_end(self)

    def rbegin(self) -> "std::vector< double >::reverse_iterator":
        return _amici.DoubleVector_rbegin(self)

    def rend(self) -> "std::vector< double >::reverse_iterator":
        return _amici.DoubleVector_rend(self)

    def clear(self) -> "void":
        return _amici.DoubleVector_clear(self)

    def get_allocator(self) -> "std::vector< double >::allocator_type":
        return _amici.DoubleVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.DoubleVector_pop_back(self)

    def erase(self, *args) -> "std::vector< double >::iterator":
        return _amici.DoubleVector_erase(self, *args)

    def __init__(self, *args):
        _amici.DoubleVector_swiginit(self, _amici.new_DoubleVector(*args))

    def push_back(self, x: "std::vector< double >::value_type const &") -> "void":
        return _amici.DoubleVector_push_back(self, x)

    def front(self) -> "std::vector< double >::value_type const &":
        return _amici.DoubleVector_front(self)

    def back(self) -> "std::vector< double >::value_type const &":
        return _amici.DoubleVector_back(self)

    def assign(self, n: "std::vector< double >::size_type", x: "std::vector< double >::value_type const &") -> "void":
        return _amici.DoubleVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.DoubleVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.DoubleVector_insert(self, *args)

    def reserve(self, n: "std::vector< double >::size_type") -> "void":
        return _amici.DoubleVector_reserve(self, n)

    def capacity(self) -> "std::vector< double >::size_type":
        return _amici.DoubleVector_capacity(self)
    __swig_destroy__ = _amici.delete_DoubleVector

# Register DoubleVector in _amici:
_amici.DoubleVector_swigregister(DoubleVector)

class IntVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.IntVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.IntVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.IntVector___bool__(self)

    def __len__(self) -> "std::vector< int >::size_type":
        return _amici.IntVector___len__(self)

    def __getslice__(self, i: "std::vector< int >::difference_type", j: "std::vector< int >::difference_type") -> "std::vector< int,std::allocator< int > > *":
        return _amici.IntVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.IntVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< int >::difference_type", j: "std::vector< int >::difference_type") -> "void":
        return _amici.IntVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.IntVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< int >::value_type const &":
        return _amici.IntVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.IntVector___setitem__(self, *args)

    def pop(self) -> "std::vector< int >::value_type":
        return _amici.IntVector_pop(self)

    def append(self, x: "std::vector< int >::value_type const &") -> "void":
        return _amici.IntVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.IntVector_empty(self)

    def size(self) -> "std::vector< int >::size_type":
        return _amici.IntVector_size(self)

    def swap(self, v: "IntVector") -> "void":
        return _amici.IntVector_swap(self, v)

    def begin(self) -> "std::vector< int >::iterator":
        return _amici.IntVector_begin(self)

    def end(self) -> "std::vector< int >::iterator":
        return _amici.IntVector_end(self)

    def rbegin(self) -> "std::vector< int >::reverse_iterator":
        return _amici.IntVector_rbegin(self)

    def rend(self) -> "std::vector< int >::reverse_iterator":
        return _amici.IntVector_rend(self)

    def clear(self) -> "void":
        return _amici.IntVector_clear(self)

    def get_allocator(self) -> "std::vector< int >::allocator_type":
        return _amici.IntVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.IntVector_pop_back(self)

    def erase(self, *args) -> "std::vector< int >::iterator":
        return _amici.IntVector_erase(self, *args)

    def __init__(self, *args):
        _amici.IntVector_swiginit(self, _amici.new_IntVector(*args))

    def push_back(self, x: "std::vector< int >::value_type const &") -> "void":
        return _amici.IntVector_push_back(self, x)

    def front(self) -> "std::vector< int >::value_type const &":
        return _amici.IntVector_front(self)

    def back(self) -> "std::vector< int >::value_type const &":
        return _amici.IntVector_back(self)

    def assign(self, n: "std::vector< int >::size_type", x: "std::vector< int >::value_type const &") -> "void":
        return _amici.IntVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.IntVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.IntVector_insert(self, *args)

    def reserve(self, n: "std::vector< int >::size_type") -> "void":
        return _amici.IntVector_reserve(self, n)

    def capacity(self) -> "std::vector< int >::size_type":
        return _amici.IntVector_capacity(self)
    __swig_destroy__ = _amici.delete_IntVector

# Register IntVector in _amici:
_amici.IntVector_swigregister(IntVector)

class BoolVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.BoolVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.BoolVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.BoolVector___bool__(self)

    def __len__(self) -> "std::vector< bool >::size_type":
        return _amici.BoolVector___len__(self)

    def __getslice__(self, i: "std::vector< bool >::difference_type", j: "std::vector< bool >::difference_type") -> "std::vector< bool,std::allocator< bool > > *":
        return _amici.BoolVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.BoolVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< bool >::difference_type", j: "std::vector< bool >::difference_type") -> "void":
        return _amici.BoolVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.BoolVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< bool >::value_type":
        return _amici.BoolVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.BoolVector___setitem__(self, *args)

    def pop(self) -> "std::vector< bool >::value_type":
        return _amici.BoolVector_pop(self)

    def append(self, x: "std::vector< bool >::value_type") -> "void":
        return _amici.BoolVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.BoolVector_empty(self)

    def size(self) -> "std::vector< bool >::size_type":
        return _amici.BoolVector_size(self)

    def swap(self, v: "BoolVector") -> "void":
        return _amici.BoolVector_swap(self, v)

    def begin(self) -> "std::vector< bool >::iterator":
        return _amici.BoolVector_begin(self)

    def end(self) -> "std::vector< bool >::iterator":
        return _amici.BoolVector_end(self)

    def rbegin(self) -> "std::vector< bool >::reverse_iterator":
        return _amici.BoolVector_rbegin(self)

    def rend(self) -> "std::vector< bool >::reverse_iterator":
        return _amici.BoolVector_rend(self)

    def clear(self) -> "void":
        return _amici.BoolVector_clear(self)

    def get_allocator(self) -> "std::vector< bool >::allocator_type":
        return _amici.BoolVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.BoolVector_pop_back(self)

    def erase(self, *args) -> "std::vector< bool >::iterator":
        return _amici.BoolVector_erase(self, *args)

    def __init__(self, *args):
        _amici.BoolVector_swiginit(self, _amici.new_BoolVector(*args))

    def push_back(self, x: "std::vector< bool >::value_type") -> "void":
        return _amici.BoolVector_push_back(self, x)

    def front(self) -> "std::vector< bool >::value_type":
        return _amici.BoolVector_front(self)

    def back(self) -> "std::vector< bool >::value_type":
        return _amici.BoolVector_back(self)

    def assign(self, n: "std::vector< bool >::size_type", x: "std::vector< bool >::value_type") -> "void":
        return _amici.BoolVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.BoolVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.BoolVector_insert(self, *args)

    def reserve(self, n: "std::vector< bool >::size_type") -> "void":
        return _amici.BoolVector_reserve(self, n)

    def capacity(self) -> "std::vector< bool >::size_type":
        return _amici.BoolVector_capacity(self)
    __swig_destroy__ = _amici.delete_BoolVector

# Register BoolVector in _amici:
_amici.BoolVector_swigregister(BoolVector)

class StringVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.StringVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.StringVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.StringVector___bool__(self)

    def __len__(self) -> "std::vector< std::string >::size_type":
        return _amici.StringVector___len__(self)

    def __getslice__(self, i: "std::vector< std::string >::difference_type", j: "std::vector< std::string >::difference_type") -> "std::vector< std::string,std::allocator< std::string > > *":
        return _amici.StringVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.StringVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< std::string >::difference_type", j: "std::vector< std::string >::difference_type") -> "void":
        return _amici.StringVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.StringVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< std::string >::value_type const &":
        return _amici.StringVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.StringVector___setitem__(self, *args)

    def pop(self) -> "std::vector< std::string >::value_type":
        return _amici.StringVector_pop(self)

    def append(self, x: "std::vector< std::string >::value_type const &") -> "void":
        return _amici.StringVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.StringVector_empty(self)

    def size(self) -> "std::vector< std::string >::size_type":
        return _amici.StringVector_size(self)

    def swap(self, v: "StringVector") -> "void":
        return _amici.StringVector_swap(self, v)

    def begin(self) -> "std::vector< std::string >::iterator":
        return _amici.StringVector_begin(self)

    def end(self) -> "std::vector< std::string >::iterator":
        return _amici.StringVector_end(self)

    def rbegin(self) -> "std::vector< std::string >::reverse_iterator":
        return _amici.StringVector_rbegin(self)

    def rend(self) -> "std::vector< std::string >::reverse_iterator":
        return _amici.StringVector_rend(self)

    def clear(self) -> "void":
        return _amici.StringVector_clear(self)

    def get_allocator(self) -> "std::vector< std::string >::allocator_type":
        return _amici.StringVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.StringVector_pop_back(self)

    def erase(self, *args) -> "std::vector< std::string >::iterator":
        return _amici.StringVector_erase(self, *args)

    def __init__(self, *args):
        _amici.StringVector_swiginit(self, _amici.new_StringVector(*args))

    def push_back(self, x: "std::vector< std::string >::value_type const &") -> "void":
        return _amici.StringVector_push_back(self, x)

    def front(self) -> "std::vector< std::string >::value_type const &":
        return _amici.StringVector_front(self)

    def back(self) -> "std::vector< std::string >::value_type const &":
        return _amici.StringVector_back(self)

    def assign(self, n: "std::vector< std::string >::size_type", x: "std::vector< std::string >::value_type const &") -> "void":
        return _amici.StringVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.StringVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.StringVector_insert(self, *args)

    def reserve(self, n: "std::vector< std::string >::size_type") -> "void":
        return _amici.StringVector_reserve(self, n)

    def capacity(self) -> "std::vector< std::string >::size_type":
        return _amici.StringVector_capacity(self)
    __swig_destroy__ = _amici.delete_StringVector

# Register StringVector in _amici:
_amici.StringVector_swigregister(StringVector)

class StringDoubleMap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.StringDoubleMap_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.StringDoubleMap___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.StringDoubleMap___bool__(self)

    def __len__(self) -> "std::map< std::string,double >::size_type":
        return _amici.StringDoubleMap___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key: "std::map< std::string,double >::key_type const &") -> "std::map< std::string,double >::mapped_type const &":
        return _amici.StringDoubleMap___getitem__(self, key)

    def __delitem__(self, key: "std::map< std::string,double >::key_type const &") -> "void":
        return _amici.StringDoubleMap___delitem__(self, key)

    def has_key(self, key: "std::map< std::string,double >::key_type const &") -> "bool":
        return _amici.StringDoubleMap_has_key(self, key)

    def keys(self) -> "PyObject *":
        return _amici.StringDoubleMap_keys(self)

    def values(self) -> "PyObject *":
        return _amici.StringDoubleMap_values(self)

    def items(self) -> "PyObject *":
        return _amici.StringDoubleMap_items(self)

    def __contains__(self, key: "std::map< std::string,double >::key_type const &") -> "bool":
        return _amici.StringDoubleMap___contains__(self, key)

    def key_iterator(self) -> "swig::SwigPyIterator *":
        return _amici.StringDoubleMap_key_iterator(self)

    def value_iterator(self) -> "swig::SwigPyIterator *":
        return _amici.StringDoubleMap_value_iterator(self)

    def __setitem__(self, *args) -> "void":
        return _amici.StringDoubleMap___setitem__(self, *args)

    def asdict(self) -> "PyObject *":
        return _amici.StringDoubleMap_asdict(self)

    def __init__(self, *args):
        _amici.StringDoubleMap_swiginit(self, _amici.new_StringDoubleMap(*args))

    def empty(self) -> "bool":
        return _amici.StringDoubleMap_empty(self)

    def size(self) -> "std::map< std::string,double >::size_type":
        return _amici.StringDoubleMap_size(self)

    def swap(self, v: "StringDoubleMap") -> "void":
        return _amici.StringDoubleMap_swap(self, v)

    def begin(self) -> "std::map< std::string,double >::iterator":
        return _amici.StringDoubleMap_begin(self)

    def end(self) -> "std::map< std::string,double >::iterator":
        return _amici.StringDoubleMap_end(self)

    def rbegin(self) -> "std::map< std::string,double >::reverse_iterator":
        return _amici.StringDoubleMap_rbegin(self)

    def rend(self) -> "std::map< std::string,double >::reverse_iterator":
        return _amici.StringDoubleMap_rend(self)

    def clear(self) -> "void":
        return _amici.StringDoubleMap_clear(self)

    def get_allocator(self) -> "std::map< std::string,double >::allocator_type":
        return _amici.StringDoubleMap_get_allocator(self)

    def count(self, x: "std::map< std::string,double >::key_type const &") -> "std::map< std::string,double >::size_type":
        return _amici.StringDoubleMap_count(self, x)

    def erase(self, *args) -> "void":
        return _amici.StringDoubleMap_erase(self, *args)

    def find(self, x: "std::map< std::string,double >::key_type const &") -> "std::map< std::string,double >::iterator":
        return _amici.StringDoubleMap_find(self, x)

    def lower_bound(self, x: "std::map< std::string,double >::key_type const &") -> "std::map< std::string,double >::iterator":
        return _amici.StringDoubleMap_lower_bound(self, x)

    def upper_bound(self, x: "std::map< std::string,double >::key_type const &") -> "std::map< std::string,double >::iterator":
        return _amici.StringDoubleMap_upper_bound(self, x)
    __swig_destroy__ = _amici.delete_StringDoubleMap

# Register StringDoubleMap in _amici:
_amici.StringDoubleMap_swigregister(StringDoubleMap)


def stdVec2ndarray(*args) -> "PyObject *":
    r"""
    *Overload 1:*

    Convert 1D array to *non-owning* numpy ndarray.
    :type vec: std::vector< double,std::allocator< double > >
    :param vec:
    :type dim1: int
    :param dim1:
    :rtype: PyObject
    :return: 

    |

    *Overload 2:*

    Convert row-major flattened 2D array to *non-owning* numpy ndarray.
    :type vec: std::vector< double,std::allocator< double > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :rtype: PyObject
    :return: 

    |

    *Overload 3:*

    Convert row-major flattened 3D array to *non-owning* numpy ndarray.
    :type vec: std::vector< double,std::allocator< double > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :type dim3: int
    :param dim3:
    :rtype: PyObject
    :return: 

    |

    *Overload 4:*

    Convert row-major flattened 2D array to *non-owning* numpy ndarray.
    :type vec: std::vector< double,std::allocator< double > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :type dim3: int
    :param dim3:
    :type dim4: int
    :param dim4:
    :rtype: PyObject
    :return: 

    |

    *Overload 5:*

    Convert 1D array to *non-owning* numpy ndarray.
    :type vec: std::vector< int,std::allocator< int > >
    :param vec:
    :type dim1: int
    :param dim1:
    :rtype: PyObject
    :return: 

    |

    *Overload 6:*

    Convert row-major flattened 2D array to *non-owning* numpy ndarray.
    :type vec: std::vector< int,std::allocator< int > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :rtype: PyObject
    :return: 

    |

    *Overload 7:*

    Convert row-major flattened 3D array to *non-owning* numpy ndarray.
    :type vec: std::vector< int,std::allocator< int > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :type dim3: int
    :param dim3:
    :rtype: PyObject
    :return: 

    |

    *Overload 8:*

    Convert row-major flattened 2D array to *non-owning* numpy ndarray.
    :type vec: std::vector< int,std::allocator< int > >
    :param vec:
    :type dim1: int
    :param dim1:
    :type dim2: int
    :param dim2:
    :type dim3: int
    :param dim3:
    :type dim4: int
    :param dim4:
    :rtype: PyObject
    :return: 
    """
    return _amici.stdVec2ndarray(*args)
class SolverPtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _amici.SolverPtr_swiginit(self, _amici.new_SolverPtr(*args))

    def __deref__(self) -> "std::unique_ptr< amici::Solver >::pointer":
        return _amici.SolverPtr___deref__(self)

    def release(self) -> "std::unique_ptr< amici::Solver >::pointer":
        return _amici.SolverPtr_release(self)

    def reset(self, *args) -> "void":
        return _amici.SolverPtr_reset(self, *args)

    def swap(self, __u: "SolverPtr") -> "void":
        return _amici.SolverPtr_swap(self, __u)

    def get(self) -> "std::unique_ptr< amici::Solver >::pointer":
        return _amici.SolverPtr_get(self)

    def __nonzero__(self):
        return _amici.SolverPtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _amici.delete_SolverPtr

    def clone(self) -> "amici::Solver *":
        r"""
        Clone this instance
        :rtype: :py:class:`Solver`
        :return: The clone
        """
        return _amici.SolverPtr_clone(self)

    def run(self, tout: "amici::realtype") -> "int":
        r"""
        runs a forward simulation until the specified timepoint

        :type tout: float
        :param tout: next timepooint
        :rtype: int
        :return: status flag
        """
        return _amici.SolverPtr_run(self, tout)

    def step(self, tout: "amici::realtype") -> "int":
        r"""
        makes a single step in the simulation

        :type tout: float
        :param tout: next timepooint
        :rtype: int
        :return: status flag
        """
        return _amici.SolverPtr_step(self, tout)

    def runB(self, tout: "amici::realtype") -> "void":
        r"""
        runs a backward simulation until the specified timepoint

        :type tout: float
        :param tout: next timepooint
        """
        return _amici.SolverPtr_runB(self, tout)

    def updateAndReinitStatesAndSensitivities(self, model: "Model") -> "void":
        r"""
        Reinitializes state and respective sensitivities (if necessary) according
        to changes in fixedParameters

        :type model: :py:class:`Model`
        :param model: pointer to the model instance
        """
        return _amici.SolverPtr_updateAndReinitStatesAndSensitivities(self, model)

    def getRootInfo(self, rootsfound: "int *") -> "void":
        r"""
        getRootInfo extracts information which event occured

        :type rootsfound: int
        :param rootsfound: array with flags indicating whether the respective
            event occured
        """
        return _amici.SolverPtr_getRootInfo(self, rootsfound)

    def calcIC(self, tout1: "amici::realtype") -> "void":
        r"""
        Calculates consistent initial conditions, assumes initial
        states to be correct (DAE only)

        :type tout1: float
        :param tout1: next timepoint to be computed (sets timescale)
        """
        return _amici.SolverPtr_calcIC(self, tout1)

    def calcICB(self, which: "int", tout1: "amici::realtype") -> "void":
        r"""
        Calculates consistent initial conditions for the backwards
        problem, assumes initial states to be correct (DAE only)

        :type which: int
        :param which: identifier of the backwards problem
        :type tout1: float
        :param tout1: next timepoint to be computed (sets timescale)
        """
        return _amici.SolverPtr_calcICB(self, which, tout1)

    def solveB(self, tBout: "amici::realtype", itaskB: "int") -> "void":
        r"""
        Solves the backward problem until a predefined timepoint
        (adjoint only)

        :type tBout: float
        :param tBout: timepoint until which simulation should be performed
        :type itaskB: int
        :param itaskB: task identifier, can be CV_NORMAL or CV_ONE_STEP
        """
        return _amici.SolverPtr_solveB(self, tBout, itaskB)

    def turnOffRootFinding(self) -> "void":
        r"""Disable rootfinding"""
        return _amici.SolverPtr_turnOffRootFinding(self)

    def getSensitivityMethod(self) -> "amici::SensitivityMethod":
        r"""
        Return current sensitivity method
        :rtype: int
        :return: method enum
        """
        return _amici.SolverPtr_getSensitivityMethod(self)

    def setSensitivityMethod(self, sensi_meth: "amici::SensitivityMethod") -> "void":
        r"""
        Set sensitivity method
        :type sensi_meth: int
        :param sensi_meth:
        """
        return _amici.SolverPtr_setSensitivityMethod(self, sensi_meth)

    def getSensitivityMethodPreequilibration(self) -> "amici::SensitivityMethod":
        r"""
        Return current sensitivity method during preequilibration
        :rtype: int
        :return: method enum
        """
        return _amici.SolverPtr_getSensitivityMethodPreequilibration(self)

    def setSensitivityMethodPreequilibration(self, sensi_meth_preeq: "amici::SensitivityMethod") -> "void":
        r"""
        Set sensitivity method for preequilibration
        :type sensi_meth_preeq: int
        :param sensi_meth_preeq:
        """
        return _amici.SolverPtr_setSensitivityMethodPreequilibration(self, sensi_meth_preeq)

    def switchForwardSensisOff(self) -> "void":
        r"""Disable forward sensitivity integration (used in steady state sim)"""
        return _amici.SolverPtr_switchForwardSensisOff(self)

    def getNewtonMaxSteps(self) -> "int":
        r"""
        Get maximum number of allowed Newton steps for steady state
        computation
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getNewtonMaxSteps(self)

    def setNewtonMaxSteps(self, newton_maxsteps: "int") -> "void":
        r"""
        Set maximum number of allowed Newton steps for steady state
        computation
        :type newton_maxsteps: int
        :param newton_maxsteps:
        """
        return _amici.SolverPtr_setNewtonMaxSteps(self, newton_maxsteps)

    def getPreequilibration(self) -> "bool":
        r"""
        Get if model preequilibration is enabled
        :rtype: boolean
        :return: 
        """
        return _amici.SolverPtr_getPreequilibration(self)

    def setPreequilibration(self, require_preequilibration: "bool") -> "void":
        r"""
        Enable/disable model preequilibration
        :type require_preequilibration: boolean
        :param require_preequilibration:
        """
        return _amici.SolverPtr_setPreequilibration(self, require_preequilibration)

    def getNewtonMaxLinearSteps(self) -> "int":
        r"""
        Get maximum number of allowed linear steps per Newton step for
        steady state computation
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getNewtonMaxLinearSteps(self)

    def setNewtonMaxLinearSteps(self, newton_maxlinsteps: "int") -> "void":
        r"""
        Set maximum number of allowed linear steps per Newton step for
        steady state computation
        :type newton_maxlinsteps: int
        :param newton_maxlinsteps:
        """
        return _amici.SolverPtr_setNewtonMaxLinearSteps(self, newton_maxlinsteps)

    def getNewtonDampingFactorMode(self) -> "amici::NewtonDampingFactorMode":
        r"""
        Get a state of the damping factor used in the Newton solver
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getNewtonDampingFactorMode(self)

    def setNewtonDampingFactorMode(self, dampingFactorMode: "amici::NewtonDampingFactorMode") -> "void":
        r"""
        Turn on/off a damping factor in the Newton method
        :type dampingFactorMode: int
        :param dampingFactorMode:
        """
        return _amici.SolverPtr_setNewtonDampingFactorMode(self, dampingFactorMode)

    def getNewtonDampingFactorLowerBound(self) -> "double":
        r"""
        Get a lower bound of the damping factor used in the Newton solver
        :rtype: float
        :return: 
        """
        return _amici.SolverPtr_getNewtonDampingFactorLowerBound(self)

    def setNewtonDampingFactorLowerBound(self, dampingFactorLowerBound: "double") -> "void":
        r"""
        Set a lower bound of the damping factor in the Newton solver
        :type dampingFactorLowerBound: float
        :param dampingFactorLowerBound:
        """
        return _amici.SolverPtr_setNewtonDampingFactorLowerBound(self, dampingFactorLowerBound)

    def getSensitivityOrder(self) -> "amici::SensitivityOrder":
        r"""
        Get sensitvity order
        :rtype: int
        :return: sensitivity order
        """
        return _amici.SolverPtr_getSensitivityOrder(self)

    def setSensitivityOrder(self, sensi: "amici::SensitivityOrder") -> "void":
        r"""
        Set the sensitvity order
        :type sensi: int
        :param sensi: sensitivity order
        """
        return _amici.SolverPtr_setSensitivityOrder(self, sensi)

    def getRelativeTolerance(self) -> "double":
        r"""
        Get the relative tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setRelativeToleranceASA.

        :rtype: float
        :return: relative tolerances
        """
        return _amici.SolverPtr_getRelativeTolerance(self)

    def setRelativeTolerance(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setRelativeToleranceASA.

        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeTolerance(self, rtol)

    def getAbsoluteTolerance(self) -> "double":
        r"""
        Get the absolute tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setAbsoluteToleranceASA.

        :rtype: float
        :return: absolute tolerances
        """
        return _amici.SolverPtr_getAbsoluteTolerance(self)

    def setAbsoluteTolerance(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setAbsoluteToleranceASA.

        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteTolerance(self, atol)

    def getRelativeToleranceFSA(self) -> "double":
        r"""
        Returns the relative tolerances for the forward sensitivity
        problem
        :rtype: float
        :return: relative tolerances
        """
        return _amici.SolverPtr_getRelativeToleranceFSA(self)

    def setRelativeToleranceFSA(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the forward sensitivity problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeToleranceFSA(self, rtol)

    def getAbsoluteToleranceFSA(self) -> "double":
        r"""
        Returns the absolute tolerances for the forward sensitivity
        problem
        :rtype: float
        :return: absolute tolerances
        """
        return _amici.SolverPtr_getAbsoluteToleranceFSA(self)

    def setAbsoluteToleranceFSA(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the forward sensitivity problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteToleranceFSA(self, atol)

    def getRelativeToleranceB(self) -> "double":
        r"""
        Returns the relative tolerances for the adjoint sensitivity
        problem
        :rtype: float
        :return: relative tolerances
        """
        return _amici.SolverPtr_getRelativeToleranceB(self)

    def setRelativeToleranceB(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the adjoint sensitivity problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeToleranceB(self, rtol)

    def getAbsoluteToleranceB(self) -> "double":
        r"""
        Returns the absolute tolerances for the backward problem for
        adjoint sensitivity analysis
        :rtype: float
        :return: absolute tolerances
        """
        return _amici.SolverPtr_getAbsoluteToleranceB(self)

    def setAbsoluteToleranceB(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the backward problem for
        adjoint sensitivity analysis
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteToleranceB(self, atol)

    def getRelativeToleranceQuadratures(self) -> "double":
        r"""
        Returns the relative tolerance for the quadrature problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.SolverPtr_getRelativeToleranceQuadratures(self)

    def setRelativeToleranceQuadratures(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the quadrature problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeToleranceQuadratures(self, rtol)

    def getAbsoluteToleranceQuadratures(self) -> "double":
        r"""
        returns the absolute tolerance for the quadrature problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.SolverPtr_getAbsoluteToleranceQuadratures(self)

    def setAbsoluteToleranceQuadratures(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the quadrature problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteToleranceQuadratures(self, atol)

    def getRelativeToleranceSteadyState(self) -> "double":
        r"""
        returns the relative tolerance for the steady state problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.SolverPtr_getRelativeToleranceSteadyState(self)

    def setRelativeToleranceSteadyState(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the steady state problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeToleranceSteadyState(self, rtol)

    def getAbsoluteToleranceSteadyState(self) -> "double":
        r"""
        returns the absolute tolerance for the steady state problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.SolverPtr_getAbsoluteToleranceSteadyState(self)

    def setAbsoluteToleranceSteadyState(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the steady state problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteToleranceSteadyState(self, atol)

    def getRelativeToleranceSteadyStateSensi(self) -> "double":
        r"""
        returns the relative tolerance for the sensitivities of the
        steady state problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.SolverPtr_getRelativeToleranceSteadyStateSensi(self)

    def setRelativeToleranceSteadyStateSensi(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the sensitivities of the
        steady state problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.SolverPtr_setRelativeToleranceSteadyStateSensi(self, rtol)

    def getAbsoluteToleranceSteadyStateSensi(self) -> "double":
        r"""
        returns the absolute tolerance for the sensitivities of the
        steady state problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.SolverPtr_getAbsoluteToleranceSteadyStateSensi(self)

    def setAbsoluteToleranceSteadyStateSensi(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the sensitivities of the
        steady state problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.SolverPtr_setAbsoluteToleranceSteadyStateSensi(self, atol)

    def getMaxSteps(self) -> "long":
        r"""
        returns the maximum number of solver steps for the forward
        problem
        :rtype: int
        :return: maximum number of solver steps
        """
        return _amici.SolverPtr_getMaxSteps(self)

    def setMaxSteps(self, maxsteps: "long") -> "void":
        r"""
        sets the maximum number of solver steps for the forward problem
        :type maxsteps: int
        :param maxsteps: maximum number of solver steps (non-negative number)
        """
        return _amici.SolverPtr_setMaxSteps(self, maxsteps)

    def getMaxStepsBackwardProblem(self) -> "long":
        r"""
        returns the maximum number of solver steps for the backward
        problem
        :rtype: int
        :return: maximum number of solver steps
        """
        return _amici.SolverPtr_getMaxStepsBackwardProblem(self)

    def setMaxStepsBackwardProblem(self, maxsteps: "long") -> "void":
        r"""
        sets the maximum number of solver steps for the backward problem
        :type maxsteps: int
        :param maxsteps: maximum number of solver steps (non-negative number)
        """
        return _amici.SolverPtr_setMaxStepsBackwardProblem(self, maxsteps)

    def getLinearMultistepMethod(self) -> "amici::LinearMultistepMethod":
        r"""
        returns the linear system multistep method
        :rtype: int
        :return: linear system multistep method
        """
        return _amici.SolverPtr_getLinearMultistepMethod(self)

    def setLinearMultistepMethod(self, lmm: "amici::LinearMultistepMethod") -> "void":
        r"""
        sets the linear system multistep method
        :type lmm: int
        :param lmm: linear system multistep method
        """
        return _amici.SolverPtr_setLinearMultistepMethod(self, lmm)

    def getNonlinearSolverIteration(self) -> "amici::NonlinearSolverIteration":
        r"""
        returns the nonlinear system solution method
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getNonlinearSolverIteration(self)

    def setNonlinearSolverIteration(self, iter: "amici::NonlinearSolverIteration") -> "void":
        r"""
        sets the nonlinear system solution method
        :type iter: int
        :param iter: nonlinear system solution method
        """
        return _amici.SolverPtr_setNonlinearSolverIteration(self, iter)

    def getInterpolationType(self) -> "amici::InterpolationType":
        r"""
        getInterpolationType
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getInterpolationType(self)

    def setInterpolationType(self, interpType: "amici::InterpolationType") -> "void":
        r"""
        sets the interpolation of the forward solution that is used for
        the backwards problem
        :type interpType: int
        :param interpType: interpolation type
        """
        return _amici.SolverPtr_setInterpolationType(self, interpType)

    def getStateOrdering(self) -> "int":
        r"""
        Gets KLU / SuperLUMT state ordering mode

        :rtype: int
        :return: State-ordering as integer according to
            SUNLinSolKLU::StateOrdering or SUNLinSolSuperLUMT::StateOrdering (which
            differ).
        """
        return _amici.SolverPtr_getStateOrdering(self)

    def setStateOrdering(self, ordering: "int") -> "void":
        r"""
        Sets KLU / SuperLUMT state ordering mode

        This only applies when linsol is set to LinearSolver::KLU or
        LinearSolver::SuperLUMT. Mind the difference between
        SUNLinSolKLU::StateOrdering and SUNLinSolSuperLUMT::StateOrdering.
        :type ordering: int
        :param ordering: state ordering
        """
        return _amici.SolverPtr_setStateOrdering(self, ordering)

    def getStabilityLimitFlag(self) -> "int":
        r"""
        returns stability limit detection mode
        :rtype: int
        :return: stldet can be amici.FALSE (deactivated) or amici.TRUE (activated)
        """
        return _amici.SolverPtr_getStabilityLimitFlag(self)

    def setStabilityLimitFlag(self, stldet: "int") -> "void":
        r"""
        set stability limit detection mode
        :type stldet: int
        :param stldet: can be amici.FALSE (deactivated) or amici.TRUE (activated)
        """
        return _amici.SolverPtr_setStabilityLimitFlag(self, stldet)

    def getLinearSolver(self) -> "amici::LinearSolver":
        r"""
        getLinearSolver
        :rtype: int
        :return: 
        """
        return _amici.SolverPtr_getLinearSolver(self)

    def setLinearSolver(self, linsol: "amici::LinearSolver") -> "void":
        r"""
        setLinearSolver
        :type linsol: int
        :param linsol:
        """
        return _amici.SolverPtr_setLinearSolver(self, linsol)

    def getInternalSensitivityMethod(self) -> "amici::InternalSensitivityMethod":
        r"""
        returns the internal sensitivity method
        :rtype: int
        :return: internal sensitivity method
        """
        return _amici.SolverPtr_getInternalSensitivityMethod(self)

    def setInternalSensitivityMethod(self, ism: "amici::InternalSensitivityMethod") -> "void":
        r"""
        sets the internal sensitivity method
        :type ism: int
        :param ism: internal sensitivity method
        """
        return _amici.SolverPtr_setInternalSensitivityMethod(self, ism)

    def getReturnDataReportingMode(self) -> "amici::RDataReporting":
        r"""
        returns the ReturnData reporting mode
        :rtype: int
        :return: ReturnData reporting mode
        """
        return _amici.SolverPtr_getReturnDataReportingMode(self)

    def setReturnDataReportingMode(self, rdrm: "amici::RDataReporting") -> "void":
        r"""
        sets the ReturnData reporting mode
        :type rdrm: int
        :param rdrm: ReturnData reporting mode
        """
        return _amici.SolverPtr_setReturnDataReportingMode(self, rdrm)

    def sensToggleOff(self) -> "void":
        r"""
        Switches off computation of  state sensitivites without
        deallocating the memory for sensitivities
        """
        return _amici.SolverPtr_sensToggleOff(self)

    def gett(self) -> "amici::realtype":
        r"""
        current solver timepoint
        :rtype: float
        :return: t
        """
        return _amici.SolverPtr_gett(self)

    def getCpuTime(self) -> "amici::realtype":
        r"""
        Reads out the cpu time needed for forward solve
        :rtype: float
        :return: cpu_time
        """
        return _amici.SolverPtr_getCpuTime(self)

    def getCpuTimeB(self) -> "amici::realtype":
        r"""
        Reads out the cpu time needed for bavkward solve
        :rtype: float
        :return: cpu_timeB
        """
        return _amici.SolverPtr_getCpuTimeB(self)

    def nx(self) -> "int":
        r"""
        number of states with which the solver was initialized
        :rtype: int
        :return: x.getLength()
        """
        return _amici.SolverPtr_nx(self)

    def nplist(self) -> "int":
        r"""
        number of parameters with which the solver was initialized
        :rtype: int
        :return: sx.getLength()
        """
        return _amici.SolverPtr_nplist(self)

    def nquad(self) -> "int":
        r"""
        number of quadratures with which the solver was initialized
        :rtype: int
        :return: xQB.getLength()
        """
        return _amici.SolverPtr_nquad(self)

    def computingFSA(self) -> "bool":
        r"""
        check if FSA is being computed
        :rtype: boolean
        :return: flag
        """
        return _amici.SolverPtr_computingFSA(self)

    def computingASA(self) -> "bool":
        r"""
        check if ASA is being computed
        :rtype: boolean
        :return: flag
        """
        return _amici.SolverPtr_computingASA(self)

    def resetDiagnosis(self) -> "void":
        r"""Resets vectors containing diagnosis information"""
        return _amici.SolverPtr_resetDiagnosis(self)

    def storeDiagnosis(self) -> "void":
        r"""Stores diagnosis information from solver memory block for forward problem"""
        return _amici.SolverPtr_storeDiagnosis(self)

    def storeDiagnosisB(self, which: "int") -> "void":
        r"""
        Stores diagnosis information from solver memory block for backward problem

        :type which: int
        :param which: identifier of the backwards problem
        """
        return _amici.SolverPtr_storeDiagnosisB(self, which)

    def getNumSteps(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor ns
        :rtype: std::vector< int,std::allocator< int > >
        :return: ns
        """
        return _amici.SolverPtr_getNumSteps(self)

    def getNumStepsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nsB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nsB
        """
        return _amici.SolverPtr_getNumStepsB(self)

    def getNumRhsEvals(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nrhs
        :rtype: std::vector< int,std::allocator< int > >
        :return: nrhs
        """
        return _amici.SolverPtr_getNumRhsEvals(self)

    def getNumRhsEvalsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nrhsB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nrhsB
        """
        return _amici.SolverPtr_getNumRhsEvalsB(self)

    def getNumErrTestFails(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor netf
        :rtype: std::vector< int,std::allocator< int > >
        :return: netf
        """
        return _amici.SolverPtr_getNumErrTestFails(self)

    def getNumErrTestFailsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor netfB
        :rtype: std::vector< int,std::allocator< int > >
        :return: netfB
        """
        return _amici.SolverPtr_getNumErrTestFailsB(self)

    def getNumNonlinSolvConvFails(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nnlscf
        :rtype: std::vector< int,std::allocator< int > >
        :return: nnlscf
        """
        return _amici.SolverPtr_getNumNonlinSolvConvFails(self)

    def getNumNonlinSolvConvFailsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nnlscfB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nnlscfB
        """
        return _amici.SolverPtr_getNumNonlinSolvConvFailsB(self)

    def getLastOrder(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor order
        :rtype: std::vector< int,std::allocator< int > >
        :return: order
        """
        return _amici.SolverPtr_getLastOrder(self)
    app = property(_amici.SolverPtr_app_get, _amici.SolverPtr_app_set, doc=r""" AMICI context""")

# Register SolverPtr in _amici:
_amici.SolverPtr_swigregister(SolverPtr)

class ReturnDataPtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _amici.ReturnDataPtr_swiginit(self, _amici.new_ReturnDataPtr(*args))

    def __deref__(self) -> "std::unique_ptr< amici::ReturnData >::pointer":
        return _amici.ReturnDataPtr___deref__(self)

    def release(self) -> "std::unique_ptr< amici::ReturnData >::pointer":
        return _amici.ReturnDataPtr_release(self)

    def reset(self, *args) -> "void":
        return _amici.ReturnDataPtr_reset(self, *args)

    def swap(self, __u: "ReturnDataPtr") -> "void":
        return _amici.ReturnDataPtr_swap(self, __u)

    def get(self) -> "std::unique_ptr< amici::ReturnData >::pointer":
        return _amici.ReturnDataPtr_get(self)

    def __nonzero__(self):
        return _amici.ReturnDataPtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _amici.delete_ReturnDataPtr
    ts = property(_amici.ReturnDataPtr_ts_get, _amici.ReturnDataPtr_ts_set, doc=r""" timepoints (dimension: nt)""")
    xdot = property(_amici.ReturnDataPtr_xdot_get, _amici.ReturnDataPtr_xdot_set, doc=r""" time derivative (dimension: nx)""")
    J = property(_amici.ReturnDataPtr_J_get, _amici.ReturnDataPtr_J_set, doc=r"""
    Jacobian of differential equation right hand side (dimension: nx x nx,
    row-major)
    """)
    w = property(_amici.ReturnDataPtr_w_get, _amici.ReturnDataPtr_w_set, doc=r"""
    w data from the model (recurring terms in xdot, for imported SBML models
    from python, this contains the flux vector)
    (dimensions: nt x nw, row major)
    """)
    z = property(_amici.ReturnDataPtr_z_get, _amici.ReturnDataPtr_z_set, doc=r""" event output (dimension: nmaxevent x nz, row-major)""")
    sigmaz = property(_amici.ReturnDataPtr_sigmaz_get, _amici.ReturnDataPtr_sigmaz_set, doc=r"""
    event output sigma standard deviation (dimension: nmaxevent x nz,
    row-major)
    """)
    sz = property(_amici.ReturnDataPtr_sz_get, _amici.ReturnDataPtr_sz_set, doc=r"""
    parameter derivative of event output (dimension: nmaxevent x nz,
    row-major)
    """)
    ssigmaz = property(_amici.ReturnDataPtr_ssigmaz_get, _amici.ReturnDataPtr_ssigmaz_set, doc=r"""
    parameter derivative of event output standard deviation (dimension:
    nmaxevent x nz, row-major)
    """)
    rz = property(_amici.ReturnDataPtr_rz_get, _amici.ReturnDataPtr_rz_set, doc=r""" event trigger output (dimension: nmaxevent x nz, row-major)""")
    srz = property(_amici.ReturnDataPtr_srz_get, _amici.ReturnDataPtr_srz_set, doc=r"""
    parameter derivative of event trigger output (dimension: nmaxevent x nz
    x nplist, row-major)
    """)
    s2rz = property(_amici.ReturnDataPtr_s2rz_get, _amici.ReturnDataPtr_s2rz_set, doc=r"""
    second order parameter derivative of event trigger output (dimension:
    nmaxevent x nztrue x nplist x nplist, row-major)
    """)
    x = property(_amici.ReturnDataPtr_x_get, _amici.ReturnDataPtr_x_set, doc=r""" state (dimension: nt x nx, row-major)""")
    sx = property(_amici.ReturnDataPtr_sx_get, _amici.ReturnDataPtr_sx_set, doc=r"""parameter derivative of state (dimension: nt x nplist x nx, row-major)""")
    y = property(_amici.ReturnDataPtr_y_get, _amici.ReturnDataPtr_y_set, doc=r""" observable (dimension: nt x ny, row-major)""")
    sigmay = property(_amici.ReturnDataPtr_sigmay_get, _amici.ReturnDataPtr_sigmay_set, doc=r""" observable standard deviation (dimension: nt x ny, row-major)""")
    sy = property(_amici.ReturnDataPtr_sy_get, _amici.ReturnDataPtr_sy_set, doc=r"""
    parameter derivative of observable (dimension: nt x nplist x ny,
    row-major)
    """)
    ssigmay = property(_amici.ReturnDataPtr_ssigmay_get, _amici.ReturnDataPtr_ssigmay_set, doc=r"""
    parameter derivative of observable standard deviation (dimension: nt x
    nplist x ny, row-major)
    """)
    res = property(_amici.ReturnDataPtr_res_get, _amici.ReturnDataPtr_res_set, doc=r""" observable (dimension: nt*ny, row-major)""")
    sres = property(_amici.ReturnDataPtr_sres_get, _amici.ReturnDataPtr_sres_set, doc=r"""parameter derivative of residual (dimension: nt*ny x nplist, row-major)""")
    FIM = property(_amici.ReturnDataPtr_FIM_get, _amici.ReturnDataPtr_FIM_set, doc=r""" fisher information matrix (dimension: nplist x nplist, row-major)""")
    numsteps = property(_amici.ReturnDataPtr_numsteps_get, _amici.ReturnDataPtr_numsteps_set, doc=r""" number of integration steps forward problem (dimension: nt)""")
    numstepsB = property(_amici.ReturnDataPtr_numstepsB_get, _amici.ReturnDataPtr_numstepsB_set, doc=r""" number of integration steps backward problem (dimension: nt)""")
    numrhsevals = property(_amici.ReturnDataPtr_numrhsevals_get, _amici.ReturnDataPtr_numrhsevals_set, doc=r""" number of right hand side evaluations forward problem (dimension: nt)""")
    numrhsevalsB = property(_amici.ReturnDataPtr_numrhsevalsB_get, _amici.ReturnDataPtr_numrhsevalsB_set, doc=r""" number of right hand side evaluations backwad problem (dimension: nt)""")
    numerrtestfails = property(_amici.ReturnDataPtr_numerrtestfails_get, _amici.ReturnDataPtr_numerrtestfails_set, doc=r""" number of error test failures forward problem (dimension: nt)""")
    numerrtestfailsB = property(_amici.ReturnDataPtr_numerrtestfailsB_get, _amici.ReturnDataPtr_numerrtestfailsB_set, doc=r""" number of error test failures backwad problem (dimension: nt)""")
    numnonlinsolvconvfails = property(_amici.ReturnDataPtr_numnonlinsolvconvfails_get, _amici.ReturnDataPtr_numnonlinsolvconvfails_set, doc=r"""
    number of linear solver convergence failures forward problem (dimension:
    nt)
    """)
    numnonlinsolvconvfailsB = property(_amici.ReturnDataPtr_numnonlinsolvconvfailsB_get, _amici.ReturnDataPtr_numnonlinsolvconvfailsB_set, doc=r"""
    number of linear solver convergence failures backwad problem (dimension:
    nt)
    """)
    order = property(_amici.ReturnDataPtr_order_get, _amici.ReturnDataPtr_order_set, doc=r""" employed order forward problem (dimension: nt)""")
    cpu_time = property(_amici.ReturnDataPtr_cpu_time_get, _amici.ReturnDataPtr_cpu_time_set, doc=r""" computation time of forward solve [ms]""")
    cpu_timeB = property(_amici.ReturnDataPtr_cpu_timeB_get, _amici.ReturnDataPtr_cpu_timeB_set, doc=r""" computation time of backward solve [ms]""")
    preeq_status = property(_amici.ReturnDataPtr_preeq_status_get, _amici.ReturnDataPtr_preeq_status_set, doc=r""" flags indicating success of steady state solver (preequilibration)""")
    preeq_cpu_time = property(_amici.ReturnDataPtr_preeq_cpu_time_get, _amici.ReturnDataPtr_preeq_cpu_time_set, doc=r""" computation time of the steady state solver [ms] (preequilibration)""")
    preeq_cpu_timeB = property(_amici.ReturnDataPtr_preeq_cpu_timeB_get, _amici.ReturnDataPtr_preeq_cpu_timeB_set, doc=r"""
    computation time of the steady state solver of the backward problem [ms]
    (preequilibration)
    """)
    posteq_status = property(_amici.ReturnDataPtr_posteq_status_get, _amici.ReturnDataPtr_posteq_status_set, doc=r""" flags indicating success of steady state solver  (postequilibration)""")
    posteq_cpu_time = property(_amici.ReturnDataPtr_posteq_cpu_time_get, _amici.ReturnDataPtr_posteq_cpu_time_set, doc=r""" computation time of the steady state solver [ms]  (postequilibration)""")
    posteq_cpu_timeB = property(_amici.ReturnDataPtr_posteq_cpu_timeB_get, _amici.ReturnDataPtr_posteq_cpu_timeB_set, doc=r"""
    computation time of the steady state solver of the backward problem [ms]
    (postequilibration)
    """)
    preeq_numsteps = property(_amici.ReturnDataPtr_preeq_numsteps_get, _amici.ReturnDataPtr_preeq_numsteps_set, doc=r"""
    number of Newton steps for steady state problem (preequilibration)
    [newton, simulation, newton] (length = 3)
    """)
    preeq_numlinsteps = property(_amici.ReturnDataPtr_preeq_numlinsteps_get, _amici.ReturnDataPtr_preeq_numlinsteps_set, doc=r"""
    number of linear steps by Newton step for steady state problem. this
    will only be filled for iterative solvers (preequilibration)
    (length = newton_maxsteps * 2)
    """)
    preeq_numstepsB = property(_amici.ReturnDataPtr_preeq_numstepsB_get, _amici.ReturnDataPtr_preeq_numstepsB_set, doc=r"""
    number of simulation steps for adjoint steady state problem
    (preequilibration) [== 0 if analytical solution worked, > 0 otherwise]
    """)
    posteq_numsteps = property(_amici.ReturnDataPtr_posteq_numsteps_get, _amici.ReturnDataPtr_posteq_numsteps_set, doc=r"""
    number of Newton steps for steady state problem (preequilibration)
    [newton, simulation, newton] (length = 3) (postequilibration)
    """)
    posteq_numlinsteps = property(_amici.ReturnDataPtr_posteq_numlinsteps_get, _amici.ReturnDataPtr_posteq_numlinsteps_set, doc=r"""
    number of linear steps by Newton step for steady state problem. this
    will only be filled for iterative solvers (postequilibration)
    (length = newton_maxsteps * 2)
    """)
    posteq_numstepsB = property(_amici.ReturnDataPtr_posteq_numstepsB_get, _amici.ReturnDataPtr_posteq_numstepsB_set, doc=r"""
    number of simulation steps for adjoint steady state problem
    (postequilibration) [== 0 if analytical solution worked, > 0 otherwise]
    """)
    preeq_t = property(_amici.ReturnDataPtr_preeq_t_get, _amici.ReturnDataPtr_preeq_t_set, doc=r"""time when steadystate was reached via simulation (preequilibration)""")
    preeq_wrms = property(_amici.ReturnDataPtr_preeq_wrms_get, _amici.ReturnDataPtr_preeq_wrms_set, doc=r"""
    weighted root-mean-square of the rhs when steadystate
    was reached (preequilibration)
    """)
    posteq_t = property(_amici.ReturnDataPtr_posteq_t_get, _amici.ReturnDataPtr_posteq_t_set, doc=r"""time when steadystate was reached via simulation (postequilibration)""")
    posteq_wrms = property(_amici.ReturnDataPtr_posteq_wrms_get, _amici.ReturnDataPtr_posteq_wrms_set, doc=r"""
    weighted root-mean-square of the rhs when steadystate
    was reached (postequilibration)
    """)
    x0 = property(_amici.ReturnDataPtr_x0_get, _amici.ReturnDataPtr_x0_set, doc=r""" initial state (dimension: nx)""")
    x_ss = property(_amici.ReturnDataPtr_x_ss_get, _amici.ReturnDataPtr_x_ss_set, doc=r""" preequilibration steady state found by Newton solver (dimension: nx)""")
    sx0 = property(_amici.ReturnDataPtr_sx0_get, _amici.ReturnDataPtr_sx0_set, doc=r""" initial sensitivities (dimension: nplist x nx, row-major)""")
    sx_ss = property(_amici.ReturnDataPtr_sx_ss_get, _amici.ReturnDataPtr_sx_ss_set, doc=r"""
    preequilibration sensitivities found by Newton solver (dimension: nplist
    x nx, row-major)
    """)
    llh = property(_amici.ReturnDataPtr_llh_get, _amici.ReturnDataPtr_llh_set, doc=r""" loglikelihood value""")
    chi2 = property(_amici.ReturnDataPtr_chi2_get, _amici.ReturnDataPtr_chi2_set, doc=r""" chi2 value""")
    sllh = property(_amici.ReturnDataPtr_sllh_get, _amici.ReturnDataPtr_sllh_set, doc=r""" parameter derivative of loglikelihood (dimension: nplist)""")
    s2llh = property(_amici.ReturnDataPtr_s2llh_get, _amici.ReturnDataPtr_s2llh_set, doc=r"""
    second order parameter derivative of loglikelihood (dimension: (nJ-1) x
    nplist, row-major)
    """)
    status = property(_amici.ReturnDataPtr_status_get, _amici.ReturnDataPtr_status_set, doc=r""" status code""")
    np = property(_amici.ReturnDataPtr_np_get, _amici.ReturnDataPtr_np_set, doc=r""" total number of model parameters""")
    nk = property(_amici.ReturnDataPtr_nk_get, _amici.ReturnDataPtr_nk_set, doc=r""" number of fixed parameters""")
    nx = property(_amici.ReturnDataPtr_nx_get, _amici.ReturnDataPtr_nx_set, doc=r""" number of states""")
    nx_solver = property(_amici.ReturnDataPtr_nx_solver_get, _amici.ReturnDataPtr_nx_solver_set, doc=r""" number of states with conservation laws applied""")
    nxtrue = property(_amici.ReturnDataPtr_nxtrue_get, _amici.ReturnDataPtr_nxtrue_set, doc=r""" number of states in the unaugmented system""")
    nx_solver_reinit = property(_amici.ReturnDataPtr_nx_solver_reinit_get, _amici.ReturnDataPtr_nx_solver_reinit_set, doc=r""" number of solver states to be reinitilized after preequilibration""")
    ny = property(_amici.ReturnDataPtr_ny_get, _amici.ReturnDataPtr_ny_set, doc=r""" number of observables""")
    nytrue = property(_amici.ReturnDataPtr_nytrue_get, _amici.ReturnDataPtr_nytrue_set, doc=r""" number of observables in the unaugmented system""")
    nz = property(_amici.ReturnDataPtr_nz_get, _amici.ReturnDataPtr_nz_set, doc=r""" number of event outputs""")
    nztrue = property(_amici.ReturnDataPtr_nztrue_get, _amici.ReturnDataPtr_nztrue_set, doc=r""" number of event outputs in the unaugmented system""")
    ne = property(_amici.ReturnDataPtr_ne_get, _amici.ReturnDataPtr_ne_set, doc=r""" number of events""")
    nJ = property(_amici.ReturnDataPtr_nJ_get, _amici.ReturnDataPtr_nJ_set, doc=r""" dimension of the augmented objective function for 2nd order ASA""")
    nplist = property(_amici.ReturnDataPtr_nplist_get, _amici.ReturnDataPtr_nplist_set, doc=r""" number of parameter for which sensitivities were requested""")
    nmaxevent = property(_amici.ReturnDataPtr_nmaxevent_get, _amici.ReturnDataPtr_nmaxevent_set, doc=r""" maximal number of occuring events (for every event type)""")
    nt = property(_amici.ReturnDataPtr_nt_get, _amici.ReturnDataPtr_nt_set, doc=r""" number of considered timepoints""")
    nw = property(_amici.ReturnDataPtr_nw_get, _amici.ReturnDataPtr_nw_set, doc=r""" number of columns in w""")
    newton_maxsteps = property(_amici.ReturnDataPtr_newton_maxsteps_get, _amici.ReturnDataPtr_newton_maxsteps_set, doc=r""" maximal number of newton iterations for steady state calculation""")
    pscale = property(_amici.ReturnDataPtr_pscale_get, _amici.ReturnDataPtr_pscale_set, doc=r""" scaling of parameterization (lin,log,log10)""")
    o2mode = property(_amici.ReturnDataPtr_o2mode_get, _amici.ReturnDataPtr_o2mode_set, doc=r""" flag indicating whether second order sensitivities were requested""")
    sensi = property(_amici.ReturnDataPtr_sensi_get, _amici.ReturnDataPtr_sensi_set, doc=r""" sensitivity order""")
    sensi_meth = property(_amici.ReturnDataPtr_sensi_meth_get, _amici.ReturnDataPtr_sensi_meth_set, doc=r""" sensitivity method""")
    rdata_reporting = property(_amici.ReturnDataPtr_rdata_reporting_get, _amici.ReturnDataPtr_rdata_reporting_set, doc=r""" reporting mode""")

# Register ReturnDataPtr in _amici:
_amici.ReturnDataPtr_swigregister(ReturnDataPtr)

class ModelPtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _amici.ModelPtr_swiginit(self, _amici.new_ModelPtr(*args))

    def __deref__(self) -> "std::unique_ptr< amici::Model >::pointer":
        return _amici.ModelPtr___deref__(self)

    def release(self) -> "std::unique_ptr< amici::Model >::pointer":
        return _amici.ModelPtr_release(self)

    def reset(self, *args) -> "void":
        return _amici.ModelPtr_reset(self, *args)

    def swap(self, __u: "ModelPtr") -> "void":
        return _amici.ModelPtr_swap(self, __u)

    def get(self) -> "std::unique_ptr< amici::Model >::pointer":
        return _amici.ModelPtr_get(self)

    def __nonzero__(self):
        return _amici.ModelPtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _amici.delete_ModelPtr

    def clone(self) -> "amici::Model *":
        r"""
        Clone this instance
        :rtype: :py:class:`Model`
        :return: The clone
        """
        return _amici.ModelPtr_clone(self)

    def nplist(self) -> "int":
        r"""
        Number of parameters wrt to which sensitivities are computed
        :rtype: int
        :return: length of sensitivity index vector
        """
        return _amici.ModelPtr_nplist(self)

    def np(self) -> "int":
        r"""
        Total number of model parameters
        :rtype: int
        :return: length of parameter vector
        """
        return _amici.ModelPtr_np(self)

    def nk(self) -> "int":
        r"""
        Number of constants
        :rtype: int
        :return: length of constant vector
        """
        return _amici.ModelPtr_nk(self)

    def ncl(self) -> "int":
        r"""
        Number of conservation laws
        :rtype: int
        :return: difference between nx_rdata and nx_solver
        """
        return _amici.ModelPtr_ncl(self)

    def nx_reinit(self) -> "int":
        r"""
        Number of solver states subject to reinitialization
        :rtype: int
        :return: model member nx_solver_reinit
        """
        return _amici.ModelPtr_nx_reinit(self)

    def k(self) -> "double const *":
        r"""
        Fixed parameters
        :rtype: float
        :return: pointer to constants array
        """
        return _amici.ModelPtr_k(self)

    def nMaxEvent(self) -> "int":
        r"""
        Get nmaxevent
        :rtype: int
        :return: maximum number of events that may occur for each type
        """
        return _amici.ModelPtr_nMaxEvent(self)

    def setNMaxEvent(self, nmaxevent: "int") -> "void":
        r"""
        Set nmaxevent
        :type nmaxevent: int
        :param nmaxevent: maximum number of events that may occur for each type
        """
        return _amici.ModelPtr_setNMaxEvent(self, nmaxevent)

    def nt(self) -> "int":
        r"""
        Get number of timepoints
        :rtype: int
        :return: number of timepoints
        """
        return _amici.ModelPtr_nt(self)

    def getParameterScale(self) -> "std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > > const &":
        r"""
        Get ParameterScale for each parameter
        :rtype: std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >
        :return: vector of parameter scale
        """
        return _amici.ModelPtr_getParameterScale(self)

    def setParameterScale(self, *args) -> "void":
        r"""
        *Overload 1:*

        Set ParameterScale for each parameter, resets initial state
        sensitivities
        :type pscale: int
        :param pscale: scalar parameter scale for all parameters

        |

        *Overload 2:*

        Set ParameterScale for each parameter, resets initial state
        sensitivities
        :type pscaleVec: std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >
        :param pscaleVec: vector of parameter scales
        """
        return _amici.ModelPtr_setParameterScale(self, *args)

    def getUnscaledParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Gets parameters with transformation according to ParameterScale
        applied
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: unscaled parameters
        """
        return _amici.ModelPtr_getUnscaledParameters(self)

    def getParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Get the parameter vector
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: The user-set parameters (see also getUnscaledParameters)
        """
        return _amici.ModelPtr_getParameters(self)

    def getParameterById(self, par_id: "std::string const &") -> "amici::realtype":
        r"""
        Get value of first model parameter with the specified id
        :type par_id: string
        :param par_id: parameter id
        :rtype: float
        :return: parameter value
        """
        return _amici.ModelPtr_getParameterById(self, par_id)

    def getParameterByName(self, par_name: "std::string const &") -> "amici::realtype":
        r"""
        Get value of first model parameter with the specified name,
        :type par_name: string
        :param par_name: parameter name
        :rtype: float
        :return: parameter value
        """
        return _amici.ModelPtr_getParameterByName(self, par_name)

    def setParameters(self, p: "DoubleVector") -> "void":
        r"""
        Sets the parameter vector
        :type p: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param p: vector of parameters
        """
        return _amici.ModelPtr_setParameters(self, p)

    def setParameterById(self, *args) -> "void":
        r"""
        *Overload 1:*

        Sets model parameters according to the parameter IDs and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters IDs and values
        :type ignoreErrors: boolean
        :param ignoreErrors: Ignore errors such as parameter IDs in p which are
            not model parameters

        |

        *Overload 2:*

        Set value of first model parameter with the specified id
        :type par_id: string
        :param par_id: parameter id
        :type value: float
        :param value: parameter value
        """
        return _amici.ModelPtr_setParameterById(self, *args)

    def setParametersByIdRegex(self, par_id_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set all values of model parameters with ids matching the specified
        regex
        :type par_id_regex: string
        :param par_id_regex: parameter id regex
        :type value: float
        :param value: parameter value
        :rtype: int
        :return: number of parameter ids that matched the regex
        """
        return _amici.ModelPtr_setParametersByIdRegex(self, par_id_regex, value)

    def setParameterByName(self, *args) -> "void":
        r"""
        *Overload 1:*

        Set value of first model parameter with the specified name
        :type par_name: string
        :param par_name: parameter name
        :type value: float
        :param value: parameter value

        |

        *Overload 2:*

        Sets model parameters according to the parameter name and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters names and values
        :type ignoreErrors: boolean
        :param ignoreErrors: Ignore errors such as parameter names in p which are
            not model parameters

        |

        *Overload 3:*

        Sets model parameters according to the parameter name and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters names and values
        :param ignoreErrors: Ignore errors such as parameter names in p which are
            not model parameters
        """
        return _amici.ModelPtr_setParameterByName(self, *args)

    def setParametersByNameRegex(self, par_name_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set all values of all model parameters with names matching the
        specified regex
        :type par_name_regex: string
        :param par_name_regex: parameter name regex
        :type value: float
        :param value: parameter value
        :rtype: int
        :return: number of fixed parameter names that matched the regex
        """
        return _amici.ModelPtr_setParametersByNameRegex(self, par_name_regex, value)

    def getFixedParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Gets the fixedParameter member
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: vector of fixed parameters
        """
        return _amici.ModelPtr_getFixedParameters(self)

    def getFixedParameterById(self, par_id: "std::string const &") -> "amici::realtype":
        r"""
        Get value of fixed parameter with the specified Id
        :type par_id: string
        :param par_id: parameter id
        :rtype: float
        :return: parameter value
        """
        return _amici.ModelPtr_getFixedParameterById(self, par_id)

    def getFixedParameterByName(self, par_name: "std::string const &") -> "amici::realtype":
        r"""
        Get value of fixed parameter with the specified name, if multiple
        parameters have the same name, the first parameter with matching name is
        returned
        :type par_name: string
        :param par_name: parameter name
        :rtype: float
        :return: parameter value
        """
        return _amici.ModelPtr_getFixedParameterByName(self, par_name)

    def setFixedParameters(self, k: "DoubleVector") -> "void":
        r"""
        Sets the fixedParameter member
        :type k: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param k: vector of fixed parameters
        """
        return _amici.ModelPtr_setFixedParameters(self, k)

    def setFixedParameterById(self, par_id: "std::string const &", value: "amici::realtype") -> "void":
        r"""
        Set value of first fixed parameter with the specified id
        :type par_id: string
        :param par_id: fixed parameter id
        :type value: float
        :param value: fixed parameter value
        """
        return _amici.ModelPtr_setFixedParameterById(self, par_id, value)

    def setFixedParametersByIdRegex(self, par_id_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set values of all fixed parameters with the id matching the
        specified regex
        :type par_id_regex: string
        :param par_id_regex: fixed parameter name regex
        :type value: float
        :param value: fixed parameter value
        :rtype: int
        :return: number of fixed parameter ids that matched the regex
        """
        return _amici.ModelPtr_setFixedParametersByIdRegex(self, par_id_regex, value)

    def setFixedParameterByName(self, par_name: "std::string const &", value: "amici::realtype") -> "void":
        r"""
        Set value of first fixed parameter with the specified name,
        :type par_name: string
        :param par_name: fixed parameter id
        :type value: float
        :param value: fixed parameter value
        """
        return _amici.ModelPtr_setFixedParameterByName(self, par_name, value)

    def setFixedParametersByNameRegex(self, par_name_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set value of all fixed parameters with name matching the specified
        regex,
        :type par_name_regex: string
        :param par_name_regex: fixed parameter name regex
        :type value: float
        :param value: fixed parameter value
        :rtype: int
        :return: number of fixed parameter names that matched the regex
        """
        return _amici.ModelPtr_setFixedParametersByNameRegex(self, par_name_regex, value)

    def getName(self) -> "std::string":
        r"""
        Returns the model name
        :rtype: string
        :return: model name
        """
        return _amici.ModelPtr_getName(self)

    def hasParameterNames(self) -> "bool":
        r"""
        Reports whether the model has parameter names set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether parameter names were set
        """
        return _amici.ModelPtr_hasParameterNames(self)

    def getParameterNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.ModelPtr_getParameterNames(self)

    def hasStateNames(self) -> "bool":
        r"""
        Reports whether the model has state names set. Also returns true
        if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether state names were set
        """
        return _amici.ModelPtr_hasStateNames(self)

    def getStateNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the model states
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.ModelPtr_getStateNames(self)

    def hasFixedParameterNames(self) -> "bool":
        r"""
        Reports whether the model has fixed parameter names set. Also
        returns true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether fixed parameter names were set
        """
        return _amici.ModelPtr_hasFixedParameterNames(self)

    def getFixedParameterNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the fixed model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.ModelPtr_getFixedParameterNames(self)

    def hasObservableNames(self) -> "bool":
        r"""
        Reports whether the model has observable names set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether observabke names were set
        """
        return _amici.ModelPtr_hasObservableNames(self)

    def getObservableNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the observables
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.ModelPtr_getObservableNames(self)

    def hasParameterIds(self) -> "bool":
        r"""
        Reports whether the model has parameter ids set. Also returns true
        if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether parameter ids were set
        """
        return _amici.ModelPtr_hasParameterIds(self)

    def getParameterIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.ModelPtr_getParameterIds(self)

    def hasStateIds(self) -> "bool":
        r"""
        Reports whether the model has state ids set. Also returns true if
        the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether state ids were set
        """
        return _amici.ModelPtr_hasStateIds(self)

    def getStateIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the model states
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.ModelPtr_getStateIds(self)

    def hasFixedParameterIds(self) -> "bool":
        r"""
        Reports whether the model has fixed parameter ids set. Also
        returns true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether fixed parameter ids were set
        """
        return _amici.ModelPtr_hasFixedParameterIds(self)

    def getFixedParameterIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the fixed model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.ModelPtr_getFixedParameterIds(self)

    def hasObservableIds(self) -> "bool":
        r"""
        Reports whether the model has observable ids set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether observale ids were set
        """
        return _amici.ModelPtr_hasObservableIds(self)

    def getObservableIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the observables
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.ModelPtr_getObservableIds(self)

    def getTimepoints(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Get the timepoint vector
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: timepoint vector
        """
        return _amici.ModelPtr_getTimepoints(self)

    def getTimepoint(self, it: "int") -> "amici::realtype":
        r"""
        get simulation timepoint for time index it
        :type it: int
        :param it: time index
        :rtype: float
        :return: t timepoint
        """
        return _amici.ModelPtr_getTimepoint(self, it)

    def setTimepoints(self, ts: "DoubleVector") -> "void":
        r"""
        Set the timepoint vector
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts: timepoint vector
        """
        return _amici.ModelPtr_setTimepoints(self, ts)

    def t0(self) -> "double":
        r"""
        get simulation start time
        :rtype: float
        :return: simulation start time
        """
        return _amici.ModelPtr_t0(self)

    def setT0(self, t0: "double") -> "void":
        r"""
        set simulation start time
        :type t0: float
        :param t0: simulation start time
        """
        return _amici.ModelPtr_setT0(self, t0)

    def getStateIsNonNegative(self) -> "std::vector< bool,std::allocator< bool > > const &":
        r"""
        gets flags indicating whether states should be treated as
        non-negative
        :rtype: std::vector< bool,std::allocator< bool > >
        :return: vector of flags
        """
        return _amici.ModelPtr_getStateIsNonNegative(self)

    def setStateIsNonNegative(self, stateIsNonNegative: "BoolVector") -> "void":
        r"""
        sets flags indicating whether states should be treated as
        non-negative
        :type stateIsNonNegative: std::vector< bool,std::allocator< bool > >
        :param stateIsNonNegative: vector of flags
        """
        return _amici.ModelPtr_setStateIsNonNegative(self, stateIsNonNegative)

    def setAllStatesNonNegative(self) -> "void":
        r"""
        sets flags indicating that all states should be treated as
        non-negative
        """
        return _amici.ModelPtr_setAllStatesNonNegative(self)

    def getParameterList(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Get the list of parameters for which sensitivities are computed
        :rtype: std::vector< int,std::allocator< int > >
        :return: list of parameter indices
        """
        return _amici.ModelPtr_getParameterList(self)

    def plist(self, pos: "int") -> "int":
        r"""
        entry in parameter list
        :type pos: int
        :param pos: index
        :rtype: int
        :return: entry
        """
        return _amici.ModelPtr_plist(self, pos)

    def setParameterList(self, plist: "IntVector") -> "void":
        r"""
        Set the list of parameters for which sensitivities are computed,
        resets initial state sensitivities
        :type plist: std::vector< int,std::allocator< int > >
        :param plist: list of parameter indices
        """
        return _amici.ModelPtr_setParameterList(self, plist)

    def getInitialStates(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > >":
        r"""
        Get the initial states
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: initial state vector
        """
        return _amici.ModelPtr_getInitialStates(self)

    def setInitialStates(self, x0: "DoubleVector") -> "void":
        r"""
        Set the initial states
        :type x0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param x0: initial state vector
        """
        return _amici.ModelPtr_setInitialStates(self, x0)

    def hasCustomInitialStates(self) -> "bool":
        r"""
        Returns whether custom initial states have been set
        :rtype: boolean
        :return: True if has custom initial states, otherwise false
        """
        return _amici.ModelPtr_hasCustomInitialStates(self)

    def getInitialStateSensitivities(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > >":
        r"""
        Get the initial states sensitivities
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: vector of initial state sensitivities
        """
        return _amici.ModelPtr_getInitialStateSensitivities(self)

    def setInitialStateSensitivities(self, sx0: "DoubleVector") -> "void":
        r"""
        Set the initial state sensitivities
        :type sx0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sx0: vector of initial state sensitivities with chainrule applied.
            This could be a slice of ReturnData::sx or ReturnData::sx0
        """
        return _amici.ModelPtr_setInitialStateSensitivities(self, sx0)

    def hasCustomInitialStateSensitivities(self) -> "bool":
        r"""
        Returns whether custom initial state sensitivitiess have been set
        :rtype: boolean
        :return: True if has custom initial state sensitivitiess, otherwise false
        """
        return _amici.ModelPtr_hasCustomInitialStateSensitivities(self)

    def setUnscaledInitialStateSensitivities(self, sx0: "DoubleVector") -> "void":
        r"""
        Set the initial state sensitivities
        :type sx0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sx0: vector of initial state sensitivities without chainrule
            applied. This could be the readin from a model.sx0data saved to hdf5.
        """
        return _amici.ModelPtr_setUnscaledInitialStateSensitivities(self, sx0)

    def setSteadyStateSensitivityMode(self, mode: "amici::SteadyStateSensitivityMode") -> "void":
        r"""
        Sets the mode how sensitivities are computed in the steadystate
        simulation
        :type mode: int
        :param mode: steadyStateSensitivityMode
        """
        return _amici.ModelPtr_setSteadyStateSensitivityMode(self, mode)

    def getSteadyStateSensitivityMode(self) -> "amici::SteadyStateSensitivityMode":
        r"""
        Gets the mode how sensitivities are computed in the steadystate
        simulation
        :rtype: int
        :return: flag value
        """
        return _amici.ModelPtr_getSteadyStateSensitivityMode(self)

    def setReinitializeFixedParameterInitialStates(self, flag: "bool") -> "void":
        r"""
        Set whether initial states depending on fixedParmeters are to be
        reinitialized after preequilibration and presimulation
        :type flag: boolean
        :param flag: true/false
        """
        return _amici.ModelPtr_setReinitializeFixedParameterInitialStates(self, flag)

    def getReinitializeFixedParameterInitialStates(self) -> "bool":
        r"""
        Get whether initial states depending on fixedParmeters are to be
        reinitialized after preequilibration and presimulation
        :rtype: boolean
        :return: flag true/false
        """
        return _amici.ModelPtr_getReinitializeFixedParameterInitialStates(self)

    def requireSensitivitiesForAllParameters(self) -> "void":
        r"""
        Require computation of sensitivities for all parameters p [0..np[
        in natural order, resets initial state sensitivities
        """
        return _amici.ModelPtr_requireSensitivitiesForAllParameters(self)

    def getObservableSigma(self, sigmay: "gsl::span< amici::realtype >", it: "int const", edata: "ExpData") -> "void":
        r"""
        Time-resolved observable standard deviations
        :type sigmay: gsl::span< amici::realtype >
        :param sigmay: buffer (dimension: ny)
        :type it: int
        :param it: timepoint index
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.ModelPtr_getObservableSigma(self, sigmay, it, edata)

    def getObservableSigmaSensitivity(self, ssigmay: "gsl::span< amici::realtype >", it: "int const", edata: "ExpData") -> "void":
        r"""
        Sensitivity of time-resolved observable standard deviation, total
        derivative (can be used with both adjoint and forward sensitivity)
        :type ssigmay: gsl::span< amici::realtype >
        :param ssigmay: buffer (dimension: ny x nplist, row-major)
        :type it: int
        :param it: timepoint index
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.ModelPtr_getObservableSigmaSensitivity(self, ssigmay, it, edata)

    def getUnobservedEventSensitivity(self, sz: "gsl::span< amici::realtype >", ie: "int const") -> "void":
        r"""
        Sensitivity of z at final timepoint (ignores sensitivity of
        timepoint), total derivative
        :type sz: gsl::span< amici::realtype >
        :param sz: output buffer (dimension: nz x nplist, row-major)
        :type ie: int
        :param ie: event index
        """
        return _amici.ModelPtr_getUnobservedEventSensitivity(self, sz, ie)

    def getEventSigma(self, sigmaz: "gsl::span< amici::realtype >", ie: "int const", nroots: "int const", t: "amici::realtype const", edata: "ExpData") -> "void":
        r"""
        Event-resolved observable standard deviations
        :type sigmaz: gsl::span< amici::realtype >
        :param sigmaz: buffer (dimension: nz)
        :type ie: int
        :param ie: event index
        :type nroots: int
        :param nroots: event occurence
        :type t: float
        :param t: timepoint
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.ModelPtr_getEventSigma(self, sigmaz, ie, nroots, t, edata)

    def getEventSigmaSensitivity(self, ssigmaz: "gsl::span< amici::realtype >", ie: "int const", nroots: "int const", t: "amici::realtype const", edata: "ExpData") -> "void":
        r"""
        Sensitivities of event-resolved observable standard deviations,
        total derivative (only forward sensitivities)
        :type ssigmaz: gsl::span< amici::realtype >
        :param ssigmaz: buffer (dimension: nz x nplist, row-major)
        :type ie: int
        :param ie: event index
        :type nroots: int
        :param nroots: event occurence
        :type t: float
        :param t: timepoint
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.ModelPtr_getEventSigmaSensitivity(self, ssigmaz, ie, nroots, t, edata)

    def updateHeaviside(self, rootsfound: "IntVector") -> "void":
        r"""
        Update the heaviside variables h on event occurences

        :type rootsfound: std::vector< int,std::allocator< int > >
        :param rootsfound: provides the direction of the zero-crossing, so adding
            it will give the right update to the heaviside variables (zero if no root
            was found)
        """
        return _amici.ModelPtr_updateHeaviside(self, rootsfound)

    def updateHeavisideB(self, rootsfound: "int const *") -> "void":
        r"""
        Updates the heaviside variables h on event occurences in the
        backward problem
        :type rootsfound: int
        :param rootsfound: provides the direction of the zero-crossing, so adding
            it will give the right update to the heaviside variables (zero if no root
            was found)
        """
        return _amici.ModelPtr_updateHeavisideB(self, rootsfound)

    def checkFinite(self, array: "gsl::span< amici::realtype const >", fun: "char const *") -> "int":
        r"""
        Check if the given array has only finite elements. If not try to
        give hints by which other fields this could be caused.

        :type array: gsl::span< amici::realtype const >
        :param array: arrays of values
        :type fun: string
        :param fun: name of the fucntion that generated the values
        :rtype: int
        :return: AMICI_RECOVERABLE_ERROR if a NaN/Inf value was found,
            AMICI_SUCCESS otherwise
        """
        return _amici.ModelPtr_checkFinite(self, array, fun)

    def setAlwaysCheckFinite(self, alwaysCheck: "bool") -> "void":
        r"""
        Set if the result of every call to Model::f* should be checked for
        finiteness
        :type alwaysCheck: boolean
        :param alwaysCheck:
        """
        return _amici.ModelPtr_setAlwaysCheckFinite(self, alwaysCheck)

    def getAlwaysCheckFinite(self) -> "bool":
        r"""
        Get setting of whether the result of every call to Model::f*
        should be checked for finiteness
        :rtype: boolean
        :return: that
        """
        return _amici.ModelPtr_getAlwaysCheckFinite(self)

    def fx0(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fx0
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector

        |

        *Overload 2:*

        Initial states
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.ModelPtr_fx0(self, *args)

    def fx0_fixedParameters(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fx0_fixedParameters
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector

        |

        *Overload 2:*

        Sets only those initial states that are specified via
        fixedParmeters
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.ModelPtr_fx0_fixedParameters(self, *args)

    def fsx0(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fsx0
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index

        |

        *Overload 2:*

        Initial value for initial state sensitivities
        :type sx: AmiVectorArray
        :param sx: pointer to state sensitivity variables
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.ModelPtr_fsx0(self, *args)

    def fsx0_fixedParameters(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fsx0_fixedParameters
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index

        |

        *Overload 2:*

        Sets only those initial states sensitivities that are affected
        from fx0 fixedParmeters
        :type sx: AmiVectorArray
        :param sx: pointer to state sensitivity variables
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.ModelPtr_fsx0_fixedParameters(self, *args)

    def fsdx0(self) -> "void":
        r"""
        Sensitivity of derivative initial states sensitivities sdx0 (only
         necessary for DAEs)
        """
        return _amici.ModelPtr_fsdx0(self)
    nx_rdata = property(_amici.ModelPtr_nx_rdata_get, _amici.ModelPtr_nx_rdata_set, doc=r""" number of states""")
    nxtrue_rdata = property(_amici.ModelPtr_nxtrue_rdata_get, _amici.ModelPtr_nxtrue_rdata_set, doc=r""" number of states in the unaugmented system""")
    nx_solver = property(_amici.ModelPtr_nx_solver_get, _amici.ModelPtr_nx_solver_set, doc=r""" number of states with conservation laws applied""")
    nxtrue_solver = property(_amici.ModelPtr_nxtrue_solver_get, _amici.ModelPtr_nxtrue_solver_set, doc=r"""
    number of states in the unaugmented system with conservation laws
    applied
    """)
    nx_solver_reinit = property(_amici.ModelPtr_nx_solver_reinit_get, _amici.ModelPtr_nx_solver_reinit_set, doc=r""" number of solver states subject to reinitialization""")
    ny = property(_amici.ModelPtr_ny_get, _amici.ModelPtr_ny_set, doc=r""" number of observables""")
    nytrue = property(_amici.ModelPtr_nytrue_get, _amici.ModelPtr_nytrue_set, doc=r""" number of observables in the unaugmented system""")
    nz = property(_amici.ModelPtr_nz_get, _amici.ModelPtr_nz_set, doc=r""" number of event outputs""")
    nztrue = property(_amici.ModelPtr_nztrue_get, _amici.ModelPtr_nztrue_set, doc=r""" number of event outputs in the unaugmented system""")
    ne = property(_amici.ModelPtr_ne_get, _amici.ModelPtr_ne_set, doc=r""" number of events""")
    nw = property(_amici.ModelPtr_nw_get, _amici.ModelPtr_nw_set, doc=r""" number of common expressions""")
    ndwdx = property(_amici.ModelPtr_ndwdx_get, _amici.ModelPtr_ndwdx_set, doc=r""" number of derivatives of common expressions wrt x""")
    ndwdp = property(_amici.ModelPtr_ndwdp_get, _amici.ModelPtr_ndwdp_set, doc=r""" number of derivatives of common expressions wrt p""")
    ndxdotdw = property(_amici.ModelPtr_ndxdotdw_get, _amici.ModelPtr_ndxdotdw_set, doc=r""" number of nonzero entries in dxdotdw""")
    ndJydy = property(_amici.ModelPtr_ndJydy_get, _amici.ModelPtr_ndJydy_set, doc=r""" number of nonzero entries in dJydy""")
    nnz = property(_amici.ModelPtr_nnz_get, _amici.ModelPtr_nnz_set, doc=r""" number of nonzero entries in jacobian""")
    nJ = property(_amici.ModelPtr_nJ_get, _amici.ModelPtr_nJ_set, doc=r""" dimension of the augmented objective function for 2nd order ASA""")
    ubw = property(_amici.ModelPtr_ubw_get, _amici.ModelPtr_ubw_set, doc=r""" upper bandwith of the jacobian""")
    lbw = property(_amici.ModelPtr_lbw_get, _amici.ModelPtr_lbw_set, doc=r""" lower bandwith of the jacobian""")
    pythonGenerated = property(_amici.ModelPtr_pythonGenerated_get, _amici.ModelPtr_pythonGenerated_set, doc=r""" flag indicating Matlab or python based model generation""")
    ndxdotdp_explicit = property(_amici.ModelPtr_ndxdotdp_explicit_get, _amici.ModelPtr_ndxdotdp_explicit_set, doc=r""" number of nonzero entries in ndxdotdp_explicit""")
    ndxdotdp_implicit = property(_amici.ModelPtr_ndxdotdp_implicit_get, _amici.ModelPtr_ndxdotdp_implicit_set, doc=r""" number of nonzero entries in ndxdotdp_implicit""")
    o2mode = property(_amici.ModelPtr_o2mode_get, _amici.ModelPtr_o2mode_set, doc=r"""
    flag indicating whether for sensi == AMICI_SENSI_ORDER_SECOND
    directional or full second order derivative will be computed
    """)
    idlist = property(_amici.ModelPtr_idlist_get, _amici.ModelPtr_idlist_set, doc=r""" flag array for DAE equations""")
    app = property(_amici.ModelPtr_app_get, _amici.ModelPtr_app_set, doc=r""" AMICI context""")

    def getSolver(self) -> "std::unique_ptr< amici::Solver >":
        r"""
        Retrieves the solver object
        :rtype: std::unique_ptr< amici::Solver >
        :return: The Solver instance
        """
        return _amici.ModelPtr_getSolver(self)

    def getAmiciVersion(self) -> "std::string const":
        r"""
        Returns the amici version that was used to generate the model
        :rtype: string
        :return: ver amici version string
        """
        return _amici.ModelPtr_getAmiciVersion(self)

    def getAmiciCommit(self) -> "std::string const":
        r"""
        Returns the amici commit that was used to generate the model
        :rtype: string
        :return: ver amici commit string
        """
        return _amici.ModelPtr_getAmiciCommit(self)

    def isFixedParameterStateReinitializationAllowed(self) -> "bool":
        r"""
        Function indicating whether reinitialization of states depending
        on fixed parameters is permissible
        :rtype: boolean
        :return: flag inidication whether reinitialization of states depending on
            fixed parameters is permissible
        """
        return _amici.ModelPtr_isFixedParameterStateReinitializationAllowed(self)

    def fstau(self, stau: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int", ie: "int") -> "void":
        r"""
        Model specific implementation of fstau
        :type stau: float
        :param stau: total derivative of event timepoint
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        """
        return _amici.ModelPtr_fstau(self, stau, t, x, p, k, h, sx, ip, ie)

    def fsz(self, sz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsz
        :type sz: float
        :param sz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.ModelPtr_fsz(self, sz, ie, t, x, p, k, h, sx, ip)

    def fsrz(self, srz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsrz
        :type srz: float
        :param srz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type sx: float
        :param sx: current state sensitivity
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.ModelPtr_fsrz(self, srz, ie, t, x, p, k, h, sx, ip)

    def fdeltax(self, deltax: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltax
        :type deltax: float
        :param deltax: state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        """
        return _amici.ModelPtr_fdeltax(self, deltax, t, x, p, k, h, ie, xdot, xdot_old)

    def fdeltasx(self, deltasx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", sx: "amici::realtype const *", stau: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltasx
        :type deltasx: float
        :param deltasx: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type sx: float
        :param sx: state sensitivity
        :type stau: float
        :param stau: event-time sensitivity
        """
        return _amici.ModelPtr_fdeltasx(self, deltasx, t, x, p, k, h, w, ip, ie, xdot, xdot_old, sx, stau)

    def fdeltaxB(self, deltaxB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaxB
        :type deltaxB: float
        :param deltaxB: adjoint state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: current adjoint state
        """
        return _amici.ModelPtr_fdeltaxB(self, deltaxB, t, x, p, k, h, ie, xdot, xdot_old, xB)

    def fdeltaqB(self, deltaqB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaqB
        :type deltaqB: float
        :param deltaqB: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: adjoint state
        """
        return _amici.ModelPtr_fdeltaqB(self, deltaqB, t, x, p, k, h, ip, ie, xdot, xdot_old, xB)

    def fdwdp_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.ModelPtr_fdwdp_colptrs(self, indexptrs)

    def fdwdp_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.ModelPtr_fdwdp_rowvals(self, indexvals)

    def fdwdx_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.ModelPtr_fdwdx_colptrs(self, indexptrs)

    def fdwdx_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.ModelPtr_fdwdx_rowvals(self, indexvals)

# Register ModelPtr in _amici:
_amici.ModelPtr_swigregister(ModelPtr)

class ExpDataPtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _amici.ExpDataPtr_swiginit(self, _amici.new_ExpDataPtr(*args))

    def __deref__(self) -> "std::unique_ptr< amici::ExpData >::pointer":
        return _amici.ExpDataPtr___deref__(self)

    def release(self) -> "std::unique_ptr< amici::ExpData >::pointer":
        return _amici.ExpDataPtr_release(self)

    def reset(self, *args) -> "void":
        return _amici.ExpDataPtr_reset(self, *args)

    def swap(self, __u: "ExpDataPtr") -> "void":
        return _amici.ExpDataPtr_swap(self, __u)

    def get(self) -> "std::unique_ptr< amici::ExpData >::pointer":
        return _amici.ExpDataPtr_get(self)

    def __nonzero__(self):
        return _amici.ExpDataPtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _amici.delete_ExpDataPtr

    def nytrue(self) -> "int":
        r"""
        number of observables of the non-augmented model

        :rtype: int
        :return: number of observables of the non-augmented model
        """
        return _amici.ExpDataPtr_nytrue(self)

    def nztrue(self) -> "int":
        r"""
        number of event observables of the non-augmented model

        :rtype: int
        :return: number of event observables of the non-augmented model
        """
        return _amici.ExpDataPtr_nztrue(self)

    def nmaxevent(self) -> "int":
        r"""
        maximal number of events to track

        :rtype: int
        :return: maximal number of events to track
        """
        return _amici.ExpDataPtr_nmaxevent(self)

    def nt(self) -> "int":
        r"""
        number of timepoints

        :rtype: int
        :return: number of timepoints
        """
        return _amici.ExpDataPtr_nt(self)

    def setTimepoints(self, ts: "DoubleVector") -> "void":
        r"""
        set function that copies data from input to ExpData::ts

        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts: timepoints
        """
        return _amici.ExpDataPtr_setTimepoints(self, ts)

    def getTimepoints(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::ts to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: ExpData::ts
        """
        return _amici.ExpDataPtr_getTimepoints(self)

    def getTimepoint(self, it: "int") -> "amici::realtype":
        r"""
        get function that returns timepoint at index

        :type it: int
        :param it: timepoint index

        :rtype: float
        :return: timepoint timepoint at index
        """
        return _amici.ExpDataPtr_getTimepoint(self, it)

    def setObservedData(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to ExpData::my

        :type observedData: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedData: observed data (dimension: nt x nytrue, row-major)

        |

        *Overload 2:*

        set function that copies observed data for specific observable

        :type observedData: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedData: observed data (dimension: nt)
        :type iy: int
        :param iy: oberved data index
        """
        return _amici.ExpDataPtr_setObservedData(self, *args)

    def isSetObservedData(self, it: "int", iy: "int") -> "bool":
        r"""
        get function that checks whether data at specified indices has
        been set

        :type it: int
        :param it: time index
        :type iy: int
        :param iy: observable index

        :rtype: boolean
        :return: boolean specifying if data was set
        """
        return _amici.ExpDataPtr_isSetObservedData(self, it, iy)

    def getObservedData(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedData to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: observed data (dimension: nt x nytrue, row-major)
        """
        return _amici.ExpDataPtr_getObservedData(self)

    def getObservedDataPtr(self, it: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to observed data at index

        :type it: int
        :param it: timepoint index

        :rtype: float
        :return: pointer to observed data at index (dimension: nytrue)
        """
        return _amici.ExpDataPtr_getObservedDataPtr(self, it)

    def setObservedDataStdDev(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to
        ExpData::observedDataStdDev

        :type observedDataStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedDataStdDev: standard deviation of observed data (dimension:
            nt x nytrue, row-major)

        |

        *Overload 2:*

        set function that sets all ExpData::observedDataStdDev to the
        input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)

        |

        *Overload 3:*

        set function that copies standard deviation of observed data for
        specific observable

        :type observedDataStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedDataStdDev: standard deviation of observed data (dimension:
            nt)
        :type iy: int
        :param iy: observed data index

        |

        *Overload 4:*

        set function that sets all standard deviation of a specific
        observable to the input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)
        :type iy: int
        :param iy: observed data index
        """
        return _amici.ExpDataPtr_setObservedDataStdDev(self, *args)

    def isSetObservedDataStdDev(self, it: "int", iy: "int") -> "bool":
        r"""
        get function that checks whether standard deviation of data at
        specified indices has been set

        :type it: int
        :param it: time index
        :type iy: int
        :param iy: observable index
        :rtype: boolean
        :return: boolean specifying if standard deviation of data was set
        """
        return _amici.ExpDataPtr_isSetObservedDataStdDev(self, it, iy)

    def getObservedDataStdDev(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedDataStdDev to
        output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: standard deviation of observed data
        """
        return _amici.ExpDataPtr_getObservedDataStdDev(self)

    def getObservedDataStdDevPtr(self, it: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to standard deviation of
        observed data at index

        :type it: int
        :param it: timepoint index
        :rtype: float
        :return: pointer to standard deviation of observed data at index
        """
        return _amici.ExpDataPtr_getObservedDataStdDevPtr(self, it)

    def setObservedEvents(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies observed event data from input to
        ExpData::observedEvents

        :type observedEvents: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEvents: observed data (dimension: nmaxevent x nztrue,
            row-major)

        |

        *Overload 2:*

        set function that copies observed event data for specific event
        observable

        :type observedEvents: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEvents: observed data (dimension: nmaxevent)
        :type iz: int
        :param iz: observed event data index
        """
        return _amici.ExpDataPtr_setObservedEvents(self, *args)

    def isSetObservedEvents(self, ie: "int", iz: "int") -> "bool":
        r"""
        get function that checks whether event data at specified indices
        has been set

        :type ie: int
        :param ie: event index
        :type iz: int
        :param iz: event observable index
        :rtype: boolean
        :return: boolean specifying if data was set
        """
        return _amici.ExpDataPtr_isSetObservedEvents(self, ie, iz)

    def getObservedEvents(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::mz to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: observed event data
        """
        return _amici.ExpDataPtr_getObservedEvents(self)

    def getObservedEventsPtr(self, ie: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to observed data at ieth
        occurence

        :type ie: int
        :param ie: event occurence

        :rtype: float
        :return: pointer to observed event data at ieth occurence
        """
        return _amici.ExpDataPtr_getObservedEventsPtr(self, ie)

    def setObservedEventsStdDev(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to
        ExpData::observedEventsStdDev

        :type observedEventsStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEventsStdDev: standard deviation of observed event data

        |

        *Overload 2:*

        set function that sets all ExpData::observedDataStdDev to the
        input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)

        |

        *Overload 3:*

        set function that copies standard deviation of observed data for
        specific observable

        :type observedEventsStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEventsStdDev: standard deviation of observed data
            (dimension: nmaxevent)
        :type iz: int
        :param iz: observed data index

        |

        *Overload 4:*

        set function that sets all standard deviation of a specific
        observable to the input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)
        :type iz: int
        :param iz: observed data index
        """
        return _amici.ExpDataPtr_setObservedEventsStdDev(self, *args)

    def isSetObservedEventsStdDev(self, ie: "int", iz: "int") -> "bool":
        r"""
        get function that checks whether standard deviation of even data
        at specified indices has been set

        :type ie: int
        :param ie: event index
        :type iz: int
        :param iz: event observable index
        :rtype: boolean
        :return: boolean specifying if standard deviation of event data was set
        """
        return _amici.ExpDataPtr_isSetObservedEventsStdDev(self, ie, iz)

    def getObservedEventsStdDev(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedEventsStdDev
        to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: standard deviation of observed event data
        """
        return _amici.ExpDataPtr_getObservedEventsStdDev(self)

    def getObservedEventsStdDevPtr(self, ie: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to standard deviation of
        observed event data at ieth occurence

        :type ie: int
        :param ie: event occurence

        :rtype: float
        :return: pointer to standard deviation of observed event data at ieth
            occurence
        """
        return _amici.ExpDataPtr_getObservedEventsStdDevPtr(self, ie)
    fixedParameters = property(_amici.ExpDataPtr_fixedParameters_get, _amici.ExpDataPtr_fixedParameters_set, doc=r"""condition-specific fixed parameters of size Model::nk() or empty""")
    fixedParametersPreequilibration = property(_amici.ExpDataPtr_fixedParametersPreequilibration_get, _amici.ExpDataPtr_fixedParametersPreequilibration_set, doc=r"""
    condition-specific fixed parameters for pre-equilibration of size
    Model::nk() or empty. Overrides Solver::newton_preeq
    """)
    fixedParametersPresimulation = property(_amici.ExpDataPtr_fixedParametersPresimulation_get, _amici.ExpDataPtr_fixedParametersPresimulation_set, doc=r"""
    condition-specific fixed parameters for pre-simulation of
    size Model::nk() or empty.
    """)
    parameters = property(_amici.ExpDataPtr_parameters_get, _amici.ExpDataPtr_parameters_set, doc=r"""condition-specific parameters of size Model::np() or empty""")
    x0 = property(_amici.ExpDataPtr_x0_get, _amici.ExpDataPtr_x0_set, doc=r"""
    condition-specific initial conditions of size Model::nx() or
    empty
    """)
    sx0 = property(_amici.ExpDataPtr_sx0_get, _amici.ExpDataPtr_sx0_set, doc=r"""
    condition-specific initial condition sensitivities of size
    Model::nx() * Model::nplist(), Model::nx() * ExpDataplist.size(), if
    ExpData::plist is not empty, or empty
    """)
    pscale = property(_amici.ExpDataPtr_pscale_get, _amici.ExpDataPtr_pscale_set, doc=r"""condition-specific parameter scales of size Model::np()""")
    plist = property(_amici.ExpDataPtr_plist_get, _amici.ExpDataPtr_plist_set, doc=r"""condition-specific parameter list""")
    t_presim = property(_amici.ExpDataPtr_t_presim_get, _amici.ExpDataPtr_t_presim_set, doc=r"""
    duration of pre-simulation
    if this is > 0, presimualation will be performed from
    (model->t0 - t_presim) to model->t0 using the fixedParameters in
    fixedParametersPresimulation
    """)
    reinitializeFixedParameterInitialStates = property(_amici.ExpDataPtr_reinitializeFixedParameterInitialStates_get, _amici.ExpDataPtr_reinitializeFixedParameterInitialStates_set, doc=r"""
    flag indicating whether reinitialization of states depending on
    fixed parameters is activated
    """)

# Register ExpDataPtr in _amici:
_amici.ExpDataPtr_swigregister(ExpDataPtr)

BLASLayout_rowMajor = _amici.BLASLayout_rowMajor
BLASLayout_colMajor = _amici.BLASLayout_colMajor
BLASTranspose_noTrans = _amici.BLASTranspose_noTrans
BLASTranspose_trans = _amici.BLASTranspose_trans
BLASTranspose_conjTrans = _amici.BLASTranspose_conjTrans
ParameterScaling_none = _amici.ParameterScaling_none
ParameterScaling_ln = _amici.ParameterScaling_ln
ParameterScaling_log10 = _amici.ParameterScaling_log10
SecondOrderMode_none = _amici.SecondOrderMode_none
SecondOrderMode_full = _amici.SecondOrderMode_full
SecondOrderMode_directional = _amici.SecondOrderMode_directional
SensitivityOrder_none = _amici.SensitivityOrder_none
SensitivityOrder_first = _amici.SensitivityOrder_first
SensitivityOrder_second = _amici.SensitivityOrder_second
SensitivityMethod_none = _amici.SensitivityMethod_none
SensitivityMethod_forward = _amici.SensitivityMethod_forward
SensitivityMethod_adjoint = _amici.SensitivityMethod_adjoint
LinearSolver_dense = _amici.LinearSolver_dense
LinearSolver_band = _amici.LinearSolver_band
LinearSolver_LAPACKDense = _amici.LinearSolver_LAPACKDense
LinearSolver_LAPACKBand = _amici.LinearSolver_LAPACKBand
LinearSolver_diag = _amici.LinearSolver_diag
LinearSolver_SPGMR = _amici.LinearSolver_SPGMR
LinearSolver_SPBCG = _amici.LinearSolver_SPBCG
LinearSolver_SPTFQMR = _amici.LinearSolver_SPTFQMR
LinearSolver_KLU = _amici.LinearSolver_KLU
LinearSolver_SuperLUMT = _amici.LinearSolver_SuperLUMT
InternalSensitivityMethod_simultaneous = _amici.InternalSensitivityMethod_simultaneous
InternalSensitivityMethod_staggered = _amici.InternalSensitivityMethod_staggered
InternalSensitivityMethod_staggered1 = _amici.InternalSensitivityMethod_staggered1
InterpolationType_hermite = _amici.InterpolationType_hermite
InterpolationType_polynomial = _amici.InterpolationType_polynomial
LinearMultistepMethod_adams = _amici.LinearMultistepMethod_adams
LinearMultistepMethod_BDF = _amici.LinearMultistepMethod_BDF
NonlinearSolverIteration_functional = _amici.NonlinearSolverIteration_functional
NonlinearSolverIteration_fixedpoint = _amici.NonlinearSolverIteration_fixedpoint
r""" deprecated"""
NonlinearSolverIteration_newton = _amici.NonlinearSolverIteration_newton
SteadyStateSensitivityMode_newtonOnly = _amici.SteadyStateSensitivityMode_newtonOnly
SteadyStateSensitivityMode_simulationFSA = _amici.SteadyStateSensitivityMode_simulationFSA
SteadyStateStatus_failed_too_long_simulation = _amici.SteadyStateStatus_failed_too_long_simulation
SteadyStateStatus_failed_damping = _amici.SteadyStateStatus_failed_damping
SteadyStateStatus_failed_factorization = _amici.SteadyStateStatus_failed_factorization
SteadyStateStatus_failed_convergence = _amici.SteadyStateStatus_failed_convergence
SteadyStateStatus_failed = _amici.SteadyStateStatus_failed
SteadyStateStatus_not_run = _amici.SteadyStateStatus_not_run
SteadyStateStatus_success = _amici.SteadyStateStatus_success
SteadyStateContext_newtonSensi = _amici.SteadyStateContext_newtonSensi
SteadyStateContext_sensiStorage = _amici.SteadyStateContext_sensiStorage
SteadyStateContext_solverCreation = _amici.SteadyStateContext_solverCreation
NewtonDampingFactorMode_off = _amici.NewtonDampingFactorMode_off
NewtonDampingFactorMode_on = _amici.NewtonDampingFactorMode_on
FixedParameterContext_simulation = _amici.FixedParameterContext_simulation
FixedParameterContext_preequilibration = _amici.FixedParameterContext_preequilibration
FixedParameterContext_presimulation = _amici.FixedParameterContext_presimulation
RDataReporting_full = _amici.RDataReporting_full
RDataReporting_residuals = _amici.RDataReporting_residuals
RDataReporting_likelihood = _amici.RDataReporting_likelihood
class AbstractModel(object):
    r"""
    Abstract base class of amici::Model defining functions that need to
    be implemented in an AMICI model.

    Some functions have empty default implementations or throw.
    This class shall not have any data members.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_AbstractModel

    def getSolver(self) -> "std::unique_ptr< amici::Solver >":
        r"""
        Retrieves the solver object
        :rtype: std::unique_ptr< amici::Solver >
        :return: The Solver instance
        """
        return _amici.AbstractModel_getSolver(self)

    def getAmiciVersion(self) -> "std::string const":
        r"""
        Returns the amici version that was used to generate the model
        :rtype: string
        :return: ver amici version string
        """
        return _amici.AbstractModel_getAmiciVersion(self)

    def getAmiciCommit(self) -> "std::string const":
        r"""
        Returns the amici commit that was used to generate the model
        :rtype: string
        :return: ver amici commit string
        """
        return _amici.AbstractModel_getAmiciCommit(self)

    def fx0(self, x0: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fx0
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.AbstractModel_fx0(self, x0, t, p, k)

    def isFixedParameterStateReinitializationAllowed(self) -> "bool":
        r"""
        Function indicating whether reinitialization of states depending
        on fixed parameters is permissible
        :rtype: boolean
        :return: flag inidication whether reinitialization of states depending on
            fixed parameters is permissible
        """
        return _amici.AbstractModel_isFixedParameterStateReinitializationAllowed(self)

    def fx0_fixedParameters(self, x0: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fx0_fixedParameters
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.AbstractModel_fx0_fixedParameters(self, x0, t, p, k)

    def fsx0_fixedParameters(self, sx0: "amici::realtype *", t: "amici::realtype const", x0: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsx0_fixedParameters
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fsx0_fixedParameters(self, sx0, t, x0, p, k, ip)

    def fsx0(self, sx0: "amici::realtype *", t: "amici::realtype const", x0: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsx0
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fsx0(self, sx0, t, x0, p, k, ip)

    def fstau(self, stau: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int", ie: "int") -> "void":
        r"""
        Model specific implementation of fstau
        :type stau: float
        :param stau: total derivative of event timepoint
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        """
        return _amici.AbstractModel_fstau(self, stau, t, x, p, k, h, sx, ip, ie)

    def fy(self, y: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fy
        :type y: float
        :param y: model output at current timepoint
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        """
        return _amici.AbstractModel_fy(self, y, t, x, p, k, h, w)

    def fdydp(self, dydp: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int", w: "amici::realtype const *", dwdp: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdydp
        :type dydp: float
        :param dydp: partial derivative of observables y w.r.t. model parameters p
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        :type w: float
        :param w: repeating elements vector
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        """
        return _amici.AbstractModel_fdydp(self, dydp, t, x, p, k, h, ip, w, dwdp)

    def fdydx(self, dydx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", dwdx: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdydx
        :type dydx: float
        :param dydx: partial derivative of observables y w.r.t. model states x
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        :type dwdx: float
        :param dwdx: Recurring terms in xdot, state derivative
        """
        return _amici.AbstractModel_fdydx(self, dydx, t, x, p, k, h, w, dwdx)

    def fz(self, z: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fz
        :type z: float
        :param z: value of event output
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.AbstractModel_fz(self, z, ie, t, x, p, k, h)

    def fsz(self, sz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsz
        :type sz: float
        :param sz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fsz(self, sz, ie, t, x, p, k, h, sx, ip)

    def frz(self, rz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of frz
        :type rz: float
        :param rz: value of root function at current timepoint (non-output events
            not included)
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.AbstractModel_frz(self, rz, ie, t, x, p, k, h)

    def fsrz(self, srz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsrz
        :type srz: float
        :param srz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type sx: float
        :param sx: current state sensitivity
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fsrz(self, srz, ie, t, x, p, k, h, sx, ip)

    def fdzdp(self, dzdp: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fdzdp
        :type dzdp: float
        :param dzdp: partial derivative of event-resolved output z w.r.t. model
            parameters p
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        """
        return _amici.AbstractModel_fdzdp(self, dzdp, ie, t, x, p, k, h, ip)

    def fdzdx(self, dzdx: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdzdx
        :type dzdx: float
        :param dzdx: partial derivative of event-resolved output z w.r.t. model
            states x
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.AbstractModel_fdzdx(self, dzdx, ie, t, x, p, k, h)

    def fdrzdp(self, drzdp: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fdrzdp
        :type drzdp: float
        :param drzdp: partial derivative of root output rz w.r.t. model parameters
            p
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        """
        return _amici.AbstractModel_fdrzdp(self, drzdp, ie, t, x, p, k, h, ip)

    def fdrzdx(self, drzdx: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdrzdx
        :type drzdx: float
        :param drzdx: partial derivative of root output rz w.r.t. model states x
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.AbstractModel_fdrzdx(self, drzdx, ie, t, x, p, k, h)

    def fdeltax(self, deltax: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltax
        :type deltax: float
        :param deltax: state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        """
        return _amici.AbstractModel_fdeltax(self, deltax, t, x, p, k, h, ie, xdot, xdot_old)

    def fdeltasx(self, deltasx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", sx: "amici::realtype const *", stau: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltasx
        :type deltasx: float
        :param deltasx: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type sx: float
        :param sx: state sensitivity
        :type stau: float
        :param stau: event-time sensitivity
        """
        return _amici.AbstractModel_fdeltasx(self, deltasx, t, x, p, k, h, w, ip, ie, xdot, xdot_old, sx, stau)

    def fdeltaxB(self, deltaxB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaxB
        :type deltaxB: float
        :param deltaxB: adjoint state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: current adjoint state
        """
        return _amici.AbstractModel_fdeltaxB(self, deltaxB, t, x, p, k, h, ie, xdot, xdot_old, xB)

    def fdeltaqB(self, deltaqB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaqB
        :type deltaqB: float
        :param deltaqB: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: adjoint state
        """
        return _amici.AbstractModel_fdeltaqB(self, deltaqB, t, x, p, k, h, ip, ie, xdot, xdot_old, xB)

    def fsigmay(self, sigmay: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fsigmay
        :type sigmay: float
        :param sigmay: standard deviation of measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.AbstractModel_fsigmay(self, sigmay, t, p, k)

    def fdsigmaydp(self, dsigmaydp: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsigmay
        :type dsigmaydp: float
        :param dsigmaydp: partial derivative of standard deviation of measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fdsigmaydp(self, dsigmaydp, t, p, k, ip)

    def fsigmaz(self, sigmaz: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fsigmaz
        :type sigmaz: float
        :param sigmaz: standard deviation of event measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.AbstractModel_fsigmaz(self, sigmaz, t, p, k)

    def fdsigmazdp(self, dsigmazdp: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsigmaz
        :type dsigmazdp: float
        :param dsigmazdp: partial derivative of standard deviation of event
            measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.AbstractModel_fdsigmazdp(self, dsigmazdp, t, p, k, ip)

    def fJy(self, nllh: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJy
        :type nllh: float
        :param nllh: negative log-likelihood for measurements y
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurements at timepoint
        """
        return _amici.AbstractModel_fJy(self, nllh, iy, p, k, y, sigmay, my)

    def fJz(self, nllh: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJz
        :type nllh: float
        :param nllh: negative log-likelihood for event measurements z
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurements at timepoint
        """
        return _amici.AbstractModel_fJz(self, nllh, iz, p, k, z, sigmaz, mz)

    def fJrz(self, nllh: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJrz
        :type nllh: float
        :param nllh: regularization for event measurements z
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.AbstractModel_fJrz(self, nllh, iz, p, k, z, sigmaz)

    def fdJydy(self, dJydy: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJydy
        :type dJydy: float
        :param dJydy: partial derivative of time-resolved measurement negative
            log-likelihood Jy
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurement at timepoint
        """
        return _amici.AbstractModel_fdJydy(self, dJydy, iy, p, k, y, sigmay, my)

    def fdJydsigma(self, dJydsigma: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJydsigma
        :type dJydsigma: float
        :param dJydsigma: Sensitivity of time-resolved measurement negative
            log-likelihood Jy w.r.t. standard deviation sigmay
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurement at timepoint
        """
        return _amici.AbstractModel_fdJydsigma(self, dJydsigma, iy, p, k, y, sigmay, my)

    def fdJzdz(self, dJzdz: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJzdz
        :type dJzdz: float
        :param dJzdz: partial derivative of event measurement negative
            log-likelihood Jz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurement at timepoint
        """
        return _amici.AbstractModel_fdJzdz(self, dJzdz, iz, p, k, z, sigmaz, mz)

    def fdJzdsigma(self, dJzdsigma: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJzdsigma
        :type dJzdsigma: float
        :param dJzdsigma: Sensitivity of event measurement negative log-likelihood
            Jz w.r.t. standard deviation sigmaz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurement at timepoint
        """
        return _amici.AbstractModel_fdJzdsigma(self, dJzdsigma, iz, p, k, z, sigmaz, mz)

    def fdJrzdz(self, dJrzdz: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", rz: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJrzdz
        :type dJrzdz: float
        :param dJrzdz: partial derivative of event penalization Jrz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type rz: float
        :param rz: model root output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.AbstractModel_fdJrzdz(self, dJrzdz, iz, p, k, rz, sigmaz)

    def fdJrzdsigma(self, dJrzdsigma: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", rz: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJrzdsigma
        :type dJrzdsigma: float
        :param dJrzdsigma: Sensitivity of event penalization Jrz w.r.t. standard
            deviation sigmaz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type rz: float
        :param rz: model root output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.AbstractModel_fdJrzdsigma(self, dJrzdsigma, iz, p, k, rz, sigmaz)

    def fw(self, w: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", tcl: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fw
        :type w: float
        :param w: Recurring terms in xdot
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type tcl: float
        :param tcl: total abundances for conservations laws
        """
        return _amici.AbstractModel_fw(self, w, t, x, p, k, h, tcl)

    def fdwdp_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.AbstractModel_fdwdp_colptrs(self, indexptrs)

    def fdwdp_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.AbstractModel_fdwdp_rowvals(self, indexvals)

    def fdwdp(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific sparse implementation of dwdp
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        :type stcl: float
        :param stcl: sensitivities of total abundances for conservations laws

        |

        *Overload 2:*

        Model specific sensitivity implementation of dwdp
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        :type stcl: float
        :param stcl: sensitivities of total abundances for conservations laws
        :type ip: int
        :param ip: sensitivity parameter index
        """
        return _amici.AbstractModel_fdwdp(self, *args)

    def fdwdx(self, dwdx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", tcl: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of dwdx, data part
        :type dwdx: float
        :param dwdx: Recurring terms in xdot, state derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        """
        return _amici.AbstractModel_fdwdx(self, dwdx, t, x, p, k, h, w, tcl)

    def fdwdx_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.AbstractModel_fdwdx_colptrs(self, indexptrs)

    def fdwdx_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.AbstractModel_fdwdx_rowvals(self, indexvals)

# Register AbstractModel in _amici:
_amici.AbstractModel_swigregister(AbstractModel)
cvar = _amici.cvar
pi = cvar.pi
AMICI_ONEOUTPUT = cvar.AMICI_ONEOUTPUT
AMICI_RECOVERABLE_ERROR = cvar.AMICI_RECOVERABLE_ERROR
AMICI_UNRECOVERABLE_ERROR = cvar.AMICI_UNRECOVERABLE_ERROR
AMICI_TOO_MUCH_WORK = cvar.AMICI_TOO_MUCH_WORK
AMICI_TOO_MUCH_ACC = cvar.AMICI_TOO_MUCH_ACC
AMICI_ERR_FAILURE = cvar.AMICI_ERR_FAILURE
AMICI_CONV_FAILURE = cvar.AMICI_CONV_FAILURE
AMICI_ILL_INPUT = cvar.AMICI_ILL_INPUT
AMICI_ERROR = cvar.AMICI_ERROR
AMICI_NO_STEADY_STATE = cvar.AMICI_NO_STEADY_STATE
AMICI_DAMPING_FACTOR_ERROR = cvar.AMICI_DAMPING_FACTOR_ERROR
AMICI_SINGULAR_JACOBIAN = cvar.AMICI_SINGULAR_JACOBIAN
AMICI_NOT_IMPLEMENTED = cvar.AMICI_NOT_IMPLEMENTED
AMICI_SUCCESS = cvar.AMICI_SUCCESS
AMICI_DATA_RETURN = cvar.AMICI_DATA_RETURN
AMICI_ROOT_RETURN = cvar.AMICI_ROOT_RETURN
AMICI_NORMAL = cvar.AMICI_NORMAL
AMICI_ONE_STEP = cvar.AMICI_ONE_STEP
AMICI_PREEQUILIBRATE = cvar.AMICI_PREEQUILIBRATE


def unscaleParameters(bufferScaled: "gsl::span< amici::realtype const >", pscale: "gsl::span< amici::ParameterScaling const >", bufferUnscaled: "gsl::span< amici::realtype >") -> "void":
    r"""
    Remove parameter scaling according to the parameter scaling in pscale

    All vectors must be of same length.

    :type bufferScaled: gsl::span< amici::realtype const >
    :param bufferScaled: scaled parameters
    :type pscale: gsl::span< amici::ParameterScaling const >
    :param pscale: parameter scaling
    :type bufferUnscaled: gsl::span< amici::realtype >
    :param bufferUnscaled: unscaled parameters are written to the array
    """
    return _amici.unscaleParameters(bufferScaled, pscale, bufferUnscaled)

def getUnscaledParameter(scaledParameter: "double", scaling: "amici::ParameterScaling") -> "double":
    r"""
    Remove parameter scaling according to `scaling`

    :type scaledParameter: float
    :param scaledParameter: scaled parameter
    :type scaling: int
    :param scaling: parameter scaling

    :rtype: float
    :return: Unscaled parameter
    """
    return _amici.getUnscaledParameter(scaledParameter, scaling)

def getScaledParameter(unscaledParameter: "double", scaling: "amici::ParameterScaling") -> "double":
    r"""
    Apply parameter scaling according to `scaling`
    :type unscaledParameter: float
    :param unscaledParameter:
    :type scaling: int
    :param scaling: parameter scaling
    :rtype: float
    :return: Scaled parameter
    """
    return _amici.getScaledParameter(unscaledParameter, scaling)

def scaleParameters(bufferUnscaled: "gsl::span< amici::realtype const >", pscale: "gsl::span< amici::ParameterScaling const >", bufferScaled: "gsl::span< amici::realtype >") -> "void":
    r"""
    Apply parameter scaling according to `scaling`
    :type bufferUnscaled: gsl::span< amici::realtype const >
    :param bufferUnscaled:
    :type pscale: gsl::span< amici::ParameterScaling const >
    :param pscale: parameter scaling
    :type bufferScaled: gsl::span< amici::realtype >
    :param bufferScaled: destination
    """
    return _amici.scaleParameters(bufferUnscaled, pscale, bufferScaled)

def backtraceString(maxFrames: "int") -> "std::string":
    r"""
    Returns the current backtrace as std::string
    :type maxFrames: int
    :param maxFrames: Number of frames to include
    :rtype: string
    :return: Backtrace
    """
    return _amici.backtraceString(maxFrames)
class ContextManager(object):
    r"""
    Generic implementation for a context manager, explicitely deletes copy and move operators for
    derived classes
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _amici.ContextManager_swiginit(self, _amici.new_ContextManager())
    __swig_destroy__ = _amici.delete_ContextManager

# Register ContextManager in _amici:
_amici.ContextManager_swigregister(ContextManager)

class ExpData(object):
    r"""
    ExpData carries all information about experimental or
    condition-specific data
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        default constructor

        |

        *Overload 2:*

        Copy constructor, needs to be declared to be generated in
        swig

        |

        *Overload 3:*

        constructor that only initializes dimensions

        :type nytrue: int
        :param nytrue:
        :type nztrue: int
        :param nztrue:
        :type nmaxevent: int
        :param nmaxevent:

        |

        *Overload 4:*

        constructor that initializes timepoints from vectors

        :type nytrue: int
        :param nytrue:               (dimension: scalar)
        :type nztrue: int
        :param nztrue:               (dimension: scalar)
        :type nmaxevent: int
        :param nmaxevent:            (dimension: scalar)
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts:                   (dimension: nt)

        |

        *Overload 5:*

        constructor that initializes timepoints and fixed parameters from
        vectors

        :type nytrue: int
        :param nytrue:               (dimension: scalar)
        :type nztrue: int
        :param nztrue:               (dimension: scalar)
        :type nmaxevent: int
        :param nmaxevent:            (dimension: scalar)
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts:                   (dimension: nt)
        :type fixedParameters: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param fixedParameters:      (dimension: nk)

        |

        *Overload 6:*

        constructor that initializes timepoints and data from vectors

        :type nytrue: int
        :param nytrue:               (dimension: scalar)
        :type nztrue: int
        :param nztrue:               (dimension: scalar)
        :type nmaxevent: int
        :param nmaxevent:            (dimension: scalar)
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts:                   (dimension: nt)
        :type observedData: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedData:         (dimension: nt x nytrue, row-major)
        :type observedDataStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedDataStdDev:   (dimension: nt x nytrue, row-major)
        :type observedEvents: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEvents:       (dimension: nmaxevent x nztrue, row-major)
        :type observedEventsStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEventsStdDev: (dimension: nmaxevent x nztrue, row-major)

        |

        *Overload 7:*

        constructor that initializes with Model

        :type model: :py:class:`Model`
        :param model: pointer to model specification object

        |

        *Overload 8:*

        constructor that initializes with returnData, adds noise according
        to specified sigmas

        :type rdata: :py:class:`ReturnData`
        :param rdata: return data pointer with stored simulation results
        :type sigma_y: float
        :param sigma_y: scalar standard deviations for all observables
        :type sigma_z: float
        :param sigma_z: scalar standard deviations for all event observables

        |

        *Overload 9:*

        constructor that initializes with returnData, adds noise according
        to specified sigmas

        :type rdata: :py:class:`ReturnData`
        :param rdata: return data pointer with stored simulation results
        :type sigma_y: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sigma_y: vector of standard deviations for observables
            (dimension: nytrue or nt x nytrue, row-major)
        :type sigma_z: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sigma_z: vector of standard deviations for event observables
            (dimension: nztrue or nmaxevent x nztrue, row-major)
        """
        _amici.ExpData_swiginit(self, _amici.new_ExpData(*args))
    __swig_destroy__ = _amici.delete_ExpData

    def nytrue(self) -> "int":
        r"""
        number of observables of the non-augmented model

        :rtype: int
        :return: number of observables of the non-augmented model
        """
        return _amici.ExpData_nytrue(self)

    def nztrue(self) -> "int":
        r"""
        number of event observables of the non-augmented model

        :rtype: int
        :return: number of event observables of the non-augmented model
        """
        return _amici.ExpData_nztrue(self)

    def nmaxevent(self) -> "int":
        r"""
        maximal number of events to track

        :rtype: int
        :return: maximal number of events to track
        """
        return _amici.ExpData_nmaxevent(self)

    def nt(self) -> "int":
        r"""
        number of timepoints

        :rtype: int
        :return: number of timepoints
        """
        return _amici.ExpData_nt(self)

    def setTimepoints(self, ts: "DoubleVector") -> "void":
        r"""
        set function that copies data from input to ExpData::ts

        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts: timepoints
        """
        return _amici.ExpData_setTimepoints(self, ts)

    def getTimepoints(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::ts to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: ExpData::ts
        """
        return _amici.ExpData_getTimepoints(self)

    def getTimepoint(self, it: "int") -> "amici::realtype":
        r"""
        get function that returns timepoint at index

        :type it: int
        :param it: timepoint index

        :rtype: float
        :return: timepoint timepoint at index
        """
        return _amici.ExpData_getTimepoint(self, it)

    def setObservedData(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to ExpData::my

        :type observedData: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedData: observed data (dimension: nt x nytrue, row-major)

        |

        *Overload 2:*

        set function that copies observed data for specific observable

        :type observedData: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedData: observed data (dimension: nt)
        :type iy: int
        :param iy: oberved data index
        """
        return _amici.ExpData_setObservedData(self, *args)

    def isSetObservedData(self, it: "int", iy: "int") -> "bool":
        r"""
        get function that checks whether data at specified indices has
        been set

        :type it: int
        :param it: time index
        :type iy: int
        :param iy: observable index

        :rtype: boolean
        :return: boolean specifying if data was set
        """
        return _amici.ExpData_isSetObservedData(self, it, iy)

    def getObservedData(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedData to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: observed data (dimension: nt x nytrue, row-major)
        """
        return _amici.ExpData_getObservedData(self)

    def getObservedDataPtr(self, it: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to observed data at index

        :type it: int
        :param it: timepoint index

        :rtype: float
        :return: pointer to observed data at index (dimension: nytrue)
        """
        return _amici.ExpData_getObservedDataPtr(self, it)

    def setObservedDataStdDev(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to
        ExpData::observedDataStdDev

        :type observedDataStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedDataStdDev: standard deviation of observed data (dimension:
            nt x nytrue, row-major)

        |

        *Overload 2:*

        set function that sets all ExpData::observedDataStdDev to the
        input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)

        |

        *Overload 3:*

        set function that copies standard deviation of observed data for
        specific observable

        :type observedDataStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedDataStdDev: standard deviation of observed data (dimension:
            nt)
        :type iy: int
        :param iy: observed data index

        |

        *Overload 4:*

        set function that sets all standard deviation of a specific
        observable to the input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)
        :type iy: int
        :param iy: observed data index
        """
        return _amici.ExpData_setObservedDataStdDev(self, *args)

    def isSetObservedDataStdDev(self, it: "int", iy: "int") -> "bool":
        r"""
        get function that checks whether standard deviation of data at
        specified indices has been set

        :type it: int
        :param it: time index
        :type iy: int
        :param iy: observable index
        :rtype: boolean
        :return: boolean specifying if standard deviation of data was set
        """
        return _amici.ExpData_isSetObservedDataStdDev(self, it, iy)

    def getObservedDataStdDev(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedDataStdDev to
        output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: standard deviation of observed data
        """
        return _amici.ExpData_getObservedDataStdDev(self)

    def getObservedDataStdDevPtr(self, it: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to standard deviation of
        observed data at index

        :type it: int
        :param it: timepoint index
        :rtype: float
        :return: pointer to standard deviation of observed data at index
        """
        return _amici.ExpData_getObservedDataStdDevPtr(self, it)

    def setObservedEvents(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies observed event data from input to
        ExpData::observedEvents

        :type observedEvents: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEvents: observed data (dimension: nmaxevent x nztrue,
            row-major)

        |

        *Overload 2:*

        set function that copies observed event data for specific event
        observable

        :type observedEvents: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEvents: observed data (dimension: nmaxevent)
        :type iz: int
        :param iz: observed event data index
        """
        return _amici.ExpData_setObservedEvents(self, *args)

    def isSetObservedEvents(self, ie: "int", iz: "int") -> "bool":
        r"""
        get function that checks whether event data at specified indices
        has been set

        :type ie: int
        :param ie: event index
        :type iz: int
        :param iz: event observable index
        :rtype: boolean
        :return: boolean specifying if data was set
        """
        return _amici.ExpData_isSetObservedEvents(self, ie, iz)

    def getObservedEvents(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::mz to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: observed event data
        """
        return _amici.ExpData_getObservedEvents(self)

    def getObservedEventsPtr(self, ie: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to observed data at ieth
        occurence

        :type ie: int
        :param ie: event occurence

        :rtype: float
        :return: pointer to observed event data at ieth occurence
        """
        return _amici.ExpData_getObservedEventsPtr(self, ie)

    def setObservedEventsStdDev(self, *args) -> "void":
        r"""
        *Overload 1:*

        set function that copies data from input to
        ExpData::observedEventsStdDev

        :type observedEventsStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEventsStdDev: standard deviation of observed event data

        |

        *Overload 2:*

        set function that sets all ExpData::observedDataStdDev to the
        input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)

        |

        *Overload 3:*

        set function that copies standard deviation of observed data for
        specific observable

        :type observedEventsStdDev: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param observedEventsStdDev: standard deviation of observed data
            (dimension: nmaxevent)
        :type iz: int
        :param iz: observed data index

        |

        *Overload 4:*

        set function that sets all standard deviation of a specific
        observable to the input value

        :type stdDev: float
        :param stdDev: standard deviation (dimension: scalar)
        :type iz: int
        :param iz: observed data index
        """
        return _amici.ExpData_setObservedEventsStdDev(self, *args)

    def isSetObservedEventsStdDev(self, ie: "int", iz: "int") -> "bool":
        r"""
        get function that checks whether standard deviation of even data
        at specified indices has been set

        :type ie: int
        :param ie: event index
        :type iz: int
        :param iz: event observable index
        :rtype: boolean
        :return: boolean specifying if standard deviation of event data was set
        """
        return _amici.ExpData_isSetObservedEventsStdDev(self, ie, iz)

    def getObservedEventsStdDev(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        get function that copies data from ExpData::observedEventsStdDev
        to output

        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: standard deviation of observed event data
        """
        return _amici.ExpData_getObservedEventsStdDev(self)

    def getObservedEventsStdDevPtr(self, ie: "int") -> "amici::realtype const *":
        r"""
        get function that returns a pointer to standard deviation of
        observed event data at ieth occurence

        :type ie: int
        :param ie: event occurence

        :rtype: float
        :return: pointer to standard deviation of observed event data at ieth
            occurence
        """
        return _amici.ExpData_getObservedEventsStdDevPtr(self, ie)
    fixedParameters = property(_amici.ExpData_fixedParameters_get, _amici.ExpData_fixedParameters_set, doc=r"""condition-specific fixed parameters of size Model::nk() or empty""")
    fixedParametersPreequilibration = property(_amici.ExpData_fixedParametersPreequilibration_get, _amici.ExpData_fixedParametersPreequilibration_set, doc=r"""
    condition-specific fixed parameters for pre-equilibration of size
    Model::nk() or empty. Overrides Solver::newton_preeq
    """)
    fixedParametersPresimulation = property(_amici.ExpData_fixedParametersPresimulation_get, _amici.ExpData_fixedParametersPresimulation_set, doc=r"""
    condition-specific fixed parameters for pre-simulation of
    size Model::nk() or empty.
    """)
    parameters = property(_amici.ExpData_parameters_get, _amici.ExpData_parameters_set, doc=r"""condition-specific parameters of size Model::np() or empty""")
    x0 = property(_amici.ExpData_x0_get, _amici.ExpData_x0_set, doc=r"""
    condition-specific initial conditions of size Model::nx() or
    empty
    """)
    sx0 = property(_amici.ExpData_sx0_get, _amici.ExpData_sx0_set, doc=r"""
    condition-specific initial condition sensitivities of size
    Model::nx() * Model::nplist(), Model::nx() * ExpDataplist.size(), if
    ExpData::plist is not empty, or empty
    """)
    pscale = property(_amici.ExpData_pscale_get, _amici.ExpData_pscale_set, doc=r"""condition-specific parameter scales of size Model::np()""")
    plist = property(_amici.ExpData_plist_get, _amici.ExpData_plist_set, doc=r"""condition-specific parameter list""")
    t_presim = property(_amici.ExpData_t_presim_get, _amici.ExpData_t_presim_set, doc=r"""
    duration of pre-simulation
    if this is > 0, presimualation will be performed from
    (model->t0 - t_presim) to model->t0 using the fixedParameters in
    fixedParametersPresimulation
    """)
    reinitializeFixedParameterInitialStates = property(_amici.ExpData_reinitializeFixedParameterInitialStates_get, _amici.ExpData_reinitializeFixedParameterInitialStates_set, doc=r"""
    flag indicating whether reinitialization of states depending on
    fixed parameters is activated
    """)

# Register ExpData in _amici:
_amici.ExpData_swigregister(ExpData)


def checkSigmaPositivity(*args) -> "void":
    r"""
    *Overload 1:*

    checks input vector of sigmas for not strictly positive values

    :type sigmaVector: std::vector< amici::realtype,std::allocator< amici::realtype > >
    :param sigmaVector: vector input to be checked
    :type vectorName: string
    :param vectorName: name of the input

    |

    *Overload 2:*

    checks input scalar sigma for not strictly positive value

    :type sigma: float
    :param sigma: input to be checked
    :type sigmaName: string
    :param sigmaName: name of the input
    """
    return _amici.checkSigmaPositivity(*args)
class ConditionContext(ContextManager):
    r"""
    The ConditionContext class applies condition-specific amici::Model
    settings and restores them when going out of scope
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Apply condition-specific settings from edata to model while
        keeping a backup of the original values.

        :type model: :py:class:`Model`
        :param model:
        :type edata: :py:class:`ExpData`
        :param edata:
        :type fpc: int
        :param fpc: flag indicating which fixedParmeter from edata to apply
        """
        _amici.ConditionContext_swiginit(self, _amici.new_ConditionContext(*args))
    __swig_destroy__ = _amici.delete_ConditionContext

    def applyCondition(self, edata: "ExpData", fpc: "amici::FixedParameterContext") -> "void":
        r"""
        Apply condition-specific settings from edata to the
        constructor-supplied model, not changing the settings which were
        backed-up in the constructor call.

        :type edata: :py:class:`ExpData`
        :param edata:
        :type fpc: int
        :param fpc: flag indicating which fixedParmeter from edata to apply
        """
        return _amici.ConditionContext_applyCondition(self, edata, fpc)

    def restore(self) -> "void":
        r"""
        Restore original settings on constructor-supplied amici::Model.
        Will be called during destruction. Explicit call is generally not
        necessary.
        """
        return _amici.ConditionContext_restore(self)

# Register ConditionContext in _amici:
_amici.ConditionContext_swigregister(ConditionContext)

class ReturnData(object):
    r"""
    Stores all data to be returned by amici::runAmiciSimulation.

    NOTE: multidimensional arrays are stored in row-major order
    (FORTRAN-style)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        default constructor

        |

        *Overload 2:*

        ReturnData
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts: see amici::Model::ts
        :type np: int
        :param np: see amici::Model::np
        :type nk: int
        :param nk: see amici::Model::nk
        :type nx: int
        :param nx: see amici::Model::nx_rdata
        :type nx_solver: int
        :param nx_solver: see amici::Model::nx_solver
        :type nxtrue: int
        :param nxtrue: see amici::Model::nxtrue_rdata
        :type nx_solver_reinit: int
        :param nx_solver_reinit: see amici::Model::nx_solver_reinit
        :type ny: int
        :param ny: see amici::Model::ny
        :type nytrue: int
        :param nytrue: see amici::Model::nytrue
        :type nz: int
        :param nz: see amici::Model::nz
        :type nztrue: int
        :param nztrue: see amici::Model::nztrue
        :type ne: int
        :param ne: see amici::Model::ne
        :type nJ: int
        :param nJ: see amici::Model::nJ
        :type nplist: int
        :param nplist: see amici::Model::nplist
        :type nmaxevent: int
        :param nmaxevent: see amici::Model::nmaxevent
        :type nt: int
        :param nt: see amici::Model::nt
        :type newton_maxsteps: int
        :param newton_maxsteps: see amici::Solver::newton_maxsteps
        :type nw: int
        :param nw: see amici::Model::nw
        :type pscale: std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >
        :param pscale: see amici::Model::pscale
        :type o2mode: int
        :param o2mode: see amici::Model::o2mode
        :type sensi: int
        :param sensi: see amici::Solver::sensi
        :type sensi_meth: int
        :param sensi_meth: see amici::Solver::sensi_meth
        :type rdrm: int
        :param rdrm: see amici::Solver::rdata_reporting

        |

        *Overload 3:*

        constructor that uses information from model and solver to
        appropriately initialize fields
        :type solver: :py:class:`Solver`
        :param solver: solver instance
        :type model: :py:class:`Model`
        :param model: model instance
        """
        _amici.ReturnData_swiginit(self, _amici.new_ReturnData(*args))
    __swig_destroy__ = _amici.delete_ReturnData
    ts = property(_amici.ReturnData_ts_get, _amici.ReturnData_ts_set, doc=r""" timepoints (dimension: nt)""")
    xdot = property(_amici.ReturnData_xdot_get, _amici.ReturnData_xdot_set, doc=r""" time derivative (dimension: nx)""")
    J = property(_amici.ReturnData_J_get, _amici.ReturnData_J_set, doc=r"""
    Jacobian of differential equation right hand side (dimension: nx x nx,
    row-major)
    """)
    w = property(_amici.ReturnData_w_get, _amici.ReturnData_w_set, doc=r"""
    w data from the model (recurring terms in xdot, for imported SBML models
    from python, this contains the flux vector)
    (dimensions: nt x nw, row major)
    """)
    z = property(_amici.ReturnData_z_get, _amici.ReturnData_z_set, doc=r""" event output (dimension: nmaxevent x nz, row-major)""")
    sigmaz = property(_amici.ReturnData_sigmaz_get, _amici.ReturnData_sigmaz_set, doc=r"""
    event output sigma standard deviation (dimension: nmaxevent x nz,
    row-major)
    """)
    sz = property(_amici.ReturnData_sz_get, _amici.ReturnData_sz_set, doc=r"""
    parameter derivative of event output (dimension: nmaxevent x nz,
    row-major)
    """)
    ssigmaz = property(_amici.ReturnData_ssigmaz_get, _amici.ReturnData_ssigmaz_set, doc=r"""
    parameter derivative of event output standard deviation (dimension:
    nmaxevent x nz, row-major)
    """)
    rz = property(_amici.ReturnData_rz_get, _amici.ReturnData_rz_set, doc=r""" event trigger output (dimension: nmaxevent x nz, row-major)""")
    srz = property(_amici.ReturnData_srz_get, _amici.ReturnData_srz_set, doc=r"""
    parameter derivative of event trigger output (dimension: nmaxevent x nz
    x nplist, row-major)
    """)
    s2rz = property(_amici.ReturnData_s2rz_get, _amici.ReturnData_s2rz_set, doc=r"""
    second order parameter derivative of event trigger output (dimension:
    nmaxevent x nztrue x nplist x nplist, row-major)
    """)
    x = property(_amici.ReturnData_x_get, _amici.ReturnData_x_set, doc=r""" state (dimension: nt x nx, row-major)""")
    sx = property(_amici.ReturnData_sx_get, _amici.ReturnData_sx_set, doc=r"""parameter derivative of state (dimension: nt x nplist x nx, row-major)""")
    y = property(_amici.ReturnData_y_get, _amici.ReturnData_y_set, doc=r""" observable (dimension: nt x ny, row-major)""")
    sigmay = property(_amici.ReturnData_sigmay_get, _amici.ReturnData_sigmay_set, doc=r""" observable standard deviation (dimension: nt x ny, row-major)""")
    sy = property(_amici.ReturnData_sy_get, _amici.ReturnData_sy_set, doc=r"""
    parameter derivative of observable (dimension: nt x nplist x ny,
    row-major)
    """)
    ssigmay = property(_amici.ReturnData_ssigmay_get, _amici.ReturnData_ssigmay_set, doc=r"""
    parameter derivative of observable standard deviation (dimension: nt x
    nplist x ny, row-major)
    """)
    res = property(_amici.ReturnData_res_get, _amici.ReturnData_res_set, doc=r""" observable (dimension: nt*ny, row-major)""")
    sres = property(_amici.ReturnData_sres_get, _amici.ReturnData_sres_set, doc=r"""parameter derivative of residual (dimension: nt*ny x nplist, row-major)""")
    FIM = property(_amici.ReturnData_FIM_get, _amici.ReturnData_FIM_set, doc=r""" fisher information matrix (dimension: nplist x nplist, row-major)""")
    numsteps = property(_amici.ReturnData_numsteps_get, _amici.ReturnData_numsteps_set, doc=r""" number of integration steps forward problem (dimension: nt)""")
    numstepsB = property(_amici.ReturnData_numstepsB_get, _amici.ReturnData_numstepsB_set, doc=r""" number of integration steps backward problem (dimension: nt)""")
    numrhsevals = property(_amici.ReturnData_numrhsevals_get, _amici.ReturnData_numrhsevals_set, doc=r""" number of right hand side evaluations forward problem (dimension: nt)""")
    numrhsevalsB = property(_amici.ReturnData_numrhsevalsB_get, _amici.ReturnData_numrhsevalsB_set, doc=r""" number of right hand side evaluations backwad problem (dimension: nt)""")
    numerrtestfails = property(_amici.ReturnData_numerrtestfails_get, _amici.ReturnData_numerrtestfails_set, doc=r""" number of error test failures forward problem (dimension: nt)""")
    numerrtestfailsB = property(_amici.ReturnData_numerrtestfailsB_get, _amici.ReturnData_numerrtestfailsB_set, doc=r""" number of error test failures backwad problem (dimension: nt)""")
    numnonlinsolvconvfails = property(_amici.ReturnData_numnonlinsolvconvfails_get, _amici.ReturnData_numnonlinsolvconvfails_set, doc=r"""
    number of linear solver convergence failures forward problem (dimension:
    nt)
    """)
    numnonlinsolvconvfailsB = property(_amici.ReturnData_numnonlinsolvconvfailsB_get, _amici.ReturnData_numnonlinsolvconvfailsB_set, doc=r"""
    number of linear solver convergence failures backwad problem (dimension:
    nt)
    """)
    order = property(_amici.ReturnData_order_get, _amici.ReturnData_order_set, doc=r""" employed order forward problem (dimension: nt)""")
    cpu_time = property(_amici.ReturnData_cpu_time_get, _amici.ReturnData_cpu_time_set, doc=r""" computation time of forward solve [ms]""")
    cpu_timeB = property(_amici.ReturnData_cpu_timeB_get, _amici.ReturnData_cpu_timeB_set, doc=r""" computation time of backward solve [ms]""")
    preeq_status = property(_amici.ReturnData_preeq_status_get, _amici.ReturnData_preeq_status_set, doc=r""" flags indicating success of steady state solver (preequilibration)""")
    preeq_cpu_time = property(_amici.ReturnData_preeq_cpu_time_get, _amici.ReturnData_preeq_cpu_time_set, doc=r""" computation time of the steady state solver [ms] (preequilibration)""")
    preeq_cpu_timeB = property(_amici.ReturnData_preeq_cpu_timeB_get, _amici.ReturnData_preeq_cpu_timeB_set, doc=r"""
    computation time of the steady state solver of the backward problem [ms]
    (preequilibration)
    """)
    posteq_status = property(_amici.ReturnData_posteq_status_get, _amici.ReturnData_posteq_status_set, doc=r""" flags indicating success of steady state solver  (postequilibration)""")
    posteq_cpu_time = property(_amici.ReturnData_posteq_cpu_time_get, _amici.ReturnData_posteq_cpu_time_set, doc=r""" computation time of the steady state solver [ms]  (postequilibration)""")
    posteq_cpu_timeB = property(_amici.ReturnData_posteq_cpu_timeB_get, _amici.ReturnData_posteq_cpu_timeB_set, doc=r"""
    computation time of the steady state solver of the backward problem [ms]
    (postequilibration)
    """)
    preeq_numsteps = property(_amici.ReturnData_preeq_numsteps_get, _amici.ReturnData_preeq_numsteps_set, doc=r"""
    number of Newton steps for steady state problem (preequilibration)
    [newton, simulation, newton] (length = 3)
    """)
    preeq_numlinsteps = property(_amici.ReturnData_preeq_numlinsteps_get, _amici.ReturnData_preeq_numlinsteps_set, doc=r"""
    number of linear steps by Newton step for steady state problem. this
    will only be filled for iterative solvers (preequilibration)
    (length = newton_maxsteps * 2)
    """)
    preeq_numstepsB = property(_amici.ReturnData_preeq_numstepsB_get, _amici.ReturnData_preeq_numstepsB_set, doc=r"""
    number of simulation steps for adjoint steady state problem
    (preequilibration) [== 0 if analytical solution worked, > 0 otherwise]
    """)
    posteq_numsteps = property(_amici.ReturnData_posteq_numsteps_get, _amici.ReturnData_posteq_numsteps_set, doc=r"""
    number of Newton steps for steady state problem (preequilibration)
    [newton, simulation, newton] (length = 3) (postequilibration)
    """)
    posteq_numlinsteps = property(_amici.ReturnData_posteq_numlinsteps_get, _amici.ReturnData_posteq_numlinsteps_set, doc=r"""
    number of linear steps by Newton step for steady state problem. this
    will only be filled for iterative solvers (postequilibration)
    (length = newton_maxsteps * 2)
    """)
    posteq_numstepsB = property(_amici.ReturnData_posteq_numstepsB_get, _amici.ReturnData_posteq_numstepsB_set, doc=r"""
    number of simulation steps for adjoint steady state problem
    (postequilibration) [== 0 if analytical solution worked, > 0 otherwise]
    """)
    preeq_t = property(_amici.ReturnData_preeq_t_get, _amici.ReturnData_preeq_t_set, doc=r"""time when steadystate was reached via simulation (preequilibration)""")
    preeq_wrms = property(_amici.ReturnData_preeq_wrms_get, _amici.ReturnData_preeq_wrms_set, doc=r"""
    weighted root-mean-square of the rhs when steadystate
    was reached (preequilibration)
    """)
    posteq_t = property(_amici.ReturnData_posteq_t_get, _amici.ReturnData_posteq_t_set, doc=r"""time when steadystate was reached via simulation (postequilibration)""")
    posteq_wrms = property(_amici.ReturnData_posteq_wrms_get, _amici.ReturnData_posteq_wrms_set, doc=r"""
    weighted root-mean-square of the rhs when steadystate
    was reached (postequilibration)
    """)
    x0 = property(_amici.ReturnData_x0_get, _amici.ReturnData_x0_set, doc=r""" initial state (dimension: nx)""")
    x_ss = property(_amici.ReturnData_x_ss_get, _amici.ReturnData_x_ss_set, doc=r""" preequilibration steady state found by Newton solver (dimension: nx)""")
    sx0 = property(_amici.ReturnData_sx0_get, _amici.ReturnData_sx0_set, doc=r""" initial sensitivities (dimension: nplist x nx, row-major)""")
    sx_ss = property(_amici.ReturnData_sx_ss_get, _amici.ReturnData_sx_ss_set, doc=r"""
    preequilibration sensitivities found by Newton solver (dimension: nplist
    x nx, row-major)
    """)
    llh = property(_amici.ReturnData_llh_get, _amici.ReturnData_llh_set, doc=r""" loglikelihood value""")
    chi2 = property(_amici.ReturnData_chi2_get, _amici.ReturnData_chi2_set, doc=r""" chi2 value""")
    sllh = property(_amici.ReturnData_sllh_get, _amici.ReturnData_sllh_set, doc=r""" parameter derivative of loglikelihood (dimension: nplist)""")
    s2llh = property(_amici.ReturnData_s2llh_get, _amici.ReturnData_s2llh_set, doc=r"""
    second order parameter derivative of loglikelihood (dimension: (nJ-1) x
    nplist, row-major)
    """)
    status = property(_amici.ReturnData_status_get, _amici.ReturnData_status_set, doc=r""" status code""")
    np = property(_amici.ReturnData_np_get, _amici.ReturnData_np_set, doc=r""" total number of model parameters""")
    nk = property(_amici.ReturnData_nk_get, _amici.ReturnData_nk_set, doc=r""" number of fixed parameters""")
    nx = property(_amici.ReturnData_nx_get, _amici.ReturnData_nx_set, doc=r""" number of states""")
    nx_solver = property(_amici.ReturnData_nx_solver_get, _amici.ReturnData_nx_solver_set, doc=r""" number of states with conservation laws applied""")
    nxtrue = property(_amici.ReturnData_nxtrue_get, _amici.ReturnData_nxtrue_set, doc=r""" number of states in the unaugmented system""")
    nx_solver_reinit = property(_amici.ReturnData_nx_solver_reinit_get, _amici.ReturnData_nx_solver_reinit_set, doc=r""" number of solver states to be reinitilized after preequilibration""")
    ny = property(_amici.ReturnData_ny_get, _amici.ReturnData_ny_set, doc=r""" number of observables""")
    nytrue = property(_amici.ReturnData_nytrue_get, _amici.ReturnData_nytrue_set, doc=r""" number of observables in the unaugmented system""")
    nz = property(_amici.ReturnData_nz_get, _amici.ReturnData_nz_set, doc=r""" number of event outputs""")
    nztrue = property(_amici.ReturnData_nztrue_get, _amici.ReturnData_nztrue_set, doc=r""" number of event outputs in the unaugmented system""")
    ne = property(_amici.ReturnData_ne_get, _amici.ReturnData_ne_set, doc=r""" number of events""")
    nJ = property(_amici.ReturnData_nJ_get, _amici.ReturnData_nJ_set, doc=r""" dimension of the augmented objective function for 2nd order ASA""")
    nplist = property(_amici.ReturnData_nplist_get, _amici.ReturnData_nplist_set, doc=r""" number of parameter for which sensitivities were requested""")
    nmaxevent = property(_amici.ReturnData_nmaxevent_get, _amici.ReturnData_nmaxevent_set, doc=r""" maximal number of occuring events (for every event type)""")
    nt = property(_amici.ReturnData_nt_get, _amici.ReturnData_nt_set, doc=r""" number of considered timepoints""")
    nw = property(_amici.ReturnData_nw_get, _amici.ReturnData_nw_set, doc=r""" number of columns in w""")
    newton_maxsteps = property(_amici.ReturnData_newton_maxsteps_get, _amici.ReturnData_newton_maxsteps_set, doc=r""" maximal number of newton iterations for steady state calculation""")
    pscale = property(_amici.ReturnData_pscale_get, _amici.ReturnData_pscale_set, doc=r""" scaling of parameterization (lin,log,log10)""")
    o2mode = property(_amici.ReturnData_o2mode_get, _amici.ReturnData_o2mode_set, doc=r""" flag indicating whether second order sensitivities were requested""")
    sensi = property(_amici.ReturnData_sensi_get, _amici.ReturnData_sensi_set, doc=r""" sensitivity order""")
    sensi_meth = property(_amici.ReturnData_sensi_meth_get, _amici.ReturnData_sensi_meth_set, doc=r""" sensitivity method""")
    rdata_reporting = property(_amici.ReturnData_rdata_reporting_get, _amici.ReturnData_rdata_reporting_set, doc=r""" reporting mode""")

# Register ReturnData in _amici:
_amici.ReturnData_swigregister(ReturnData)

class ModelContext(ContextManager):
    r"""
    The ModelContext temporarily stores amici::Model::state
    and restores it when going out of scope
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, model: "Model"):
        r"""
        initialize backup of the original values.

        :type model: :py:class:`Model`
        :param model:
        """
        _amici.ModelContext_swiginit(self, _amici.new_ModelContext(model))
    __swig_destroy__ = _amici.delete_ModelContext

    def restore(self) -> "void":
        r"""
        Restore original state on constructor-supplied amici::Model.
        Will be called during destruction. Explicit call is generally not
        necessary.
        """
        return _amici.ModelContext_restore(self)

# Register ModelContext in _amici:
_amici.ModelContext_swigregister(ModelContext)

class Solver(object):
    r"""
    The Solver class provides a generic interface to CVODES and IDAS solvers,
    individual realizations are realized in the CVodeSolver and the IDASolver
    class. All transient private/protected members (CVODES/IDAS memory, interface
    variables and status flags) are specified as mutable and not included in
    serialization or equality checks. No solver setting parameter should be
    marked mutable.

    NOTE: Any changes in data members here must be propagated to copy ctor,
    equality operator, serialization functions in serialization.h, and
    amici::hdf5::readSolverSettingsFromHDF5 in hdf5.cpp.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_Solver

    def clone(self) -> "amici::Solver *":
        r"""
        Clone this instance
        :rtype: :py:class:`Solver`
        :return: The clone
        """
        return _amici.Solver_clone(self)

    def run(self, tout: "amici::realtype") -> "int":
        r"""
        runs a forward simulation until the specified timepoint

        :type tout: float
        :param tout: next timepooint
        :rtype: int
        :return: status flag
        """
        return _amici.Solver_run(self, tout)

    def step(self, tout: "amici::realtype") -> "int":
        r"""
        makes a single step in the simulation

        :type tout: float
        :param tout: next timepooint
        :rtype: int
        :return: status flag
        """
        return _amici.Solver_step(self, tout)

    def runB(self, tout: "amici::realtype") -> "void":
        r"""
        runs a backward simulation until the specified timepoint

        :type tout: float
        :param tout: next timepooint
        """
        return _amici.Solver_runB(self, tout)

    def updateAndReinitStatesAndSensitivities(self, model: "Model") -> "void":
        r"""
        Reinitializes state and respective sensitivities (if necessary) according
        to changes in fixedParameters

        :type model: :py:class:`Model`
        :param model: pointer to the model instance
        """
        return _amici.Solver_updateAndReinitStatesAndSensitivities(self, model)

    def getRootInfo(self, rootsfound: "int *") -> "void":
        r"""
        getRootInfo extracts information which event occured

        :type rootsfound: int
        :param rootsfound: array with flags indicating whether the respective
            event occured
        """
        return _amici.Solver_getRootInfo(self, rootsfound)

    def calcIC(self, tout1: "amici::realtype") -> "void":
        r"""
        Calculates consistent initial conditions, assumes initial
        states to be correct (DAE only)

        :type tout1: float
        :param tout1: next timepoint to be computed (sets timescale)
        """
        return _amici.Solver_calcIC(self, tout1)

    def calcICB(self, which: "int", tout1: "amici::realtype") -> "void":
        r"""
        Calculates consistent initial conditions for the backwards
        problem, assumes initial states to be correct (DAE only)

        :type which: int
        :param which: identifier of the backwards problem
        :type tout1: float
        :param tout1: next timepoint to be computed (sets timescale)
        """
        return _amici.Solver_calcICB(self, which, tout1)

    def solveB(self, tBout: "amici::realtype", itaskB: "int") -> "void":
        r"""
        Solves the backward problem until a predefined timepoint
        (adjoint only)

        :type tBout: float
        :param tBout: timepoint until which simulation should be performed
        :type itaskB: int
        :param itaskB: task identifier, can be CV_NORMAL or CV_ONE_STEP
        """
        return _amici.Solver_solveB(self, tBout, itaskB)

    def turnOffRootFinding(self) -> "void":
        r"""Disable rootfinding"""
        return _amici.Solver_turnOffRootFinding(self)

    def getSensitivityMethod(self) -> "amici::SensitivityMethod":
        r"""
        Return current sensitivity method
        :rtype: int
        :return: method enum
        """
        return _amici.Solver_getSensitivityMethod(self)

    def setSensitivityMethod(self, sensi_meth: "amici::SensitivityMethod") -> "void":
        r"""
        Set sensitivity method
        :type sensi_meth: int
        :param sensi_meth:
        """
        return _amici.Solver_setSensitivityMethod(self, sensi_meth)

    def getSensitivityMethodPreequilibration(self) -> "amici::SensitivityMethod":
        r"""
        Return current sensitivity method during preequilibration
        :rtype: int
        :return: method enum
        """
        return _amici.Solver_getSensitivityMethodPreequilibration(self)

    def setSensitivityMethodPreequilibration(self, sensi_meth_preeq: "amici::SensitivityMethod") -> "void":
        r"""
        Set sensitivity method for preequilibration
        :type sensi_meth_preeq: int
        :param sensi_meth_preeq:
        """
        return _amici.Solver_setSensitivityMethodPreequilibration(self, sensi_meth_preeq)

    def switchForwardSensisOff(self) -> "void":
        r"""Disable forward sensitivity integration (used in steady state sim)"""
        return _amici.Solver_switchForwardSensisOff(self)

    def getNewtonMaxSteps(self) -> "int":
        r"""
        Get maximum number of allowed Newton steps for steady state
        computation
        :rtype: int
        :return: 
        """
        return _amici.Solver_getNewtonMaxSteps(self)

    def setNewtonMaxSteps(self, newton_maxsteps: "int") -> "void":
        r"""
        Set maximum number of allowed Newton steps for steady state
        computation
        :type newton_maxsteps: int
        :param newton_maxsteps:
        """
        return _amici.Solver_setNewtonMaxSteps(self, newton_maxsteps)

    def getPreequilibration(self) -> "bool":
        r"""
        Get if model preequilibration is enabled
        :rtype: boolean
        :return: 
        """
        return _amici.Solver_getPreequilibration(self)

    def setPreequilibration(self, require_preequilibration: "bool") -> "void":
        r"""
        Enable/disable model preequilibration
        :type require_preequilibration: boolean
        :param require_preequilibration:
        """
        return _amici.Solver_setPreequilibration(self, require_preequilibration)

    def getNewtonMaxLinearSteps(self) -> "int":
        r"""
        Get maximum number of allowed linear steps per Newton step for
        steady state computation
        :rtype: int
        :return: 
        """
        return _amici.Solver_getNewtonMaxLinearSteps(self)

    def setNewtonMaxLinearSteps(self, newton_maxlinsteps: "int") -> "void":
        r"""
        Set maximum number of allowed linear steps per Newton step for
        steady state computation
        :type newton_maxlinsteps: int
        :param newton_maxlinsteps:
        """
        return _amici.Solver_setNewtonMaxLinearSteps(self, newton_maxlinsteps)

    def getNewtonDampingFactorMode(self) -> "amici::NewtonDampingFactorMode":
        r"""
        Get a state of the damping factor used in the Newton solver
        :rtype: int
        :return: 
        """
        return _amici.Solver_getNewtonDampingFactorMode(self)

    def setNewtonDampingFactorMode(self, dampingFactorMode: "amici::NewtonDampingFactorMode") -> "void":
        r"""
        Turn on/off a damping factor in the Newton method
        :type dampingFactorMode: int
        :param dampingFactorMode:
        """
        return _amici.Solver_setNewtonDampingFactorMode(self, dampingFactorMode)

    def getNewtonDampingFactorLowerBound(self) -> "double":
        r"""
        Get a lower bound of the damping factor used in the Newton solver
        :rtype: float
        :return: 
        """
        return _amici.Solver_getNewtonDampingFactorLowerBound(self)

    def setNewtonDampingFactorLowerBound(self, dampingFactorLowerBound: "double") -> "void":
        r"""
        Set a lower bound of the damping factor in the Newton solver
        :type dampingFactorLowerBound: float
        :param dampingFactorLowerBound:
        """
        return _amici.Solver_setNewtonDampingFactorLowerBound(self, dampingFactorLowerBound)

    def getSensitivityOrder(self) -> "amici::SensitivityOrder":
        r"""
        Get sensitvity order
        :rtype: int
        :return: sensitivity order
        """
        return _amici.Solver_getSensitivityOrder(self)

    def setSensitivityOrder(self, sensi: "amici::SensitivityOrder") -> "void":
        r"""
        Set the sensitvity order
        :type sensi: int
        :param sensi: sensitivity order
        """
        return _amici.Solver_setSensitivityOrder(self, sensi)

    def getRelativeTolerance(self) -> "double":
        r"""
        Get the relative tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setRelativeToleranceASA.

        :rtype: float
        :return: relative tolerances
        """
        return _amici.Solver_getRelativeTolerance(self)

    def setRelativeTolerance(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setRelativeToleranceASA.

        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeTolerance(self, rtol)

    def getAbsoluteTolerance(self) -> "double":
        r"""
        Get the absolute tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setAbsoluteToleranceASA.

        :rtype: float
        :return: absolute tolerances
        """
        return _amici.Solver_getAbsoluteTolerance(self)

    def setAbsoluteTolerance(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the forward problem

        Same tolerance is used for the backward problem if not specified
        differently via setAbsoluteToleranceASA.

        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteTolerance(self, atol)

    def getRelativeToleranceFSA(self) -> "double":
        r"""
        Returns the relative tolerances for the forward sensitivity
        problem
        :rtype: float
        :return: relative tolerances
        """
        return _amici.Solver_getRelativeToleranceFSA(self)

    def setRelativeToleranceFSA(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the forward sensitivity problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeToleranceFSA(self, rtol)

    def getAbsoluteToleranceFSA(self) -> "double":
        r"""
        Returns the absolute tolerances for the forward sensitivity
        problem
        :rtype: float
        :return: absolute tolerances
        """
        return _amici.Solver_getAbsoluteToleranceFSA(self)

    def setAbsoluteToleranceFSA(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the forward sensitivity problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteToleranceFSA(self, atol)

    def getRelativeToleranceB(self) -> "double":
        r"""
        Returns the relative tolerances for the adjoint sensitivity
        problem
        :rtype: float
        :return: relative tolerances
        """
        return _amici.Solver_getRelativeToleranceB(self)

    def setRelativeToleranceB(self, rtol: "double") -> "void":
        r"""
        Sets the relative tolerances for the adjoint sensitivity problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeToleranceB(self, rtol)

    def getAbsoluteToleranceB(self) -> "double":
        r"""
        Returns the absolute tolerances for the backward problem for
        adjoint sensitivity analysis
        :rtype: float
        :return: absolute tolerances
        """
        return _amici.Solver_getAbsoluteToleranceB(self)

    def setAbsoluteToleranceB(self, atol: "double") -> "void":
        r"""
        Sets the absolute tolerances for the backward problem for
        adjoint sensitivity analysis
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteToleranceB(self, atol)

    def getRelativeToleranceQuadratures(self) -> "double":
        r"""
        Returns the relative tolerance for the quadrature problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.Solver_getRelativeToleranceQuadratures(self)

    def setRelativeToleranceQuadratures(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the quadrature problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeToleranceQuadratures(self, rtol)

    def getAbsoluteToleranceQuadratures(self) -> "double":
        r"""
        returns the absolute tolerance for the quadrature problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.Solver_getAbsoluteToleranceQuadratures(self)

    def setAbsoluteToleranceQuadratures(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the quadrature problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteToleranceQuadratures(self, atol)

    def getRelativeToleranceSteadyState(self) -> "double":
        r"""
        returns the relative tolerance for the steady state problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.Solver_getRelativeToleranceSteadyState(self)

    def setRelativeToleranceSteadyState(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the steady state problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeToleranceSteadyState(self, rtol)

    def getAbsoluteToleranceSteadyState(self) -> "double":
        r"""
        returns the absolute tolerance for the steady state problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.Solver_getAbsoluteToleranceSteadyState(self)

    def setAbsoluteToleranceSteadyState(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the steady state problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteToleranceSteadyState(self, atol)

    def getRelativeToleranceSteadyStateSensi(self) -> "double":
        r"""
        returns the relative tolerance for the sensitivities of the
        steady state problem
        :rtype: float
        :return: relative tolerance
        """
        return _amici.Solver_getRelativeToleranceSteadyStateSensi(self)

    def setRelativeToleranceSteadyStateSensi(self, rtol: "double") -> "void":
        r"""
        sets the relative tolerance for the sensitivities of the
        steady state problem
        :type rtol: float
        :param rtol: relative tolerance (non-negative number)
        """
        return _amici.Solver_setRelativeToleranceSteadyStateSensi(self, rtol)

    def getAbsoluteToleranceSteadyStateSensi(self) -> "double":
        r"""
        returns the absolute tolerance for the sensitivities of the
        steady state problem
        :rtype: float
        :return: absolute tolerance
        """
        return _amici.Solver_getAbsoluteToleranceSteadyStateSensi(self)

    def setAbsoluteToleranceSteadyStateSensi(self, atol: "double") -> "void":
        r"""
        sets the absolute tolerance for the sensitivities of the
        steady state problem
        :type atol: float
        :param atol: absolute tolerance (non-negative number)
        """
        return _amici.Solver_setAbsoluteToleranceSteadyStateSensi(self, atol)

    def getMaxSteps(self) -> "long":
        r"""
        returns the maximum number of solver steps for the forward
        problem
        :rtype: int
        :return: maximum number of solver steps
        """
        return _amici.Solver_getMaxSteps(self)

    def setMaxSteps(self, maxsteps: "long") -> "void":
        r"""
        sets the maximum number of solver steps for the forward problem
        :type maxsteps: int
        :param maxsteps: maximum number of solver steps (non-negative number)
        """
        return _amici.Solver_setMaxSteps(self, maxsteps)

    def getMaxStepsBackwardProblem(self) -> "long":
        r"""
        returns the maximum number of solver steps for the backward
        problem
        :rtype: int
        :return: maximum number of solver steps
        """
        return _amici.Solver_getMaxStepsBackwardProblem(self)

    def setMaxStepsBackwardProblem(self, maxsteps: "long") -> "void":
        r"""
        sets the maximum number of solver steps for the backward problem
        :type maxsteps: int
        :param maxsteps: maximum number of solver steps (non-negative number)
        """
        return _amici.Solver_setMaxStepsBackwardProblem(self, maxsteps)

    def getLinearMultistepMethod(self) -> "amici::LinearMultistepMethod":
        r"""
        returns the linear system multistep method
        :rtype: int
        :return: linear system multistep method
        """
        return _amici.Solver_getLinearMultistepMethod(self)

    def setLinearMultistepMethod(self, lmm: "amici::LinearMultistepMethod") -> "void":
        r"""
        sets the linear system multistep method
        :type lmm: int
        :param lmm: linear system multistep method
        """
        return _amici.Solver_setLinearMultistepMethod(self, lmm)

    def getNonlinearSolverIteration(self) -> "amici::NonlinearSolverIteration":
        r"""
        returns the nonlinear system solution method
        :rtype: int
        :return: 
        """
        return _amici.Solver_getNonlinearSolverIteration(self)

    def setNonlinearSolverIteration(self, iter: "amici::NonlinearSolverIteration") -> "void":
        r"""
        sets the nonlinear system solution method
        :type iter: int
        :param iter: nonlinear system solution method
        """
        return _amici.Solver_setNonlinearSolverIteration(self, iter)

    def getInterpolationType(self) -> "amici::InterpolationType":
        r"""
        getInterpolationType
        :rtype: int
        :return: 
        """
        return _amici.Solver_getInterpolationType(self)

    def setInterpolationType(self, interpType: "amici::InterpolationType") -> "void":
        r"""
        sets the interpolation of the forward solution that is used for
        the backwards problem
        :type interpType: int
        :param interpType: interpolation type
        """
        return _amici.Solver_setInterpolationType(self, interpType)

    def getStateOrdering(self) -> "int":
        r"""
        Gets KLU / SuperLUMT state ordering mode

        :rtype: int
        :return: State-ordering as integer according to
            SUNLinSolKLU::StateOrdering or SUNLinSolSuperLUMT::StateOrdering (which
            differ).
        """
        return _amici.Solver_getStateOrdering(self)

    def setStateOrdering(self, ordering: "int") -> "void":
        r"""
        Sets KLU / SuperLUMT state ordering mode

        This only applies when linsol is set to LinearSolver::KLU or
        LinearSolver::SuperLUMT. Mind the difference between
        SUNLinSolKLU::StateOrdering and SUNLinSolSuperLUMT::StateOrdering.
        :type ordering: int
        :param ordering: state ordering
        """
        return _amici.Solver_setStateOrdering(self, ordering)

    def getStabilityLimitFlag(self) -> "int":
        r"""
        returns stability limit detection mode
        :rtype: int
        :return: stldet can be amici.FALSE (deactivated) or amici.TRUE (activated)
        """
        return _amici.Solver_getStabilityLimitFlag(self)

    def setStabilityLimitFlag(self, stldet: "int") -> "void":
        r"""
        set stability limit detection mode
        :type stldet: int
        :param stldet: can be amici.FALSE (deactivated) or amici.TRUE (activated)
        """
        return _amici.Solver_setStabilityLimitFlag(self, stldet)

    def getLinearSolver(self) -> "amici::LinearSolver":
        r"""
        getLinearSolver
        :rtype: int
        :return: 
        """
        return _amici.Solver_getLinearSolver(self)

    def setLinearSolver(self, linsol: "amici::LinearSolver") -> "void":
        r"""
        setLinearSolver
        :type linsol: int
        :param linsol:
        """
        return _amici.Solver_setLinearSolver(self, linsol)

    def getInternalSensitivityMethod(self) -> "amici::InternalSensitivityMethod":
        r"""
        returns the internal sensitivity method
        :rtype: int
        :return: internal sensitivity method
        """
        return _amici.Solver_getInternalSensitivityMethod(self)

    def setInternalSensitivityMethod(self, ism: "amici::InternalSensitivityMethod") -> "void":
        r"""
        sets the internal sensitivity method
        :type ism: int
        :param ism: internal sensitivity method
        """
        return _amici.Solver_setInternalSensitivityMethod(self, ism)

    def getReturnDataReportingMode(self) -> "amici::RDataReporting":
        r"""
        returns the ReturnData reporting mode
        :rtype: int
        :return: ReturnData reporting mode
        """
        return _amici.Solver_getReturnDataReportingMode(self)

    def setReturnDataReportingMode(self, rdrm: "amici::RDataReporting") -> "void":
        r"""
        sets the ReturnData reporting mode
        :type rdrm: int
        :param rdrm: ReturnData reporting mode
        """
        return _amici.Solver_setReturnDataReportingMode(self, rdrm)

    def sensToggleOff(self) -> "void":
        r"""
        Switches off computation of  state sensitivites without
        deallocating the memory for sensitivities
        """
        return _amici.Solver_sensToggleOff(self)

    def gett(self) -> "amici::realtype":
        r"""
        current solver timepoint
        :rtype: float
        :return: t
        """
        return _amici.Solver_gett(self)

    def getCpuTime(self) -> "amici::realtype":
        r"""
        Reads out the cpu time needed for forward solve
        :rtype: float
        :return: cpu_time
        """
        return _amici.Solver_getCpuTime(self)

    def getCpuTimeB(self) -> "amici::realtype":
        r"""
        Reads out the cpu time needed for bavkward solve
        :rtype: float
        :return: cpu_timeB
        """
        return _amici.Solver_getCpuTimeB(self)

    def nx(self) -> "int":
        r"""
        number of states with which the solver was initialized
        :rtype: int
        :return: x.getLength()
        """
        return _amici.Solver_nx(self)

    def nplist(self) -> "int":
        r"""
        number of parameters with which the solver was initialized
        :rtype: int
        :return: sx.getLength()
        """
        return _amici.Solver_nplist(self)

    def nquad(self) -> "int":
        r"""
        number of quadratures with which the solver was initialized
        :rtype: int
        :return: xQB.getLength()
        """
        return _amici.Solver_nquad(self)

    def computingFSA(self) -> "bool":
        r"""
        check if FSA is being computed
        :rtype: boolean
        :return: flag
        """
        return _amici.Solver_computingFSA(self)

    def computingASA(self) -> "bool":
        r"""
        check if ASA is being computed
        :rtype: boolean
        :return: flag
        """
        return _amici.Solver_computingASA(self)

    def resetDiagnosis(self) -> "void":
        r"""Resets vectors containing diagnosis information"""
        return _amici.Solver_resetDiagnosis(self)

    def storeDiagnosis(self) -> "void":
        r"""Stores diagnosis information from solver memory block for forward problem"""
        return _amici.Solver_storeDiagnosis(self)

    def storeDiagnosisB(self, which: "int") -> "void":
        r"""
        Stores diagnosis information from solver memory block for backward problem

        :type which: int
        :param which: identifier of the backwards problem
        """
        return _amici.Solver_storeDiagnosisB(self, which)

    def getNumSteps(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor ns
        :rtype: std::vector< int,std::allocator< int > >
        :return: ns
        """
        return _amici.Solver_getNumSteps(self)

    def getNumStepsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nsB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nsB
        """
        return _amici.Solver_getNumStepsB(self)

    def getNumRhsEvals(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nrhs
        :rtype: std::vector< int,std::allocator< int > >
        :return: nrhs
        """
        return _amici.Solver_getNumRhsEvals(self)

    def getNumRhsEvalsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nrhsB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nrhsB
        """
        return _amici.Solver_getNumRhsEvalsB(self)

    def getNumErrTestFails(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor netf
        :rtype: std::vector< int,std::allocator< int > >
        :return: netf
        """
        return _amici.Solver_getNumErrTestFails(self)

    def getNumErrTestFailsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor netfB
        :rtype: std::vector< int,std::allocator< int > >
        :return: netfB
        """
        return _amici.Solver_getNumErrTestFailsB(self)

    def getNumNonlinSolvConvFails(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nnlscf
        :rtype: std::vector< int,std::allocator< int > >
        :return: nnlscf
        """
        return _amici.Solver_getNumNonlinSolvConvFails(self)

    def getNumNonlinSolvConvFailsB(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor nnlscfB
        :rtype: std::vector< int,std::allocator< int > >
        :return: nnlscfB
        """
        return _amici.Solver_getNumNonlinSolvConvFailsB(self)

    def getLastOrder(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Accessor order
        :rtype: std::vector< int,std::allocator< int > >
        :return: order
        """
        return _amici.Solver_getLastOrder(self)
    app = property(_amici.Solver_app_get, _amici.Solver_app_set, doc=r""" AMICI context""")

# Register Solver in _amici:
_amici.Solver_swigregister(Solver)


def wrapErrHandlerFn(error_code: "int", module: "char const *", function: "char const *", msg: "char *", eh_data: "void *") -> "void":
    r"""
    Extracts diagnosis information from solver memory block and
    passes them to the specified output function

    :type error_code: int
    :param error_code: error identifier
    :type module: string
    :param module: name of the module in which the error occured
    :type function: string
    :param function: name of the function in which the error occured
    :type msg: string
    :param msg: error message
    :type eh_data: void
    :param eh_data: amici::Solver as void*
    """
    return _amici.wrapErrHandlerFn(error_code, module, function, msg, eh_data)
class IDASolver(Solver):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_IDASolver

    def clone(self) -> "amici::Solver *":
        r"""
        Clone this instance
        :rtype: :py:class:`Solver`
        :return: The clone
        """
        return _amici.IDASolver_clone(self)

    def reInitPostProcessF(self, tnext: "amici::realtype") -> "void":
        return _amici.IDASolver_reInitPostProcessF(self, tnext)

    def reInitPostProcessB(self, tnext: "amici::realtype") -> "void":
        return _amici.IDASolver_reInitPostProcessB(self, tnext)

    def sensToggleOff(self) -> "void":
        return _amici.IDASolver_sensToggleOff(self)

    def quadSStolerancesB(self, which: "int", reltolQB: "amici::realtype", abstolQB: "amici::realtype") -> "void":
        return _amici.IDASolver_quadSStolerancesB(self, which, reltolQB, abstolQB)

    def quadSStolerances(self, reltolQ: "amici::realtype", abstolQ: "amici::realtype") -> "void":
        return _amici.IDASolver_quadSStolerances(self, reltolQ, abstolQ)

    def solve(self, tout: "amici::realtype", itask: "int") -> "int":
        return _amici.IDASolver_solve(self, tout, itask)

    def solveF(self, tout: "amici::realtype", itask: "int", ncheckPtr: "int *") -> "int":
        return _amici.IDASolver_solveF(self, tout, itask, ncheckPtr)

    def solveB(self, tBout: "amici::realtype", itaskB: "int") -> "void":
        return _amici.IDASolver_solveB(self, tBout, itaskB)

    def getRootInfo(self, rootsfound: "int *") -> "void":
        return _amici.IDASolver_getRootInfo(self, rootsfound)

    def getDky(self, t: "amici::realtype", k: "int") -> "void":
        return _amici.IDASolver_getDky(self, t, k)

    def getSens(self) -> "void":
        return _amici.IDASolver_getSens(self)

    def getSensDky(self, t: "amici::realtype", k: "int") -> "void":
        return _amici.IDASolver_getSensDky(self, t, k)

    def getB(self, which: "int") -> "void":
        return _amici.IDASolver_getB(self, which)

    def getDkyB(self, t: "amici::realtype", k: "int", which: "int") -> "void":
        return _amici.IDASolver_getDkyB(self, t, k, which)

    def getQuadB(self, which: "int") -> "void":
        return _amici.IDASolver_getQuadB(self, which)

    def getQuadDkyB(self, t: "amici::realtype", k: "int", which: "int") -> "void":
        return _amici.IDASolver_getQuadDkyB(self, t, k, which)

    def getQuad(self, t: "amici::realtype &") -> "void":
        return _amici.IDASolver_getQuad(self, t)

    def getQuadDky(self, t: "amici::realtype", k: "int") -> "void":
        return _amici.IDASolver_getQuadDky(self, t, k)

    def calcIC(self, tout1: "amici::realtype") -> "void":
        return _amici.IDASolver_calcIC(self, tout1)

    def calcICB(self, which: "int", tout1: "amici::realtype") -> "void":
        return _amici.IDASolver_calcICB(self, which, tout1)

    def setStopTime(self, tstop: "amici::realtype") -> "void":
        return _amici.IDASolver_setStopTime(self, tstop)

    def turnOffRootFinding(self) -> "void":
        return _amici.IDASolver_turnOffRootFinding(self)

    def getModel(self) -> "amici::Model const *":
        return _amici.IDASolver_getModel(self)

    def setLinearSolver(self) -> "void":
        return _amici.IDASolver_setLinearSolver(self)

    def setLinearSolverB(self, which: "int") -> "void":
        return _amici.IDASolver_setLinearSolverB(self, which)

    def setNonLinearSolver(self) -> "void":
        return _amici.IDASolver_setNonLinearSolver(self)

    def setNonLinearSolverSens(self) -> "void":
        return _amici.IDASolver_setNonLinearSolverSens(self)

    def setNonLinearSolverB(self, which: "int") -> "void":
        return _amici.IDASolver_setNonLinearSolverB(self, which)

# Register IDASolver in _amici:
_amici.IDASolver_swigregister(IDASolver)

class CVodeSolver(Solver):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_CVodeSolver

    def clone(self) -> "amici::Solver *":
        r"""
        Clone this instance
        :rtype: :py:class:`Solver`
        :return: The clone
        """
        return _amici.CVodeSolver_clone(self)

    def sensToggleOff(self) -> "void":
        return _amici.CVodeSolver_sensToggleOff(self)

    def solve(self, tout: "amici::realtype", itask: "int") -> "int":
        return _amici.CVodeSolver_solve(self, tout, itask)

    def solveF(self, tout: "amici::realtype", itask: "int", ncheckPtr: "int *") -> "int":
        return _amici.CVodeSolver_solveF(self, tout, itask, ncheckPtr)

    def solveB(self, tBout: "amici::realtype", itaskB: "int") -> "void":
        return _amici.CVodeSolver_solveB(self, tBout, itaskB)

    def getDky(self, t: "amici::realtype", k: "int") -> "void":
        return _amici.CVodeSolver_getDky(self, t, k)

    def getSensDky(self, t: "amici::realtype", k: "int") -> "void":
        return _amici.CVodeSolver_getSensDky(self, t, k)

    def getQuadDkyB(self, t: "amici::realtype", k: "int", which: "int") -> "void":
        return _amici.CVodeSolver_getQuadDkyB(self, t, k, which)

    def getDkyB(self, t: "amici::realtype", k: "int", which: "int") -> "void":
        return _amici.CVodeSolver_getDkyB(self, t, k, which)

    def getRootInfo(self, rootsfound: "int *") -> "void":
        return _amici.CVodeSolver_getRootInfo(self, rootsfound)

    def setStopTime(self, tstop: "amici::realtype") -> "void":
        return _amici.CVodeSolver_setStopTime(self, tstop)

    def turnOffRootFinding(self) -> "void":
        return _amici.CVodeSolver_turnOffRootFinding(self)

    def getModel(self) -> "amici::Model const *":
        return _amici.CVodeSolver_getModel(self)

    def setLinearSolver(self, *args) -> "void":
        return _amici.CVodeSolver_setLinearSolver(self, *args)

    def setLinearSolverB(self, which: "int") -> "void":
        return _amici.CVodeSolver_setLinearSolverB(self, which)

    def setNonLinearSolver(self) -> "void":
        return _amici.CVodeSolver_setNonLinearSolver(self)

    def setNonLinearSolverSens(self) -> "void":
        return _amici.CVodeSolver_setNonLinearSolverSens(self)

    def setNonLinearSolverB(self, which: "int") -> "void":
        return _amici.CVodeSolver_setNonLinearSolverB(self, which)

# Register CVodeSolver in _amici:
_amici.CVodeSolver_swigregister(CVodeSolver)

class Model(AbstractModel):
    r"""
    The Model class represents an AMICI ODE/DAE model. The model can compute
    various model related quantities based on symbolically generated code.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _amici.delete_Model

    def clone(self) -> "amici::Model *":
        r"""
        Clone this instance
        :rtype: :py:class:`Model`
        :return: The clone
        """
        return _amici.Model_clone(self)

    def fdeltaqB(self, deltaqB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaqB
        :type deltaqB: float
        :param deltaqB: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: adjoint state
        """
        return _amici.Model_fdeltaqB(self, deltaqB, t, x, p, k, h, ip, ie, xdot, xdot_old, xB)

    def fdeltasx(self, deltasx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", ip: "int", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", sx: "amici::realtype const *", stau: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltasx
        :type deltasx: float
        :param deltasx: sensitivity update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type sx: float
        :param sx: state sensitivity
        :type stau: float
        :param stau: event-time sensitivity
        """
        return _amici.Model_fdeltasx(self, deltasx, t, x, p, k, h, w, ip, ie, xdot, xdot_old, sx, stau)

    def fdeltax(self, deltax: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltax
        :type deltax: float
        :param deltax: state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        """
        return _amici.Model_fdeltax(self, deltax, t, x, p, k, h, ie, xdot, xdot_old)

    def fdeltaxB(self, deltaxB: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ie: "int", xdot: "amici::realtype const *", xdot_old: "amici::realtype const *", xB: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdeltaxB
        :type deltaxB: float
        :param deltaxB: adjoint state update
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ie: int
        :param ie: event index
        :type xdot: float
        :param xdot: new model right hand side
        :type xdot_old: float
        :param xdot_old: previous model right hand side
        :type xB: float
        :param xB: current adjoint state
        """
        return _amici.Model_fdeltaxB(self, deltaxB, t, x, p, k, h, ie, xdot, xdot_old, xB)

    def fdJrzdsigma(self, dJrzdsigma: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", rz: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJrzdsigma
        :type dJrzdsigma: float
        :param dJrzdsigma: Sensitivity of event penalization Jrz w.r.t. standard
            deviation sigmaz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type rz: float
        :param rz: model root output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.Model_fdJrzdsigma(self, dJrzdsigma, iz, p, k, rz, sigmaz)

    def fdJrzdz(self, dJrzdz: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", rz: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJrzdz
        :type dJrzdz: float
        :param dJrzdz: partial derivative of event penalization Jrz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type rz: float
        :param rz: model root output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.Model_fdJrzdz(self, dJrzdz, iz, p, k, rz, sigmaz)

    def fdJydsigma(self, dJydsigma: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJydsigma
        :type dJydsigma: float
        :param dJydsigma: Sensitivity of time-resolved measurement negative
            log-likelihood Jy w.r.t. standard deviation sigmay
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurement at timepoint
        """
        return _amici.Model_fdJydsigma(self, dJydsigma, iy, p, k, y, sigmay, my)

    def fdJydy(self, dJydy: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJydy
        :type dJydy: float
        :param dJydy: partial derivative of time-resolved measurement negative
            log-likelihood Jy
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurement at timepoint
        """
        return _amici.Model_fdJydy(self, dJydy, iy, p, k, y, sigmay, my)

    def fdJzdsigma(self, dJzdsigma: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJzdsigma
        :type dJzdsigma: float
        :param dJzdsigma: Sensitivity of event measurement negative log-likelihood
            Jz w.r.t. standard deviation sigmaz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurement at timepoint
        """
        return _amici.Model_fdJzdsigma(self, dJzdsigma, iz, p, k, z, sigmaz, mz)

    def fdJzdz(self, dJzdz: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdJzdz
        :type dJzdz: float
        :param dJzdz: partial derivative of event measurement negative
            log-likelihood Jz
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurement at timepoint
        """
        return _amici.Model_fdJzdz(self, dJzdz, iz, p, k, z, sigmaz, mz)

    def fdrzdp(self, drzdp: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fdrzdp
        :type drzdp: float
        :param drzdp: partial derivative of root output rz w.r.t. model parameters
            p
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        """
        return _amici.Model_fdrzdp(self, drzdp, ie, t, x, p, k, h, ip)

    def fdrzdx(self, drzdx: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdrzdx
        :type drzdx: float
        :param drzdx: partial derivative of root output rz w.r.t. model states x
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.Model_fdrzdx(self, drzdx, ie, t, x, p, k, h)

    def fdsigmaydp(self, dsigmaydp: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsigmay
        :type dsigmaydp: float
        :param dsigmaydp: partial derivative of standard deviation of measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.Model_fdsigmaydp(self, dsigmaydp, t, p, k, ip)

    def fdsigmazdp(self, dsigmazdp: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsigmaz
        :type dsigmazdp: float
        :param dsigmazdp: partial derivative of standard deviation of event
            measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.Model_fdsigmazdp(self, dsigmazdp, t, p, k, ip)

    def fdwdp(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific sparse implementation of dwdp
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        :type stcl: float
        :param stcl: sensitivities of total abundances for conservations laws

        |

        *Overload 2:*

        Model specific sensitivity implementation of dwdp
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        :type stcl: float
        :param stcl: sensitivities of total abundances for conservations laws
        :type ip: int
        :param ip: sensitivity parameter index
        """
        return _amici.Model_fdwdp(self, *args)

    def fdwdp_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.Model_fdwdp_colptrs(self, indexptrs)

    def fdwdp_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdp, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.Model_fdwdp_rowvals(self, indexvals)

    def fdwdx(self, dwdx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", tcl: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of dwdx, data part
        :type dwdx: float
        :param dwdx: Recurring terms in xdot, state derivative
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: vector with helper variables
        :type tcl: float
        :param tcl: total abundances for conservations laws
        """
        return _amici.Model_fdwdx(self, dwdx, t, x, p, k, h, w, tcl)

    def fdwdx_colptrs(self, indexptrs: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, column pointers
        :type indexptrs: sunindextype
        :param indexptrs: column pointers
        """
        return _amici.Model_fdwdx_colptrs(self, indexptrs)

    def fdwdx_rowvals(self, indexvals: "sunindextype *") -> "void":
        r"""
        Model specific implementation for dwdx, row values
        :type indexvals: sunindextype
        :param indexvals: row values
        """
        return _amici.Model_fdwdx_rowvals(self, indexvals)

    def fdydp(self, dydp: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int", w: "amici::realtype const *", dwdp: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdydp
        :type dydp: float
        :param dydp: partial derivative of observables y w.r.t. model parameters p
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        :type w: float
        :param w: repeating elements vector
        :type dwdp: float
        :param dwdp: Recurring terms in xdot, parameter derivative
        """
        return _amici.Model_fdydp(self, dydp, t, x, p, k, h, ip, w, dwdp)

    def fdydx(self, dydx: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *", dwdx: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdydx
        :type dydx: float
        :param dydx: partial derivative of observables y w.r.t. model states x
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        :type dwdx: float
        :param dwdx: Recurring terms in xdot, state derivative
        """
        return _amici.Model_fdydx(self, dydx, t, x, p, k, h, w, dwdx)

    def fdzdp(self, dzdp: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fdzdp
        :type dzdp: float
        :param dzdp: partial derivative of event-resolved output z w.r.t. model
            parameters p
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: parameter index w.r.t. which the derivative is requested
        """
        return _amici.Model_fdzdp(self, dzdp, ie, t, x, p, k, h, ip)

    def fdzdx(self, dzdx: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fdzdx
        :type dzdx: float
        :param dzdx: partial derivative of event-resolved output z w.r.t. model
            states x
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.Model_fdzdx(self, dzdx, ie, t, x, p, k, h)

    def fJrz(self, nllh: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJrz
        :type nllh: float
        :param nllh: regularization for event measurements z
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        """
        return _amici.Model_fJrz(self, nllh, iz, p, k, z, sigmaz)

    def fJy(self, nllh: "amici::realtype *", iy: "int", p: "amici::realtype const *", k: "amici::realtype const *", y: "amici::realtype const *", sigmay: "amici::realtype const *", my: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJy
        :type nllh: float
        :param nllh: negative log-likelihood for measurements y
        :type iy: int
        :param iy: output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type y: float
        :param y: model output at timepoint
        :type sigmay: float
        :param sigmay: measurement standard deviation at timepoint
        :type my: float
        :param my: measurements at timepoint
        """
        return _amici.Model_fJy(self, nllh, iy, p, k, y, sigmay, my)

    def fJz(self, nllh: "amici::realtype *", iz: "int", p: "amici::realtype const *", k: "amici::realtype const *", z: "amici::realtype const *", sigmaz: "amici::realtype const *", mz: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fJz
        :type nllh: float
        :param nllh: negative log-likelihood for event measurements z
        :type iz: int
        :param iz: event output index
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type z: float
        :param z: model event output at timepoint
        :type sigmaz: float
        :param sigmaz: event measurement standard deviation at timepoint
        :type mz: float
        :param mz: event measurements at timepoint
        """
        return _amici.Model_fJz(self, nllh, iz, p, k, z, sigmaz, mz)

    def frz(self, rz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of frz
        :type rz: float
        :param rz: value of root function at current timepoint (non-output events
            not included)
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.Model_frz(self, rz, ie, t, x, p, k, h)

    def fsigmay(self, sigmay: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fsigmay
        :type sigmay: float
        :param sigmay: standard deviation of measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.Model_fsigmay(self, sigmay, t, p, k)

    def fsigmaz(self, sigmaz: "amici::realtype *", t: "amici::realtype const", p: "amici::realtype const *", k: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fsigmaz
        :type sigmaz: float
        :param sigmaz: standard deviation of event measurements
        :type t: float
        :param t: current time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        """
        return _amici.Model_fsigmaz(self, sigmaz, t, p, k)

    def fsrz(self, srz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsrz
        :type srz: float
        :param srz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type sx: float
        :param sx: current state sensitivity
        :type h: float
        :param h: heavyside vector
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.Model_fsrz(self, srz, ie, t, x, p, k, h, sx, ip)

    def fstau(self, stau: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int", ie: "int") -> "void":
        r"""
        Model specific implementation of fstau
        :type stau: float
        :param stau: total derivative of event timepoint
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        :type ie: int
        :param ie: event index
        """
        return _amici.Model_fstau(self, stau, t, x, p, k, h, sx, ip, ie)

    def fsz(self, sz: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", sx: "amici::realtype const *", ip: "int") -> "void":
        r"""
        Model specific implementation of fsz
        :type sz: float
        :param sz: Sensitivity of rz, total derivative
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type sx: float
        :param sx: current state sensitivity
        :type ip: int
        :param ip: sensitivity index
        """
        return _amici.Model_fsz(self, sz, ie, t, x, p, k, h, sx, ip)

    def fw(self, w: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", tcl: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fw
        :type w: float
        :param w: Recurring terms in xdot
        :type t: float
        :param t: timepoint
        :type x: float
        :param x: vector with the states
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constants vector
        :type h: float
        :param h: heavyside vector
        :type tcl: float
        :param tcl: total abundances for conservations laws
        """
        return _amici.Model_fw(self, w, t, x, p, k, h, tcl)

    def fy(self, y: "amici::realtype *", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *", w: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fy
        :type y: float
        :param y: model output at current timepoint
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        :type w: float
        :param w: repeating elements vector
        """
        return _amici.Model_fy(self, y, t, x, p, k, h, w)

    def fz(self, z: "amici::realtype *", ie: "int", t: "amici::realtype const", x: "amici::realtype const *", p: "amici::realtype const *", k: "amici::realtype const *", h: "amici::realtype const *") -> "void":
        r"""
        Model specific implementation of fz
        :type z: float
        :param z: value of event output
        :type ie: int
        :param ie: event index
        :type t: float
        :param t: current time
        :type x: float
        :param x: current state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type h: float
        :param h: heavyside vector
        """
        return _amici.Model_fz(self, z, ie, t, x, p, k, h)

    def nplist(self) -> "int":
        r"""
        Number of parameters wrt to which sensitivities are computed
        :rtype: int
        :return: length of sensitivity index vector
        """
        return _amici.Model_nplist(self)

    def np(self) -> "int":
        r"""
        Total number of model parameters
        :rtype: int
        :return: length of parameter vector
        """
        return _amici.Model_np(self)

    def nk(self) -> "int":
        r"""
        Number of constants
        :rtype: int
        :return: length of constant vector
        """
        return _amici.Model_nk(self)

    def ncl(self) -> "int":
        r"""
        Number of conservation laws
        :rtype: int
        :return: difference between nx_rdata and nx_solver
        """
        return _amici.Model_ncl(self)

    def nx_reinit(self) -> "int":
        r"""
        Number of solver states subject to reinitialization
        :rtype: int
        :return: model member nx_solver_reinit
        """
        return _amici.Model_nx_reinit(self)

    def k(self) -> "double const *":
        r"""
        Fixed parameters
        :rtype: float
        :return: pointer to constants array
        """
        return _amici.Model_k(self)

    def nMaxEvent(self) -> "int":
        r"""
        Get nmaxevent
        :rtype: int
        :return: maximum number of events that may occur for each type
        """
        return _amici.Model_nMaxEvent(self)

    def setNMaxEvent(self, nmaxevent: "int") -> "void":
        r"""
        Set nmaxevent
        :type nmaxevent: int
        :param nmaxevent: maximum number of events that may occur for each type
        """
        return _amici.Model_setNMaxEvent(self, nmaxevent)

    def nt(self) -> "int":
        r"""
        Get number of timepoints
        :rtype: int
        :return: number of timepoints
        """
        return _amici.Model_nt(self)

    def getParameterScale(self) -> "std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > > const &":
        r"""
        Get ParameterScale for each parameter
        :rtype: std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >
        :return: vector of parameter scale
        """
        return _amici.Model_getParameterScale(self)

    def setParameterScale(self, *args) -> "void":
        r"""
        *Overload 1:*

        Set ParameterScale for each parameter, resets initial state
        sensitivities
        :type pscale: int
        :param pscale: scalar parameter scale for all parameters

        |

        *Overload 2:*

        Set ParameterScale for each parameter, resets initial state
        sensitivities
        :type pscaleVec: std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >
        :param pscaleVec: vector of parameter scales
        """
        return _amici.Model_setParameterScale(self, *args)

    def getUnscaledParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Gets parameters with transformation according to ParameterScale
        applied
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: unscaled parameters
        """
        return _amici.Model_getUnscaledParameters(self)

    def getParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Get the parameter vector
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: The user-set parameters (see also getUnscaledParameters)
        """
        return _amici.Model_getParameters(self)

    def getParameterById(self, par_id: "std::string const &") -> "amici::realtype":
        r"""
        Get value of first model parameter with the specified id
        :type par_id: string
        :param par_id: parameter id
        :rtype: float
        :return: parameter value
        """
        return _amici.Model_getParameterById(self, par_id)

    def getParameterByName(self, par_name: "std::string const &") -> "amici::realtype":
        r"""
        Get value of first model parameter with the specified name,
        :type par_name: string
        :param par_name: parameter name
        :rtype: float
        :return: parameter value
        """
        return _amici.Model_getParameterByName(self, par_name)

    def setParameters(self, p: "DoubleVector") -> "void":
        r"""
        Sets the parameter vector
        :type p: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param p: vector of parameters
        """
        return _amici.Model_setParameters(self, p)

    def setParameterById(self, *args) -> "void":
        r"""
        *Overload 1:*

        Sets model parameters according to the parameter IDs and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters IDs and values
        :type ignoreErrors: boolean
        :param ignoreErrors: Ignore errors such as parameter IDs in p which are
            not model parameters

        |

        *Overload 2:*

        Set value of first model parameter with the specified id
        :type par_id: string
        :param par_id: parameter id
        :type value: float
        :param value: parameter value
        """
        return _amici.Model_setParameterById(self, *args)

    def setParametersByIdRegex(self, par_id_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set all values of model parameters with ids matching the specified
        regex
        :type par_id_regex: string
        :param par_id_regex: parameter id regex
        :type value: float
        :param value: parameter value
        :rtype: int
        :return: number of parameter ids that matched the regex
        """
        return _amici.Model_setParametersByIdRegex(self, par_id_regex, value)

    def setParameterByName(self, *args) -> "void":
        r"""
        *Overload 1:*

        Set value of first model parameter with the specified name
        :type par_name: string
        :param par_name: parameter name
        :type value: float
        :param value: parameter value

        |

        *Overload 2:*

        Sets model parameters according to the parameter name and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters names and values
        :type ignoreErrors: boolean
        :param ignoreErrors: Ignore errors such as parameter names in p which are
            not model parameters

        |

        *Overload 3:*

        Sets model parameters according to the parameter name and mapped
        values.
        :type p: std::map< std::string,amici::realtype,std::less< std::string >,std::allocator< std::pair< std::string const,amici::realtype > > >
        :param p: map of parameters names and values
        :param ignoreErrors: Ignore errors such as parameter names in p which are
            not model parameters
        """
        return _amici.Model_setParameterByName(self, *args)

    def setParametersByNameRegex(self, par_name_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set all values of all model parameters with names matching the
        specified regex
        :type par_name_regex: string
        :param par_name_regex: parameter name regex
        :type value: float
        :param value: parameter value
        :rtype: int
        :return: number of fixed parameter names that matched the regex
        """
        return _amici.Model_setParametersByNameRegex(self, par_name_regex, value)

    def getFixedParameters(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Gets the fixedParameter member
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: vector of fixed parameters
        """
        return _amici.Model_getFixedParameters(self)

    def getFixedParameterById(self, par_id: "std::string const &") -> "amici::realtype":
        r"""
        Get value of fixed parameter with the specified Id
        :type par_id: string
        :param par_id: parameter id
        :rtype: float
        :return: parameter value
        """
        return _amici.Model_getFixedParameterById(self, par_id)

    def getFixedParameterByName(self, par_name: "std::string const &") -> "amici::realtype":
        r"""
        Get value of fixed parameter with the specified name, if multiple
        parameters have the same name, the first parameter with matching name is
        returned
        :type par_name: string
        :param par_name: parameter name
        :rtype: float
        :return: parameter value
        """
        return _amici.Model_getFixedParameterByName(self, par_name)

    def setFixedParameters(self, k: "DoubleVector") -> "void":
        r"""
        Sets the fixedParameter member
        :type k: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param k: vector of fixed parameters
        """
        return _amici.Model_setFixedParameters(self, k)

    def setFixedParameterById(self, par_id: "std::string const &", value: "amici::realtype") -> "void":
        r"""
        Set value of first fixed parameter with the specified id
        :type par_id: string
        :param par_id: fixed parameter id
        :type value: float
        :param value: fixed parameter value
        """
        return _amici.Model_setFixedParameterById(self, par_id, value)

    def setFixedParametersByIdRegex(self, par_id_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set values of all fixed parameters with the id matching the
        specified regex
        :type par_id_regex: string
        :param par_id_regex: fixed parameter name regex
        :type value: float
        :param value: fixed parameter value
        :rtype: int
        :return: number of fixed parameter ids that matched the regex
        """
        return _amici.Model_setFixedParametersByIdRegex(self, par_id_regex, value)

    def setFixedParameterByName(self, par_name: "std::string const &", value: "amici::realtype") -> "void":
        r"""
        Set value of first fixed parameter with the specified name,
        :type par_name: string
        :param par_name: fixed parameter id
        :type value: float
        :param value: fixed parameter value
        """
        return _amici.Model_setFixedParameterByName(self, par_name, value)

    def setFixedParametersByNameRegex(self, par_name_regex: "std::string const &", value: "amici::realtype") -> "int":
        r"""
        Set value of all fixed parameters with name matching the specified
        regex,
        :type par_name_regex: string
        :param par_name_regex: fixed parameter name regex
        :type value: float
        :param value: fixed parameter value
        :rtype: int
        :return: number of fixed parameter names that matched the regex
        """
        return _amici.Model_setFixedParametersByNameRegex(self, par_name_regex, value)

    def getName(self) -> "std::string":
        r"""
        Returns the model name
        :rtype: string
        :return: model name
        """
        return _amici.Model_getName(self)

    def hasParameterNames(self) -> "bool":
        r"""
        Reports whether the model has parameter names set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether parameter names were set
        """
        return _amici.Model_hasParameterNames(self)

    def getParameterNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.Model_getParameterNames(self)

    def hasStateNames(self) -> "bool":
        r"""
        Reports whether the model has state names set. Also returns true
        if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether state names were set
        """
        return _amici.Model_hasStateNames(self)

    def getStateNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the model states
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.Model_getStateNames(self)

    def hasFixedParameterNames(self) -> "bool":
        r"""
        Reports whether the model has fixed parameter names set. Also
        returns true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether fixed parameter names were set
        """
        return _amici.Model_hasFixedParameterNames(self)

    def getFixedParameterNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the fixed model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.Model_getFixedParameterNames(self)

    def hasObservableNames(self) -> "bool":
        r"""
        Reports whether the model has observable names set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether observabke names were set
        """
        return _amici.Model_hasObservableNames(self)

    def getObservableNames(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get names of the observables
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the names
        """
        return _amici.Model_getObservableNames(self)

    def hasParameterIds(self) -> "bool":
        r"""
        Reports whether the model has parameter ids set. Also returns true
        if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether parameter ids were set
        """
        return _amici.Model_hasParameterIds(self)

    def getParameterIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.Model_getParameterIds(self)

    def hasStateIds(self) -> "bool":
        r"""
        Reports whether the model has state ids set. Also returns true if
        the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether state ids were set
        """
        return _amici.Model_hasStateIds(self)

    def getStateIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the model states
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.Model_getStateIds(self)

    def hasFixedParameterIds(self) -> "bool":
        r"""
        Reports whether the model has fixed parameter ids set. Also
        returns true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether fixed parameter ids were set
        """
        return _amici.Model_hasFixedParameterIds(self)

    def getFixedParameterIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the fixed model parameters
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.Model_getFixedParameterIds(self)

    def hasObservableIds(self) -> "bool":
        r"""
        Reports whether the model has observable ids set. Also returns
        true if the number of corresponding variables is just zero.
        :rtype: boolean
        :return: boolean indicating whether observale ids were set
        """
        return _amici.Model_hasObservableIds(self)

    def getObservableIds(self) -> "std::vector< std::string,std::allocator< std::string > >":
        r"""
        Get ids of the observables
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: the ids
        """
        return _amici.Model_getObservableIds(self)

    def getTimepoints(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > > const &":
        r"""
        Get the timepoint vector
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: timepoint vector
        """
        return _amici.Model_getTimepoints(self)

    def getTimepoint(self, it: "int") -> "amici::realtype":
        r"""
        get simulation timepoint for time index it
        :type it: int
        :param it: time index
        :rtype: float
        :return: t timepoint
        """
        return _amici.Model_getTimepoint(self, it)

    def setTimepoints(self, ts: "DoubleVector") -> "void":
        r"""
        Set the timepoint vector
        :type ts: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param ts: timepoint vector
        """
        return _amici.Model_setTimepoints(self, ts)

    def t0(self) -> "double":
        r"""
        get simulation start time
        :rtype: float
        :return: simulation start time
        """
        return _amici.Model_t0(self)

    def setT0(self, t0: "double") -> "void":
        r"""
        set simulation start time
        :type t0: float
        :param t0: simulation start time
        """
        return _amici.Model_setT0(self, t0)

    def getStateIsNonNegative(self) -> "std::vector< bool,std::allocator< bool > > const &":
        r"""
        gets flags indicating whether states should be treated as
        non-negative
        :rtype: std::vector< bool,std::allocator< bool > >
        :return: vector of flags
        """
        return _amici.Model_getStateIsNonNegative(self)

    def setStateIsNonNegative(self, stateIsNonNegative: "BoolVector") -> "void":
        r"""
        sets flags indicating whether states should be treated as
        non-negative
        :type stateIsNonNegative: std::vector< bool,std::allocator< bool > >
        :param stateIsNonNegative: vector of flags
        """
        return _amici.Model_setStateIsNonNegative(self, stateIsNonNegative)

    def setAllStatesNonNegative(self) -> "void":
        r"""
        sets flags indicating that all states should be treated as
        non-negative
        """
        return _amici.Model_setAllStatesNonNegative(self)

    def getParameterList(self) -> "std::vector< int,std::allocator< int > > const &":
        r"""
        Get the list of parameters for which sensitivities are computed
        :rtype: std::vector< int,std::allocator< int > >
        :return: list of parameter indices
        """
        return _amici.Model_getParameterList(self)

    def plist(self, pos: "int") -> "int":
        r"""
        entry in parameter list
        :type pos: int
        :param pos: index
        :rtype: int
        :return: entry
        """
        return _amici.Model_plist(self, pos)

    def setParameterList(self, plist: "IntVector") -> "void":
        r"""
        Set the list of parameters for which sensitivities are computed,
        resets initial state sensitivities
        :type plist: std::vector< int,std::allocator< int > >
        :param plist: list of parameter indices
        """
        return _amici.Model_setParameterList(self, plist)

    def getInitialStates(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > >":
        r"""
        Get the initial states
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: initial state vector
        """
        return _amici.Model_getInitialStates(self)

    def setInitialStates(self, x0: "DoubleVector") -> "void":
        r"""
        Set the initial states
        :type x0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param x0: initial state vector
        """
        return _amici.Model_setInitialStates(self, x0)

    def hasCustomInitialStates(self) -> "bool":
        r"""
        Returns whether custom initial states have been set
        :rtype: boolean
        :return: True if has custom initial states, otherwise false
        """
        return _amici.Model_hasCustomInitialStates(self)

    def getInitialStateSensitivities(self) -> "std::vector< amici::realtype,std::allocator< amici::realtype > >":
        r"""
        Get the initial states sensitivities
        :rtype: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :return: vector of initial state sensitivities
        """
        return _amici.Model_getInitialStateSensitivities(self)

    def setInitialStateSensitivities(self, sx0: "DoubleVector") -> "void":
        r"""
        Set the initial state sensitivities
        :type sx0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sx0: vector of initial state sensitivities with chainrule applied.
            This could be a slice of ReturnData::sx or ReturnData::sx0
        """
        return _amici.Model_setInitialStateSensitivities(self, sx0)

    def hasCustomInitialStateSensitivities(self) -> "bool":
        r"""
        Returns whether custom initial state sensitivitiess have been set
        :rtype: boolean
        :return: True if has custom initial state sensitivitiess, otherwise false
        """
        return _amici.Model_hasCustomInitialStateSensitivities(self)

    def setUnscaledInitialStateSensitivities(self, sx0: "DoubleVector") -> "void":
        r"""
        Set the initial state sensitivities
        :type sx0: std::vector< amici::realtype,std::allocator< amici::realtype > >
        :param sx0: vector of initial state sensitivities without chainrule
            applied. This could be the readin from a model.sx0data saved to hdf5.
        """
        return _amici.Model_setUnscaledInitialStateSensitivities(self, sx0)

    def setSteadyStateSensitivityMode(self, mode: "amici::SteadyStateSensitivityMode") -> "void":
        r"""
        Sets the mode how sensitivities are computed in the steadystate
        simulation
        :type mode: int
        :param mode: steadyStateSensitivityMode
        """
        return _amici.Model_setSteadyStateSensitivityMode(self, mode)

    def getSteadyStateSensitivityMode(self) -> "amici::SteadyStateSensitivityMode":
        r"""
        Gets the mode how sensitivities are computed in the steadystate
        simulation
        :rtype: int
        :return: flag value
        """
        return _amici.Model_getSteadyStateSensitivityMode(self)

    def setReinitializeFixedParameterInitialStates(self, flag: "bool") -> "void":
        r"""
        Set whether initial states depending on fixedParmeters are to be
        reinitialized after preequilibration and presimulation
        :type flag: boolean
        :param flag: true/false
        """
        return _amici.Model_setReinitializeFixedParameterInitialStates(self, flag)

    def getReinitializeFixedParameterInitialStates(self) -> "bool":
        r"""
        Get whether initial states depending on fixedParmeters are to be
        reinitialized after preequilibration and presimulation
        :rtype: boolean
        :return: flag true/false
        """
        return _amici.Model_getReinitializeFixedParameterInitialStates(self)

    def requireSensitivitiesForAllParameters(self) -> "void":
        r"""
        Require computation of sensitivities for all parameters p [0..np[
        in natural order, resets initial state sensitivities
        """
        return _amici.Model_requireSensitivitiesForAllParameters(self)

    def getObservableSigma(self, sigmay: "gsl::span< amici::realtype >", it: "int const", edata: "ExpData") -> "void":
        r"""
        Time-resolved observable standard deviations
        :type sigmay: gsl::span< amici::realtype >
        :param sigmay: buffer (dimension: ny)
        :type it: int
        :param it: timepoint index
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.Model_getObservableSigma(self, sigmay, it, edata)

    def getObservableSigmaSensitivity(self, ssigmay: "gsl::span< amici::realtype >", it: "int const", edata: "ExpData") -> "void":
        r"""
        Sensitivity of time-resolved observable standard deviation, total
        derivative (can be used with both adjoint and forward sensitivity)
        :type ssigmay: gsl::span< amici::realtype >
        :param ssigmay: buffer (dimension: ny x nplist, row-major)
        :type it: int
        :param it: timepoint index
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.Model_getObservableSigmaSensitivity(self, ssigmay, it, edata)

    def getUnobservedEventSensitivity(self, sz: "gsl::span< amici::realtype >", ie: "int const") -> "void":
        r"""
        Sensitivity of z at final timepoint (ignores sensitivity of
        timepoint), total derivative
        :type sz: gsl::span< amici::realtype >
        :param sz: output buffer (dimension: nz x nplist, row-major)
        :type ie: int
        :param ie: event index
        """
        return _amici.Model_getUnobservedEventSensitivity(self, sz, ie)

    def getEventSigma(self, sigmaz: "gsl::span< amici::realtype >", ie: "int const", nroots: "int const", t: "amici::realtype const", edata: "ExpData") -> "void":
        r"""
        Event-resolved observable standard deviations
        :type sigmaz: gsl::span< amici::realtype >
        :param sigmaz: buffer (dimension: nz)
        :type ie: int
        :param ie: event index
        :type nroots: int
        :param nroots: event occurence
        :type t: float
        :param t: timepoint
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.Model_getEventSigma(self, sigmaz, ie, nroots, t, edata)

    def getEventSigmaSensitivity(self, ssigmaz: "gsl::span< amici::realtype >", ie: "int const", nroots: "int const", t: "amici::realtype const", edata: "ExpData") -> "void":
        r"""
        Sensitivities of event-resolved observable standard deviations,
        total derivative (only forward sensitivities)
        :type ssigmaz: gsl::span< amici::realtype >
        :param ssigmaz: buffer (dimension: nz x nplist, row-major)
        :type ie: int
        :param ie: event index
        :type nroots: int
        :param nroots: event occurence
        :type t: float
        :param t: timepoint
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data instance (optional, pass
            nullptr to ignore)
        """
        return _amici.Model_getEventSigmaSensitivity(self, ssigmaz, ie, nroots, t, edata)

    def updateHeaviside(self, rootsfound: "IntVector") -> "void":
        r"""
        Update the heaviside variables h on event occurences

        :type rootsfound: std::vector< int,std::allocator< int > >
        :param rootsfound: provides the direction of the zero-crossing, so adding
            it will give the right update to the heaviside variables (zero if no root
            was found)
        """
        return _amici.Model_updateHeaviside(self, rootsfound)

    def updateHeavisideB(self, rootsfound: "int const *") -> "void":
        r"""
        Updates the heaviside variables h on event occurences in the
        backward problem
        :type rootsfound: int
        :param rootsfound: provides the direction of the zero-crossing, so adding
            it will give the right update to the heaviside variables (zero if no root
            was found)
        """
        return _amici.Model_updateHeavisideB(self, rootsfound)

    def checkFinite(self, array: "gsl::span< amici::realtype const >", fun: "char const *") -> "int":
        r"""
        Check if the given array has only finite elements. If not try to
        give hints by which other fields this could be caused.

        :type array: gsl::span< amici::realtype const >
        :param array: arrays of values
        :type fun: string
        :param fun: name of the fucntion that generated the values
        :rtype: int
        :return: AMICI_RECOVERABLE_ERROR if a NaN/Inf value was found,
            AMICI_SUCCESS otherwise
        """
        return _amici.Model_checkFinite(self, array, fun)

    def setAlwaysCheckFinite(self, alwaysCheck: "bool") -> "void":
        r"""
        Set if the result of every call to Model::f* should be checked for
        finiteness
        :type alwaysCheck: boolean
        :param alwaysCheck:
        """
        return _amici.Model_setAlwaysCheckFinite(self, alwaysCheck)

    def getAlwaysCheckFinite(self) -> "bool":
        r"""
        Get setting of whether the result of every call to Model::f*
        should be checked for finiteness
        :rtype: boolean
        :return: that
        """
        return _amici.Model_getAlwaysCheckFinite(self)

    def fx0(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fx0
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector

        |

        *Overload 2:*

        Initial states
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.Model_fx0(self, *args)

    def fx0_fixedParameters(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fx0_fixedParameters
        :type x0: float
        :param x0: initial state
        :type t: float
        :param t: initial time
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector

        |

        *Overload 2:*

        Sets only those initial states that are specified via
        fixedParmeters
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.Model_fx0_fixedParameters(self, *args)

    def fsx0(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fsx0
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index

        |

        *Overload 2:*

        Initial value for initial state sensitivities
        :type sx: AmiVectorArray
        :param sx: pointer to state sensitivity variables
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.Model_fsx0(self, *args)

    def fsx0_fixedParameters(self, *args) -> "void":
        r"""
        *Overload 1:*

        Model specific implementation of fsx0_fixedParameters
        :type sx0: float
        :param sx0: initial state sensitivities
        :type t: float
        :param t: initial time
        :type x0: float
        :param x0: initial state
        :type p: float
        :param p: parameter vector
        :type k: float
        :param k: constant vector
        :type ip: int
        :param ip: sensitivity index

        |

        *Overload 2:*

        Sets only those initial states sensitivities that are affected
        from fx0 fixedParmeters
        :type sx: AmiVectorArray
        :param sx: pointer to state sensitivity variables
        :type x: AmiVector
        :param x: pointer to state variables
        """
        return _amici.Model_fsx0_fixedParameters(self, *args)

    def fsdx0(self) -> "void":
        r"""
        Sensitivity of derivative initial states sensitivities sdx0 (only
         necessary for DAEs)
        """
        return _amici.Model_fsdx0(self)
    nx_rdata = property(_amici.Model_nx_rdata_get, _amici.Model_nx_rdata_set, doc=r""" number of states""")
    nxtrue_rdata = property(_amici.Model_nxtrue_rdata_get, _amici.Model_nxtrue_rdata_set, doc=r""" number of states in the unaugmented system""")
    nx_solver = property(_amici.Model_nx_solver_get, _amici.Model_nx_solver_set, doc=r""" number of states with conservation laws applied""")
    nxtrue_solver = property(_amici.Model_nxtrue_solver_get, _amici.Model_nxtrue_solver_set, doc=r"""
    number of states in the unaugmented system with conservation laws
    applied
    """)
    nx_solver_reinit = property(_amici.Model_nx_solver_reinit_get, _amici.Model_nx_solver_reinit_set, doc=r""" number of solver states subject to reinitialization""")
    ny = property(_amici.Model_ny_get, _amici.Model_ny_set, doc=r""" number of observables""")
    nytrue = property(_amici.Model_nytrue_get, _amici.Model_nytrue_set, doc=r""" number of observables in the unaugmented system""")
    nz = property(_amici.Model_nz_get, _amici.Model_nz_set, doc=r""" number of event outputs""")
    nztrue = property(_amici.Model_nztrue_get, _amici.Model_nztrue_set, doc=r""" number of event outputs in the unaugmented system""")
    ne = property(_amici.Model_ne_get, _amici.Model_ne_set, doc=r""" number of events""")
    nw = property(_amici.Model_nw_get, _amici.Model_nw_set, doc=r""" number of common expressions""")
    ndwdx = property(_amici.Model_ndwdx_get, _amici.Model_ndwdx_set, doc=r""" number of derivatives of common expressions wrt x""")
    ndwdp = property(_amici.Model_ndwdp_get, _amici.Model_ndwdp_set, doc=r""" number of derivatives of common expressions wrt p""")
    ndxdotdw = property(_amici.Model_ndxdotdw_get, _amici.Model_ndxdotdw_set, doc=r""" number of nonzero entries in dxdotdw""")
    ndJydy = property(_amici.Model_ndJydy_get, _amici.Model_ndJydy_set, doc=r""" number of nonzero entries in dJydy""")
    nnz = property(_amici.Model_nnz_get, _amici.Model_nnz_set, doc=r""" number of nonzero entries in jacobian""")
    nJ = property(_amici.Model_nJ_get, _amici.Model_nJ_set, doc=r""" dimension of the augmented objective function for 2nd order ASA""")
    ubw = property(_amici.Model_ubw_get, _amici.Model_ubw_set, doc=r""" upper bandwith of the jacobian""")
    lbw = property(_amici.Model_lbw_get, _amici.Model_lbw_set, doc=r""" lower bandwith of the jacobian""")
    pythonGenerated = property(_amici.Model_pythonGenerated_get, _amici.Model_pythonGenerated_set, doc=r""" flag indicating Matlab or python based model generation""")
    ndxdotdp_explicit = property(_amici.Model_ndxdotdp_explicit_get, _amici.Model_ndxdotdp_explicit_set, doc=r""" number of nonzero entries in ndxdotdp_explicit""")
    ndxdotdp_implicit = property(_amici.Model_ndxdotdp_implicit_get, _amici.Model_ndxdotdp_implicit_set, doc=r""" number of nonzero entries in ndxdotdp_implicit""")
    o2mode = property(_amici.Model_o2mode_get, _amici.Model_o2mode_set, doc=r"""
    flag indicating whether for sensi == AMICI_SENSI_ORDER_SECOND
    directional or full second order derivative will be computed
    """)
    idlist = property(_amici.Model_idlist_get, _amici.Model_idlist_set, doc=r""" flag array for DAE equations""")
    app = property(_amici.Model_app_get, _amici.Model_app_set, doc=r""" AMICI context""")

# Register Model in _amici:
_amici.Model_swigregister(Model)

def equals(*args) -> "bool":
    r"""
    *Overload 1:*

    Check equality of data members excluding solver memory
    :type a: :py:class:`Solver`
    :param a:
    :type b: :py:class:`Solver`
    :param b:
    :rtype: boolean
    :return: 

    |

    *Overload 2:*

    Check equality of data members
    :type a: :py:class:`Model`
    :param a: first model instance
    :type b: :py:class:`Model`
    :param b: second model instance
    :rtype: boolean
    :return: equality
    """
    return _amici.equals(*args)


def __eq__(*args) -> "bool":
    return _amici.__eq__(*args)
class Model_ODE(Model):
    r"""
    The Model class represents an AMICI ODE model.

    The model does not contain any data, but represents the state
    of the model at a specific time t. The states must not always be
    in sync, but may be updated asynchroneously.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fJvB(self, vB: "N_Vector", JvB: "N_Vector", t: "amici::realtype", x: "N_Vector", xB: "N_Vector") -> "void":
        r"""
        Implementation of fJvB at the N_Vector level
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type vB: N_Vector
        :param vB: Vector with which the Jacobian is multiplied
        :type JvB: N_Vector
        :param JvB: Vector to which the Jacobian vector product will be written
        """
        return _amici.Model_ODE_fJvB(self, vB, JvB, t, x, xB)

    def fxBdot(self, t: "amici::realtype", x: "N_Vector", xB: "N_Vector", xBdot: "N_Vector") -> "void":
        r"""
        Implementation of fxBdot at the N_Vector level
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type xBdot: N_Vector
        :param xBdot: Vector with the adjoint right hand side
        """
        return _amici.Model_ODE_fxBdot(self, t, x, xB, xBdot)

    def fqBdot(self, t: "amici::realtype", x: "N_Vector", xB: "N_Vector", qBdot: "N_Vector") -> "void":
        r"""
        Implementation of fqBdot at the N_Vector level
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type qBdot: N_Vector
        :param qBdot: Vector with the adjoint quadrature right hand side
        """
        return _amici.Model_ODE_fqBdot(self, t, x, xB, qBdot)

    def fqBdot_ss(self, t: "amici::realtype", xB: "N_Vector", qBdot: "N_Vector") -> "void":
        r"""
        Implementation of fqBdot for steady state case at the N_Vector level
        :type t: float
        :param t: timepoint
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type qBdot: N_Vector
        :param qBdot: Vector with the adjoint quadrature right hand side
        """
        return _amici.Model_ODE_fqBdot_ss(self, t, xB, qBdot)

    def fdxdotdw(self, t: "amici::realtype", x: "N_Vector const") -> "void":
        r"""
        Sensitivity of dx/dt wrt model parameters w
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        """
        return _amici.Model_ODE_fdxdotdw(self, t, x)

    def getSolver(self) -> "std::unique_ptr< amici::Solver >":
        return _amici.Model_ODE_getSolver(self)
    __swig_destroy__ = _amici.delete_Model_ODE

# Register Model_ODE in _amici:
_amici.Model_ODE_swigregister(Model_ODE)

class Model_DAE(Model):
    r"""
    The Model class represents an AMICI DAE model.

    The model does not contain any data, but represents the state
    of the model at a specific time t. The states must not always be
    in sync, but may be updated asynchroneously.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def fJvB(self, t: "amici::realtype", x: "N_Vector", dx: "N_Vector", xB: "N_Vector", dxB: "N_Vector", vB: "N_Vector", JvB: "N_Vector", cj: "amici::realtype") -> "void":
        r"""
        Matrix vector product of JB with a vector v (for iterative solvers)
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type dx: N_Vector
        :param dx: Vector with the derivative states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type dxB: N_Vector
        :param dxB: Vector with the adjoint derivative states
        :type vB: N_Vector
        :param vB: Vector with which the Jacobian is multiplied
        :type JvB: N_Vector
        :param JvB: Vector to which the Jacobian vector product will be
            written
        :type cj: float
        :param cj: scalar in Jacobian (inverse stepsize)
        """
        return _amici.Model_DAE_fJvB(self, t, x, dx, xB, dxB, vB, JvB, cj)

    def fxBdot(self, t: "amici::realtype", x: "N_Vector", dx: "N_Vector", xB: "N_Vector", dxB: "N_Vector", xBdot: "N_Vector") -> "void":
        r"""
        Right hand side of differential equation for adjoint state xB
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type dx: N_Vector
        :param dx: Vector with the derivative states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type dxB: N_Vector
        :param dxB: Vector with the adjoint derivative states
        :type xBdot: N_Vector
        :param xBdot: Vector with the adjoint right hand side
        """
        return _amici.Model_DAE_fxBdot(self, t, x, dx, xB, dxB, xBdot)

    def fqBdot(self, t: "amici::realtype", x: "N_Vector", dx: "N_Vector", xB: "N_Vector", dxB: "N_Vector", qBdot: "N_Vector") -> "void":
        r"""
        Right hand side of integral equation for quadrature states qB
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        :type dx: N_Vector
        :param dx: Vector with the derivative states
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type dxB: N_Vector
        :param dxB: Vector with the adjoint derivative states
        :type qBdot: N_Vector
        :param qBdot: Vector with the adjoint quadrature right hand side
        """
        return _amici.Model_DAE_fqBdot(self, t, x, dx, xB, dxB, qBdot)

    def fqBdot_ss(self, t: "amici::realtype", xB: "N_Vector", dxB: "N_Vector", qBdot: "N_Vector") -> "void":
        r"""
        Implementation of fqBdot for steady state at the N_Vector level
        :type t: float
        :param t: timepoint
        :type xB: N_Vector
        :param xB: Vector with the adjoint states
        :type dxB: N_Vector
        :param dxB: Vector with the adjoint derivative states
        :type qBdot: N_Vector
        :param qBdot: Vector with the adjoint quadrature right hand side
        """
        return _amici.Model_DAE_fqBdot_ss(self, t, xB, dxB, qBdot)

    def fM(self, t: "amici::realtype", x: "N_Vector const") -> "void":
        r"""
        Mass matrix for DAE systems
        :type t: float
        :param t: timepoint
        :type x: N_Vector
        :param x: Vector with the states
        """
        return _amici.Model_DAE_fM(self, t, x)

    def getSolver(self) -> "std::unique_ptr< amici::Solver >":
        return _amici.Model_DAE_getSolver(self)
    __swig_destroy__ = _amici.delete_Model_DAE

# Register Model_DAE in _amici:
_amici.Model_DAE_swigregister(Model_DAE)


def createOrOpenForWriting(hdf5filename: "std::string const &") -> "H5::H5File":
    r"""
    Open the given file for writing. Append if exists, create if not.
    :type hdf5filename: string
    :param hdf5filename:
    :rtype: H5::H5File
    :return: 
    """
    return _amici.createOrOpenForWriting(hdf5filename)

def writeSolverSettingsToHDF5(*args) -> "void":
    r"""
    *Overload 1:*

    Write solver options from HDF5 file
    :param hdf5Filenamehdf5: Name of HDF5 file
    :type solver: :py:class:`Solver`
    :param solver: solver to write options from
    :type hdf5Location: string
    :param hdf5Location: Path inside the HDF5 file

    |

    *Overload 2:*

    Write solver options from HDF5 file
    :type file: H5::H5File
    :param file: file handle to read from
    :type solver: :py:class:`Solver`
    :param solver: solver to write options from
    :type hdf5Location: string
    :param hdf5Location: Path inside the HDF5 file
    """
    return _amici.writeSolverSettingsToHDF5(*args)

def readSolverSettingsFromHDF5(*args) -> "void":
    r"""
    *Overload 1:*

    Read solver options from HDF5 file
    :type file: H5::H5File
    :param file: hdf5 file handle to read from
    :type solver: :py:class:`Solver`
    :param solver: solver to set options on
    :type datasetPath: string
    :param datasetPath: Path inside the HDF5 file

    |

    *Overload 2:*

    Read solver options from HDF5 file
    :type hdffile: string
    :param hdffile: Name of HDF5 file
    :type solver: :py:class:`Solver`
    :param solver: solver to set options on
    :type datasetPath: string
    :param datasetPath: Path inside the HDF5 file
    """
    return _amici.readSolverSettingsFromHDF5(*args)

def readModelDataFromHDF5(*args) -> "void":
    r"""
    *Overload 1:*

    Read model data from HDF5 file
    :type hdffile: string
    :param hdffile: Name of HDF5 file
    :type model: :py:class:`Model`
    :param model: model to set data on
    :type datasetPath: string
    :param datasetPath: Path inside the HDF5 file

    |

    *Overload 2:*

    Read model data from HDF5 file
    :param fileId: hdf5 file handle to read from
    :type model: :py:class:`Model`
    :param model: model to set data on
    :type datasetPath: string
    :param datasetPath: Path inside the HDF5 file
    """
    return _amici.readModelDataFromHDF5(*args)

def writeReturnData(*args) -> "void":
    return _amici.writeReturnData(*args)

def writeReturnDataDiagnosis(rdata: "ReturnData", file: "H5::H5File const &", hdf5Location: "std::string const &") -> "void":
    return _amici.writeReturnDataDiagnosis(rdata, file, hdf5Location)

def createGroup(file: "H5::H5File const &", groupPath: "std::string const &", recursively: "bool"=True) -> "void":
    r"""
    Create the given group and possibly parents
    :type file: H5::H5File
    :param file:
    :type groupPath: string
    :param groupPath:
    :type recursively: boolean
    :param recursively:
    """
    return _amici.createGroup(file, groupPath, recursively)

def readSimulationExpData(hdf5Filename: "std::string const &", hdf5Root: "std::string const &", model: "Model") -> "std::unique_ptr< amici::ExpData >":
    r"""
    readSimulationExpData reads AMICI experimental data from attributes in
    HDF5 file.
    :type hdf5Filename: string
    :param hdf5Filename: Name of HDF5 file
    :type hdf5Root: string
    :param hdf5Root: Path inside the HDF5 file to object having ExpData as
        attributes
    :type model: :py:class:`Model`
    :param model: The model for which data is to be read
    :rtype: std::unique_ptr< amici::ExpData >
    :return: 
    """
    return _amici.readSimulationExpData(hdf5Filename, hdf5Root, model)

def writeSimulationExpData(edata: "ExpData", file: "H5::H5File const &", hdf5Location: "std::string const &") -> "void":
    r"""
    writeSimulationExpData writes AMICI experimental data to attributes in
    HDF5 file.
    :type edata: :py:class:`ExpData`
    :param edata: The experimental data which is to be written
    :param hdf5Filename: Name of HDF5 file
    :param hdf5Root: Path inside the HDF5 file to object having ExpData as
        attributes
    """
    return _amici.writeSimulationExpData(edata, file, hdf5Location)

def attributeExists(*args) -> "bool":
    return _amici.attributeExists(*args)

def createAndWriteInt1DDataset(file: "H5::H5File const &", datasetName: "std::string const &", buffer: "gsl::span< int const >") -> "void":
    return _amici.createAndWriteInt1DDataset(file, datasetName, buffer)

def createAndWriteInt2DDataset(file: "H5::H5File const &", datasetName: "std::string const &", buffer: "gsl::span< int const >", m: "hsize_t", n: "hsize_t") -> "void":
    return _amici.createAndWriteInt2DDataset(file, datasetName, buffer, m, n)

def createAndWriteDouble1DDataset(file: "H5::H5File const &", datasetName: "std::string const &", buffer: "gsl::span< double const >") -> "void":
    return _amici.createAndWriteDouble1DDataset(file, datasetName, buffer)

def createAndWriteDouble2DDataset(file: "H5::H5File const &", datasetName: "std::string const &", buffer: "gsl::span< double const >", m: "hsize_t", n: "hsize_t") -> "void":
    return _amici.createAndWriteDouble2DDataset(file, datasetName, buffer, m, n)

def createAndWriteDouble3DDataset(file: "H5::H5File const &", datasetName: "std::string const &", buffer: "gsl::span< double const >", m: "hsize_t", n: "hsize_t", o: "hsize_t") -> "void":
    return _amici.createAndWriteDouble3DDataset(file, datasetName, buffer, m, n, o)

def getDoubleScalarAttribute(file: "H5::H5File const &", optionsObject: "std::string const &", attributeName: "std::string const &") -> "double":
    return _amici.getDoubleScalarAttribute(file, optionsObject, attributeName)

def getIntScalarAttribute(file: "H5::H5File const &", optionsObject: "std::string const &", attributeName: "std::string const &") -> "int":
    return _amici.getIntScalarAttribute(file, optionsObject, attributeName)

def getIntDataset1D(file: "H5::H5File const &", name: "std::string const &") -> "std::vector< int,std::allocator< int > >":
    return _amici.getIntDataset1D(file, name)

def getDoubleDataset1D(file: "H5::H5File const &", name: "std::string const &") -> "std::vector< double,std::allocator< double > >":
    return _amici.getDoubleDataset1D(file, name)

def getDoubleDataset2D(file: "H5::H5File const &", name: "std::string const &", m: "hsize_t &", n: "hsize_t &") -> "std::vector< double,std::allocator< double > >":
    return _amici.getDoubleDataset2D(file, name, m, n)

def getDoubleDataset3D(file: "H5::H5File const &", name: "std::string const &", m: "hsize_t &", n: "hsize_t &", o: "hsize_t &") -> "std::vector< double,std::allocator< double > >":
    return _amici.getDoubleDataset3D(file, name, m, n, o)

def locationExists(*args) -> "bool":
    return _amici.locationExists(*args)

def printErrMsgIdAndTxt(id: "std::string const &", message: "std::string const &") -> "void":
    r"""
    Prints a specified error message associated with the specified
    identifier

    :type id: string
    :param id: error identifier
    :type message: string
    :param message: error message
    """
    return _amici.printErrMsgIdAndTxt(id, message)

def printWarnMsgIdAndTxt(id: "std::string const &", message: "std::string const &") -> "void":
    r"""
    Prints a specified warning message associated with the specified
    identifier

    :type id: string
    :param id: warning identifier
    :type message: string
    :param message: warning message
    """
    return _amici.printWarnMsgIdAndTxt(id, message)
class AmiciApplication(object):
    r"""
    Main class for making calls to AMICI.

    This class is used to provide separate AMICI contexts, for example, for use
    in multi-threaded applications where different threads want to use AMICI with
    different settings, such custom logging functions.

    NOTE: For this moment, the context object needs to be set manually to any
    Model and Solver object. If not set, they will use the default output
    channel.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _amici.AmiciApplication_swiginit(self, _amici.new_AmiciApplication())

    def runAmiciSimulation(self, solver: "Solver", edata: "ExpData", model: "Model", rethrow: "bool"=False) -> "std::unique_ptr< amici::ReturnData >":
        r"""
        Core integration routine. Initializes the solver and runs the
        forward and backward problem.

        :type solver: :py:class:`Solver`
        :param solver: Solver instance
        :type edata: :py:class:`ExpData`
        :param edata: pointer to experimental data object
        :type model: :py:class:`Model`
        :param model: model specification object
        :type rethrow: boolean
        :param rethrow: rethrow integration exceptions?
        :rtype: std::unique_ptr< amici::ReturnData >
        :return: rdata pointer to return data object
        """
        return _amici.AmiciApplication_runAmiciSimulation(self, solver, edata, model, rethrow)

    def runAmiciSimulations(self, solver: "Solver", edatas: "ExpDataPtrVector", model: "Model", failfast: "bool", num_threads: "int") -> "std::vector< std::unique_ptr< amici::ReturnData >,std::allocator< std::unique_ptr< amici::ReturnData > > >":
        r"""
        Same as runAmiciSimulation, but for multiple ExpData instances.

        :type solver: :py:class:`Solver`
        :param solver: Solver instance
        :type edatas: std::vector< amici::ExpData *,std::allocator< amici::ExpData * > >
        :param edatas: experimental data objects
        :type model: :py:class:`Model`
        :param model: model specification object
        :type failfast: boolean
        :param failfast: flag to allow early termination
        :type num_threads: int
        :param num_threads: number of threads for parallel execution
        :rtype: std::vector< std::unique_ptr< amici::ReturnData >,std::allocator< std::unique_ptr< amici::ReturnData > > >
        :return: vector of pointers to return data objects
        """
        return _amici.AmiciApplication_runAmiciSimulations(self, solver, edatas, model, failfast, num_threads)
    warning = property(_amici.AmiciApplication_warning_get, _amici.AmiciApplication_warning_set, doc=r""" Function to process warnings""")
    error = property(_amici.AmiciApplication_error_get, _amici.AmiciApplication_error_set, doc=r""" Function to process errors""")

    def checkFinite(self, array: "gsl::span< amici::realtype const >", fun: "char const *") -> "int":
        r"""
        Checks the values in an array for NaNs and Infs

        :type array: gsl::span< amici::realtype const >
        :param array: array
        :type fun: string
        :param fun: name of calling function
        :rtype: int
        :return: AMICI_RECOVERABLE_ERROR if a NaN/Inf value was found,
            AMICI_SUCCESS otherwise
        """
        return _amici.AmiciApplication_checkFinite(self, array, fun)
    __swig_destroy__ = _amici.delete_AmiciApplication

# Register AmiciApplication in _amici:
_amici.AmiciApplication_swigregister(AmiciApplication)


def runAmiciSimulation(solver: "Solver", edata: "ExpData", model: "Model", rethrow: "bool"=False) -> "std::unique_ptr< amici::ReturnData >":
    r"""
    Core integration routine. Initializes the solver and runs the forward
    and backward problem.

    :type solver: :py:class:`Solver`
    :param solver: Solver instance
    :type edata: :py:class:`ExpData`
    :param edata: pointer to experimental data object
    :type model: :py:class:`Model`
    :param model: model specification object
    :type rethrow: boolean
    :param rethrow: rethrow integration exceptions?
    :rtype: std::unique_ptr< amici::ReturnData >
    :return: rdata pointer to return data object
    """
    return _amici.runAmiciSimulation(solver, edata, model, rethrow)

def runAmiciSimulations(solver: "Solver", edatas: "ExpDataPtrVector", model: "Model", failfast: "bool", num_threads: "int") -> "std::vector< std::unique_ptr< amici::ReturnData >,std::allocator< std::unique_ptr< amici::ReturnData > > >":
    r"""
    Same as runAmiciSimulation, but for multiple ExpData instances. When
    compiled with openMP support, this function runs multi-threaded.

    :type solver: :py:class:`Solver`
    :param solver: Solver instance
    :type edatas: std::vector< amici::ExpData *,std::allocator< amici::ExpData * > >
    :param edatas: experimental data objects
    :type model: :py:class:`Model`
    :param model: model specification object
    :type failfast: boolean
    :param failfast: flag to allow early termination
    :type num_threads: int
    :param num_threads: number of threads for parallel execution
    :rtype: std::vector< std::unique_ptr< amici::ReturnData >,std::allocator< std::unique_ptr< amici::ReturnData > > >
    :return: vector of pointers to return data objects
    """
    return _amici.runAmiciSimulations(solver, edatas, model, failfast, num_threads)
class ExpDataPtrVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.ExpDataPtrVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.ExpDataPtrVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.ExpDataPtrVector___bool__(self)

    def __len__(self) -> "std::vector< amici::ExpData * >::size_type":
        return _amici.ExpDataPtrVector___len__(self)

    def __getslice__(self, i: "std::vector< amici::ExpData * >::difference_type", j: "std::vector< amici::ExpData * >::difference_type") -> "std::vector< amici::ExpData *,std::allocator< amici::ExpData * > > *":
        return _amici.ExpDataPtrVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.ExpDataPtrVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< amici::ExpData * >::difference_type", j: "std::vector< amici::ExpData * >::difference_type") -> "void":
        return _amici.ExpDataPtrVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.ExpDataPtrVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< amici::ExpData * >::value_type":
        return _amici.ExpDataPtrVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.ExpDataPtrVector___setitem__(self, *args)

    def pop(self) -> "std::vector< amici::ExpData * >::value_type":
        return _amici.ExpDataPtrVector_pop(self)

    def append(self, x: "ExpData") -> "void":
        return _amici.ExpDataPtrVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.ExpDataPtrVector_empty(self)

    def size(self) -> "std::vector< amici::ExpData * >::size_type":
        return _amici.ExpDataPtrVector_size(self)

    def swap(self, v: "ExpDataPtrVector") -> "void":
        return _amici.ExpDataPtrVector_swap(self, v)

    def begin(self) -> "std::vector< amici::ExpData * >::iterator":
        return _amici.ExpDataPtrVector_begin(self)

    def end(self) -> "std::vector< amici::ExpData * >::iterator":
        return _amici.ExpDataPtrVector_end(self)

    def rbegin(self) -> "std::vector< amici::ExpData * >::reverse_iterator":
        return _amici.ExpDataPtrVector_rbegin(self)

    def rend(self) -> "std::vector< amici::ExpData * >::reverse_iterator":
        return _amici.ExpDataPtrVector_rend(self)

    def clear(self) -> "void":
        return _amici.ExpDataPtrVector_clear(self)

    def get_allocator(self) -> "std::vector< amici::ExpData * >::allocator_type":
        return _amici.ExpDataPtrVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.ExpDataPtrVector_pop_back(self)

    def erase(self, *args) -> "std::vector< amici::ExpData * >::iterator":
        return _amici.ExpDataPtrVector_erase(self, *args)

    def __init__(self, *args):
        _amici.ExpDataPtrVector_swiginit(self, _amici.new_ExpDataPtrVector(*args))

    def push_back(self, x: "ExpData") -> "void":
        return _amici.ExpDataPtrVector_push_back(self, x)

    def front(self) -> "std::vector< amici::ExpData * >::value_type":
        return _amici.ExpDataPtrVector_front(self)

    def back(self) -> "std::vector< amici::ExpData * >::value_type":
        return _amici.ExpDataPtrVector_back(self)

    def assign(self, n: "std::vector< amici::ExpData * >::size_type", x: "ExpData") -> "void":
        return _amici.ExpDataPtrVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.ExpDataPtrVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.ExpDataPtrVector_insert(self, *args)

    def reserve(self, n: "std::vector< amici::ExpData * >::size_type") -> "void":
        return _amici.ExpDataPtrVector_reserve(self, n)

    def capacity(self) -> "std::vector< amici::ExpData * >::size_type":
        return _amici.ExpDataPtrVector_capacity(self)
    __swig_destroy__ = _amici.delete_ExpDataPtrVector

# Register ExpDataPtrVector in _amici:
_amici.ExpDataPtrVector_swigregister(ExpDataPtrVector)


def parameterScalingFromIntVector(intVec: "IntVector") -> "std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > >":
    return _amici.parameterScalingFromIntVector(intVec)
class ParameterScalingVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.ParameterScalingVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.ParameterScalingVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.ParameterScalingVector___bool__(self)

    def __len__(self) -> "std::vector< enum amici::ParameterScaling >::size_type":
        return _amici.ParameterScalingVector___len__(self)

    def __getslice__(self, i: "std::vector< enum amici::ParameterScaling >::difference_type", j: "std::vector< enum amici::ParameterScaling >::difference_type") -> "std::vector< amici::ParameterScaling,std::allocator< amici::ParameterScaling > > *":
        return _amici.ParameterScalingVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.ParameterScalingVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< enum amici::ParameterScaling >::difference_type", j: "std::vector< enum amici::ParameterScaling >::difference_type") -> "void":
        return _amici.ParameterScalingVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.ParameterScalingVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< enum amici::ParameterScaling >::value_type const &":
        return _amici.ParameterScalingVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.ParameterScalingVector___setitem__(self, *args)

    def pop(self) -> "std::vector< enum amici::ParameterScaling >::value_type":
        return _amici.ParameterScalingVector_pop(self)

    def append(self, x: "std::vector< enum amici::ParameterScaling >::value_type const &") -> "void":
        return _amici.ParameterScalingVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.ParameterScalingVector_empty(self)

    def size(self) -> "std::vector< enum amici::ParameterScaling >::size_type":
        return _amici.ParameterScalingVector_size(self)

    def swap(self, v: "ParameterScalingVector") -> "void":
        return _amici.ParameterScalingVector_swap(self, v)

    def begin(self) -> "std::vector< enum amici::ParameterScaling >::iterator":
        return _amici.ParameterScalingVector_begin(self)

    def end(self) -> "std::vector< enum amici::ParameterScaling >::iterator":
        return _amici.ParameterScalingVector_end(self)

    def rbegin(self) -> "std::vector< enum amici::ParameterScaling >::reverse_iterator":
        return _amici.ParameterScalingVector_rbegin(self)

    def rend(self) -> "std::vector< enum amici::ParameterScaling >::reverse_iterator":
        return _amici.ParameterScalingVector_rend(self)

    def clear(self) -> "void":
        return _amici.ParameterScalingVector_clear(self)

    def get_allocator(self) -> "std::vector< enum amici::ParameterScaling >::allocator_type":
        return _amici.ParameterScalingVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.ParameterScalingVector_pop_back(self)

    def erase(self, *args) -> "std::vector< enum amici::ParameterScaling >::iterator":
        return _amici.ParameterScalingVector_erase(self, *args)

    def __init__(self, *args):
        _amici.ParameterScalingVector_swiginit(self, _amici.new_ParameterScalingVector(*args))

    def push_back(self, x: "std::vector< enum amici::ParameterScaling >::value_type const &") -> "void":
        return _amici.ParameterScalingVector_push_back(self, x)

    def front(self) -> "std::vector< enum amici::ParameterScaling >::value_type const &":
        return _amici.ParameterScalingVector_front(self)

    def back(self) -> "std::vector< enum amici::ParameterScaling >::value_type const &":
        return _amici.ParameterScalingVector_back(self)

    def assign(self, n: "std::vector< enum amici::ParameterScaling >::size_type", x: "std::vector< enum amici::ParameterScaling >::value_type const &") -> "void":
        return _amici.ParameterScalingVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.ParameterScalingVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.ParameterScalingVector_insert(self, *args)

    def reserve(self, n: "std::vector< enum amici::ParameterScaling >::size_type") -> "void":
        return _amici.ParameterScalingVector_reserve(self, n)

    def capacity(self) -> "std::vector< enum amici::ParameterScaling >::size_type":
        return _amici.ParameterScalingVector_capacity(self)
    __swig_destroy__ = _amici.delete_ParameterScalingVector

# Register ParameterScalingVector in _amici:
_amici.ParameterScalingVector_swigregister(ParameterScalingVector)


def compiledWithOpenMP() -> "bool":
    return _amici.compiledWithOpenMP()

from enum import IntEnum
def enum(prefix):
    values = {k:v for k,v in globals().items() if k.startswith(prefix + '_')}
    values = {k[len(prefix)+1:]:v for k,v in values.items()}
    return IntEnum(prefix, values)
ParameterScaling = enum('ParameterScaling')
SecondOrderMode = enum('SecondOrderMode')
SensitivityOrder = enum('SensitivityOrder')
SensitivityMethod = enum('SensitivityMethod')
LinearSolver = enum('LinearSolver')
InternalSensitivityMethod = enum('InternalSensitivityMethod')
InterpolationType = enum('InterpolationType')
LinearMultistepMethod = enum('LinearMultistepMethod')
NonlinearSolverIteration = enum('NonlinearSolverIteration')
SteadyStateSensitivityMode = enum('SteadyStateSensitivityMode')
SteadyStateStatus = enum('SteadyStateStatus')
NewtonDampingFactorMode = enum('NewtonDampingFactorMode')
FixedParameterContext = enum('FixedParameterContext')
RDataReporting = enum('RDataReporting')

class SteadyStateStatusVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _amici.SteadyStateStatusVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _amici.SteadyStateStatusVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _amici.SteadyStateStatusVector___bool__(self)

    def __len__(self) -> "std::vector< enum amici::SteadyStateStatus >::size_type":
        return _amici.SteadyStateStatusVector___len__(self)

    def __getslice__(self, i: "std::vector< enum amici::SteadyStateStatus >::difference_type", j: "std::vector< enum amici::SteadyStateStatus >::difference_type") -> "std::vector< amici::SteadyStateStatus,std::allocator< amici::SteadyStateStatus > > *":
        return _amici.SteadyStateStatusVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _amici.SteadyStateStatusVector___setslice__(self, *args)

    def __delslice__(self, i: "std::vector< enum amici::SteadyStateStatus >::difference_type", j: "std::vector< enum amici::SteadyStateStatus >::difference_type") -> "void":
        return _amici.SteadyStateStatusVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _amici.SteadyStateStatusVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< enum amici::SteadyStateStatus >::value_type const &":
        return _amici.SteadyStateStatusVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _amici.SteadyStateStatusVector___setitem__(self, *args)

    def pop(self) -> "std::vector< enum amici::SteadyStateStatus >::value_type":
        return _amici.SteadyStateStatusVector_pop(self)

    def append(self, x: "std::vector< enum amici::SteadyStateStatus >::value_type const &") -> "void":
        return _amici.SteadyStateStatusVector_append(self, x)

    def empty(self) -> "bool":
        return _amici.SteadyStateStatusVector_empty(self)

    def size(self) -> "std::vector< enum amici::SteadyStateStatus >::size_type":
        return _amici.SteadyStateStatusVector_size(self)

    def swap(self, v: "SteadyStateStatusVector") -> "void":
        return _amici.SteadyStateStatusVector_swap(self, v)

    def begin(self) -> "std::vector< enum amici::SteadyStateStatus >::iterator":
        return _amici.SteadyStateStatusVector_begin(self)

    def end(self) -> "std::vector< enum amici::SteadyStateStatus >::iterator":
        return _amici.SteadyStateStatusVector_end(self)

    def rbegin(self) -> "std::vector< enum amici::SteadyStateStatus >::reverse_iterator":
        return _amici.SteadyStateStatusVector_rbegin(self)

    def rend(self) -> "std::vector< enum amici::SteadyStateStatus >::reverse_iterator":
        return _amici.SteadyStateStatusVector_rend(self)

    def clear(self) -> "void":
        return _amici.SteadyStateStatusVector_clear(self)

    def get_allocator(self) -> "std::vector< enum amici::SteadyStateStatus >::allocator_type":
        return _amici.SteadyStateStatusVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _amici.SteadyStateStatusVector_pop_back(self)

    def erase(self, *args) -> "std::vector< enum amici::SteadyStateStatus >::iterator":
        return _amici.SteadyStateStatusVector_erase(self, *args)

    def __init__(self, *args):
        _amici.SteadyStateStatusVector_swiginit(self, _amici.new_SteadyStateStatusVector(*args))

    def push_back(self, x: "std::vector< enum amici::SteadyStateStatus >::value_type const &") -> "void":
        return _amici.SteadyStateStatusVector_push_back(self, x)

    def front(self) -> "std::vector< enum amici::SteadyStateStatus >::value_type const &":
        return _amici.SteadyStateStatusVector_front(self)

    def back(self) -> "std::vector< enum amici::SteadyStateStatus >::value_type const &":
        return _amici.SteadyStateStatusVector_back(self)

    def assign(self, n: "std::vector< enum amici::SteadyStateStatus >::size_type", x: "std::vector< enum amici::SteadyStateStatus >::value_type const &") -> "void":
        return _amici.SteadyStateStatusVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _amici.SteadyStateStatusVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _amici.SteadyStateStatusVector_insert(self, *args)

    def reserve(self, n: "std::vector< enum amici::SteadyStateStatus >::size_type") -> "void":
        return _amici.SteadyStateStatusVector_reserve(self, n)

    def capacity(self) -> "std::vector< enum amici::SteadyStateStatus >::size_type":
        return _amici.SteadyStateStatusVector_capacity(self)
    __swig_destroy__ = _amici.delete_SteadyStateStatusVector

# Register SteadyStateStatusVector in _amici:
_amici.SteadyStateStatusVector_swigregister(SteadyStateStatusVector)



